/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.base;

import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalTypeEnum;

public class ArrPreBaseSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivaltype");
        sic.add("lettercredit");
        sic.add("currency");
        sic.add("amount");
        sic.add("credittype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String arrivalType = (String)dataEntity.getValue("arrivaltype");
            if (ArrivalTypeEnum.CREDIT.getValue().equals(arrivalType)) {
                this.validateMustInput(dataEntity, "lettercredit", "currency", "amount", "credittype");
            }
            if (!ArrivalTypeEnum.DA.getValue().equals(arrivalType)) continue;
            this.validateMustInput(dataEntity, "forwarddays");
        }
    }

    private void validateMustInput(ExtendedDataEntity dataEntity, String ... columnKeys) {
        for (String columnKey : columnKeys) {
            if (!this.isValNull(dataEntity, columnKey)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"%s\"\u3002", (String)"ArrPreBaseSubmitValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]), (String)"ArrPreBaseSubmitValidator_0", (String)"tmc-lc-business", (Object[])new Object[]{((IDataEntityProperty)dataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName()}));
        }
    }

    private boolean isValNull(ExtendedDataEntity entryRow, String columnKey) {
        Object rowVal = entryRow.getValue(columnKey);
        return EmptyUtil.isEmpty((Object)rowVal);
    }
}

