/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.config;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;

public class UnPayConfigConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("arrivalstatus");
        sic.add("ispayconfig");
        sic.add("org");
        sic.add("arrivalno");
        sic.add("isinit");
        sic.add("tradechannel");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject arrivalBill = dataEntity.getDataEntity();
            String payMethod = LcParameterHelper.getAppStringParameter((long)arrivalBill.getDynamicObject("org").getLong("id"), (String)"paymethod");
            if (BaseEnableEnum.DISABLE.getValue().equals(payMethod)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u6570\u9009\u62e9\u4e3a\u201c\u5230\u5355\u5173\u8054\u4ed8\u6b3e\u5355\u201d\uff0c\u4e0d\u80fd\u57fa\u4e8e\u5230\u5355\u76f4\u63a5\u505a\u53d6\u6d88\u4ed8\u6b3e\u786e\u8ba4\u3002", (String)"UnPayConfigConfirmValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            String billStatus = arrivalBill.getString("billstatus");
            String arrivalStatus = arrivalBill.getString("arrivalstatus");
            boolean isPayConfig = arrivalBill.getBoolean("ispayconfig");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || ArrivalStatusEnum.ARRIVAL_REGISTER.getValue().equals(arrivalStatus) || !isPayConfig) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u3010\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u5230\u5355\u72b6\u6001\u4e3a\u5230\u5355\u5df2\u786e\u8ba4\u6216\u5230\u5355\u5df2\u4ed8\u6b3e\u3011\u4e14\u5230\u5355\u4ed8\u6b3e\u786e\u8ba4\u660e\u7ec6\u4e0d\u4e3a\u7a7a\uff0c\u624d\u53ef\u53d1\u8d77\u53d6\u6d88\u4ed8\u6b3e\u786e\u8ba4\u3002", (String)"UnPayConfigConfirmValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (arrivalBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u786e\u8ba4\u3002", (String)"UnPayConfigConfirmValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!TradeChannelEnum.ONLINE.getValue().equals(arrivalBill.getString("tradechannel"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u7684\u5230\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u786e\u8ba4\u3002", (String)"UnPayConfigConfirmValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

