/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditFinishInitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("isforward");
        sic.add("forwarddays");
        sic.add("creditno");
        sic.add("amount");
        sic.add("amountscaleupper");
        sic.add("guarantee");
        sic.add("promisrate");
        sic.add("suretycur");
        sic.add("suretymoney");
        sic.add("totalsuretymoney");
        sic.add("creditamount");
        sic.add("arrivalentry");
        sic.add("arrivalentry.a_arrivalno");
        sic.add("entry_surety");
        sic.add("entry_surety.suretybill");
        sic.add("entry_surety.suretycurrency");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        block0: for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObjectCollection arrivalEntryList;
            String checkMsg;
            String guaWay;
            List guaWayList;
            BigDecimal calAmount;
            String creditNo;
            DynamicObject letterCreditInit = dataEntity.getDataEntity();
            boolean isForward = letterCreditInit.getBoolean("isforward");
            if (isForward && EmptyUtil.isEmpty((Long)letterCreditInit.getLong("forwarddays"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fdc\u671f\u6253\u5f00\uff0c\u8fdc\u671f\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"LetterCreditFinishInitValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)(creditNo = letterCreditInit.getString("creditno")))) {
                QFilter cqFilter = new QFilter("creditno", "=", (Object)creditNo);
                boolean creditExists = TmcDataServiceHelper.exists((String)"lc_lettercredit", (QFilter[])cqFilter.toArray());
                if (creditExists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4fe1\u7528\u8bc1\u53f7\u5df2\u5b58\u5728\u6570\u636e", (String)"LetterCreditFinishInitValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]), creditNo));
                }
                cqFilter = new QFilter("creditno", "=", (Object)creditNo);
                cqFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                creditExists = TmcDataServiceHelper.exists((String)"lc_lettercredit_init", (QFilter[])cqFilter.toArray());
                if (creditExists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7%s\u6709\u91cd\u590d\u6570\u636e", (String)"LetterCreditFinishInitValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]), creditNo));
                }
            }
            if ((calAmount = LetterCreditHelper.getAmount((DynamicObject)letterCreditInit)).compareTo(Constants.MAX_AMOUNT) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91d1\u989d*(1+\u77ed\u6ea2\u88c5\u4e0a\u9650%)\u8d85\u51fa\u91d1\u989d\u6700\u5927\u503c\u8303\u56f4 9,999,999,999,999.9999\u3002", (String)"LetterCreditFinishInitValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if ((guaWayList = Arrays.stream((guaWay = letterCreditInit.getString("guarantee")).split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList())).contains(GuaranteeWayEnum.ENSUAMT.getNumberValue())) {
                if (EmptyUtil.isEmpty((BigDecimal)letterCreditInit.getBigDecimal("promisrate"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4fdd\u8bc1\u91d1\u6bd4\u4f8b(%)\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditFinishInitValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((Object)letterCreditInit.get("suretycur"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4fdd\u8bc1\u91d1\u5e01\u79cd\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditFinishInitValidator_7", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)letterCreditInit.getBigDecimal("suretymoney"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4fdd\u8bc1\u91d1\u521d\u59cb\u91d1\u989d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditFinishInitValidator_8", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)letterCreditInit.getBigDecimal("totalsuretymoney"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4fdd\u8bc1\u91d1\u7d2f\u8ba1\u91d1\u989d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditFinishInitValidator_9", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
            }
            if (EmptyUtil.isNoEmpty((String)(checkMsg = LetterCreditHelper.checkContainsSurety((DynamicObject)letterCreditInit)))) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(arrivalEntryList = letterCreditInit.getDynamicObjectCollection("arrivalentry")))) continue;
            HashSet<String> arrivalNoSet = new HashSet<String>(arrivalEntryList.size());
            for (DynamicObject arrivalEntry : arrivalEntryList) {
                String arrivalNo = arrivalEntry.getString("a_arrivalno");
                QFilter qFilter = new QFilter("arrivalno", "=", (Object)arrivalNo);
                boolean exists = TmcDataServiceHelper.exists((String)"lc_arrival", (QFilter[])qFilter.toArray());
                if (exists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5230\u5355\u7f16\u53f7\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"LetterCreditFinishInitValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]), arrivalNo));
                    continue block0;
                }
                qFilter = new QFilter("arrivalentry.a_arrivalno", "=", (Object)arrivalNo);
                qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                exists = TmcDataServiceHelper.exists((String)"lc_lettercredit_init", (QFilter[])qFilter.toArray());
                if (arrivalNoSet.contains(arrivalNo) || exists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5230\u5355\u7f16\u53f7%s\u6709\u91cd\u590d\u6570\u636e\u3002", (String)"LetterCreditFinishInitValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]), arrivalNo));
                    continue block0;
                }
                arrivalNoSet.add(arrivalNo);
            }
        }
    }
}

