/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.init;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ReceiptBillFinishInitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("isforward");
        sic.add("forwarddays");
        sic.add("amount");
        sic.add("amountscaleupper");
        sic.add("presententry");
        sic.add("presententry.p_presentno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        block0: for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObjectCollection presentEntryList;
            BigDecimal calAmount;
            DynamicObject receiptBillInit = dataEntity.getDataEntity();
            boolean isForward = receiptBillInit.getBoolean("isforward");
            if (isForward && EmptyUtil.isEmpty((Long)receiptBillInit.getLong("forwarddays"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fdc\u671f\u6253\u5f00\uff0c\u8fdc\u671f\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptBillFinishInitValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
                break;
            }
            String creditNo = receiptBillInit.getString("creditno");
            if (EmptyUtil.isNoEmpty((String)creditNo)) {
                QFilter cqFilter = new QFilter("creditno", "=", (Object)creditNo);
                boolean creditExists = TmcDataServiceHelper.exists((String)"lc_receipt", (QFilter[])cqFilter.toArray());
                if (creditExists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4fe1\u7528\u8bc1\u53f7\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"ReceiptBillFinishInitValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]), creditNo));
                }
                cqFilter = new QFilter("creditno", "=", (Object)creditNo);
                cqFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                creditExists = TmcDataServiceHelper.exists((String)"lc_receipt_init", (QFilter[])cqFilter.toArray());
                if (creditExists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7%s\u6709\u91cd\u590d\u6570\u636e\u3002", (String)"ReceiptBillFinishInitValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]), creditNo));
                }
            }
            if ((calAmount = LetterCreditHelper.getAmount((DynamicObject)receiptBillInit)).compareTo(Constants.MAX_AMOUNT) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91d1\u989d*(1+\u77ed\u6ea2\u88c5\u4e0a\u9650%)\u8d85\u51fa\u91d1\u989d\u6700\u5927\u503c\u8303\u56f4 9,999,999,999,999.9999\u3002", (String)"ReceiptBillFinishInitValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(presentEntryList = receiptBillInit.getDynamicObjectCollection("presententry")))) continue;
            HashSet<String> presentNoSet = new HashSet<String>(presentEntryList.size());
            for (DynamicObject presentEntry : presentEntryList) {
                String presentNo = presentEntry.getString("p_presentno");
                QFilter qFilter = new QFilter("arrivalno", "=", (Object)presentNo);
                boolean exists = TmcDataServiceHelper.exists((String)"lc_present", (QFilter[])qFilter.toArray());
                if (exists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4ea4\u5355\u7f16\u53f7\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"ReceiptBillFinishInitValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]), presentNo));
                    continue block0;
                }
                qFilter = new QFilter("presententry.p_presentno", "=", (Object)presentNo);
                qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                exists = TmcDataServiceHelper.exists((String)"lc_receipt_init", (QFilter[])qFilter.toArray());
                if (presentNoSet.contains(presentNo) || exists) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ea4\u5355\u7f16\u53f7%s\u6709\u91cd\u590d\u6570\u636e\u3002", (String)"ReceiptBillFinishInitValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]), presentNo));
                    continue block0;
                }
                presentNoSet.add(presentNo);
            }
        }
    }
}

