/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("benefitertype");
        sic.add("benefiter");
        sic.add("creditno");
        sic.add("tradechannel");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject letterCredit = dataEntity.getDataEntity();
            String benefitType = letterCredit.getString("benefitertype");
            if (!"bos_org".equals(benefitType) || !this.recCreditSwitch(letterCredit)) continue;
            String creditNo = letterCredit.getString("creditno");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("creditno", "=", (Object)creditNo));
            boolean existLc = TmcDataServiceHelper.exists((String)"lc_lettercredit", (QFilter[])qFilter.toArray());
            QFilter receiptFilter = new QFilter("creditno", "=", (Object)creditNo);
            boolean exists = TmcDataServiceHelper.exists((String)"lc_receipt", (QFilter[])receiptFilter.toArray());
            if (!existLc || !exists) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u76f8\u540c\u4fe1\u7528\u8bc1\u53f7\u7684\u6536\u8bc1\u5355\u636e\uff0c\u81ea\u52a8\u751f\u6210\u5931\u8d25\u3002", (String)"LetterCreditAuditValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }

    private boolean recCreditSwitch(DynamicObject letterCredit) {
        Long orgId = letterCredit.getDynamicObject("benefiter").getLong("id");
        return LetterCreditHelper.checkRecCompCredit((DynamicObject)letterCredit, (long)orgId);
    }
}

