/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditProp;

public class LetterCreditChangeSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("totalarramount");
        sic.add("notarramount");
        sic.add("amountscaleupper");
        sic.add("amount");
        sic.add("billstatus");
        sic.add("isforward");
        sic.add("forwarddays");
        sic.add("creditlimit");
        sic.add("amount");
        sic.add("bank");
        sic.add("credittype");
        sic.add("org");
        sic.add("currency");
        sic.add("creditapplyno");
        sic.add("entry_surety");
        sic.add("entry_surety.suretycurrency");
        sic.add("suretycur");
        sic.add("suretymoney");
        sic.add("guarantee");
        sic.add("promisrate");
        sic.add("creditno");
        sic.add("creditamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Map variables = this.getOption().getVariables();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String checkMsg;
            BigDecimal creditAmount;
            BigDecimal lettAmount;
            DynamicObject letterCredit = dataEntity.getDataEntity();
            BigDecimal amount = letterCredit.getBigDecimal("amount");
            String billStatus = letterCredit.getString("billstatus");
            if (BillStatusEnum.AUDIT.getValue().equals(billStatus) && BigDecimal.ZERO.compareTo(amount) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91d1\u989d\u201d\u3002", (String)"LetterCreditChangeSaveValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if ((lettAmount = LetterCreditHelper.getAmount((DynamicObject)letterCredit)).compareTo(creditAmount = letterCredit.getBigDecimal("creditamount")) < 0) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditChangeSaveValidator_9.loadKDString());
            }
            BigDecimal totalArrAmount = letterCredit.getBigDecimal("totalarramount");
            letterCredit.set("notarramount", (Object)lettAmount.subtract(totalArrAmount));
            for (IDataEntityProperty prop : letterCredit.getDataEntityType().getProperties()) {
                if (!(prop instanceof AmountProp) || letterCredit.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
            }
            String creditApplyNo = letterCredit.getString("creditapplyno");
            if (!variables.containsKey("auditPush") && EmptyUtil.isNoEmpty((String)creditApplyNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)creditApplyNo);
                DynamicObject applyBill = QueryServiceHelper.queryOne((String)"lc_bizapply", (String)"id,billstatus", (QFilter[])filter.toArray());
                if (EmptyUtil.isEmpty((DynamicObject)applyBill) || !BillStatusEnum.AUDIT.getValue().equals(applyBill.getString("billstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u8bc1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u5f00\u8bc1\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditChangeSaveValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (LetterCreditHelper.isExistsLcApply((DynamicObject)letterCredit)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u8bc1\u7533\u8bf7\u503c%s\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"LetterCreditChangeSaveValidator_7", (String)"tmc-lc-business", (Object[])new Object[]{creditApplyNo}));
                }
            }
            if (BillStatusEnum.SAVE.getValue().equals(billStatus) && EmptyUtil.isNoEmpty((String)(checkMsg = LetterCreditHelper.checkCreditlimit((ExtendedDataEntity)dataEntity)))) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            if (EmptyUtil.isEmpty((DynamicObject)letterCredit.getDynamicObject("bank"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u8bc1\u884c\u201d\u3002", (String)"LetterCreditChangeSaveValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObject)letterCredit.getDynamicObject("currency"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5e01\u79cd\u201d\u3002", (String)"LetterCreditChangeSaveValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!"true".equals(variables.get(LetterCreditProp.OP_HISTORY_KEY)) && EmptyUtil.isNoEmpty((String)(checkMsg = LetterCreditHelper.checkContainsSurety((DynamicObject)letterCredit)))) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            if (!LetterCreditHelper.isExistsCreditNo((DynamicObject)letterCredit)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7\u503c%s\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"LetterCreditChangeSaveValidator_8", (String)"tmc-lc-business", (Object[])new Object[]{letterCredit.getString("creditno")}));
        }
    }
}

