/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;

public class LetterCreditCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("creditstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            QFilter qFilter;
            DynamicObject letterCredit = dataEntity.getDataEntity();
            boolean isLetterCredit = "lc_lettercredit".equals(letterCredit.getDynamicObjectType().getName());
            if (!BillStatusEnum.AUDIT.getValue().equals(letterCredit.getString("billstatus")) || !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(letterCredit.getString("creditstatus"))) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditCloseValidator_0.loadKDString());
                continue;
            }
            boolean isPay = TmcDataServiceHelper.exists((String)(isLetterCredit ? "lc_arrival" : "lc_present"), (QFilter[])(qFilter = new QFilter("lettercredit", "=", letterCredit.getPkValue()).and(isLetterCredit ? new QFilter("todoamount", ">", (Object)0) : new QFilter("todoamount", ">", (Object)0).and("isforfaiting", "=", (Object)false)).and(new QFilter("arrivalway", "!=", (Object)ArrivalWayEnum.PROTEST.getValue()))).toArray());
            if (!isPay) continue;
            String errorMsg = LcBusResourceEnum.LetterCreditCloseValidator_1.loadKDString();
            if (!isLetterCredit) {
                errorMsg = LcBusResourceEnum.LetterCreditCloseValidator_2.loadKDString();
            }
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

