/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditOpenValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebilltype");
        selector.add("srcbillid");
        selector.add("currency");
        selector.add("amount");
        selector.add("resubmitsrcno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        List letterBills = Arrays.stream(dataEntitys).filter(o -> "cas_paybill".equals(o.getDataEntity().getString("sourcebilltype")) && EmptyUtil.isNoEmpty((Long)o.getDataEntity().getLong("srcbillid")) && EmptyUtil.isEmpty((String)o.getDataEntity().getString("resubmitsrcno"))).map(o -> o.getDataEntity()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(letterBills)) {
            return;
        }
        Set payBillIds = letterBills.stream().map(o -> o.getLong("srcbillid")).collect(Collectors.toSet());
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,actpayamt,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)});
        Map payBillMaps = payBills.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (v1, v2) -> v2));
        payBillIds.clear();
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            QFilter filter;
            DynamicObject lettBillExt;
            DynamicObject lettBill = dataEntity.getDataEntity();
            DynamicObject currency = lettBill.getDynamicObject("currency");
            long sourceBillId = lettBill.getLong("srcbillid");
            if (EmptyUtil.isEmpty((Long)sourceBillId) || EmptyUtil.isEmpty((DynamicObject)((DynamicObject)payBillMaps.get(sourceBillId)))) continue;
            if (payBillIds.contains(sourceBillId)) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditOpenValidator_0.loadKDString());
                continue;
            }
            payBillIds.add(sourceBillId);
            DynamicObject payBill = (DynamicObject)payBillMaps.get(sourceBillId);
            if (currency == null || currency.getLong("id") != payBill.getLong("currency")) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditOpenValidator_1.loadKDString());
            }
            int amtPrecision = LetterCreditHelper.getAmtprecision((DynamicObject)lettBill.getDynamicObject("currency"));
            if (payBill.getBigDecimal("actpayamt").compareTo(lettBill.getBigDecimal("amount")) != 0) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditOpenValidator_2.loadKDString(lettBill.getBigDecimal("amount").setScale(amtPrecision), payBill.getBigDecimal("actpayamt").setScale(amtPrecision)));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(lettBillExt = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"billno", (QFilter[])new QFilter[]{(filter = new QFilter("srcbillid", "=", (Object)sourceBillId).or("billentry.e_billid", "=", (Object)sourceBillId)).and("id", "!=", (Object)lettBill.getLong("id"))})))) continue;
            this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditOpenValidator_3.loadKDString(lettBillExt.getString("billno")));
        }
    }
}

