/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditPushArrivalValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("benefitertype");
        sic.add("org");
        sic.add("creditstatus");
        sic.add("amount");
        sic.add("amountscaleupper");
        sic.add("notarramount");
        sic.add("bebankstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            BigDecimal notArrAmount;
            DynamicObject letterCredit = dataEntity.getDataEntity();
            String billStatus = letterCredit.getString("billstatus");
            String creditStatus = letterCredit.getString("creditstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(creditStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838&\u5df2\u767b\u8bb0\u72b6\u6001\u7684\u4fe1\u7528\u8bc1\u624d\u80fd\u751f\u6210\u5230\u5355\u3002", (String)"LetterCreditPushArrivalValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            String benefitType = letterCredit.getString("benefitertype");
            Long orgId = letterCredit.getDynamicObject("org").getLong("id");
            boolean recCompPresent = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent");
            if ("bos_org".equals(benefitType) && recCompPresent) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u6536\u8bc1\u4ea4\u5355\u751f\u6210\u5230\u5355\u3002", (String)"LetterCreditPushArrivalValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if ((notArrAmount = letterCredit.getBigDecimal("notarramount")) == null || notArrAmount.compareTo(Constants.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5df2\u7ecf\u5168\u90e8\u5230\u5355\u3002", (String)"LetterCreditPushArrivalValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
                return;
            }
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"lc_lettercredit", (Long[])new Long[]{letterCredit.getLong("id")});
            HashSet targetEntityIds = (HashSet)targetBills.get("lc_arrival");
            if (targetEntityIds == null) continue;
            BigDecimal arrivalSum = Constants.ZERO;
            QFilter qFilter = new QFilter("id", "in", (Object)targetEntityIds);
            DynamicObjectCollection arrivalList = QueryServiceHelper.query((String)"lc_arrival", (String)"arrivalamount", (QFilter[])qFilter.toArray());
            for (DynamicObject arrival : arrivalList) {
                arrivalSum = arrivalSum.add(arrival.getBigDecimal("arrivalamount"));
            }
            if (arrivalSum.compareTo(LetterCreditHelper.getAmount((DynamicObject)letterCredit)) < 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5df2\u7ecf\u5168\u90e8\u5230\u5355\u3002", (String)"LetterCreditPushArrivalValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

