/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditProp;

public class LetterCreditSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("totalarramount");
        sic.add("notarramount");
        sic.add("amountscaleupper");
        sic.add("benefiterother");
        sic.add("isforward");
        sic.add("forwarddays");
        sic.add("entry_surety");
        sic.add("entry_surety.suretybill");
        sic.add("entry_surety.suretycurrency");
        sic.add("creditlimit");
        sic.add("currency");
        sic.add("suretycur");
        sic.add("suretymoney");
        sic.add("org");
        sic.add("amount");
        sic.add("creditno");
        sic.add("tradechannel");
        sic.add("bizdate");
        sic.add("validdate");
        sic.add("guarantee");
        sic.add("promisrate");
        sic.add("creditamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BigDecimal creditAmount;
            String checkMsg;
            String creditApplyNo;
            boolean isTrue;
            DynamicObject letterCredit = dataEntity.getDataEntity();
            if (TradeChannelEnum.OFFLINE.getValue().equals(letterCredit.getString("tradechannel")) && EmptyUtil.isEmpty((String)letterCredit.getString("creditno"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4fe1\u7528\u8bc1\u53f7\u201d\u3002", (String)"LetterCreditSubmitValidator_6", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)letterCredit.getString("benefiterother"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u53d7\u76ca\u4eba\"\u3002", (String)"LetterCreditSubmitValidator_4", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (isTrue = LetterCreditHelper.checkIsforward((DynamicObject)letterCredit)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8fdc\u671f\u5929\u6570\"\u3002", (String)"LetterCreditSubmitValidator_5", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)(creditApplyNo = letterCredit.getString("creditapplyno")))) {
                QFilter filter = new QFilter("billno", "=", (Object)creditApplyNo);
                DynamicObject applyBill = QueryServiceHelper.queryOne((String)"lc_bizapply", (String)"id,billstatus", (QFilter[])filter.toArray());
                if (EmptyUtil.isEmpty((DynamicObject)applyBill) || !BillStatusEnum.AUDIT.getValue().equals(applyBill.getString("billstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u8bc1\u5904\u7406\u5355\u5bf9\u5e94\u7684\u5f00\u8bc1\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditSubmitValidator_8", (String)"tmc-lc-business", (Object[])new Object[0]));
                }
                if (LetterCreditHelper.isExistsLcApply((DynamicObject)letterCredit)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u8bc1\u7533\u8bf7\u503c%s\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"LetterCreditChangeSaveValidator_7", (String)"tmc-lc-business", (Object[])new Object[]{creditApplyNo}));
                }
            }
            if (!"true".equals(this.getOption().getVariables().get(LetterCreditProp.OP_HISTORY_KEY)) && EmptyUtil.isNoEmpty((String)(checkMsg = LetterCreditHelper.checkContainsSurety((DynamicObject)letterCredit)))) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            BigDecimal totalArrAmount = letterCredit.getBigDecimal("totalarramount");
            letterCredit.set("notarramount", (Object)LetterCreditHelper.getAmount((DynamicObject)letterCredit).subtract(totalArrAmount));
            for (IDataEntityProperty prop : letterCredit.getDataEntityType().getProperties()) {
                if (!(prop instanceof AmountProp) || letterCredit.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
            }
            BigDecimal letterAmount = LetterCreditHelper.getAmount((DynamicObject)letterCredit);
            if (letterAmount.compareTo(creditAmount = letterCredit.getBigDecimal("creditamount")) < 0) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.LetterCreditChangeSaveValidator_9.loadKDString());
            }
            this.validateAmt(letterCredit, dataEntity);
            this.validateDueDate(letterCredit, dataEntity);
            if (!LetterCreditHelper.isExistsCreditNo((DynamicObject)letterCredit)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7\u503c%s\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"LetterCreditChangeSaveValidator_8", (String)"tmc-lc-business", (Object[])new Object[]{letterCredit.getString("creditno")}));
        }
    }

    public void validateAmt(DynamicObject bizBill, ExtendedDataEntity dataEntity) {
        if (EmptyUtil.isNoEmpty((BigDecimal)bizBill.getBigDecimal("amount")) && EmptyUtil.isNoEmpty((DynamicObject)bizBill.getDynamicObject("creditlimit")) && EmptyUtil.isNoEmpty((BigDecimal)bizBill.getBigDecimal("suretymoney")) && EmptyUtil.isEmpty((String)this.getOption().getVariableValue("after_credit_surety_amt_confirm", null))) {
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)bizBill.getLong("id"), (String)bizBill.getDataEntityType().getName());
            BigDecimal creditAmount = creditUseBill.getBigDecimal("bizcreditamount");
            BigDecimal letterAmount = LetterCreditHelper.getAmount((DynamicObject)bizBill);
            if (bizBill.getBigDecimal("suretymoney").add(creditAmount).compareTo(letterAmount) > 0) {
                this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u7528\u91d1\u989d + \u4fdd\u8bc1\u91d1\u91d1\u989d\u5df2\u8d85\u51fa\u5f00\u8bc1\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"LetterCreditSubmitValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateDueDate(DynamicObject bizBill, ExtendedDataEntity dataEntity) {
        Date openDate = bizBill.getDate("bizdate");
        Date validDate = bizBill.getDate("validdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{openDate, validDate})) {
            return;
        }
        if (validDate.compareTo(openDate) <= 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u987b\u5927\u4e8e\u5f00\u8bc1\u65e5\u671f\u3002", (String)"LetterCreditSubmitValidator_7", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

