/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;

public class LetterCreditSyncStatusValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bebankstatus");
        selector.add("opetype");
        selector.add("acceptbebankstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            String beBankStatus;
            DynamicObject bizBill = extData.getDataEntity();
            String entityName = bizBill.getDynamicObjectType().getName();
            if ("lc_arrival".equals(entityName) && ArrivalWayEnum.isAccept((String)bizBill.getString("opetype"))) {
                beBankStatus = bizBill.getString("acceptbebankstatus");
                if (BeBillStatusEnum.OS.getValue().equals(beBankStatus) || BeBillStatusEnum.BP.getValue().equals(beBankStatus) || BeBillStatusEnum.NC.getValue().equals(beBankStatus)) continue;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u64cd\u4f5c\u72b6\u6001\u4e3a\u94f6\u4f01\u5904\u7406\u4e2d\u6216\u94f6\u884c\u5904\u7406\u4e2d\u6216\u4ea4\u6613\u672a\u786e\u8ba4\u7684\u5355\u636e\u624d\u80fd\u540c\u6b65\u72b6\u6001\u3002", (String)"LetterCreditSyncStatusValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
                continue;
            }
            beBankStatus = bizBill.getString("bebankstatus");
            if (BeBillStatusEnum.OS.getValue().equals(beBankStatus) || BeBillStatusEnum.BP.getValue().equals(beBankStatus) || BeBillStatusEnum.NC.getValue().equals(beBankStatus)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u64cd\u4f5c\u72b6\u6001\u4e3a\u94f6\u4f01\u5904\u7406\u4e2d\u6216\u94f6\u884c\u5904\u7406\u4e2d\u6216\u4ea4\u6613\u672a\u786e\u8ba4\u7684\u5355\u636e\u624d\u80fd\u540c\u6b65\u72b6\u6001\u3002", (String)"LetterCreditSyncStatusValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

