/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.lettercredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import org.apache.commons.lang3.StringUtils;

public class LetterCreditUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("creditno");
        sic.add("isinit");
        sic.add("tradechannel");
        sic.add("bebankstatus");
        sic.add("sourcebilltype");
        sic.add("billentry");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject letterCredit = dataEntity.getDataEntity();
            QFilter filter = new QFilter("lettercredit", "=", (Object)letterCredit.getLong("id"));
            filter.and("biztype", "=", (Object)LetterBizTypeEnum.EDIT_CARD.getValue());
            boolean exists = TmcDataServiceHelper.exists((String)"lc_bizapply", (QFilter[])filter.toArray());
            if (exists) {
                String creditNo = letterCredit.getString("creditno");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7\u201c%s\u201d\u5df2\u5b58\u5728\u4e0b\u6e38\u6539\u8bc1\u4e1a\u52a1\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LetterCreditUnAuditValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]), creditNo));
            }
            if (letterCredit.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u4fe1\u7528\u8bc1\u5f00\u8bc1\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LetterCreditUnAuditValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            this.validateIsCommitBei(dataEntity, letterCredit);
        }
    }

    private void validateIsCommitBei(ExtendedDataEntity dataEntity, DynamicObject letterCredit) {
        if (StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)letterCredit.getString("tradechannel")) && EmptyUtil.isNoEmpty((String)letterCredit.getString("bebankstatus"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u63d0\u4ea4\u94f6\u4f01\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"LetterCreditUnAuditValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

