/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.present;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PresentBillAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("benefiter");
        sic.add("lettercredit.number");
        sic.add("arrivalno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject presentBill = dataEntity.getDataEntity();
            Long orgId = EmptyUtil.isNoEmpty((DynamicObject)presentBill.getDynamicObject("benefiter")) ? presentBill.getDynamicObject("benefiter").getLong("id") : 0L;
            boolean recCompPresent = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent");
            if (!recCompPresent) {
                return;
            }
            DynamicObject receiptBillDo = presentBill.getDynamicObject("lettercredit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)receiptBillDo)) continue;
            String creditNo = receiptBillDo.getString("number");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("number", "=", (Object)creditNo));
            DynamicObject letterCreditDo = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit_f7", (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObject)letterCreditDo) || !"bos_org".equals(letterCreditDo.getString("benefitertype"))) continue;
            String arrivalNo = presentBill.getString("arrivalno");
            QFilter presentFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            presentFilter.and(new QFilter("arrivalno", "=", (Object)arrivalNo));
            boolean existLc = TmcDataServiceHelper.exists((String)"lc_present", (QFilter[])presentFilter.toArray());
            QFilter arrivalFilter = new QFilter("arrivalno", "=", (Object)arrivalNo);
            boolean exists = TmcDataServiceHelper.exists((String)"lc_arrival", (QFilter[])arrivalFilter.toArray());
            if (!existLc || !exists) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u76f8\u540c\u7f16\u53f7\u7684\u5230\u5355\u5355\u636e\uff0c\u81ea\u52a8\u751f\u6210\u5931\u8d25\u3002", (String)"PresentBillAuditValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

