/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.present;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.lc.business.validate.resource.LcBusResourceEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;

public class PresentBillRecValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("arrivalstatus");
        selector.add("billstatus");
        selector.add("arrivalamount");
        selector.add("lockamount");
        selector.add("arrivalway");
        selector.add("isforfaiting");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Set billIds = Arrays.stream(dataEntities).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection recBillCols = QueryServiceHelper.query((String)"cas_recbill", (String)"sourcebillid,billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds)});
        Map<Long, String> recBillMaps = recBillCols.stream().collect(Collectors.toMap(o -> o.getLong("sourcebillid"), o -> o.getString("billno"), (v1, v2) -> v2));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            String recMethod = LcParameterHelper.getAppStringParameter((long)data.getDynamicObject("org").getLong("id"), (String)"recmethod");
            if (BaseEnableEnum.DISABLE.getValue().equals(recMethod)) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillRecValidator_0.loadKDString());
                continue;
            }
            BigDecimal presentAmount = data.getBigDecimal("arrivalamount");
            BigDecimal lockAmount = data.getBigDecimal("lockamount");
            String arrivalWay = data.getString("arrivalway");
            if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus")) || !PresentStatusEnum.PRESENT_CONFIRM.getValue().equals(data.getString("arrivalstatus"))) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillRecValidator_1.loadKDString());
            }
            if (data.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillRecValidator_5.loadKDString());
            }
            if (ArrivalWayEnum.PROTEST.getValue().equals(arrivalWay)) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillRecValidator_2.loadKDString());
            }
            if (presentAmount.compareTo(lockAmount) <= 0) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillRecValidator_3.loadKDString());
            }
            if (data.getBoolean("isforfaiting")) {
                this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillRecValidator_4.loadKDString());
            }
            if (!recBillMaps.containsKey(data.getLong("id"))) continue;
            this.addErrorMessage(dataEntity, LcBusResourceEnum.PresentBillRecValidator_6.loadKDString(recBillMaps.get(data.getLong("id"))));
        }
    }
}

