/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.present;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.PresentStatusEnum;

public class PresentBillUnConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("arrivalstatus");
        sic.add("entrys");
        sic.add("isreceipt");
        sic.add("isforfaiting");
        sic.add("arrivalno");
        sic.add("isinit");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isForfaiting;
            boolean isReceipt;
            DynamicObject presentBill = dataEntity.getDataEntity();
            String billStatus = presentBill.getString("billstatus");
            String presentStatus = presentBill.getString("arrivalstatus");
            DynamicObjectCollection entryList = presentBill.getDynamicObjectCollection("entrys");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !PresentStatusEnum.PRESENT_CONFIRM.getValue().equals(presentStatus) || EmptyUtil.isNoEmpty((DynamicObjectCollection)entryList)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u3010\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4ea4\u5355\u72b6\u6001\u4e3a\u4ea4\u5355\u5df2\u786e\u8ba4\u3011\u4e14\u4ea4\u5355\u6536\u6b3e\u660e\u7ec6\u4e3a\u7a7a\uff0c\u624d\u53ef\u53d1\u8d77\u53d6\u6d88\u4ea4\u5355\u786e\u8ba4\u3002", (String)"PresentBillUnConfirmValidator_0", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (isReceipt = presentBill.getBoolean("isreceipt")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u5355\u5df2\u88ab\u6536\u6b3e\u5355\u5173\u8054\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u518d\u505a\u53d6\u6d88\u786e\u8ba4\u3002", (String)"PresentBillUnConfirmValidator_1", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (isForfaiting = presentBill.getBoolean("isforfaiting")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u5355\u5df2\u4e0b\u63a8\u798f\u8d39\u5ef7\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u518d\u505a\u53d6\u6d88\u786e\u8ba4\u3002", (String)"PresentBillUnConfirmValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (!presentBill.getBoolean("isinit")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u4ea4\u5355\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u505a\u53d6\u6d88\u786e\u8ba4\u3002", (String)"PresentBillUnConfirmValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
    }
}

