/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.validate.receipt;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ReceiptBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("benefiterother");
        sic.add("isforward");
        sic.add("forwarddays");
        sic.add("benefiter");
        sic.add("notarramount");
        sic.add("totalarramount");
        sic.add("amountscaleupper");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isTrue;
            DynamicObject receiptBill = dataEntity.getDataEntity();
            if (EmptyUtil.isEmpty((String)receiptBill.getString("benefiterother"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u5f00\u8bc1\u4eba\"\u3002", (String)"ReceiptBillSubmitValidator_2", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            if (isTrue = LetterCreditHelper.checkIsforward((DynamicObject)receiptBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8fdc\u671f\u5929\u6570\"\u3002", (String)"ReceiptBillSubmitValidator_3", (String)"tmc-lc-business", (Object[])new Object[0]));
            }
            BigDecimal totalPreAmount = receiptBill.getBigDecimal("totalarramount");
            receiptBill.set("notarramount", (Object)LetterCreditHelper.getAmount((DynamicObject)receiptBill).subtract(totalPreAmount));
            for (IDataEntityProperty prop : receiptBill.getDataEntityType().getProperties()) {
                if (!(prop instanceof AmountProp) || receiptBill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
                this.addErrorMessage(dataEntity, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
            }
        }
    }
}

