/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.apply;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.common.property.LetterCreditHistoryProp;
import kd.tmc.lc.common.property.LetterCreditProp;

public class BizApplyListPlugin
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
            break;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "trackdown": {
                this.trackDownOperation(args);
                break;
            }
            case "copy": {
                this.copyOperation(args);
                break;
            }
            case "viewsurety": {
                this.viewSuretyListForm();
                break;
            }
        }
    }

    private void viewSuretyListForm() {
        List selectedIdList = this.getSelectedIdList();
        String suretyProp = "entry_surety.suretybill";
        DynamicObjectCollection sureties = QueryServiceHelper.query((String)"lc_bizapply", (String)suretyProp, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedIdList)});
        List<Object> suretyIds = new ArrayList(selectedIdList.size());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)sureties)) {
            suretyIds = sureties.stream().map(d -> d.getLong(suretyProp)).collect(Collectors.toList());
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fbd_suretybill");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("id", "in", suretyIds);
        parameter.getListFilterParameter().setFilter(qFilter);
        parameter.getCustomParams().put("dataSource", "bizBill");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate formOperate = (AbstractOperate)args.getSource();
        if ("confirm".equals(formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void copyOperation(BeforeDoOperationEventArgs args) {
        Long id = super.getSelectedId();
        if (EmptyUtil.isNoEmpty((Long)id)) {
            boolean isApplyRepeal;
            DynamicObject applyBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_bizapply", (String)"id,org,biztype");
            String bizType = applyBill.getString("biztype");
            DynamicObject org = applyBill.getDynamicObject("org");
            if (LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType)) {
                boolean isApplyClose = LcParameterHelper.getAppBoolParameter((long)org.getLong("id"), (String)LetterCreditProp.IS_APPLY_CLOSE);
                if (!isApplyClose) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u8bc1\u4eba\u672a\u542f\u7528\u8fdb\u53e3\u4fe1\u7528\u8bc1\u95ed\u5377\u4e1a\u52a1\u7533\u8bf7!", (String)"BizApplyListPlugin_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else if (LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType) && !(isApplyRepeal = LcParameterHelper.getAppBoolParameter((long)org.getLong("id"), (String)LetterCreditProp.IS_APPLY_REPEAL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u8bc1\u4eba\u672a\u542f\u7528\u8fdb\u53e3\u4fe1\u7528\u8bc1\u64a4\u8bc1\u4e1a\u52a1\u7533\u8bf7!", (String)"BizApplyListPlugin_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void trackDownOperation(BeforeDoOperationEventArgs args) {
        Long id = super.getSelectedId();
        if (EmptyUtil.isNoEmpty((Long)id)) {
            Long applyId;
            QFilter qFilter;
            DynamicObject history;
            DynamicObject applyBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_bizapply");
            String bizType = applyBill.getString("biztype");
            String billStatus = applyBill.getString("billstatus");
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType) && BillStatusEnum.AUDIT.getValue().equals(billStatus) && EmptyUtil.isNoEmpty((DynamicObject)(history = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit_h", (String)"id", (QFilter[])(qFilter = new QFilter(LetterCreditHistoryProp.APPLYID, "=", (Object)(applyId = Long.valueOf(applyBill.getLong("id"))))).toArray())))) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setPkId((Object)history.getLong("id"));
                parameter.setFormId("lc_lettercredit_h");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                args.setCancel(true);
            }
        } else {
            args.setCancel(true);
        }
    }
}

