/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.arrival;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ArrivalBillEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrys");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        BasedataEdit letterCredit = (BasedataEdit)this.getControl("lettercredit");
        letterCredit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        if ("lettercredit".equals(property)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (EmptyUtil.isEmpty((DynamicObject)org)) {
                return;
            }
            Long orgId = org.getLong("id");
            boolean recCompPresent = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent");
            if (recCompPresent) {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                List qFilters = filterParam.getQFilters();
                QFilter qFilter = new QFilter("org", "!=", (Object)orgId);
                qFilter.or(new QFilter("benefitertype", "!=", (Object)"bos_org"));
                qFilters.add(qFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String creditId = (String)this.getView().getFormShowParameter().getCustomParam("creditId");
        if (EmptyUtil.isNoEmpty((String)creditId)) {
            this.getModel().setValue("lettercredit", (Object)Long.parseLong(creditId));
            this.letterCreditChgEvt();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "lettercredit": {
                this.letterCreditChgEvt();
                break;
            }
            case "arrivaltype": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"arrivalbank", null);
            }
        }
    }

    private void letterCreditChgEvt() {
        DynamicObject letterCredit_f7 = (DynamicObject)this.getModel().getValue("lettercredit");
        if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit_f7)) {
            DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)letterCredit_f7.getLong("id"), (String)"lc_lettercredit");
            DataEntityPropertyCollection propertys = letterCredit.getDataEntityType().getProperties();
            DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
            for (IDataEntityProperty prop : propertys) {
                String propName = prop.getName();
                if (!this.copyPropertys().contains(propName) || !props.containsKey((Object)propName)) continue;
                this.getModel().setValue(propName, letterCredit.get(propName));
                if (!"currency".equals(propName)) continue;
                this.getModel().setValue("arrivalcurrency", letterCredit.get(propName));
            }
            this.getModel().setValue("arrivalbank", (Object)letterCredit.getDynamicObject("bank"));
            this.setInfoEnable(false);
            QFilter qFilter = new QFilter("lettercredit", "=", (Object)letterCredit.getLong("id"));
            int count = TmcDataServiceHelper.count((String)"lc_arrival", (QFilter[])qFilter.toArray());
            this.getModel().setValue("arrivallot", (Object)(++count));
        } else {
            this.getView().invokeOperation("refresh");
            this.setInfoEnable(true);
        }
    }

    private void setInfoEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"org", "currency", "amount", "credittype", "isforward", "forwarddays", "benefitertype", "benefiter", "benefiterother", "arrivalcurrency"});
    }

    protected List copyPropertys() {
        return Arrays.asList("org", "currency", "amount", "credittype", "isforward", "forwarddays", "benefitertype", "benefiter", "benefiterother", "bizcontactor", "bizcontactinfo", "validdate", "lastdate");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entrys").get(rowIndex);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cas_paybill");
        showParameter.setPkId((Object)rowData.getLong("payid"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

