/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.arrival;

import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class ArrivalBillOnlineList
extends AbstractTmcListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "accept": 
            case "payment": 
            case "protest": {
                Long selectedId = this.getSelectedId();
                if (EmptyUtil.isEmpty((Long)selectedId)) {
                    args.setCancel(true);
                    return;
                }
                source.getOption().setVariableValue("OPETYPE", operateKey);
                break;
            }
            case "acptpay": {
                Long selectedId = this.getSelectedId();
                if (EmptyUtil.isEmpty((Long)selectedId)) {
                    return;
                }
                source.getOption().setVariableValue("OPETYPE", "payment");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "accept": {
                this.showForm(args, "lc_onlineaccept");
                break;
            }
            case "acptpay": 
            case "payment": {
                this.showForm(args, "lc_onlinepayment");
                break;
            }
            case "protest": {
                this.showForm(args, "lc_onlineprotest");
                break;
            }
            case "recommitbe": {
                ((BillList)this.getControl("billlistap")).refreshData();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        switch (actionId = event.getActionId()) {
            case "CLOSECALLBACK": {
                ((BillList)this.getControl("billlistap")).refreshData();
                break;
            }
        }
    }

    private void showForm(AfterDoOperationEventArgs args, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        List pkIds = args.getOperationResult().getSuccessPkIds();
        showParameter.setCustomParam("id", EmptyUtil.isNoEmpty((Object)pkIds) ? pkIds.get(0) : Long.valueOf(0L));
        showParameter.setCustomParam("OPERATE_NUMBER", (Object)args.getOperateKey());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSECALLBACK"));
        this.getView().showForm(showParameter);
    }
}

