/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.base;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.formplugin.resource.LcFormResourceEnum;

public abstract class AbstractBaseList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
            break;
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection dataList = super.getData(arg0, arg1);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                AbstractBaseList.this.setArrialSum(dataList);
                return dataList;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("arrivalsum".equals(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Object pkID = billList.getFocusRowPkId();
            DynamicObjectCollection arrBills = QueryServiceHelper.query((String)this.getArrEntityName(), (String)"id", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)("lc_arrival".equals(this.getArrEntityName()) ? ArrivalStatusEnum.ARRIVAL_REGISTER.getValue() : PresentStatusEnum.PRESENT_REGISTER.getValue())), new QFilter("lettercredit", "=", pkID)});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)arrBills)) {
                this.getView().showTipNotification("lc_arrival".equals(this.getArrEntityName()) ? LcFormResourceEnum.AbstractBaseList_0.loadKDString() : LcFormResourceEnum.AbstractBaseList_1.loadKDString());
                return;
            }
            if (arrBills.size() == 1) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setPkId((Object)((DynamicObject)arrBills.get(0)).getLong("id"));
                parameter.setFormId(this.getArrEntityName());
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setBillStatus(BillOperationStatus.VIEW);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                ListShowParameter paramters = new ListShowParameter();
                paramters.setBillFormId(this.getArrEntityName());
                paramters.getListFilterParameter().getQFilters().add(new QFilter("id", "in", arrBills.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet())));
                paramters.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                paramters.setShowFilter(false);
                paramters.setCustomParam("isquerydefault", (Object)"no");
                this.getView().showForm((FormShowParameter)paramters);
            }
        }
    }

    private void setArrialSum(DynamicObjectCollection dataList) {
        DataEntityPropertyCollection properties = ((DynamicObject)dataList.get(0)).getDataEntityType().getProperties();
        boolean isSum = properties.containsKey((Object)"arrivalsum");
        boolean isPay = properties.containsKey((Object)"payamount");
        boolean isNotPay = properties.containsKey((Object)"notpayamount");
        if (!(isSum || isPay || isNotPay)) {
            return;
        }
        Set billIds = dataList.parallelStream().map(o -> o.getPkValue()).collect(Collectors.toSet());
        GroupbyDataSet ArrivalGroupbyLetDs = QueryServiceHelper.queryDataSet((String)"AbstractBaseList_arr", (String)this.getArrEntityName(), (String)"doneamount,lettercredit", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)("lc_arrival".equals(this.getArrEntityName()) ? ArrivalStatusEnum.ARRIVAL_REGISTER.getValue() : PresentStatusEnum.PRESENT_REGISTER.getValue())), new QFilter("lettercredit", "in", billIds)}, null).groupBy(new String[]{"lettercredit"});
        DataSet countDs = ArrivalGroupbyLetDs.count().finish();
        DataSet payAmountDs = ArrivalGroupbyLetDs.sum("doneamount").finish();
        HashMap billArrSumMap = new HashMap();
        countDs.forEach(o -> billArrSumMap.put(o.getLong("lettercredit"), o.getInteger("count")));
        Map<Long, BigDecimal> billArrPayAmountMap = this.getBillAmountMap(payAmountDs, "lettercredit", "doneamount");
        Map<Object, BigDecimal> billLetAmountMap = new HashMap();
        if (isNotPay) {
            DataSet letteCreditDs = QueryServiceHelper.queryDataSet((String)"AbstractBaseList_lett", (String)this.getLetEntityName(), (String)"id,amount*(1+amountscaleupper/100) letamt", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, null).groupBy(new String[]{"id"}).sum("letamt").finish();
            billLetAmountMap = this.getBillAmountMap(letteCreditDs, "id", "letamt");
        }
        for (DynamicObject data : dataList) {
            long billId = data.getLong("id");
            if (isSum) {
                data.set("arrivalsum", (Object)billArrSumMap.getOrDefault(billId, 0));
            }
            if (isPay) {
                data.set("payamount", (Object)billArrPayAmountMap.getOrDefault(billId, BigDecimal.ZERO));
            }
            if (!isNotPay) continue;
            data.set("notpayamount", (Object)billLetAmountMap.getOrDefault(billId, BigDecimal.ZERO).subtract(billArrPayAmountMap.getOrDefault(billId, BigDecimal.ZERO)));
        }
    }

    private Map<Long, BigDecimal> getBillAmountMap(DataSet countDs, String letField, String amtField) {
        HashMap<Long, BigDecimal> billAmountMap = new HashMap<Long, BigDecimal>();
        countDs.forEach(o -> billAmountMap.put(o.getLong(letField), o.getBigDecimal(amtField)));
        return billAmountMap;
    }

    protected abstract String getArrEntityName();

    protected abstract String getLetEntityName();
}

