/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.base;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalTypeEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.helper.BaseDataHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ArrivalPresentBaseEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String TEMP_BILLSTATUS_KEY = "Temp_BillStatus";

    public void registerListener(EventObject e) {
        BasedataEdit letterCredit = (BasedataEdit)this.getControl("lettercredit");
        letterCredit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LetterCreditHelper.setDefaultBillType((IDataModel)this.getModel());
        this.initBizContactInfo();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        DynamicObject letterCredit = (DynamicObject)this.getModel().getValue("lettercredit");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus) && EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
            this.setInfoEnable(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"lettercredit"});
        }
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("confirm")) {
            this.getPageCache().put(TEMP_BILLSTATUS_KEY, this.getModel().getValue("billstatus").toString());
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_confirm"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_del", "bar_submit", "bar_print"});
            this.setInfoEnable(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno", "recorddate", "arrivalno", "lettercredit", "invoiceno"});
            IDataEntityProperty tradeChannelProp = this.getModel().getProperty("tradechannel");
            if (EmptyUtil.isNoEmpty((Object)tradeChannelProp)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"tradechannel"});
            }
        }
    }

    private void initControlsStatus() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (EmptyUtil.isNoEmpty((Object)parentView) && EmptyUtil.isNoEmpty((String)parentView.getPageCache().get("isconfirming"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"arrivaltype"});
            parentView.getPageCache().put("isconfirming", null);
        }
        if (parentView instanceof ListView) {
            String parentFormId = ((ListView)parentView).getBillFormId();
            if (!"lc_arrival".equals(parentFormId) && !"lc_present".equals(parentFormId)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"arrivaltype"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"arrivaltype"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBenefiterType();
        this.setArrivalWay();
        this.setForwardDaysMustInput();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("copy")) {
            this.getModel().setValue("todoamount", this.getModel().getValue("arrivalamount"));
            this.getModel().deleteEntryData("entrys");
        }
        this.initControlsStatus();
        this.arrivalTypeChanged();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bizcontactor": {
                this.initBizContactInfo();
                break;
            }
            case "benefiter": {
                this.setBenefiterOther();
                break;
            }
            case "benefitertype": {
                this.initBenefiterType();
                this.delBenefiterF7();
                break;
            }
            case "isforward": {
                this.setArrivalWay();
                this.setForwardDaysMustInput();
                break;
            }
            case "arrivalamount": {
                this.calTodoAmount();
                break;
            }
            case "arrivaltype": {
                this.arrivalTypeChanged();
                break;
            }
            case "endacceptdate": {
                this.setDefaultEndpaydate();
            }
        }
    }

    private void arrivalTypeChanged() {
        String arrivalType = (String)this.getModel().getValue("arrivaltype");
        if (ArrivalTypeEnum.DA.getValue().equals(arrivalType) || ArrivalTypeEnum.DP.getValue().equals(arrivalType)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"lettercredit", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"credittype", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"isdiscrepancy", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"discrepancy", null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lettercredit", "currency", "amount", "credittype", "isdiscrepancy", "discrepancy"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"lettercredit", "currency", "amount", "credittype"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"org", "forwarddays", "benefitertype", "benefiter", "benefiterother"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lettercredit", "currency", "amount", "credittype", "isdiscrepancy", "discrepancy"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"lettercredit", "currency", "amount", "credittype"});
        }
        boolean isEnable = true;
        boolean isVisible = true;
        if (ArrivalTypeEnum.DA.getValue().equals(arrivalType)) {
            this.getModel().setValue("isforward", (Object)true);
            isEnable = false;
        } else if (ArrivalTypeEnum.DP.getValue().equals(arrivalType)) {
            this.getModel().setValue("isforward", (Object)false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isforward"});
            isVisible = false;
        } else if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("lettercredit"))) {
            isEnable = false;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"isforward"});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"isforward"});
        if (((Boolean)this.getModel().getValue("isforward")).booleanValue() && ArrivalWayEnum.PAYMENT.getValue().equals(this.getModel().getValue("arrivalway"))) {
            this.getModel().setValue("arrivalway", (Object)ArrivalWayEnum.ACCEPT.getValue());
        }
        if (!((Boolean)this.getModel().getValue("isforward")).booleanValue() && ArrivalWayEnum.ACCEPT.getValue().equals(this.getModel().getValue("arrivalway"))) {
            this.getModel().setValue("arrivalway", (Object)ArrivalWayEnum.PAYMENT.getValue());
        }
    }

    private void setForwardDaysMustInput() {
        boolean isForward = (Boolean)this.getModel().getValue("isforward");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isForward, (String[])new String[]{"forwarddays"});
    }

    private void initBenefiterType() {
        String benefitType = (String)this.getModel().getValue("benefitertype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"fbd_other".equals(benefitType), (String[])new String[]{"benefiterother"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!"fbd_other".equals(benefitType) ? 1 : 0) != 0, (String[])new String[]{"benefiter"});
    }

    private void delBenefiterF7() {
        this.getModel().setValue("benefiter", (Object)"");
        this.getModel().setValue("benefiterother", (Object)"");
    }

    private void setBenefiterOther() {
        DynamicObject benefiter = (DynamicObject)this.getModel().getValue("benefiter");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"benefiterother", EmptyUtil.isNoEmpty((DynamicObject)benefiter) ? benefiter.getString("name") : null);
    }

    private void initBizContactInfo() {
        DynamicObject bizContactor = (DynamicObject)this.getModel().getValue("bizcontactor");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizContactor)) {
            DynamicObject userInfo = BaseDataHelper.getUserInfo((Long)((Long)bizContactor.getPkValue()));
            String phone = userInfo.getString("phone");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bizcontactinfo", (Object)phone);
        }
    }

    private void setArrivalWay() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        boolean isForward = (Boolean)this.getModel().getValue("isforward");
        if (isForward) {
            items.add(new ComboItem(new LocaleString(ArrivalWayEnum.ACCEPT.getName()), ArrivalWayEnum.ACCEPT.getValue()));
            if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() || ArrivalWayEnum.PAYMENT.getValue().equals(this.getModel().getValue("arrivalway"))) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"arrivalway", (Object)ArrivalWayEnum.ACCEPT.getValue());
            }
        } else {
            items.add(new ComboItem(new LocaleString(ArrivalWayEnum.PAYMENT.getName()), ArrivalWayEnum.PAYMENT.getValue()));
            if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() || ArrivalWayEnum.ACCEPT.getValue().equals(this.getModel().getValue("arrivalway"))) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"arrivalway", (Object)ArrivalWayEnum.PAYMENT.getValue());
            }
        }
        items.add(new ComboItem(new LocaleString(ArrivalWayEnum.PROTEST.getName()), ArrivalWayEnum.PROTEST.getValue()));
        ComboEdit property = (ComboEdit)this.getControl("arrivalway");
        property.setComboItems(items);
    }

    private void calTodoAmount() {
        BigDecimal arrivalAmount = (BigDecimal)this.getModel().getValue("arrivalamount");
        BigDecimal doneAmount = (BigDecimal)this.getModel().getValue("doneamount");
        this.getModel().setValue("todoamount", (Object)arrivalAmount.subtract(doneAmount));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("confirm")) {
            op.getOption().setVariableValue("confirm", "true");
            String temp_BillStatus = this.getPageCache().get(TEMP_BILLSTATUS_KEY);
            this.getModel().setValue("billstatus", (Object)temp_BillStatus);
        }
        switch (key = op.getOperateKey()) {
            case "save": {
                this.checkCreditStatus(args);
                this.checkMustInput(args);
                break;
            }
            case "submit": {
                if (!this.checkCreditStatus(args)) break;
                this.checkTotalArrAmount(args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult result = args.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        if ("save".equals(op.getOperateKey()) && this.getView().getFormShowParameter().getCustomParams().containsKey("confirm") && result.isSuccess()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_print"});
            this.getView().invokeOperation("refresh");
        } else if ("unconfirm".equals(op.getOperateKey()) && result.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        switch (property = evt.getProperty().getName()) {
            case "lettercredit": {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                List qFilters = filterParam.getQFilters();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)org)) {
                    evt.setCancel(true);
                    TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"org");
                    break;
                }
                Long orgId = org.getLong("id");
                qFilters.add(new QFilter("org", "=", (Object)orgId));
            }
        }
    }

    private void setInfoEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"org", "currency", "amount", "credittype", "isforward", "forwarddays", "benefitertype", "benefiter", "benefiterother", "arrivalcurrency"});
    }

    private boolean checkCreditStatus(BeforeDoOperationEventArgs args) {
        String creditBillNo;
        DynamicObject letterCredit = (DynamicObject)this.getModel().getValue("lettercredit");
        if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit) && !"".equals(creditBillNo = LetterCreditHelper.getIsCloseCreditStatus((DynamicObject)letterCredit))) {
            String entityName = this.getModel().getDataEntityType().getName();
            if ("lc_arrival".equals(entityName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u6e38\u5f00\u8bc1\u5904\u7406:%s\u4fe1\u7528\u72b6\u6001\u4e3a\u201c\u5df2\u95ed\u5377\u201d\uff0c\u4e0d\u5141\u8bb8\u505a\u6b64\u64cd\u4f5c\u3002", (String)"ArrivalPresentBaseEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]), creditBillNo));
            }
            if ("lc_present".equals(entityName)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u6e38\u6536\u8bc1\u5904\u7406:%s\u4fe1\u7528\u72b6\u6001\u4e3a\u201c\u5df2\u95ed\u5377\u201d\uff0c\u4e0d\u5141\u8bb8\u505a\u6b64\u64cd\u4f5c\u3002", (String)"ArrivalPresentBaseEdit_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]), creditBillNo));
            }
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void checkTotalArrAmount(BeforeDoOperationEventArgs args) {
        if (!this.getPageCache().getAll().containsKey("passSubmit")) {
            DynamicObject credit = (DynamicObject)this.getModel().getValue("lettercredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)credit)) {
                DynamicObject letterCredit;
                BigDecimal amt;
                String entityName = this.getModel().getDataEntityType().getName();
                QFilter qFilter = new QFilter("lettercredit", "=", credit.getPkValue());
                Object id = this.getModel().getValue("id");
                if (EmptyUtil.isNoEmpty((Object)id)) {
                    qFilter.and("id", "!=", id);
                }
                DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)entityName, (String)"arrivalamount,doneamount", (QFilter[])qFilter.toArray());
                BigDecimal arrivalAmount = (BigDecimal)this.getModel().getValue("arrivalamount");
                arrivalAmount = arrivalBills.stream().map(s -> s.getBigDecimal("arrivalamount")).reduce(arrivalAmount, BigDecimal::add);
                String queryEntity = "lc_lettercredit";
                if ("lc_present".equals(entityName)) {
                    queryEntity = "lc_receipt";
                }
                if (arrivalAmount.compareTo(amt = LetterCreditHelper.getAmount((DynamicObject)(letterCredit = TmcDataServiceHelper.loadSingle((Object)credit.getPkValue(), (String)queryEntity)))) > 0) {
                    this.showArrivalReson();
                    args.setCancel(true);
                }
            }
        } else {
            this.getPageCache().remove("passSubmit");
        }
    }

    private void showArrivalReson() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("lc_arrivalreson");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getCustomParams().put("formid", this.getView().getFormShowParameter().getFormId());
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sumbitConfig"));
        this.getView().showForm(param);
    }

    private void checkMustInput(BeforeDoOperationEventArgs args) {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("confirm")) {
            StringBuilder errorTip = new StringBuilder();
            if (((Boolean)this.getModel().getValue("isforward")).booleanValue()) {
                this.validate(errorTip, "forwarddays");
            }
            if ("fbd_other".equals(this.getModel().getValue("benefitertype"))) {
                this.validate(errorTip, "benefiterother");
            }
            if (!"fbd_other".equals(this.getModel().getValue("benefitertype"))) {
                this.validate(errorTip, "benefiter");
            }
            this.validate(errorTip, "arrivalway");
            if (errorTip.length() > 0) {
                this.getView().showTipNotification(errorTip.toString(), Integer.valueOf(1500));
                args.setCancel(true);
            }
        }
    }

    private void validate(StringBuilder errorTip, String prop) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(prop))) {
            errorTip.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"ArrivalPresentBaseEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]), (String)"ArrivalPresentBaseEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[]{this.getModel().getProperty(prop).getDisplayName()})).append('\n');
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"sumbitConfig", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("passSubmit", "true");
            this.getView().invokeOperation("submit");
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (event.getReturnData() == null) {
            return;
        }
        if ("sumbitConfig".equals(actionId)) {
            Map returnData = (Map)event.getReturnData();
            OrmLocaleValue exceedReason = (OrmLocaleValue)returnData.get("exceedReason");
            OperateOption option = OperateOption.create();
            option.setVariableValue("exceedresonlc", exceedReason.getLocaleValue());
            option.setVariableValue("exceedreson", exceedReason.getLocaleValue_zh_CN());
            option.setVariableValue("exceedresontw", exceedReason.getLocaleValue_zh_TW());
            option.setVariableValue("exceedresonen", exceedReason.getLocaleValue_en());
            this.getPageCache().put("passSubmit", "true");
            this.getView().invokeOperation("submit", option);
        }
    }

    private void setDefaultEndpaydate() {
        boolean isForward = (Boolean)this.getModel().getValue("isforward");
        Date endAcceptDate = (Date)this.getModel().getValue("endacceptdate");
        Date endPayDate = (Date)this.getModel().getValue("endpaydate");
        if (isForward && EmptyUtil.isNoEmpty((Object)endAcceptDate) && EmptyUtil.isEmpty((Object)endPayDate)) {
            Object forwardDays = this.getModel().getValue("forwarddays");
            this.getModel().setValue("endpaydate", (Object)DateUtils.getNextDay((Date)endAcceptDate, (int)((Integer)forwardDays)));
        }
    }
}

