/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.feedetail.AbstractBizBillFeeTabEdit;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.property.LetterCreditProp;
import org.apache.commons.lang3.tuple.Pair;

public class LetterBizBillFeeTabEdit
extends AbstractBizBillFeeTabEdit {
    public Pair<String, String> getBizBillFeeAmtFieldProp() {
        return Pair.of((Object)"amount", (Object)ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u91d1\u989d", (String)"LetterBizBillFeeTabEdit_01", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
    }

    public Pair<String, String> getBizBillCurrencyFieldProp() {
        return Pair.of((Object)"currency", (Object)ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u5e01\u79cd", (String)"LetterBizBillFeeTabEdit_02", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
    }

    public void addFeeBilIdQfilter(QFilter feeIdFilter) {
        QFilter arrivalQfilter = new QFilter("lettercredit", "=", this.getModel().getValue("id")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("arrivalstatus", "in", Arrays.asList(ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue(), ArrivalStatusEnum.ARRIVAL_PAY.getValue()));
        DynamicObjectCollection arrivalBils = QueryServiceHelper.query((String)"lc_arrival", (String)"id", (QFilter[])arrivalQfilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)arrivalBils)) {
            List arrivalBillIds = arrivalBils.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            feeIdFilter.or("entry.srcbillid", "in", arrivalBillIds);
        }
    }

    public boolean isLoanOrCreditOrPresentFee(DynamicObject feeBill) {
        String productType = String.valueOf(feeBill.get("entry.producttype"));
        return ProductTypeEnum.LC_ARRIVAL.getId().equals(productType);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(LetterCreditProp.OP_HISTORY_KEY)) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("feedetail");
            ArrayList<Integer> rows = new ArrayList<Integer>(entrys.size());
            for (int row = 0; row < entrys.size(); ++row) {
                if (!this.isExistFeeBill(((DynamicObject)entrys.get(row)).getLong("feebillid"))) continue;
                rows.add(row);
            }
            this.lockRowByIndex(rows.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rows = e.getRowIndexs();
        EntryProp entryProp = e.getEntryProp();
        if ("feedetail".equals(entryProp.getName()) && rows.length > 0 && this.getView().getFormShowParameter().getCustomParams().containsKey(LetterCreditProp.OP_HISTORY_KEY)) {
            for (int row : rows) {
                DynamicObject rowInfo = this.getModel().getEntryRowEntity("feedetail", row);
                if (!this.isExistFeeBill(rowInfo.getLong("feebillid"))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%d\u3011\u884c\u662f\u6539\u8bc1\u65f6\u5386\u53f2\u7684\u8d39\u7528\u660e\u7ec6\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e!", (String)"LetterBizBillFeeTabEdit_03", (String)"tmc-lc-formplugin", (Object[])new Object[0]), row + 1));
                e.setCancel(true);
                return;
            }
        }
    }

    private boolean isExistFeeBill(Long feeBillId) {
        return TmcDataServiceHelper.exists((Object)feeBillId, (String)"cfm_feebill");
    }

    private void lockRowByIndex(int ... indexs) {
        EntryGrid grid = (EntryGrid)this.getControl("feedetail");
        grid.setRowLock(true, indexs);
    }
}

