/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.buyerint;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.lc.common.helper.InterestCalcHelper;

public class BuyerInterestBillEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"acceptbanktext"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.completeDynamicInfo();
        this.completeEntryInfo();
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if (null != value) {
            switch (key) {
                case "term": {
                    this.checkTerm(e, (String)value);
                    break;
                }
                case "effectdate": {
                    this.checkEffectDate(e, DateUtils.stringToDate((String)((String)value), (String)"yyyy-MM-dd"));
                    break;
                }
                case "enddate": {
                    this.checkEndDate(e, DateUtils.stringToDate((String)((String)value), (String)"yyyy-MM-dd"));
                    break;
                }
                case "financeamt": {
                    this.checkFinAmt(e, new BigDecimal((String)value));
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "acceptbanktext": {
                this.acceptBankTextChg();
                break;
            }
            case "acceptbank": {
                this.acceptBankChg();
                break;
            }
            case "term": {
                this.termChg();
                break;
            }
            case "effectdate": {
                this.effectDateChg();
                break;
            }
            case "enddate": {
                this.endDateChg();
                break;
            }
            case "financeamt": 
            case "intamount": {
                this.calcAccountAmt();
                break;
            }
            case "accountamt": 
            case "exchangerate": {
                this.calcObversionAmt(this.getModel().getEntryCurrentRowIndex("entry"));
                break;
            }
            case "obversionamt": {
                this.calcTotalIntAmt();
                break;
            }
            case "currency": {
                this.currencyChg();
            }
        }
    }

    public void click(EventObject evt) {
        TextEdit textField;
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && StringUtils.equals((CharSequence)(textField = (TextEdit)evt.getSource()).getKey(), (CharSequence)"acceptbanktext")) {
            BasedataEdit acceptBank = (BasedataEdit)this.getControl("acceptbank");
            acceptBank.click();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String billStatus;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"callint") && !StringUtils.equals((CharSequence)(billStatus = (String)this.getModel().getValue("billstatus")), (CharSequence)BillStatusEnum.SAVE.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0d\u80fd\u70b9\u51fb\u5229\u606f\u8ba1\u7b97\u3002", (String)"BuyerInterestBillEdit_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"callint")) {
            this.calcInterest();
        }
    }

    private void completeEntryInfo() {
        String botpTag = (String)this.getView().getFormShowParameter().getCustomParams().get("botptag_of_datasource");
        if (EmptyUtil.isEmpty((String)botpTag)) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        int rowIndex = 0;
        for (DynamicObject row : entry) {
            String term = "";
            if (EmptyUtil.isNoEmpty((Object)row.getDate("enddate"))) {
                term = DateUtils.getDiff_ymd((Date)DateUtils.getCurrentDate(), (Date)row.getDate("enddate"));
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"effectdate", (Object)DateUtils.getCurrentDate(), (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"exchangerate", (Object)1, (int)rowIndex);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"term", (Object)term, (int)rowIndex);
            ++rowIndex;
        }
    }

    private void completeDynamicInfo() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        int rowIndex = 0;
        for (DynamicObject row : entry) {
            BigDecimal toDoAmt = row.getDynamicObject("arrival").getBigDecimal("todoamount");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"todoamount", (Object)toDoAmt, (int)rowIndex);
            ++rowIndex;
        }
    }

    private void calcInterest() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject arrivalCurrency = (DynamicObject)this.getModel().getValue("arrivalcurrency");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        String basis = entryRowEntity.getString("basis");
        BigDecimal financeAmt = entryRowEntity.getBigDecimal("financeamt");
        BigDecimal rate = entryRowEntity.getBigDecimal("rate");
        Date effectDate = entryRowEntity.getDate("effectdate");
        int delayDays = entryRowEntity.getInt("delaydays");
        Date endDate = entryRowEntity.getDate("enddate");
        if (null == effectDate || null == endDate || EmptyUtil.isEmpty((BigDecimal)financeAmt) || EmptyUtil.isEmpty((BigDecimal)rate)) {
            this.getModel().setValue("intamount", (Object)BigDecimal.ZERO, rowIndex);
            return;
        }
        IntBillInfo intBillInfo = InterestCalcHelper.callInt((DynamicObject)arrivalCurrency, (BasisEnum)BasisEnum.valueOf((String)basis), (BigDecimal)financeAmt, (BigDecimal)rate, (Date)effectDate, (Date)effectDate, (Date)DateUtils.getNextDay((Date)endDate, (int)delayDays));
        if (null != intBillInfo) {
            this.getModel().setValue("intamount", (Object)intBillInfo.getAmount(), rowIndex);
        }
    }

    private void calcTotalIntAmt() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        BigDecimal totalIntAmt = entry.stream().map(v -> v.getBigDecimal("obversionamt")).filter(EmptyUtil::isNoEmpty).reduce(BigDecimal.ZERO, BigDecimal::add);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"amount", (Object)totalIntAmt);
    }

    private void acceptBankChg() {
        DynamicObject acceptBank = (DynamicObject)this.getModel().getValue("acceptbank");
        if (null != acceptBank) {
            String acceptBankName = acceptBank.getString("name");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"acceptbanktext", (Object)acceptBankName);
        }
    }

    private void acceptBankTextChg() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"acceptbank", null);
    }

    private void checkTerm(BeforeFieldPostBackEvent e, String term) {
        if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) {
            e.setCancel(true);
            this.getView().updateView("term", this.getModel().getEntryCurrentRowIndex("entry"));
        }
    }

    private void checkEffectDate(BeforeFieldPostBackEvent e, Date effectDate) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        Date arrivalDate = entryEntity.getDynamicObject("arrival").getDate("arrivaldate");
        if (effectDate.compareTo(arrivalDate) < 0) {
            e.setCancel(true);
            this.getView().updateView("effectdate", this.getModel().getEntryCurrentRowIndex("entry"));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u878d\u8d44\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5230\u5355\u65e5\u671f\u3002", (String)"BuyerInterestBillEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkEndDate(BeforeFieldPostBackEvent e, Date endDate) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        Date effectDate = entryEntity.getDate("effectdate");
        if (null != effectDate && endDate.compareTo(effectDate) < 0) {
            e.setCancel(true);
            this.getView().updateView("enddate", this.getModel().getEntryCurrentRowIndex("entry"));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u878d\u8d44\u5230\u671f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u878d\u8d44\u751f\u6548\u65e5\u671f\u3002", (String)"BuyerInterestBillEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkFinAmt(BeforeFieldPostBackEvent e, BigDecimal financeAmt) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        BigDecimal toDoAmount = entryEntity.getDynamicObject("arrival").getBigDecimal("todoamount");
        if (financeAmt.compareTo(toDoAmount) > 0) {
            e.setCancel(true);
            this.getView().updateView("financeamt", this.getModel().getEntryCurrentRowIndex("entry"));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u878d\u8d44\u8d44\u91d1\u4e0d\u80fd\u5927\u4e8e\u5230\u5355\u672a\u4ed8\u91d1\u989d\u3002", (String)"BuyerInterestBillEdit_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
        }
    }

    private void effectDateChg() {
        this.termChg();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        this.calcExchangeRate(rowIndex);
    }

    private void termChg() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        Date effectDate = entryEntity.getDate("effectdate");
        String term = entryEntity.getString("term");
        if (null != effectDate && null != term) {
            Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)effectDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate, (int)rowIndex);
        }
    }

    private void endDateChg() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        Date effectDate = entryEntity.getDate("effectdate");
        Date endDate = entryEntity.getDate("enddate");
        if (null != effectDate && null != endDate) {
            String term = DateUtils.getDiff_ymd((Date)effectDate, (Date)endDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)term, (int)rowIndex);
        }
    }

    private void calcAccountAmt() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        BigDecimal financeAmt = entryEntity.getBigDecimal("financeamt");
        BigDecimal intAmount = entryEntity.getBigDecimal("intamount");
        this.getModel().setValue("accountamt", (Object)financeAmt.subtract(intAmount), rowIndex);
    }

    private void calcObversionAmt(int rowIndex) {
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        BigDecimal intAmount = entryEntity.getBigDecimal("intamount");
        BigDecimal exchangeRate = entryEntity.getBigDecimal("exchangerate");
        this.getModel().setValue("obversionamt", (Object)intAmount.multiply(exchangeRate), rowIndex);
    }

    private void currencyChg() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int index = 0; index < entryRowCount; ++index) {
            this.calcExchangeRate(index);
        }
    }

    private void calcExchangeRate(int rowIndex) {
        BigDecimal exchangeRate;
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
        Date effectDate = entryEntity.getDate("effectdate");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (null == effectDate || null == currency) {
            return;
        }
        DynamicObject arrivalCurrency = (DynamicObject)this.getModel().getValue("arrivalcurrency");
        if (arrivalCurrency.getPkValue().equals(currency.getPkValue())) {
            exchangeRate = BigDecimal.ONE;
        } else {
            DynamicObject orgId = (DynamicObject)this.getModel().getValue("org");
            Long exChangeTableId = TmcBusinessBaseHelper.getExchageTableId((Long)orgId.getLong("id"));
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exChangeTableId, (Long)arrivalCurrency.getLong("id"), (Long)currency.getLong("id"), (Date)effectDate);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exchangerate", (Object)exchangeRate, (int)rowIndex);
        this.calcObversionAmt(rowIndex);
    }
}

