/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.convert;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.DataSourceEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.PaymentTypeEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;

public class OnlineResult2LetterCreditPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            String presentDay;
            DynamicObject finOrg;
            String advCode;
            QFilter acctFilter;
            DynamicObject feeAcct;
            DynamicObject letterCreditBill = dataEntity.getDataEntity();
            Long srcId = (Long)letterCreditBill.get("srcbillid");
            DynamicObject onlineResultBill = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName());
            if (EmptyUtil.isNoEmpty((String)onlineResultBill.getString("serialnumber"))) {
                letterCreditBill.set("tradechannel", (Object)TradeChannelEnum.ONLINE.getValue());
            } else {
                letterCreditBill.set("tradechannel", (Object)TradeChannelEnum.OFFLINE.getValue());
            }
            String openDate = onlineResultBill.getString("opendate");
            if (EmptyUtil.isNoEmpty((String)openDate)) {
                letterCreditBill.set("bizdate", (Object)DateUtils.stringToDate((String)openDate, (String)"yyyyMMdd"));
            }
            String creditType = onlineResultBill.getString("credittype");
            letterCreditBill.set("isforward", (Object)"2".equals(creditType));
            String moreProportion = Optional.ofNullable(onlineResultBill.getString("moreproportion")).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
            letterCreditBill.set("amountscaleupper", (Object)new BigDecimal(moreProportion));
            String lessProportion = Optional.ofNullable(onlineResultBill.getString("lessproportion")).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
            letterCreditBill.set("amountscalelow", (Object)new BigDecimal(lessProportion));
            if (EmptyUtil.isNoEmpty((String)onlineResultBill.getString("duedate"))) {
                letterCreditBill.set("validdate", (Object)DateUtils.stringToDate((String)onlineResultBill.getString("duedate"), (String)"yyyyMMdd"));
            }
            letterCreditBill.set("validaddress", (Object)onlineResultBill.getString("dueaddress"));
            letterCreditBill.set("applyaddress", (Object)onlineResultBill.getString("applicantaddressen"));
            String counterName = onlineResultBill.getString("countername");
            if (EmptyUtil.isNoEmpty((String)counterName)) {
                letterCreditBill.set("benefiterother", (Object)counterName);
                QFilter qFilter = new QFilter("name", "=", (Object)counterName);
                DynamicObject bosUser = TmcDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
                if (EmptyUtil.isNoEmpty((DynamicObject)bosUser)) {
                    letterCreditBill.set("benefiter", (Object)bosUser);
                }
            }
            letterCreditBill.set("benefitaddress", (Object)onlineResultBill.getString("counteraddress"));
            String charAccNo = onlineResultBill.getString("characcno");
            if (EmptyUtil.isNoEmpty((String)charAccNo) && EmptyUtil.isNoEmpty((DynamicObject)(feeAcct = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{acctFilter = new QFilter("number", "=", (Object)charAccNo)})))) {
                letterCreditBill.set("lfeeacctbank", (Object)feeAcct);
            }
            if (EmptyUtil.isNoEmpty((String)(advCode = onlineResultBill.getString("advicnapscode"))) && EmptyUtil.isNoEmpty((DynamicObject)(finOrg = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("swift_code", "=", (Object)advCode)})))) {
                letterCreditBill.set("basenoticebank", (Object)finOrg);
                letterCreditBill.set("noticebank", (Object)finOrg.getString("name"));
            }
            letterCreditBill.set("bankaddress", (Object)onlineResultBill.getString("adviaddress"));
            letterCreditBill.set("paymenttype", (Object)PaymentTypeEnum.turnBankValToVal((String)onlineResultBill.getString("paytype")));
            String payDays = onlineResultBill.getString("paydays");
            if (EmptyUtil.isNoEmpty((String)payDays)) {
                letterCreditBill.set("forwarddays", (Object)Integer.parseInt(payDays));
            }
            letterCreditBill.set("isbatch", (Object)"Yes".equals(onlineResultBill.getString("ispartship")));
            letterCreditBill.set("istransfer", (Object)"ALLOWED".equals(onlineResultBill.getString("istranship")));
            String lastShipDate = onlineResultBill.getString("lastshipdate");
            if (EmptyUtil.isNoEmpty((String)lastShipDate)) {
                letterCreditBill.set("lastdate", (Object)DateUtils.stringToDate((String)lastShipDate, (String)"yyyyMMdd"));
            }
            if (EmptyUtil.isNoEmpty((String)(presentDay = onlineResultBill.getString("presentday")))) {
                letterCreditBill.set("days", (Object)Integer.parseInt(presentDay));
            }
            letterCreditBill.set("startplace", (Object)onlineResultBill.getString("startair"));
            letterCreditBill.set("unloadplace", (Object)onlineResultBill.getString("deliveryport"));
            letterCreditBill.set("destination", (Object)onlineResultBill.getString("termini"));
            letterCreditBill.set("datasources", (Object)DataSourceEnum.BANK.getValue());
            letterCreditBill.set("creditstatus", (Object)LetterCreditStatusEnum.DONE_REGISTER.getValue());
            letterCreditBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            BigDecimal amount = letterCreditBill.getBigDecimal("amount");
            if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                String amtStr = Optional.ofNullable(onlineResultBill.getString("amount")).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
                letterCreditBill.set("amount", (Object)new BigDecimal(amtStr));
            }
            DynamicObjectCollection entrys = letterCreditBill.getDynamicObjectCollection("entrys");
            entrys.clear();
            DynamicObject row = entrys.addNew();
            row.set("contractnum", (Object)onlineResultBill.getString("contractno"));
            row.set("contractcurrency", (Object)letterCreditBill.getDynamicObject("currency"));
            String contractAmt = Optional.ofNullable(onlineResultBill.getString("contractamount")).filter(r -> EmptyUtil.isNoEmpty((String)r)).orElse("0");
            row.set("contractamount", (Object)new BigDecimal(contractAmt));
        }
    }
}

