/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.financ;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class FinancConfigEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDataInfo();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control contol = (Control)evt.getSource();
        String key = contol.getKey();
        if ("btnok".equals(key)) {
            Object financAmount = this.getModel().getValue("financamount");
            if (financAmount == null || ((BigDecimal)financAmount).compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u878d\u8d44\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"FinancConfigEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>(2);
            returnData.put("id", this.getModel().getValue("id"));
            returnData.put("entityname", this.getModel().getValue("entityname"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void initDataInfo() {
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"id", (Object)pkId);
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"entityname", (Object)entityName);
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)pkId, (String)entityName, (String)"arrivalcurrency,todoamount,lockamount");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", (Object)bill.get("arrivalcurrency"));
        BigDecimal todoAmount = bill.getBigDecimal("todoamount");
        BigDecimal lockAmount = bill.getBigDecimal("lockamount");
        BigDecimal calAmount = todoAmount.subtract(lockAmount);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"financamount", (Object)calAmount);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"maxamount", (Object)calAmount);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"cashamount", (Object)calAmount);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        if ("financamount".equals(key) && EmptyUtil.isNoEmpty((Object)value)) {
            BigDecimal maxAmount;
            BigDecimal finAmount = new BigDecimal(String.valueOf(value));
            if (finAmount.compareTo(maxAmount = (BigDecimal)this.getModel().getValue("maxamount")) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u878d\u8d44\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\uff1a%s\u3002", (String)"FinancConfigEdit_0", (String)"tmc-lc-formplugin", (Object[])new Object[]{maxAmount}));
                e.setCancel(true);
            }
            this.getView().updateView("financamount");
        }
    }
}

