/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditHistoryProp;

public class LetterCreditHistoryEdit
extends AbstractBillPlugIn {
    private static String COLOR_THEMECOLOR = "rgba(85, 130, 243, .2)";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getValue());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("trackup".equals(op.getOperateKey())) {
            Long id = (Long)this.getModel().getValue("id");
            DynamicObject history = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_lettercredit_h", (String)"applyid,creditapplyno");
            if (EmptyUtil.isNoEmpty((Long)history.getLong(LetterCreditHistoryProp.APPLYID))) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setPkId((Object)history.getLong(LetterCreditHistoryProp.APPLYID));
                parameter.setFormId("lc_bizapply");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setBillStatus(BillOperationStatus.VIEW);
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getCustomParams().put("TrackUp", "true");
                this.getView().showForm((FormShowParameter)parameter);
                args.setCancel(true);
            }
        } else if ("close".equals(op.getOperateKey())) {
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControlFontColor();
        this.getModel().setDataChanged(false);
    }

    protected void initControlFontColor() {
        DynamicObject initLetterCredit = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue(LetterCreditHistoryProp.SOURCEBILLID), (String)this.getModel().getDataEntityType().getName());
        DataEntityPropertyCollection propertys = this.getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : propertys) {
            if ("entrys".equals(property.getName())) {
                DynamicObjectCollection oldEntrys = this.getModel().getEntryEntity("entrys");
                Map<String, Object> oldMaps = this.getMapInfo(oldEntrys);
                DynamicObjectCollection newEntrys = initLetterCredit.getDynamicObjectCollection("entrys");
                Map<String, Object> newMaps = this.getMapInfo(newEntrys);
                this.isEqualsForEntrys(newMaps, oldMaps);
                continue;
            }
            Object newVal = initLetterCredit.get(property.getName());
            Object oldVal = this.getModel().getValue(property.getName());
            if (LetterCreditHelper.isEquals((Object)oldVal, (Object)newVal) || "multilanguagetext".equals(property.getName())) continue;
            TmcViewInputHelper.showModifyTip((IFormView)this.getView(), (String)property.getName(), (String)ResManager.loadKDString((String)"\u5b57\u6bb5\u6709\u4fee\u6539", (String)"LetterCreditHistoryEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
        }
    }

    protected void isEqualsForEntrys(Map<String, Object> newMaps, Map<String, Object> oldMaps) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        EntryGrid grid = (EntryGrid)this.getControl("entrys");
        for (Map.Entry<String, Object> newEntry : newMaps.entrySet()) {
            if (oldMaps.containsKey(newEntry.getKey())) {
                CellStyle style;
                Object newVal = newEntry.getValue();
                Object oldVal = oldMaps.get(newEntry.getKey());
                String[] split = newEntry.getKey().split(";");
                if (EmptyUtil.isNoEmpty((Object)oldVal) && EmptyUtil.isEmpty((Object)newVal)) {
                    style = this.addStyle(split[1], Integer.parseInt(split[2]));
                    cellStyles.add(style);
                    continue;
                }
                if (LetterCreditHelper.isEquals((Object)oldVal, (Object)newVal) || !EmptyUtil.isNoEmpty((Object)(style = this.addStyle(split[1], Integer.parseInt(split[2]))))) continue;
                cellStyles.add(style);
                continue;
            }
            this.setAllCollStyle(newEntry, cellStyles);
        }
        if (newMaps.isEmpty()) {
            for (Map.Entry<String, Object> oldEntry : oldMaps.entrySet()) {
                this.setAllCollStyle(oldEntry, cellStyles);
            }
        }
        grid.setCellStyle(cellStyles);
    }

    private void setAllCollStyle(Map.Entry<String, Object> entry, List<CellStyle> cellStyles) {
        String[] split = entry.getKey().split(";");
        CellStyle style = this.addStyle(split[1], Integer.parseInt(split[2]));
        if (EmptyUtil.isNoEmpty((Object)style)) {
            cellStyles.add(style);
        }
    }

    private Map<String, Object> getMapInfo(DynamicObjectCollection entrys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int k = 0; k < entrys.size(); ++k) {
            DynamicObject entry = (DynamicObject)entrys.get(k);
            Long newSourId = entry.getLong(LetterCreditHistoryProp.SOURCEENTRYID);
            DataEntityPropertyCollection ePropertys = entrys.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : ePropertys) {
                Object val = entry.get(property.getName());
                map.put(newSourId + ";" + property.getName() + ";" + k, val);
            }
        }
        return map;
    }

    private CellStyle addStyle(String propertyName, int index) {
        if (Arrays.asList("id", "seq", "sourceentryid").contains(propertyName)) {
            return null;
        }
        CellStyle style = new CellStyle();
        style.setFieldKey(propertyName);
        style.setRow(index);
        style.setBackColor(COLOR_THEMECOLOR);
        return style;
    }
}

