/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.home;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.enums.WarnTypeEnum;
import kd.tmc.lc.common.property.LetterCreditProp;
import org.apache.commons.lang3.tuple.Pair;

public class AppHomeExpireWarnPlugin
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String LETTER_CREDIT_QUERY_FIELD = "org,billno,bank,noticebank,applydate,creditno,currency,amount,bizcontactor,billstatus,creditstatus,validdate,lastdate,id";
    private static final String ARRIVAL_PRESENT_QUERY_FIELD = "org,billno,arrivalno,arrivalcurrency,arrivalamount,arrivaldate,lettercredit,currency,amount,bizcontactor,endacceptdate,endpaydate,billstatus,arrivalstatus,validdate,lastdate,id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"notitybutton"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entrys");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit orgEdit = (MulBasedataEdit)this.getControl("statorg");
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setDateBill();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)property, (CharSequence)"statorg")) {
            String entityName = (String)this.getModel().getValue("direction");
            if (EmptyUtil.isEmpty((String)entityName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201d\u7edf\u8ba1\u65b9\u5411\u201c\u3002", (String)"AppHomeExpireWarnPlugin_34", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityName, (String)"47150e89000000ac");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        super.propertyChanged(args);
        switch (key = args.getProperty().getName()) {
            case "direction": {
                this.setWarnTypeComboItems();
                this.setDateBill();
                break;
            }
            case "warntype": 
            case "expireday": 
            case "custexpireenddate": 
            case "custexpirestartdate": 
            case "day": 
            case "statorg": {
                this.setDateBill();
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "notitybutton": {
                this.executeWarnNotity();
            }
        }
    }

    private void setEntryShowStyle() {
        String entityName = (String)this.getModel().getValue("direction");
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        DateEdit applyEdit = (DateEdit)this.getControl("applydate");
        DateEdit endAcceptEdit = (DateEdit)this.getControl("endacceptdate");
        DateEdit endPayEdit = (DateEdit)this.getControl("endpaydate");
        AmountEdit amountEdit = (AmountEdit)this.getControl("arrivalamount");
        TextEdit arrivalNo = (TextEdit)this.getControl("arrivalno");
        if ("lc_lettercredit".equals(entityName)) {
            orgEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f00\u8bc1\u4eba", (String)"AppHomeExpireWarnPlugin_0", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            applyEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u767b\u8bb0\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_1", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
        } else if ("lc_arrival".equals(entityName)) {
            orgEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"AppHomeExpireWarnPlugin_3", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            applyEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5230\u5355\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_4", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            endAcceptEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6700\u8fdf\u627f\u5151/\u4ed8\u6b3e\u786e\u8ba4\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_5", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            endPayEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6700\u8fdf\u4ed8\u6b3e\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_6", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            amountEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5230\u5355\u91d1\u989d", (String)"AppHomeExpireWarnPlugin_8", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            arrivalNo.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5230\u5355\u7f16\u53f7", (String)"AppHomeExpireWarnPlugin_9", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
        } else if ("lc_receipt".equals(entityName)) {
            orgEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d7\u76ca\u4eba", (String)"AppHomeExpireWarnPlugin_10", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            applyEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u767b\u8bb0\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_1", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
        } else if ("lc_present".equals(entityName)) {
            orgEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"AppHomeExpireWarnPlugin_3", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            applyEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5355\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_12", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            endAcceptEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5bf9\u65b9\u6700\u8fdf\u627f\u5151/\u4ed8\u6b3e\u786e\u8ba4\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_13", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            endPayEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5bf9\u65b9\u6700\u8fdf\u4ed8\u6b3e\u65e5\u671f", (String)"AppHomeExpireWarnPlugin_14", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            amountEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5355\u91d1\u989d", (String)"AppHomeExpireWarnPlugin_16", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
            arrivalNo.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u5355\u7f16\u53f7", (String)"AppHomeExpireWarnPlugin_17", (String)"tmc-lc-formplugin", (Object[])new Object[0])));
        }
        this.setFieldShowOrHidden(entityName);
    }

    private void setFieldShowOrHidden(String entityName) {
        if ("lc_lettercredit".equals(entityName)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bank", "noticebank", LetterCreditProp.LETTERCREDIT_STATUS});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"arrivalamount", "arrivalno", "endacceptdate", "endpaydate", LetterCreditProp.ARRIVAL_STATUS, LetterCreditProp.RECEIPT_STATUS, LetterCreditProp.PRESENT_STATUS});
        } else if ("lc_arrival".equals(entityName)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bank", "noticebank", LetterCreditProp.LETTERCREDIT_STATUS, LetterCreditProp.RECEIPT_STATUS, LetterCreditProp.PRESENT_STATUS});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"arrivalamount", "arrivalno", "endacceptdate", "endpaydate", LetterCreditProp.ARRIVAL_STATUS});
        } else if ("lc_receipt".equals(entityName)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bank", "noticebank", LetterCreditProp.RECEIPT_STATUS});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"arrivalamount", "arrivalno", "endacceptdate", "endpaydate", LetterCreditProp.LETTERCREDIT_STATUS, LetterCreditProp.ARRIVAL_STATUS, LetterCreditProp.PRESENT_STATUS});
        } else if ("lc_present".equals(entityName)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bank", "noticebank", LetterCreditProp.LETTERCREDIT_STATUS, LetterCreditProp.ARRIVAL_STATUS, LetterCreditProp.RECEIPT_STATUS});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"arrivalamount", "arrivalno", "endacceptdate", "endpaydate", LetterCreditProp.PRESENT_STATUS});
        }
    }

    private void setWarnTypeComboItems() {
        String entityName = (String)this.getModel().getValue("direction");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if ("lc_lettercredit".equals(entityName) || "lc_receipt".equals(entityName)) {
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.VALIDDATE.getName()), WarnTypeEnum.VALIDDATE.getValue()));
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.LASTDATE.getName()), WarnTypeEnum.LASTDATE.getValue()));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"warntype", (Object)WarnTypeEnum.VALIDDATE.getValue());
        } else if ("lc_arrival".equals(entityName)) {
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.ARRIVALDATE_ARRIVAL.getName()), WarnTypeEnum.ARRIVALDATE_ARRIVAL.getValue()));
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.ENDACCEPTDATE_ARRIVAL.getName()), WarnTypeEnum.ENDACCEPTDATE_ARRIVAL.getValue()));
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.ENDPAYDATE_ARRIVALE.getName()), WarnTypeEnum.ENDPAYDATE_ARRIVALE.getValue()));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"warntype", (Object)WarnTypeEnum.ARRIVALDATE_ARRIVAL.getValue());
        } else if ("lc_present".equals(entityName)) {
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.ARRIVALDATE_PRESENT.getName()), WarnTypeEnum.ARRIVALDATE_PRESENT.getValue()));
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.ENDACCEPTDATE_PRESENT.getName()), WarnTypeEnum.ENDACCEPTDATE_PRESENT.getValue()));
            items.add(new ComboItem(new LocaleString(WarnTypeEnum.ENDPAYDATE_PRESENT.getName()), WarnTypeEnum.ENDPAYDATE_PRESENT.getValue()));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"warntype", (Object)WarnTypeEnum.ARRIVALDATE_PRESENT.getValue());
        }
        ComboEdit property = (ComboEdit)this.getControl("warntype");
        property.setComboItems(items);
    }

    private void setDateBill() {
        this.setEntryShowStyle();
        Object[] dataBills = this.getBillDate();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entrys");
        if (EmptyUtil.isNoEmpty((Object[])dataBills)) {
            String entityName = (String)this.getModel().getValue("direction");
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            if ("lc_lettercredit".equals(entityName) || "lc_receipt".equals(entityName)) {
                this.buildDataLetterCredit((DynamicObject[])dataBills, entityName, vs);
            } else if ("lc_arrival".equals(entityName) || "lc_present".equals(entityName)) {
                this.buildDataArrivalPresent((DynamicObject[])dataBills, entityName, vs);
            }
            model.batchCreateNewEntryRow("entrys", vs);
            model.endInit();
            this.getView().updateView("entrys");
        }
    }

    private DynamicObject[] getBillDate() {
        String expireDay = (String)this.getModel().getValue("expireday");
        if ("customday".equals(expireDay)) {
            int day = (Integer)this.getModel().getValue("day");
            if (day <= 0 || day > 365) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u524d\u9884\u8b66\u5929\u6570\u5fc5\u586b\u4e14\u4e3a\u5c0f\u4e8e\u7b49\u4e8e365\u6b63\u6574\u6570\u3002", (String)"AppHomeExpireWarnPlugin_18", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return null;
            }
        } else if ("customrange".equals(expireDay)) {
            Date endDate = (Date)this.getModel().getValue("custexpireenddate");
            if (endDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u586b\u3002", (String)"AppHomeExpireWarnPlugin_32", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return null;
            }
            Date startDate = (Date)this.getModel().getValue("custexpirestartdate");
            if (startDate != null && startDate.after(endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"AppHomeExpireWarnPlugin_33", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return null;
            }
        }
        String entityName = (String)this.getModel().getValue("direction");
        String warnType = (String)this.getModel().getValue("warntype");
        if ("lc_arrival".equals(entityName) || "lc_present".equals(entityName)) {
            warnType = warnType.split("_")[0];
        }
        QFilter filters = this.getDateFilter(warnType);
        DynamicObjectCollection statOrgList = (DynamicObjectCollection)this.getModel().getValue("statorg");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)statOrgList)) {
            filters.and("org", "in", statOrgList.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        List orgIds = new ArrayList();
        String appId = this.getView().getFormShowParameter().getAppId();
        String queryField = "";
        if ("lc_lettercredit".equals(entityName) || "lc_receipt".equals(entityName)) {
            filters.and("creditstatus", "!=", (Object)LetterCreditStatusEnum.DONE_CLOSE.getValue());
            queryField = LETTER_CREDIT_QUERY_FIELD;
            if ("lc_lettercredit".equals(entityName)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"lc_lettercredit", (String)"47150e89000000ac");
            } else if ("lc_receipt".equals(entityName)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"lc_receipt", (String)"47150e89000000ac");
            }
        } else if ("lc_arrival".equals(entityName)) {
            filters.and("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_PAY.getValue());
            queryField = ARRIVAL_PRESENT_QUERY_FIELD;
            orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"lc_arrival", (String)"47150e89000000ac");
        } else if ("lc_present".equals(entityName)) {
            filters.and("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_RECIECT.getValue());
            queryField = ARRIVAL_PRESENT_QUERY_FIELD;
            orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"lc_present", (String)"47150e89000000ac");
        }
        if (orgIds.size() <= 0) {
            return new DynamicObject[0];
        }
        filters.and("org", "in", orgIds);
        DynamicObject[] bills = TmcDataServiceHelper.load((String)entityName, (String)queryField, (QFilter[])filters.toArray(), (String)warnType);
        return bills;
    }

    private void buildDataLetterCredit(DynamicObject[] dataBills, String entityName, TableValueSetter vs) {
        vs.addField("org", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("bank", new Object[0]);
        vs.addField("noticebank", new Object[0]);
        vs.addField("applydate", new Object[0]);
        vs.addField("creditno", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("bizcontactor", new Object[0]);
        vs.addField("billstatus", new Object[0]);
        vs.addField(entityName.split("_")[1] + "_status", new Object[0]);
        vs.addField("validdate", new Object[0]);
        vs.addField("lastdate", new Object[0]);
        vs.addField("id", new Object[0]);
        for (DynamicObject dataBill : dataBills) {
            String openBank = "";
            DynamicObject bank = dataBill.getDynamicObject("bank");
            if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
                openBank = bank.getString("name");
            }
            String noticeBank = dataBill.getString("noticebank");
            if ("lc_receipt".equals(entityName)) {
                openBank = noticeBank;
                if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
                    noticeBank = bank.getString("name");
                }
            }
            DynamicObject currency = dataBill.getDynamicObject("currency");
            DynamicObject bizContactor = dataBill.getDynamicObject("bizcontactor");
            vs.addRow(new Object[]{dataBill.getDynamicObject("org").getPkValue(), dataBill.getString("billno"), openBank, noticeBank, dataBill.getDate("applydate"), dataBill.getString("creditno"), EmptyUtil.isEmpty((DynamicObject)currency) ? null : currency.getPkValue(), dataBill.getBigDecimal("amount"), EmptyUtil.isEmpty((DynamicObject)bizContactor) ? null : bizContactor.getPkValue(), dataBill.getString("billstatus"), dataBill.getString("creditstatus"), dataBill.getDate("validdate"), dataBill.getDate("lastdate"), dataBill.getLong("id")});
        }
    }

    private void buildDataArrivalPresent(DynamicObject[] dataBills, String entityName, TableValueSetter vs) {
        vs.addField("org", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("arrivalno", new Object[0]);
        vs.addField("arrivalcurrency", new Object[0]);
        vs.addField("arrivalamount", new Object[0]);
        vs.addField("applydate", new Object[0]);
        vs.addField("creditno", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("bizcontactor", new Object[0]);
        vs.addField("endacceptdate", new Object[0]);
        vs.addField("endpaydate", new Object[0]);
        vs.addField("billstatus", new Object[0]);
        vs.addField(entityName.split("_")[1] + "_status", new Object[0]);
        vs.addField("validdate", new Object[0]);
        vs.addField("lastdate", new Object[0]);
        vs.addField("id", new Object[0]);
        for (DynamicObject dataBill : dataBills) {
            DynamicObject arrivalCurrency = dataBill.getDynamicObject("arrivalcurrency");
            DynamicObject letterCredit = dataBill.getDynamicObject("lettercredit");
            DynamicObject currency = dataBill.getDynamicObject("currency");
            DynamicObject bizContactor = dataBill.getDynamicObject("bizcontactor");
            vs.addRow(new Object[]{dataBill.getDynamicObject("org").getPkValue(), dataBill.getString("billno"), dataBill.getString("arrivalno"), EmptyUtil.isEmpty((DynamicObject)arrivalCurrency) ? null : arrivalCurrency.getPkValue(), dataBill.getBigDecimal("arrivalamount"), dataBill.getDate("arrivaldate"), EmptyUtil.isEmpty((DynamicObject)letterCredit) ? null : letterCredit.getString("number"), EmptyUtil.isEmpty((DynamicObject)currency) ? null : currency.getPkValue(), dataBill.getBigDecimal("amount"), EmptyUtil.isEmpty((DynamicObject)bizContactor) ? null : bizContactor.getPkValue(), dataBill.getDate("endacceptdate"), dataBill.getDate("endpaydate"), dataBill.getString("billstatus"), dataBill.getString("arrivalstatus"), dataBill.getDate("validdate"), dataBill.getDate("lastdate"), dataBill.getLong("id")});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String entityName = (String)this.getModel().getValue("direction");
        int rowIndex = evt.getRowIndex();
        DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entrys").get(rowIndex);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityName);
        showParameter.setPkId((Object)rowData.getLong("id"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void executeWarnNotity() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entrys");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u9884\u8b66\u901a\u77e5\u7684\u6570\u636e\u3002", (String)"AppHomeExpireWarnPlugin_19", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<Long, Integer> notityMap = new HashMap<Long, Integer>(16);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entrys", selectRows[i]);
                DynamicObject bizContactor = rowEntity.getDynamicObject("bizcontactor");
                Long userId = (Long)bizContactor.getPkValue();
                notityMap.put(userId, notityMap.getOrDefault(userId, 0) + 1);
            }
            this.sendMessageInfo(notityMap);
        }
    }

    private void sendMessageInfo(Map<Long, Integer> notityMap) {
        String entityName = (String)this.getModel().getValue("direction");
        String warnType = (String)this.getModel().getValue("warntype");
        MessageInfo message = new MessageInfo();
        for (Map.Entry<Long, Integer> map : notityMap.entrySet()) {
            String tag = ResManager.loadKDString((String)"\u5f00\u8bc1\u5904\u7406", (String)"AppHomeExpireWarnPlugin_20", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
            String splice = ResManager.loadKDString((String)"\u5f00\u8bc1-%s", (String)"AppHomeExpireWarnPlugin_21", (String)"tmc-lc-formplugin", (Object[])new Object[]{WarnTypeEnum.getName((String)warnType)});
            String contert = ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165PC\u7aef\u201c\u5f00\u8bc1\u7ba1\u7406-%s\u201d\u83dc\u5355\uff0c\u6216\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u5feb\u901f\u5904\u7406\u3002", (String)"AppHomeExpireWarnPlugin_22", (String)"tmc-lc-formplugin", (Object[])new Object[]{tag});
            if ("lc_arrival".equals(entityName)) {
                tag = ResManager.loadKDString((String)"\u5230\u5355\u5904\u7406", (String)"AppHomeExpireWarnPlugin_23", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                splice = ResManager.loadKDString((String)"\u5230\u5355-%s", (String)"AppHomeExpireWarnPlugin_24", (String)"tmc-lc-formplugin", (Object[])new Object[]{WarnTypeEnum.getName((String)warnType)});
                contert = ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165PC\u7aef\u201c\u5f00\u8bc1\u7ba1\u7406-%s\u201d\u83dc\u5355\uff0c\u6216\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u5feb\u901f\u5904\u7406\u3002", (String)"AppHomeExpireWarnPlugin_22", (String)"tmc-lc-formplugin", (Object[])new Object[]{tag});
            } else if ("lc_receipt".equals(entityName)) {
                tag = ResManager.loadKDString((String)"\u6536\u8bc1\u5904\u7406", (String)"AppHomeExpireWarnPlugin_25", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                splice = ResManager.loadKDString((String)"\u6536\u8bc1-%s", (String)"AppHomeExpireWarnPlugin_26", (String)"tmc-lc-formplugin", (Object[])new Object[]{WarnTypeEnum.getName((String)warnType)});
                contert = ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165PC\u7aef\u201c\u6536\u8bc1\u7ba1\u7406-%s\u201d\u83dc\u5355\uff0c\u6216\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u5feb\u901f\u5904\u7406\u3002", (String)"AppHomeExpireWarnPlugin_27", (String)"tmc-lc-formplugin", (Object[])new Object[]{tag});
            } else if ("lc_present".equals(entityName)) {
                tag = ResManager.loadKDString((String)"\u4ea4\u5355\u5904\u7406", (String)"AppHomeExpireWarnPlugin_28", (String)"tmc-lc-formplugin", (Object[])new Object[0]);
                splice = ResManager.loadKDString((String)"\u4ea4\u5355-%s", (String)"AppHomeExpireWarnPlugin_29", (String)"tmc-lc-formplugin", (Object[])new Object[]{WarnTypeEnum.getName((String)warnType)});
                contert = ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165PC\u7aef\u201c\u6536\u8bc1\u7ba1\u7406-%s\u201d\u83dc\u5355\uff0c\u6216\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u5feb\u901f\u5904\u7406\u3002", (String)"AppHomeExpireWarnPlugin_27", (String)"tmc-lc-formplugin", (Object[])new Object[]{tag});
            }
            String title = String.format(ResManager.loadKDString((String)"\u60a8\u6709%1$s\u6761\u201c%2$s\u201d\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"AppHomeExpireWarnPlugin_30", (String)"tmc-lc-formplugin", (Object[])new Object[0]), map.getValue(), splice);
            message.setTag(tag);
            message.setTitle(title);
            message.setContent(contert);
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + entityName + "&type=list");
            message.setUserIds(Collections.singletonList(map.getKey()));
            message.setType("warning");
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u8b66\u901a\u77e5\u6210\u529f\u3002", (String)"AppHomeExpireWarnPlugin_31", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
    }

    public QFilter getDateFilter(String dateFieldName) {
        Pair<Date, Date> dateDatePair = this.transDate();
        Date startDate = (Date)dateDatePair.getLeft();
        Date endDate = (Date)dateDatePair.getRight();
        QFilter dateFilter = new QFilter(dateFieldName, "<=", (Object)endDate);
        if (startDate != null) {
            dateFilter.and(new QFilter(dateFieldName, ">=", (Object)startDate));
        }
        return dateFilter;
    }

    private Pair<Date, Date> transDate() {
        Date startDate = DateUtils.getCurrentDate();
        Date endDate = DateUtils.getCurrentDate();
        String expireday = (String)this.getModel().getValue("expireday");
        if ("thisweek".equals(expireday)) {
            startDate = DateUtils.getFirstDayOfWeek((Date)startDate);
            endDate = DateUtils.getMaxWeekDate((Date)endDate);
        } else if ("thismonth".equals(expireday)) {
            startDate = DateUtils.getFirstDayOfMonth((Date)startDate);
            endDate = DateUtils.getMaxMonthDate((Date)endDate);
        } else if ("nextweek".equals(expireday)) {
            startDate = DateUtils.getNextWeekMonday((Date)startDate);
            endDate = DateUtils.getMaxWeekDate((Date)startDate);
        } else if ("nextmonth".equals(expireday)) {
            startDate = DateUtils.getFirstDateOfNextMonth((Date)startDate);
            endDate = DateUtils.getMaxMonthDate((Date)startDate);
        } else if ("customrange".equals(expireday)) {
            startDate = (Date)this.getModel().getValue("custexpirestartdate");
            endDate = (Date)this.getModel().getValue("custexpireenddate");
            endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        } else if ("customday".equals(expireday)) {
            endDate = DateUtils.getNextDay((Date)endDate, (int)((Integer)this.getModel().getValue("day")));
            endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }
}

