/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalWayEnum;

public class LetterCreditInitEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("lc_lettercredit_init".equals(formId)) {
            EntryGrid arrivalEntry = (EntryGrid)this.getControl("arrivalentry");
            arrivalEntry.addHyperClickListener((HyperLinkClickListener)this);
        } else if ("lc_receipt_init".equals(formId)) {
            EntryGrid presentEntry = (EntryGrid)this.getControl("presententry");
            presentEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDealBillTerm();
        this.setArrivalWay(false, null);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "isforward": {
                this.setArrivalWay(true, null);
                break;
            }
            case "validdate": {
                this.initDealBillTerm();
                break;
            }
            case "a_arrivalamount": 
            case "p_presentamount": {
                this.initDealDoneAmount(rowIndex);
                break;
            }
            case "a_doneamount": 
            case "p_doneamount": {
                this.intDoneAmtChgEvt((BigDecimal)args.getChangeSet()[0].getOldValue(), rowIndex);
                break;
            }
        }
    }

    private void intDoneAmtChgEvt(BigDecimal oldValue, int rowIndex) {
        BigDecimal doneAmt = (BigDecimal)this.getModel().getValue(this.getEntryPropName("a_doneamount"), rowIndex);
        if (EmptyUtil.isEmpty((BigDecimal)doneAmt)) {
            return;
        }
        BigDecimal arrivalAmt = (BigDecimal)this.getModel().getValue(this.getEntryPropName("a_arrivalamount"), rowIndex);
        if (EmptyUtil.isNoEmpty((BigDecimal)arrivalAmt) && doneAmt.compareTo(arrivalAmt) > 0) {
            doneAmt = oldValue;
            if ("lc_lettercredit_init".equals(this.getView().getFormShowParameter().getFormId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5230\u5355\u91d1\u989d\u3002", (String)"LetterCreditInitEdit_4", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            } else if ("lc_receipt_init".equals(this.getView().getFormShowParameter().getFormId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6536\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ea4\u5355\u91d1\u989d\u3002", (String)"LetterCreditInitEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getEntryPropName("a_doneamount"), (Object)doneAmt, (int)rowIndex);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int currRowIndex = e.getRowDataEntities()[0].getRowIndex();
        if (currRowIndex < 0) {
            return;
        }
        this.setArrivalWay(true, currRowIndex);
        this.initDealDoneAmount(currRowIndex);
    }

    private void initDealBillTerm() {
        Date validDate = (Date)this.getModel().getValue("validdate");
        if (validDate != null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            if ("lc_lettercredit_init".equals(formId)) {
                DateEdit arrivalDate = (DateEdit)this.getControl("a_arrivaldate");
                arrivalDate.setMaxDate(validDate);
            } else if ("lc_receipt_init".equals(formId)) {
                DateEdit presentDate = (DateEdit)this.getControl("p_presentdate");
                presentDate.setMaxDate(validDate);
            }
        }
    }

    private void initDealDoneAmount(int rowIndex) {
        BigDecimal arrivalAmt;
        DynamicObjectCollection arrivalPresentEntry = this.getArrivalPresentEntry();
        if (!CollectionUtils.isEmpty((Collection)arrivalPresentEntry) && EmptyUtil.isNoEmpty((BigDecimal)(arrivalAmt = (BigDecimal)this.getModel().getValue(this.getEntryPropName("a_arrivalamount"), rowIndex)))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getEntryPropName("a_doneamount"), (Object)arrivalAmt, (int)rowIndex);
        }
    }

    private void setArrivalWay(boolean isAfterBind, Integer currRowIndex) {
        DynamicObjectCollection arrivalPresentEntry;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        boolean isForward = (Boolean)this.getModel().getValue("isforward");
        if (isForward) {
            items.add(new ComboItem(new LocaleString(ArrivalWayEnum.ACCEPT.getName()), ArrivalWayEnum.ACCEPT.getValue()));
            if (isAfterBind && (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() || OperationStatus.EDIT.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) && (arrivalPresentEntry = this.getArrivalPresentEntry()) != null) {
                for (int i = 0; i < arrivalPresentEntry.size(); ++i) {
                    if (currRowIndex != null && i < currRowIndex) continue;
                    String propName = this.getEntryPropName("a_arrivalway");
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)propName, (Object)ArrivalWayEnum.ACCEPT.getValue(), (int)i);
                }
            }
        } else {
            items.add(new ComboItem(new LocaleString(ArrivalWayEnum.PAYMENT.getName()), ArrivalWayEnum.PAYMENT.getValue()));
            if (isAfterBind && (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() || OperationStatus.EDIT.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) && (arrivalPresentEntry = this.getArrivalPresentEntry()) != null) {
                for (int i = 0; i < arrivalPresentEntry.size(); ++i) {
                    if (currRowIndex != null && i < currRowIndex) continue;
                    String propName = this.getEntryPropName("a_arrivalway");
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)propName, (Object)ArrivalWayEnum.PAYMENT.getValue(), (int)i);
                }
            }
        }
        items.add(new ComboItem(new LocaleString(ArrivalWayEnum.PROTEST.getName()), ArrivalWayEnum.PROTEST.getValue()));
        ComboEdit property = (ComboEdit)this.getControl(this.getEntryPropName("a_arrivalway"));
        property.setComboItems(items);
    }

    private DynamicObjectCollection getArrivalPresentEntry() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("lc_lettercredit_init".equals(formId)) {
            return this.getModel().getDataEntity(true).getDynamicObjectCollection("arrivalentry");
        }
        if ("lc_receipt_init".equals(formId)) {
            return this.getModel().getDataEntity(true).getDynamicObjectCollection("presententry");
        }
        return null;
    }

    private String getEntryPropName(String propName) {
        String newPropName = propName;
        if ("lc_receipt_init".equals(this.getView().getFormShowParameter().getFormId())) {
            switch (propName) {
                case "a_arrivalno": {
                    newPropName = "p_presentno";
                    break;
                }
                case "a_arrivaldate": {
                    newPropName = "p_presentdate";
                    break;
                }
                case "a_arrivalway": {
                    newPropName = "p_arrivalway";
                    break;
                }
                case "a_arrivalamount": {
                    newPropName = "p_presentamount";
                    break;
                }
                case "a_doneamount": {
                    newPropName = "p_doneamount";
                    break;
                }
            }
        }
        return newPropName;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIdx = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("lc_lettercredit_init".equals(formId) && "a_arrivalno".equals(fieldName)) {
            String arrivalNo = (String)this.getModel().getValue("a_arrivalno", rowIdx);
            QFilter qFilter = new QFilter("arrivalno", "=", (Object)arrivalNo);
            qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            DynamicObject arrivalBillDo = QueryServiceHelper.queryOne((String)"lc_arrival", (String)"id", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObject)arrivalBillDo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u662f\u5426\u751f\u6210\u5230\u5355\u3002", (String)"LetterCreditInitEdit_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter param = new BillShowParameter();
            param.setFormId("lc_arrival");
            param.setPkId(arrivalBillDo.get("id"));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)param);
        } else if ("lc_receipt_init".equals(formId) && "p_presentno".equals(fieldName)) {
            String presentNo = (String)this.getModel().getValue("p_presentno", rowIdx);
            QFilter qFilter = new QFilter("arrivalno", "=", (Object)presentNo);
            qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            DynamicObject presentBillDo = QueryServiceHelper.queryOne((String)"lc_present", (String)"id", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObject)presentBillDo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u662f\u5426\u751f\u6210\u4ea4\u5355\u3002", (String)"LetterCreditInitEdit_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter param = new BillShowParameter();
            param.setFormId("lc_present");
            param.setPkId(presentBillDo.get("id"));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

