/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.init;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class LetterCreditInitList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("finishinit".equals(operateKey) || "cancelinit".equals(operateKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refreshData();
        } else if ("tracklc".equals(operateKey)) {
            this.trackLetterCredit();
        }
    }

    private void trackLetterCredit() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String entityName = "lc_lettercredit_init".equals(formId) ? "lc_lettercredit_init" : "lc_receipt_init";
        QFilter idqFilter = new QFilter("id", "=", (Object)id);
        DynamicObject letterCreditInit = QueryServiceHelper.queryOne((String)entityName, (String)String.join((CharSequence)",", "creditno", "billstatus"), (QFilter[])idqFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObject)letterCreditInit) || !BillStatusEnum.AUDIT.getValue().equals(letterCreditInit.getString("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u72b6\u6001\u624d\u80fd\u8054\u67e5\u4fe1\u7528\u8bc1\u3002", (String)"LetterCreditInitList_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        entityName = "lc_lettercredit_init".equals(formId) ? "lc_lettercredit" : "lc_receipt";
        QFilter qFilter = new QFilter("creditno", "=", (Object)letterCreditInit.getString("creditno"));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection letterCredit = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)letterCredit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditInitList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackView(letterCredit.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
    }

    protected void showTrackView(List<Long> pkIds) {
        IFormView view = this.getView();
        String formId = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId(formId.replace("_init", ""));
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(formId.replace("_init", ""));
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }
}

