/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.lettercredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillSourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.BackCreditTypeEnum;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditProp;
import kd.tmc.lc.formplugin.helper.DebtRelateSuretyHelper;

public class LetterCreditEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        BasedataEdit childCreditEdit;
        BasedataEdit motherCreditEdit;
        TextEdit creditApplyEdit = (TextEdit)this.getControl("creditapplyno");
        if (creditApplyEdit != null) {
            creditApplyEdit.addButtonClickListener((ClickListener)this);
        }
        if ((motherCreditEdit = (BasedataEdit)this.getControl("b_mothercredit")) != null) {
            motherCreditEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((childCreditEdit = (BasedataEdit)this.getControl("b_childcredit")) != null) {
            childCreditEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        EntryGrid backCreditGrid = (EntryGrid)this.getControl("entry_backcredit");
        backCreditGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailinfo"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        String applyNo = (String)this.getModel().getValue("creditapplyno");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus) && !"".equals(applyNo)) {
            this.setInfoEnable(false);
        }
        Long pkId = (Long)this.getModel().getValue("id");
        QFilter arrFilter = new QFilter("lettercredit", "=", (Object)pkId);
        arrFilter.and("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue());
        boolean arrInfo = TmcDataServiceHelper.exists((String)"lc_arrival", (QFilter[])arrFilter.toArray());
        this.getView().setVisible(Boolean.valueOf(arrInfo), new String[]{"detailinfo"});
        this.setBackCreditTypeMustInput();
        this.initBenefitType();
        this.initCreditInfo();
        DebtRelateSuretyHelper.initSuretyColumn(this.getView(), this.getModel());
        DebtRelateSuretyHelper.fillSuretyEntry(this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "currency": {
                DebtRelateSuretyHelper.initSuretyColumn(this.getView(), this.getModel());
                DebtRelateSuretyHelper.suretyMoneyChgEvt(this.getView(), this.getModel());
                break;
            }
            case "credittype": 
            case "bank": 
            case "creditamount": {
                this.clearCreditLimit();
                break;
            }
            case "amountscaleupper": 
            case "amount": {
                if (!this.getView().getFormShowParameter().getCustomParams().containsKey(LetterCreditProp.OP_HISTORY_KEY)) {
                    this.clearCreditLimit();
                }
                DebtRelateSuretyHelper.suretyMoneyChgEvt(this.getView(), this.getModel());
                break;
            }
            case "creditapplyno": {
                this.changeCreditApplyNo();
                break;
            }
            case "benefitertype": {
                this.initBenefitType();
                this.initBenefit();
                break;
            }
            case "benefiter": {
                this.initBenefit();
                break;
            }
            case "basenoticebank": {
                DynamicObject baseNoticeBank = (DynamicObject)this.getModel().getValue("basenoticebank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)baseNoticeBank)) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"noticebank", (Object)baseNoticeBank.get("name"));
                break;
            }
            case "backcredittype": {
                this.getModel().deleteEntryData("entry_backcredit");
                break;
            }
            case "b_mothercredit": 
            case "b_childcredit": {
                DynamicObject motherCredit = (DynamicObject)this.getModel().getValue("b_mothercredit", rowIndex);
                DynamicObject childCredit = (DynamicObject)this.getModel().getValue("b_childcredit", rowIndex);
                HashMap<Object, BigDecimal> payAmountMap = new HashMap<Object, BigDecimal>(1);
                if (EmptyUtil.isNoEmpty((DynamicObject)motherCredit)) {
                    DynamicObjectCollection presentCollection = QueryServiceHelper.query((String)"lc_present", (String)"doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue()), new QFilter("lettercredit", "=", motherCredit.getPkValue())});
                    BigDecimal payAmountSum = Constants.ZERO;
                    for (DynamicObject presentBill : presentCollection) {
                        payAmountSum = payAmountSum.add(presentBill.getBigDecimal("doneamount"));
                    }
                    payAmountMap.put(motherCredit.getPkValue(), payAmountSum);
                } else if (EmptyUtil.isNoEmpty((DynamicObject)childCredit)) {
                    DynamicObjectCollection arrivalCollection = QueryServiceHelper.query((String)"lc_present", (String)"doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue()), new QFilter("lettercredit", "=", childCredit.getPkValue())});
                    BigDecimal payAmountSum = Constants.ZERO;
                    for (DynamicObject arrivalBill : arrivalCollection) {
                        payAmountSum = payAmountSum.add(arrivalBill.getBigDecimal("doneamount"));
                    }
                    payAmountMap.put(childCredit.getPkValue(), payAmountSum);
                }
                LetterCreditHelper.initCreditInfo((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)motherCredit, (DynamicObject)childCredit, payAmountMap, (int)rowIndex);
                break;
            }
            case "isbackcredit": {
                this.setBackCreditTypeMustInput();
                break;
            }
            case "guarantee": {
                DebtRelateSuretyHelper.initSuretyColumn(this.getView(), this.getModel());
                break;
            }
            case "promisrate": 
            case "suretycur": {
                DebtRelateSuretyHelper.suretyMoneyChgEvt(this.getView(), this.getModel());
                break;
            }
            case "suretymoney": {
                DebtRelateSuretyHelper.actualCreditMoneyChgEvt(this.getView(), this.getModel(), (BigDecimal)args.getChangeSet()[0].getNewValue());
                break;
            }
        }
    }

    private void setBackCreditTypeMustInput() {
        boolean isBackCredit = (Boolean)this.getModel().getValue("isbackcredit");
        if (isBackCredit && EmptyUtil.isEmpty((String)((String)this.getModel().getValue("backcredittype")))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"backcredittype", (Object)BackCreditTypeEnum.CHILD_CREDIT.getValue());
        } else if (!isBackCredit) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"backcredittype", null);
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isBackCredit, (String[])new String[]{"backcredittype"});
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"b_org", "b_benefiter"}, (boolean)isBackCredit);
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"b_orgother", "b_benefiterother"}, (!isBackCredit ? 1 : 0) != 0);
    }

    private void initBenefit() {
        String backCreditType = (String)this.getModel().getValue("backcredittype");
        if (BackCreditTypeEnum.MOTHER_CREDIT.getValue().equals(backCreditType)) {
            this.getModel().deleteEntryData("entry_backcredit");
        }
    }

    private void initCreditInfo() {
        DynamicObjectCollection backCreditEntry = this.getModel().getEntryEntity("entry_backcredit");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)backCreditEntry)) {
            return;
        }
        HashSet<Object> motherIds = new HashSet<Object>(backCreditEntry.size());
        HashSet<Object> childIds = new HashSet<Object>(backCreditEntry.size());
        for (DynamicObject backCredit : backCreditEntry) {
            DynamicObject motherCredit = backCredit.getDynamicObject("b_mothercredit");
            DynamicObject childCredit = backCredit.getDynamicObject("b_childcredit");
            if (EmptyUtil.isNoEmpty((DynamicObject)motherCredit)) {
                motherIds.add(motherCredit.getPkValue());
                continue;
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)childCredit)) continue;
            childIds.add(childCredit.getPkValue());
        }
        HashMap<Long, BigDecimal> payAmountMap = new HashMap<Long, BigDecimal>(backCreditEntry.size());
        DynamicObjectCollection presentCollection = QueryServiceHelper.query((String)"lc_present", (String)"lettercredit,doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)PresentStatusEnum.PRESENT_REGISTER.getValue()), new QFilter("lettercredit", "in", motherIds)});
        for (Object presentBill : presentCollection) {
            BigDecimal payAmount = (BigDecimal)payAmountMap.get(presentBill.getLong("lettercredit"));
            if (payAmount == null) {
                payAmount = Constants.ZERO;
            }
            payAmountMap.put(presentBill.getLong("lettercredit"), payAmount.add(presentBill.getBigDecimal("doneamount")));
        }
        DynamicObjectCollection arrivalCollection = QueryServiceHelper.query((String)"lc_arrival", (String)"lettercredit,doneamount", (QFilter[])new QFilter[]{new QFilter("arrivalstatus", "!=", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue()), new QFilter("lettercredit", "in", childIds)});
        for (DynamicObject arrivalBill : arrivalCollection) {
            BigDecimal payAmount = (BigDecimal)payAmountMap.get(arrivalBill.getLong("lettercredit"));
            if (payAmount == null) {
                payAmount = Constants.ZERO;
            }
            payAmountMap.put(arrivalBill.getLong("lettercredit"), payAmount.add(arrivalBill.getBigDecimal("doneamount")));
        }
        for (int rowIndex = 0; rowIndex < backCreditEntry.size(); ++rowIndex) {
            DynamicObject backCredit = (DynamicObject)backCreditEntry.get(rowIndex);
            DynamicObject motherCredit = backCredit.getDynamicObject("b_mothercredit");
            DynamicObject childCredit = backCredit.getDynamicObject("b_childcredit");
            LetterCreditHelper.initCreditInfo((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)motherCredit, (DynamicObject)childCredit, payAmountMap, (int)rowIndex);
        }
    }

    private void initBenefitType() {
        String benefitType = (String)this.getModel().getValue("benefitertype");
        if ("bos_org".equals(benefitType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"basenoticebank"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"basenoticebank"});
        }
    }

    private void clearCreditLimit() {
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            this.getModel().setValue("creditlimit", null);
        }
    }

    public void click(EventObject evt) {
        String key;
        if (evt.getSource() instanceof Control && "creditapplyno".equals(key = ((Control)evt.getSource()).getKey())) {
            this.drawLetterCreditApplyBill();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "trackreceipt": {
                args.setCancel(true);
                this.trackReceiptBill(this.getModel().getValue("creditno"));
                break;
            }
            case "audit": {
                this.checkExistCreditNo(op.getOption());
                break;
            }
        }
    }

    private void checkExistCreditNo(OperateOption option) {
        String creditNo = (String)this.getModel().getValue("creditno");
        QFilter receiptFilter = new QFilter("creditno", "=", (Object)creditNo);
        boolean exists = TmcDataServiceHelper.exists((String)"lc_receipt", (QFilter[])receiptFilter.toArray());
        option.setVariableValue("existSameCreditNo", String.valueOf(exists));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "save": 
            case "submit": {
                LetterCreditHelper.deleteBotpRation((Object)this.getModel().getValue("id"));
                String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
                if (!(parentView instanceof BillView) || !"cas_paybill".equals(((BillView)parentView).getFormId())) break;
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
                break;
            }
            case "audit": {
                LetterCreditHelper.deleteBotpRation((Object)this.getModel().getValue("id"));
                String benefitType = (String)this.getModel().getValue("benefitertype");
                DynamicObject benefitDo = (DynamicObject)this.getModel().getValue("benefiter");
                if (EmptyUtil.isEmpty((DynamicObject)benefitDo)) {
                    return;
                }
                boolean recSwitch = LetterCreditHelper.checkRecCompCredit((IDataModel)this.getModel(), (long)benefitDo.getLong("id"));
                if (!"bos_org".equals(benefitType) || !recSwitch) break;
                String exists = op.getOption().getVariableValue("existSameCreditNo", "false");
                if (Boolean.parseBoolean(exists)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u76f8\u540c\u4fe1\u7528\u8bc1\u53f7\u7684\u6536\u8bc1\u5355\u636e\uff0c\u81ea\u52a8\u751f\u6210\u5931\u8d25\u3002", (String)"LetterCreditEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u540c\u65f6\u751f\u6210\u6536\u8bc1\u5355\u636e\u3002", (String)"LetterCreditEdit_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "unaudit": {
                if (!((Boolean)this.getModel().getValue("issurety")).booleanValue() || this.existSurety()) break;
                this.saveIsSuretyInfo(false, this.getModel().getValue("id"));
                break;
            }
        }
    }

    private boolean existSurety() {
        return QueryServiceHelper.exists((String)"fbd_suretybill", (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "entry", "debtbillid"), "=", this.getModel().getValue("id")).and(String.join((CharSequence)".", "entry", "debttype"), "=", (Object)this.getModel().getDataEntityType().getName())});
    }

    private void saveIsSuretyInfo(boolean isSurety, Object id) {
        DynamicObject isSuretyChange = TmcDataServiceHelper.loadSingle((String)this.getModel().getDataEntityType().getName(), (String)"issurety", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        if (EmptyUtil.isNoEmpty((DynamicObject)isSuretyChange)) {
            isSuretyChange.set("issurety", (Object)isSurety);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{isSuretyChange});
        }
    }

    private void trackReceiptBill(Object creditNo) {
        if (EmptyUtil.isEmpty((Object)creditNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditEdit_4", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter creditQFilter = new QFilter("creditno", "=", creditNo);
        DynamicObjectCollection receiptBill = QueryServiceHelper.query((String)"lc_receipt", (String)"id", (QFilter[])new QFilter[]{creditQFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)receiptBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditEdit_4", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackView(receiptBill.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
    }

    protected void showTrackView(List<Long> pkIds) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId("lc_receipt");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("lc_receipt");
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private void drawLetterCreditApplyBill() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "creditapplyno");
        Long currentOrgId = TmcOrgDataHelper.getCurrentOrgId();
        QFilter qFilter = new QFilter("org", "=", (Object)currentOrgId);
        DynamicObjectCollection letterCreditBills = QueryServiceHelper.query((String)"lc_lettercredit", (String)"creditapplyno", (QFilter[])qFilter.toArray());
        HashSet<String> paramSet = new HashSet<String>(letterCreditBills.size());
        for (DynamicObject letterCreditBill : letterCreditBills) {
            paramSet.add(letterCreditBill.getString("creditapplyno"));
        }
        QFilter qFilterSour = new QFilter("biztype", "=", (Object)LetterBizTypeEnum.OPEN_CARD.getValue());
        qFilterSour.and("billno", "not in", paramSet);
        TmcBotpHelper.doBeforeDraw((IFormView)this.getView(), (String)"lc_bizapply", (String)this.getModel().getDataEntityType().getName(), (Boolean)false, (QFilter)qFilterSour, (CloseCallBack)closeCallBack);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)"creditapplyno", (CharSequence)e.getActionId())) {
            Object creditLimit;
            String applyNo;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                this.delCurrFeeDetail();
                this.delCurrSuretyDetail();
                TmcBotpHelper.doDraw((IFormView)this.getView(), (String)"lc_bizapply", (String)this.getModel().getDataEntityType().getName(), (ListSelectedRowCollection)rows);
                Object[] selectIds = rows.getPrimaryKeyValues();
                Long selectId = (Long)selectIds[0];
                List attachments = AttachmentServiceHelper.getAttachments((String)"lc_bizapply", (Object)selectId, (String)"attachmentpanel");
                if (attachments.size() > 0) {
                    List attaList = TmcAttachmentHelper.copyAttachment((List)attachments, (String)"lc_lettercredit");
                    HashMap<String, List> attachementInfo = new HashMap<String, List>(16);
                    attachementInfo.put("attachmentpanel", attaList);
                    IPageCache pageCache = this.getView().getPageCache();
                    pageCache.put("TampAttCache" + this.getView().getPageId(), SerializationUtils.toJsonString(attachementInfo));
                    this.getView().updateView("attachmentpanel");
                }
            }
            if (EmptyUtil.isNoEmpty((String)(applyNo = (String)this.getModel().getValue("creditapplyno")))) {
                this.setInfoEnable(false);
            }
            if (EmptyUtil.isNoEmpty((Object)(creditLimit = this.getModel().getValue("creditlimit")))) {
                this.getModel().setValue("creditlimit", null);
                this.getModel().setValue("creditlimit", creditLimit);
            }
        }
    }

    private void delCurrSuretyDetail() {
        this.getModel().deleteEntryData("entry_surety");
    }

    private void delCurrFeeDetail() {
        this.getModel().deleteEntryData("feedetail");
        QFilter feeLinkFilter = new QFilter("entry.srcbillid", "=", this.getModel().getValue("id"));
        feeLinkFilter.and(new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()));
        DeleteServiceHelper.delete((String)"cfm_feebill", (QFilter[])new QFilter[]{feeLinkFilter});
    }

    private void setInfoEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"org", "currency", "benefitertype", "benefiter", "benefiterother"});
    }

    private void changeCreditApplyNo() {
        String creditApplyNo = (String)this.getModel().getValue("creditapplyno");
        if (EmptyUtil.isEmpty((String)creditApplyNo)) {
            this.setInfoEnable(true);
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        boolean isBackCredit = (Boolean)this.getModel().getValue("isbackcredit");
        String backCreditType = (String)this.getModel().getValue("backcredittype");
        DynamicObjectCollection backCreditEntry = this.getModel().getEntryEntity("entry_backcredit");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (StringUtils.equals((CharSequence)property, (CharSequence)"b_mothercredit") && isBackCredit && StringUtils.equals((CharSequence)backCreditType, (CharSequence)BackCreditTypeEnum.CHILD_CREDIT.getValue())) {
            ArrayList collect;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter qFilter = new QFilter("org", "=", org.getPkValue());
            List<Object> list = collect = EmptyUtil.isEmpty((DynamicObjectCollection)backCreditEntry) ? new ArrayList(16) : backCreditEntry.stream().filter(a -> EmptyUtil.isNoEmpty((DynamicObject)a.getDynamicObject("b_mothercredit"))).map(b -> b.getDynamicObject("b_mothercredit").getString("billno")).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(collect)) {
                qFilter.and("billno", "not in", collect);
            }
            qFilters.add(qFilter);
        } else if (StringUtils.equals((CharSequence)property, (CharSequence)"b_childcredit") && isBackCredit && StringUtils.equals((CharSequence)backCreditType, (CharSequence)BackCreditTypeEnum.MOTHER_CREDIT.getValue())) {
            ArrayList collect;
            DynamicObject benefit = (DynamicObject)this.getModel().getValue("benefiter");
            if (EmptyUtil.isEmpty((DynamicObject)benefit)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d7\u76ca\u4eba\u3002", (String)"LetterCreditEdit_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("org", "=", benefit.getPkValue());
            List<Object> list = collect = EmptyUtil.isEmpty((DynamicObjectCollection)backCreditEntry) ? new ArrayList(16) : backCreditEntry.stream().filter(a -> EmptyUtil.isNoEmpty((DynamicObject)a.getDynamicObject("b_childcredit"))).map(b -> b.getDynamicObject("b_childcredit").getString("billno")).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(collect)) {
                qFilter.and("billno", "not in", collect);
            }
            qFilters.add(qFilter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject motherCreditDo;
        String fieldName;
        int rowIdx = evt.getRowIndex();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasPermission = LetterCreditHelper.hyperLink((String)appId, (String)(fieldName = evt.getFieldName()), (DynamicObject)(motherCreditDo = (DynamicObject)this.getModel().getValue(fieldName, rowIdx)));
        if (!hasPermission) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6bcd\u8bc1\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"LetterCreditList_14", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter param = new BillShowParameter();
        param.setFormId("lc_receipt");
        param.setPkId(motherCreditDo.getPkValue());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isChanged = this.getModel().getDataChanged();
        this.relateApplySurety();
        if (!isChanged) {
            this.getModel().setDataChanged(false);
        }
        this.controlBillEntry();
    }

    private void controlBillEntry() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!"lc_lettercredit".equals(formId)) {
            return;
        }
        if ("cas_paybill".equals(this.getModel().getValue("sourcebilltype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "bank", "currency", "amount", "benefitertype", "benefiter", "benefiterother"});
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        this.getView().setVisible(Boolean.valueOf(entryRowCount > 0), new String[]{"billflex"});
    }

    private void relateApplySurety() {
        String applyNo = this.getModel().getDataEntity().getString("creditapplyno");
        if (EmptyUtil.isEmpty((String)applyNo)) {
            return;
        }
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((String)"lc_bizapply", (String)String.join((CharSequence)".", "entry_surety", "suretybill"), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)applyNo)});
        if (EmptyUtil.isEmpty((DynamicObject)applyBill)) {
            return;
        }
        DynamicObjectCollection sureties = applyBill.getDynamicObjectCollection("entry_surety");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)sureties)) {
            return;
        }
        int suretyEntry = this.getModel().getEntryRowCount("entry_surety");
        if (EmptyUtil.isEmpty((Integer)suretyEntry)) {
            int newEntryRow = this.getModel().createNewEntryRow("entry_surety");
            DynamicObject suretyBill = ((DynamicObject)sureties.get(0)).getDynamicObject("suretybill");
            this.getModel().setValue("suretybill", (Object)suretyBill, newEntryRow);
            this.getModel().setValue("suretyfinorg", (Object)suretyBill.getDynamicObject("finorginfo"), newEntryRow);
            this.getModel().setValue("suretycurrency", (Object)suretyBill.getDynamicObject("currency"), newEntryRow);
            this.getModel().setValue("suretyamount", (Object)suretyBill.getBigDecimal("amount"), newEntryRow);
            this.getModel().setValue("suretyaccount", (Object)suretyBill.getDynamicObject("settleaccount"), newEntryRow);
            this.getModel().setValue("suretyintdate", (Object)suretyBill.getDate("intdate"), newEntryRow);
            this.getModel().setValue("suretyterm", (Object)suretyBill.getString("term"), newEntryRow);
            this.getModel().setValue("suretyexpiredate", (Object)suretyBill.getDate("expiredate"), newEntryRow);
            this.getModel().setValue("suretysource", (Object)BillSourceEnum.HAND.getValue(), newEntryRow);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"entry_surety", "bar_saddine", "bar_sdeleteline"});
    }
}

