/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.lettercredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.LcParameterHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditProp;
import kd.tmc.lc.formplugin.base.AbstractBaseList;

public class LetterCreditList
extends AbstractBaseList
implements HyperLinkClickListener {
    private static final String CONFIRM_LETTER_AMOUNT = "confirm_letter_amount";
    private static final String AFTER_CREDIT_SURETY_AMT_CONFIRM = "after_credit_surety_amt_confirm";
    public static final String AFTER_CONFIRM = "afterConfirm";
    public static final String OP_SUBMIT = "submit";
    private static final String LETTER_CREDIT_PROP = String.join((CharSequence)",", "billno", "creditstatus", "billstatus", "creditno", "currency", "org", "amount", "amountscaleupper", "repealdate", "notarramount", "creditlimit", "bebankstatus", "tradechannel", "suretymoney", "currency.name");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qFilter = new QFilter("isinit", "=", (Object)Boolean.TRUE);
        QFilter initFilter = qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter unionFilter = initFilter.or(new QFilter("isinit", "=", (Object)Boolean.FALSE));
        e.getQFilters().add(unionFilter);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String isQueryDefault;
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Optional<FilterColumn> bizDateFilterOp = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"applydate")).findFirst();
        if (bizDateFilterOp.isPresent() && "no".equals(isQueryDefault = (String)listShowParameter.getCustomParam("isquerydefault"))) {
            bizDateFilterOp.get().setDefaultValue("");
        }
        this.removeSpareFilter(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "tblclosecard": {
                Long id = (Long)operationResult.getSuccessPkIds().get(0);
                boolean isApplyClose = LcParameterHelper.getAppBoolParameter((long)this.getLetterOrgId(id), (String)LetterCreditProp.IS_APPLY_CLOSE);
                this.showBizConfigPage(id, "close", isApplyClose);
                break;
            }
            case "save": 
            case "submit": {
                LetterCreditHelper.deleteBotpRation(operationResult.getSuccessPkIds().get(0));
                break;
            }
            case "audit": {
                List idList = operationResult.getSuccessPkIds();
                DynamicObjectCollection letterBill = QueryServiceHelper.query((String)"lc_lettercredit", (String)"benefitertype,benefiter,tradechannel", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
                if (EmptyUtil.isEmpty((DynamicObjectCollection)letterBill)) break;
                LetterCreditHelper.deleteBotpRation(idList.get(0));
                DynamicObject letterCredit = (DynamicObject)letterBill.get(0);
                String benefitType = letterCredit.getString("benefitertype");
                Long orgId = letterCredit.getLong("benefiter");
                boolean recSwitch = LetterCreditHelper.checkRecCompCredit((DynamicObject)letterCredit, (long)orgId);
                if (!"bos_org".equals(benefitType) || !recSwitch) break;
                String exists = op.getOption().getVariableValue("existSameCreditNo", "false");
                if (Boolean.parseBoolean(exists)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u76f8\u540c\u4fe1\u7528\u8bc1\u53f7\u7684\u6536\u8bc1\u5355\u636e\uff0c\u81ea\u52a8\u751f\u6210\u5931\u8d25\u3002", (String)"LetterCreditList_19", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u540c\u65f6\u751f\u6210\u6536\u8bc1\u5355\u636e\u3002", (String)"LetterCreditList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "pusharrival": {
                this.showArrivalForm(operationResult.getSuccessPkIds().get(0));
                break;
            }
            case "unaudit": {
                if (!args.getOperationResult().isSuccess()) break;
                this.updateIsSuretyInfoFalse();
                break;
            }
            case "commitbe": 
            case "recommitbe": {
                ((BillList)this.getControl("billlistap")).refreshData();
                break;
            }
            case "tblactivate": {
                Long id = (Long)operationResult.getSuccessPkIds().get(0);
                this.showBizConfigPage(id, "activate", false);
                break;
            }
            case "tblrepeal": {
                Long id = (Long)operationResult.getSuccessPkIds().get(0);
                boolean isApplyRepeal = LcParameterHelper.getAppBoolParameter((long)this.getLetterOrgId(id), (String)LetterCreditProp.IS_APPLY_REPEAL);
                this.showBizConfigPage(id, "repeal", isApplyRepeal);
                break;
            }
            case "tblcancelrepeal": {
                BigDecimal notArrAmount;
                Long id = (Long)operationResult.getSuccessPkIds().get(0);
                DynamicObject letterCredit = this.loadLetterCredit(id);
                letterCredit.set("creditstatus", (Object)LetterCreditStatusEnum.DONE_REGISTER.getValue());
                if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit.getDynamicObject("creditlimit")) && BigDecimal.ZERO.compareTo(notArrAmount = letterCredit.getBigDecimal("notarramount")) != 0) {
                    CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)letterCredit, (DynamicObject)letterCredit, (boolean)false, (BigDecimal)notArrAmount, (Long)((Long)letterCredit.getPkValue()));
                }
                letterCredit.set("repealdate", null);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{letterCredit});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u64a4\u8bc1\u6210\u529f\u3002", (String)"LetterCreditList_18", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
                break;
            }
            case "changecredit": {
                Long id = (Long)operationResult.getSuccessPkIds().get(0);
                this.showBizConfigPage(id, "creditchange", false);
                break;
            }
        }
    }

    private void updateIsSuretyInfoFalse() {
        List selectedIdList = this.getSelectedIdList();
        selectedIdList.removeAll(this.getAlreadySuretyDebtId());
        this.saveIsSuretyInfo(false, selectedIdList);
    }

    private void saveIsSuretyInfo(boolean isSurety, List<Long> idList) {
        Object[] isSuretyChangeList = TmcDataServiceHelper.load((String)this.getDataEntityName(), (String)"issurety", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        Arrays.stream(isSuretyChangeList).forEach(d -> d.set("issurety", (Object)isSurety));
        if (EmptyUtil.isNoEmpty((Object[])isSuretyChangeList)) {
            SaveServiceHelper.save((DynamicObject[])isSuretyChangeList);
        }
    }

    private List<Long> getAlreadySuretyDebtId() {
        List selectedIdList = this.getSelectedIdList();
        DynamicObjectCollection suretyBills = QueryServiceHelper.query((String)"fbd_suretybill", (String)String.join((CharSequence)".", "entry", "debtbillid"), (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "entry", "debtbillid"), "in", (Object)selectedIdList).and(String.join((CharSequence)".", "entry", "debttype"), "=", (Object)this.getDataEntityName())});
        return suretyBills.stream().map(d -> d.getLong(String.join((CharSequence)".", "entry", "debtbillid"))).collect(Collectors.toList());
    }

    private void showArrivalForm(Object pkId) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"lc_lettercredit", (Long[])new Long[]{(Long)pkId});
        HashSet arrivalSet = (HashSet)targetBills.get("lc_arrival");
        if (arrivalSet == null || arrivalSet.isEmpty()) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(arrivalSet.stream().sorted(Comparator.reverseOrder()).findFirst().get());
        showParameter.setFormId("lc_arrival");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showBizConfigPage(Long id, String operate, boolean apply) {
        if (apply) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(null);
            showParameter.setFormId("lc_bizapply");
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setCustomParam("biztype", (Object)(operate + "_card"));
            showParameter.setCustomParam("lettercredit", (Object)id);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("lc_bizconfig");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put("id", id);
            showParameter.getCustomParams().put("operate", operate);
            showParameter.getCustomParams().put("entity", "lc_lettercredit");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm_back"));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"confirm_back", (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "history": {
                if (!this.checkCanHistory()) {
                    args.setCancel(true);
                    return;
                }
                this.getPageCache().put("history", "true");
                break;
            }
            case "modify": {
                if (!this.getPageCache().getAll().containsKey("clickapply")) break;
                args.setCancel(true);
                this.getPageCache().remove("clickapply");
                break;
            }
            case "suretyconfigm": {
                if (this.checkCanSuretyConfirm()) break;
                args.setCancel(true);
                break;
            }
            case "tblclosecard": {
                Long id = super.getSelectedId();
                if (!EmptyUtil.isEmpty((Long)id)) break;
                args.setCancel(true);
                break;
            }
            case "trackreceipt": {
                args.setCancel(true);
                this.trackReceiptBill();
                break;
            }
            case "trackmother": {
                args.setCancel(true);
                this.trackMotherCredit();
                break;
            }
            case "trackchild": {
                args.setCancel(true);
                this.trackChildCredit();
                break;
            }
            case "audit": {
                if (this.checkExistCreditNo(op.getOption())) break;
                args.setCancel(true);
                break;
            }
            case "submit": {
                this.verifyCreditAndSuretyAmt(args, op);
                break;
            }
            case "tblactivate": 
            case "tblrepeal": 
            case "tblcancelrepeal": 
            case "changecredit": {
                if (null != this.getSelectedId()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private void verifyCreditAndSuretyAmt(BeforeDoOperationEventArgs args, AbstractOperate op) {
        if (op.getOption().getVariables().containsKey(AFTER_CREDIT_SURETY_AMT_CONFIRM)) {
            return;
        }
        List selectedIdList = this.getSelectedIdList();
        if (selectedIdList.size() != 1) {
            return;
        }
        Long bizId = (Long)selectedIdList.get(0);
        DynamicObject letterCredit = this.loadLetterCredit(bizId);
        if (EmptyUtil.isNoEmpty((BigDecimal)letterCredit.getBigDecimal("amount")) && EmptyUtil.isNoEmpty((Object)letterCredit.get("creditlimit")) && EmptyUtil.isNoEmpty((BigDecimal)letterCredit.getBigDecimal("suretymoney"))) {
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)((Long)selectedIdList.get(0)), (String)this.getDataEntityName());
            BigDecimal creditAmount = creditUseBill.getBigDecimal("bizcreditamount");
            BigDecimal letterAmount = LetterCreditHelper.getAmount((DynamicObject)letterCredit);
            if (letterCredit.getBigDecimal("suretymoney").add(creditAmount).compareTo(letterAmount) > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u7528\u91d1\u989d + \u4fdd\u8bc1\u91d1\u91d1\u989d\u5df2\u8d85\u51fa\u5f00\u8bc1\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"LetterCreditList_17", (String)"tmc-lc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_LETTER_AMOUNT, (IFormPlugin)this));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_LETTER_AMOUNT.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(AFTER_CREDIT_SURETY_AMT_CONFIRM, "1");
            this.getPageCache().put(AFTER_CREDIT_SURETY_AMT_CONFIRM, "1");
            if (EmptyUtil.isNoEmpty((String)this.getPageCache().get(AFTER_CONFIRM))) {
                option.setVariableValue(AFTER_CONFIRM, "1");
                this.getPageCache().remove(AFTER_CONFIRM);
            }
            this.getView().invokeOperation(OP_SUBMIT, option);
        }
    }

    private boolean checkExistCreditNo(OperateOption option) {
        DynamicObject[] receiptBillArr;
        List selectedIdList = super.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            return false;
        }
        DynamicObject[] letterCreditArr = this.loadLetterCredit(selectedIdList);
        ArrayList<String> creditNoList = new ArrayList<String>(letterCreditArr.length);
        for (DynamicObject letterCredit : letterCreditArr) {
            if (EmptyUtil.isEmpty((DynamicObject)letterCredit)) {
                return false;
            }
            creditNoList.add(letterCredit.getString("creditno"));
        }
        for (DynamicObject receiptBill : receiptBillArr = TmcDataServiceHelper.load((String)"lc_receipt", (String)"id", (QFilter[])new QFilter[]{new QFilter("creditno", "in", creditNoList)})) {
            option.setVariableValue("existSameCreditNo", String.valueOf(!EmptyUtil.isEmpty((DynamicObject)receiptBill)));
        }
        return true;
    }

    private void trackReceiptBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        DynamicObject letterCreditBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_lettercredit", (String)"creditno");
        if (EmptyUtil.isEmpty((String)letterCreditBill.getString("creditno"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditList_13", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter creditQFilter = new QFilter("creditno", "=", (Object)letterCreditBill.getString("creditno"));
        DynamicObjectCollection receiptBill = QueryServiceHelper.query((String)"lc_receipt", (String)"id", (QFilter[])new QFilter[]{creditQFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)receiptBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditList_13", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackView(receiptBill.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
    }

    private void trackMotherCredit() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection letterCreditCollection = QueryServiceHelper.query((String)"lc_lettercredit", (String)"entry_backcredit.b_mothercredit,entry_backcredit.b_mothercredit.number,entry_backcredit.b_mothercredit.org", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)letterCreditCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditList_13", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> backIdList = new ArrayList<Long>();
        for (DynamicObject letterCredit : letterCreditCollection) {
            Long backId = letterCredit.getLong("entry_backcredit.b_mothercredit");
            if (EmptyUtil.isEmpty((Long)backId)) continue;
            long orgId = letterCredit.getLong("entry_backcredit.b_mothercredit.org");
            boolean hasPermission = TmcOrgDataHelper.hasPermission((String)appId, (long)userId, (long)orgId, (String)"lc_receipt", (String)"47150e89000000ac");
            if (!hasPermission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6bcd\u8bc1\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"LetterCreditList_14", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return;
            }
            backIdList.add(backId);
        }
        if (EmptyUtil.isEmpty(backIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditList_13", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackView(backIdList);
    }

    private void trackChildCredit() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection letterCreditCollection = QueryServiceHelper.query((String)"lc_lettercredit", (String)"entry_backcredit.b_childcredit,entry_backcredit.b_childcredit.number,entry_backcredit.b_childcredit.org", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)letterCreditCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditList_13", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> backIdList = new ArrayList<Long>();
        for (DynamicObject letterCredit : letterCreditCollection) {
            Long backId = letterCredit.getLong("entry_backcredit.b_childcredit");
            if (EmptyUtil.isEmpty((Long)backId)) continue;
            long orgId = letterCredit.getLong("entry_backcredit.b_childcredit.org");
            boolean hasPermission = TmcOrgDataHelper.hasPermission((String)appId, (long)userId, (long)orgId, (String)"lc_lettercredit", (String)"47150e89000000ac");
            if (!hasPermission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5b50\u8bc1\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"LetterCreditList_15", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return;
            }
            backIdList.add(backId);
        }
        if (EmptyUtil.isEmpty(backIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LetterCreditList_13", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackViewChild(backIdList);
    }

    protected void showTrackView(List<Long> pkIds) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId("lc_receipt");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("lc_receipt");
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    protected void showTrackViewChild(List<Long> pkIds) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId("lc_lettercredit");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("lc_lettercredit");
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private boolean checkCanSuretyConfirm() {
        Long id = this.getNewSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject letterCredit = this.loadLetterCredit(id);
        if (!BillStatusEnum.AUDIT.getValue().equals(letterCredit.getString("billstatus")) || !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(letterCredit.getString("creditstatus")) && !LetterCreditStatusEnum.CHANGE_ING.getValue().equals(letterCredit.getString("creditstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4fe1\u7528\u8bc1\u72b6\u6001\u4e3a\u5df2\u767b\u8bb0\u6216\u6539\u8bc1\u4e2d\uff0c\u624d\u53ef\u5b58\u5165\u4fdd\u8bc1\u91d1\u3002", (String)"LetterCreditList_11", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Long getNewSelectedId() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            return null;
        }
        HashSet<Long> idSet = new HashSet<Long>(selectedRows.size());
        for (int i = 0; i < selectedRows.size(); ++i) {
            idSet.add((Long)selectedRows.get(i).getPrimaryKeyValue());
        }
        if (idSet.size() > 1) {
            return null;
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }

    protected boolean checkCanHistory() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject letterCredit = this.loadLetterCredit(id);
        if (!BillStatusEnum.AUDIT.getValue().equals(letterCredit.getString("billstatus")) || !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(letterCredit.getString("creditstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4fe1\u7528\u8bc1\u72b6\u6001\u4e3a\u5df2\u767b\u8bb0\uff0c\u624d\u53ef\u53d1\u8d77\u6539\u8bc1\u3002", (String)"LetterCreditList_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!BeBillStatusEnum.TS.getValue().equals(letterCredit.getString("bebankstatus")) && TradeChannelEnum.ONLINE.getValue().equals(letterCredit.getString("tradechannel"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u65f6\uff0c\u53ea\u6709\u201c\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u201d\u4e3a\u6210\u529f\u7684\u624d\u80fd\u6539\u8bc1\u3002", (String)"LetterCreditOnlineList_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject loadLetterCredit(Long id) {
        return TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_lettercredit", (String)LETTER_CREDIT_PROP);
    }

    private DynamicObject[] loadLetterCredit(List<Long> ids) {
        return TmcDataServiceHelper.load((String)"lc_lettercredit", (String)LETTER_CREDIT_PROP, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (this.getPageCache().getAll().containsKey(LetterCreditProp.OP_HISTORY_KEY)) {
            e.getParameter().setCustomParam(LetterCreditProp.OP_HISTORY_KEY, (Object)"true");
            Long id = super.getSelectedId();
            if (EmptyUtil.isEmpty((Long)id)) {
                return;
            }
            e.getParameter().setPkId(null);
            e.getParameter().setFormId("lc_bizapply");
            e.getParameter().setStatus(OperationStatus.ADDNEW);
            e.getParameter().setCustomParam("lettercredit", (Object)id);
            e.getParameter().setCustomParam("biztype", (Object)LetterBizTypeEnum.EDIT_CARD.getValue());
        }
        this.getPageCache().remove(LetterCreditProp.OP_HISTORY_KEY);
    }

    public void hyperLinkClick(HyperLinkClickEvent clickEvent) {
        String fieldName = clickEvent.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"creditapplyno")) {
            BillList billListAp = (BillList)this.getControl("billlistap");
            Object pkID = billListAp.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)pkID, (String)"lc_lettercredit");
            String creditApplyNo = letterCredit.getString("creditapplyno");
            QFilter qFilter = new QFilter("billno", "=", (Object)creditApplyNo);
            DynamicObject bizApply = TmcDataServiceHelper.loadSingle((String)"lc_bizapply", (String)"id", (QFilter[])qFilter.toArray());
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId(bizApply.getPkValue());
            parameter.setFormId("lc_bizapply");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setBillStatus(BillOperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)parameter);
            this.getPageCache().put("clickapply", "true");
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)args.getFieldName(), (CharSequence)"buyerint")) {
            args.setCancel(true);
            this.showBuyerIntList();
        }
    }

    private Long getLetterOrgId(Long id) {
        DynamicObjectCollection letterBill = QueryServiceHelper.query((String)"lc_lettercredit", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)letterBill) ? Long.valueOf(((DynamicObject)letterBill.get(0)).getLong("org")) : null;
    }

    private void showBuyerIntList() {
        BillList billListAp = (BillList)this.getControl("billlistap");
        Object pkID = billListAp.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject letterCredit = QueryServiceHelper.queryOne((String)"lc_lettercredit", (String)"buyerint", (QFilter[])new QFilter[]{new QFilter("id", "=", pkID)});
        String buyerInt = letterCredit.getString("buyerint");
        if (StringUtils.equals((CharSequence)buyerInt, (CharSequence)"0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u4e0b\u4e0d\u5b58\u5728\u4e70\u65b9\u4ed8\u606f\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditList_12", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("lettercredit", "=", pkID).and("buyerint", "=", (Object)"1");
        DynamicObjectCollection arrivals = QueryServiceHelper.query((String)"lc_arrival", (String)"buyerintid", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)arrivals)) {
            return;
        }
        List buyerIntIds = arrivals.stream().map(v -> v.get("buyerintid")).collect(Collectors.toList());
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setIsolationOrg(false);
        showParameter.setBillFormId("lc_buyerint");
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", buyerIntIds));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("fromHyperLink", (Object)"yes");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void removeSpareFilter(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        ArrayList<String> removeFeilds = new ArrayList<String>(4);
        removeFeilds.add("bank.name");
        removeFeilds.add("bizdate");
        removeFeilds.add("bebankstatus");
        commonFilterColumns.removeIf(v -> removeFeilds.contains(v.getFieldName()));
    }

    @Override
    protected String getArrEntityName() {
        return "lc_arrival";
    }

    @Override
    protected String getLetEntityName() {
        return "lc_lettercredit";
    }
}

