/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.online;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public abstract class AbstractOnlineList
extends AbstractTmcDyncListPlugin
implements HyperLinkClickListener {
    protected FilterContainerInitArgs initArgs;
    private static final String FILTERED_DATA = "filterdData";
    private static final String BILL_TYPE = "billtype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entryentity");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        this.initArgs = new FilterContainerInitArgs(event);
        if (EmptyUtil.isEmpty((String)this.getPageCache().get("isFirstInit"))) {
            this.getPageCache().put("isFirstInit", "true");
            this.initFilterItem();
            this.fillPageData();
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        super.filterSearchClickEvent(event);
        this.initFilterItem();
        this.getPageCache().remove("qfilters");
        Map filterMap = event.getFilterValues();
        List<String> commonFilterColumns = this.getCommonFilterMainPart();
        List filterJsonList = OnlineServiceHelper.getDynamicListFilters((Map)filterMap, commonFilterColumns);
        if (EmptyUtil.isNoEmpty((Object)filterJsonList)) {
            this.getPageCache().put("qfilters", SerializationUtils.toJsonString((Object)filterJsonList));
        }
        this.fillPageData();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", evt.getRowIndex());
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId(this.getEntityName());
            parameter.setPkId((Object)entryRowEntity.getLong("id"));
            parameter.setCaption(this.getEntityCaption());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "syncstatus": {
                this.setSelectRow(args, operate);
                break;
            }
            case "modifystatus": {
                this.validateBeforeModifyStatus(args);
                break;
            }
            case "modifyrecord": {
                this.validateBeforeViewRecord(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        OperationResult operationResult = eventArgs.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (eventArgs.getOperateKey()) {
            case "syncstatus": {
                this.refreshData();
                break;
            }
            case "modifystatus": {
                this.showModifyPage(eventArgs);
                break;
            }
            case "modifyrecord": {
                this.showModifyRecord();
                break;
            }
            case "refresh": {
                this.fillPageData();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "synctrans": {
                this.fillPageData();
                break;
            }
            case "modifystatus": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    protected void fillPageData() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("bebankstatus", "in", (Object)new String[]{BeBillStatusEnum.OS.getValue(), BeBillStatusEnum.BP.getValue(), BeBillStatusEnum.TS.getValue(), BeBillStatusEnum.TF.getValue(), BeBillStatusEnum.NC.getValue()}));
        qFilters.add(new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()));
        if (!CollectionUtils.isEmpty((Collection)this.getQFilterFromPagCache())) {
            qFilters.addAll(this.getQFilterFromPagCache());
        }
        List permOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"lc_lettercredit", (String)"47150e89000000ac");
        qFilters.add(new QFilter("org", "in", (Object)permOrgList));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryLcOnlineData", (String)this.getEntityName(), (String)String.join((CharSequence)",", this.getQueryAttributes()), (QFilter[])qFilters.toArray(new QFilter[0]), (String)"billno desc");
        this.batchInsertListData(dataSet);
    }

    protected void refreshData() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        ArrayList<Long> selectedIdList = new ArrayList<Long>(rows.length);
        for (int index : rows) {
            selectedIdList.add((Long)this.getModel().getValue("id", index));
        }
        this.fillPageData();
        this.reSelectData(selectedIdList);
    }

    private void reSelectData(List<Long> selectDataIds) {
        if (EmptyUtil.isEmpty(selectDataIds)) {
            return;
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> selectIndexs = new ArrayList<Integer>();
        int len = entryEntity.size();
        for (int i = 0; i < len; ++i) {
            if (!selectDataIds.contains(((DynamicObject)entryEntity.get(i)).getLong("id"))) continue;
            selectIndexs.add(i);
        }
        int[] selectIndexArr = selectIndexs.stream().mapToInt(Integer::intValue).toArray();
        entry.selectRows(selectIndexArr, 0);
    }

    protected void initFilterItem() {
        this.removeSpareFilter();
        IPageCache pageCache = this.getPageCache();
        ArrayList<String> filterJsonList = new ArrayList<String>();
        this.initArgs.getFilterContainerInitEvent().getSchemeFilterColumns().clear();
        List commonFilterColumns = this.initArgs.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            QFilter subtimeFilter;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List defaultValues = commonFilterColumn.getDefaultValues();
            if (EmptyUtil.isEmpty((Collection)defaultValues)) continue;
            if (StringUtils.equals((CharSequence)(this.getBillMainBizeOrg() + ".name"), (CharSequence)fieldName)) {
                Object[] orgList = defaultValues.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.toString())).map(v -> Long.valueOf(v.toString())).toArray();
                filterJsonList.add(new QFilter(this.getBillMainBizeOrg() + ".id", "in", (Object)orgList).toSerializedString());
                continue;
            }
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"bebankstatus")) {
                filterJsonList.add(new QFilter("bebankstatus", "in", (Object)defaultValues).toSerializedString());
                continue;
            }
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"bizdate") || !EmptyUtil.isNoEmpty((Object)(subtimeFilter = OnlineServiceHelper.getDateQfilter((String)fieldName, (List)defaultValues)))) continue;
            filterJsonList.add(subtimeFilter.toSerializedString());
        }
        pageCache.put("qfilters", SerializationUtils.toJsonString(filterJsonList));
    }

    private void setSelectRow(BeforeDoOperationEventArgs args, AbstractOperate operate) {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            args.setCancel(true);
            return;
        }
        if (selectedIdList.size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"AbstractOnlineList_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        operate.getOption().setVariableValue("selectRowId", SerializationUtils.toJsonString((Object)selectedIdList.toArray(new Long[0])));
    }

    private void showModifyPage(AfterDoOperationEventArgs args) {
        Map opMap = ((FormOperate)args.getSource()).getOption().getVariables();
        String filterdData = (String)opMap.get(FILTERED_DATA);
        if (EmptyUtil.isEmpty((String)filterdData)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(this.getModifyFormId());
        showParameter.getOpenStyle().setShowType(this.getShowType());
        showParameter.getCustomParams().put(FILTERED_DATA, filterdData);
        showParameter.getCustomParams().put(BILL_TYPE, this.getEntityName());
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifystatus"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showModifyRecord() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(this.getModifyFormId());
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(this.getShowType());
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("entryentity.srcid", "=", this.getSelectedIdList().get(0)));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void validateBeforeModifyStatus(BeforeDoOperationEventArgs args) {
        String entityName;
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            args.setCancel(true);
            return;
        }
        String selectProp = "lc_arrival".equals(entityName = this.getEntityName()) ? "id,bebankstatus,acceptbebankstatus,opetype" : "id,bebankstatus";
        DynamicObjectCollection billCols = QueryServiceHelper.query((String)entityName, (String)selectProp, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedIdList)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)billCols)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"AbstractOnlineList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> needIdSet = new HashSet<Long>(billCols.size());
        for (DynamicObject bizBill : billCols) {
            if ("lc_arrival".equals(entityName) && ArrivalWayEnum.ACCEPT.getValue().equals(bizBill.getString("opetype"))) {
                if (!StringUtils.equals((CharSequence)BeBillStatusEnum.NC.getValue(), (CharSequence)bizBill.getString("acceptbebankstatus"))) continue;
                needIdSet.add(bizBill.getLong("id"));
                continue;
            }
            if (!StringUtils.equals((CharSequence)BeBillStatusEnum.NC.getValue(), (CharSequence)bizBill.getString("bebankstatus"))) continue;
            needIdSet.add(bizBill.getLong("id"));
        }
        if (EmptyUtil.isEmpty(needIdSet)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u72b6\u6001\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"AbstractOnlineList_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        ((FormOperate)args.getSource()).getOption().setVariableValue(FILTERED_DATA, SerializationUtils.toJsonString(needIdSet));
    }

    private void validateBeforeViewRecord(BeforeDoOperationEventArgs args) {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            args.setCancel(true);
            return;
        }
        if (selectedIdList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"AbstractOnlineList_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected void batchInsertListData(DataSet dataSet) {
        String[] queryAttributes = this.getQueryAttributes();
        ArrayList dataList = new ArrayList(queryAttributes.length);
        Iterator iterator = dataSet.iterator();
        while (iterator.hasNext()) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>(queryAttributes.length);
            Row row = (Row)iterator.next();
            int len = queryAttributes.length;
            for (int i = 0; i < len; ++i) {
                rowMap.put(queryAttributes[i], row.get(queryAttributes[i]));
            }
            dataList.add(rowMap);
        }
        TmcViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataList, (boolean)true);
        this.getView().updateView("entryentity");
    }

    protected void removeSpareFilter() {
        List commonFilterColumns = this.initArgs.getFilterContainerInitEvent().getCommonFilterColumns();
        List<String> commonFilterNames = this.getCommonFilterColumns();
        commonFilterColumns.removeIf(v -> !commonFilterNames.contains(v.getFieldName()));
    }

    protected abstract String getEntityCaption();

    protected abstract String[] getQueryAttributes();

    protected abstract String getModifyFormId();

    protected abstract ShowType getShowType();

    protected abstract List<String> getCommonFilterColumns();

    protected abstract List<String> getCommonFilterMainPart();

    protected String getBillMainBizeOrg() {
        return "org";
    }
}

