/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.online;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;
import kd.tmc.lc.formplugin.online.AbstractOnlineCommitBeEdit;

public class OnlinePaymentEdit
extends AbstractOnlineCommitBeEdit
implements BeforeF7SelectListener {
    private static final String[] mustInputArr = new String[]{"paynature", "ibpisref", "ibppaytype", "trancode", "payaccno", "payamt"};

    public void registerListener(EventObject e) {
        BasedataEdit payAcct = (BasedataEdit)this.getControl("payaccno");
        payAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payAcct2 = (BasedataEdit)this.getControl("payaccno2");
        payAcct2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    protected String getSelectProps() {
        return "id,paynature,ibpisref,ibppaytype,trancode,payaccno,payamt,payaccno2,payamt2,arrivalcurrency";
    }

    @Override
    protected String getOperateKey() {
        return "payment";
    }

    @Override
    protected String getOperateParam() {
        return ArrivalWayEnum.PAYMENT.getValue();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "confirm": {
                this.validateConfirm(args);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String field = event.getProperty().getName();
        List qFilters = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters();
        switch (field) {
            case "payaccno": 
            case "payaccno2": {
                DynamicObject arrivalBill = QueryServiceHelper.queryOne((String)"lc_arrival", (String)"org,arrivalbank", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id"))});
                if (EmptyUtil.isEmpty((DynamicObject)arrivalBill)) {
                    return;
                }
                QFilter qFilter = new QFilter("company", "=", (Object)arrivalBill.getLong("org"));
                qFilter.and(new QFilter("bank", "=", (Object)arrivalBill.getLong("arrivalbank")));
                qFilters.add(qFilter);
                break;
            }
        }
    }

    private void validateConfirm(BeforeDoOperationEventArgs args) {
        BigDecimal amt2;
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])mustInputArr)) {
            args.setCancel(true);
            return;
        }
        String tranCode = (String)this.getModel().getValue("trancode");
        if (!OnlineServiceHelper.isNumeric((String)tranCode) || 6 != tranCode.length()) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u7f16\u7801\u5fc5\u987b\u4e3a6\u4f4d\u6570\u5b57\u3002", (String)"OnlinePaymentEdit_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject arrivalBill = QueryServiceHelper.queryOne((String)"lc_arrival", (String)"arrivalamount", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id"))});
        if (EmptyUtil.isEmpty((DynamicObject)arrivalBill)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5230\u5355\u5904\u7406\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"OnlinePaymentEdit_1", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal amt1 = Optional.ofNullable((BigDecimal)this.getModel().getValue("payamt")).orElse(BigDecimal.ZERO);
        if (amt1.add(amt2 = Optional.ofNullable((BigDecimal)this.getModel().getValue("payamt2")).orElse(BigDecimal.ZERO)).compareTo(arrivalBill.getBigDecimal("arrivalamount")) != 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u91d1\u989d\u4e0e\u5230\u5355\u91d1\u989d\u4e0d\u7b26\u3002", (String)"OnlinePaymentEdit_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
        }
    }
}

