/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.formplugin.receipt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.property.LetterCreditHistoryProp;
import kd.tmc.lc.common.property.ReceiptBillProp;
import kd.tmc.lc.formplugin.base.AbstractBaseList;

public class ReceiptBillList
extends AbstractBaseList {
    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String isQueryDefault;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Optional<FilterColumn> bizDateFilterOp = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"applydate")).findFirst();
        if (bizDateFilterOp.isPresent() && "no".equals(isQueryDefault = (String)formShowParameter.getCustomParam("isquerydefault"))) {
            bizDateFilterOp.get().setDefaultValue("");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qFilter = new QFilter("isinit", "=", (Object)Boolean.TRUE);
        QFilter initFilter = qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter unionFilter = initFilter.or(new QFilter("isinit", "=", (Object)Boolean.FALSE));
        e.getQFilters().add(unionFilter);
    }

    public void itemClick(ItemClickEvent evt) {
        if (this.checkSelectData().contains(evt.getItemKey())) {
            Long id = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)id)) {
                return;
            }
            switch (evt.getItemKey()) {
                case "history": {
                    this.historyClick(id);
                    break;
                }
                case "tblactivate": {
                    if (!this.checkCanActivate(id)) break;
                    this.showBizConfigPage(id, "activate");
                    break;
                }
            }
        }
    }

    protected List checkSelectData() {
        return Arrays.asList("history", "tblactivate");
    }

    private void historyClick(Long id) {
        QFilter filter = new QFilter(LetterCreditHistoryProp.LETTERCREDIT, "=", (Object)id);
        filter.and(new QFilter(LetterCreditHistoryProp.SOURCEBILLID, "!=", (Object)0));
        int count = TmcDataServiceHelper.count((String)"lc_receipt_h", (QFilter[])filter.toArray());
        if (count == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ReceiptBillList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (count == 1) {
            DynamicObject history = TmcDataServiceHelper.loadSingle((String)"lc_receipt_h", (String)"id", (QFilter[])filter.toArray());
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId(history.getPkValue());
            parameter.setFormId("lc_receipt_h");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setBillStatus(BillOperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (count > 1) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"lc_receipt_h", (boolean)true, (int)0, (boolean)false);
            parameter.getListFilterParameter().getQFilters().add(filter);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "history": {
                if (!this.checkCanHistory()) {
                    args.setCancel(true);
                    return;
                }
                this.getPageCache().put(ReceiptBillProp.OP_HISTORY_KEY, "true");
                break;
            }
            case "pushpresent": {
                if (this.checkCanPushPresent()) break;
                args.setCancel(true);
                break;
            }
            case "tblclosecard": {
                Long id = this.getSelectedId();
                if (!EmptyUtil.isEmpty((Long)id)) break;
                return;
            }
            case "trackmother": {
                args.setCancel(true);
                this.trackMotherCredit();
                break;
            }
            case "trackchild": {
                args.setCancel(true);
                this.trackChildCredit();
                break;
            }
        }
    }

    private void trackMotherCredit() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection receiptBillCollection = QueryServiceHelper.query((String)"lc_receipt", (String)"entry_backcredit.b_mothercredit,entry_backcredit.b_mothercredit.number,entry_backcredit.b_mothercredit.org", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)receiptBillCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ReceiptBillList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> backIdList = new ArrayList<Long>();
        for (DynamicObject receiptBill : receiptBillCollection) {
            Long backId = receiptBill.getLong("entry_backcredit.b_mothercredit");
            if (EmptyUtil.isEmpty((Long)backId)) continue;
            long orgId = receiptBill.getLong("entry_backcredit.b_mothercredit.org");
            boolean hasPermission = TmcOrgDataHelper.hasPermission((String)appId, (long)userId, (long)orgId, (String)"lc_receipt", (String)"47150e89000000ac");
            if (!hasPermission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6bcd\u8bc1\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ReceiptBillList_4", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return;
            }
            backIdList.add(backId);
        }
        if (EmptyUtil.isEmpty(backIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ReceiptBillList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackView(backIdList);
    }

    private void trackChildCredit() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection receiptBillCollection = QueryServiceHelper.query((String)"lc_receipt", (String)"entry_backcredit.b_childcredit,entry_backcredit.b_childcredit.number,entry_backcredit.b_childcredit.org", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)receiptBillCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ReceiptBillList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> backIdList = new ArrayList<Long>();
        for (DynamicObject receiptBill : receiptBillCollection) {
            Long backId = receiptBill.getLong("entry_backcredit.b_childcredit");
            if (EmptyUtil.isEmpty((Long)backId)) continue;
            long orgId = receiptBill.getLong("entry_backcredit.b_childcredit.org");
            boolean hasPermission = TmcOrgDataHelper.hasPermission((String)appId, (long)userId, (long)orgId, (String)"lc_lettercredit", (String)"47150e89000000ac");
            if (!hasPermission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5b50\u8bc1\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ReceiptBillList_5", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
                return;
            }
            backIdList.add(backId);
        }
        if (EmptyUtil.isEmpty(backIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ReceiptBillList_0", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTrackViewChild(backIdList);
    }

    protected void showTrackView(List<Long> pkIds) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId("lc_receipt");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("lc_receipt");
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    protected void showTrackViewChild(List<Long> pkIds) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId("lc_lettercredit");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("lc_lettercredit");
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "tblclosecard": {
                Long id = (Long)operationResult.getSuccessPkIds().get(0);
                this.showBizConfigPage(id, "close");
            }
        }
    }

    private boolean checkCanPushPresent() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject receiptBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_receipt", (String)"billstatus,creditstatus");
        if (!BillStatusEnum.AUDIT.getValue().equals(receiptBill.getString("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u4fe1\u7528\u8bc1\uff0c\u624d\u5141\u8bb8\u505a\u4ea4\u5355\u5904\u7406\u3002", (String)"ReceiptBillList_2", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(receiptBill.getString("creditstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u767b\u8bb0\u72b6\u6001\u7684\u4fe1\u7528\u8bc1\uff0c\u624d\u5141\u8bb8\u505a\u4ea4\u5355\u5904\u7406\u3002", (String)"ReceiptBillList_3", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean checkCanHistory() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject receiptBill = this.loadReceiptBill(id);
        if (!BillStatusEnum.AUDIT.getValue().equals(receiptBill.getString("billstatus")) || !LetterCreditStatusEnum.DONE_REGISTER.getValue().equals(receiptBill.getString("creditstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4fe1\u7528\u8bc1\u72b6\u6001\u4e3a\u5df2\u767b\u8bb0\uff0c\u624d\u53ef\u53d1\u8d77\u6539\u8bc1\u3002", (String)"ReceiptBillList_6", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCanActivate(Long id) {
        DynamicObject receiptBill = this.loadReceiptBill(id);
        if (!BillStatusEnum.AUDIT.getValue().equals(receiptBill.getString("billstatus")) || !LetterCreditStatusEnum.DONE_CLOSE.getValue().equals(receiptBill.getString("creditstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4fe1\u7528\u8bc1\u72b6\u6001\u4e3a\u5df2\u95ed\u5377\uff0c\u624d\u53ef\u53d1\u8d77\u6fc0\u6d3b\u3002", (String)"ReceiptBillList_7", (String)"tmc-lc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject loadReceiptBill(Long id) {
        return TmcDataServiceHelper.loadSingle((Object)id, (String)"lc_receipt", (String)"creditstatus,billstatus");
    }

    private void showBizConfigPage(Long id, String operate) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("lc_bizconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("id", id);
        showParameter.getCustomParams().put("operate", operate);
        showParameter.getCustomParams().put("entity", "lc_receipt");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm_back"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"confirm_back", (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (this.getPageCache().getAll().containsKey(ReceiptBillProp.OP_HISTORY_KEY)) {
            e.getParameter().setCustomParam(ReceiptBillProp.OP_HISTORY_KEY, (Object)"true");
            e.getParameter().setFormId("lc_receipt_change");
        }
        this.getPageCache().remove(ReceiptBillProp.OP_HISTORY_KEY);
    }

    @Override
    protected String getArrEntityName() {
        return "lc_present";
    }

    @Override
    protected String getLetEntityName() {
        return "lc_receipt";
    }
}

