/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.service;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class BuyerIntPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        sourceBill.set("lockamount", (Object)param.getPayBill().getAmount());
        sourceBill.set("paybill", (Object)param.getPayBill().getPayBillId());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveExecute(param, sourceBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doChargebackExecute(param, sourceBill);
        this.updateLockAmount(sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doRenoteExecute(param, sourceBill);
        this.updateLockAmount(sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateLockAmount(sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((String)"lc_buyerint", (String)"id,amount,currency,lockamount,paybill,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payBillInfo.getSourceBillId())});
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("amount");
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        this.addDefineOpValid(param, sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    private void addDefineOpValid(PayBillWriteBackParam param, DynamicObject sourceBill) {
        Long payBillId = param.getPayBill().getPayBillId();
        DynamicObject payBill = sourceBill.getDynamicObject("paybill");
        if (EmptyUtil.isNoEmpty((DynamicObject)payBill) && !StringUtils.equals((CharSequence)payBill.getString("status"), (CharSequence)"G") && !StringUtils.equals((CharSequence)payBill.getString("status"), (CharSequence)"F") && !payBill.getPkValue().equals(payBillId)) {
            PayBillWriteBackOperateEnum operateEnum = PayBillWriteBackOperateEnum.getByValue((String)param.getOperate());
            String operateName = operateEnum != null ? operateEnum.getBridge().loadKDString() : param.getOperate();
            String error = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: \u8be5\u4e0a\u6e38\u5bf9\u5e94\u7684\u4e70\u65b9\u4ed8\u606f\u5355\u636e:[%2$s]\u5df2\u7ecf\u751f\u6210\u4ed8\u6b3e\u5355[%3$s],\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", (String)"BuyerIntPayBillWriteBackService_0", (String)"tmc-lc-mservice", (Object[])new Object[0]), operateName, sourceBill.getString("billno"), payBill.getString("number"));
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{error});
        }
    }

    private void updateLockAmount(DynamicObject sourceBill) {
        sourceBill.set("lockamount", (Object)BigDecimal.ZERO);
        sourceBill.set("paybill", null);
    }
}

