/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.formplugin.index;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.formplugin.index.CommonMethodsPlugin;

public class AccountInformationPlugin
extends CommonMethodsPlugin
implements ClickListener {
    private String cardName = ResManager.loadKDString((String)"\u8d26\u6237\u4fe1\u606f", (String)"AccountInformationPlugin_0", (String)"tmc-mon-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"summoney"});
        this.getView().getFormShowParameter().setListentimerElapsed(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getSumMoney();
    }

    private void getSumMoney() {
        List<Long> orgList = this.getOrgList();
        if (orgList == null) {
            return;
        }
        QFilter orgFilter = new QFilter("company", "in", (Object)orgList.toArray());
        QFilter acctstatus = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "closing"});
        Long currency = OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId());
        if (currency == null || "0".equals(String.valueOf(currency))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ec4\u7ec7\u672c\u4f4d\u5e01\u79cd", (String)"AccountInformationPlugin_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] bankAccts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,currency,defaultcurrency", (QFilter[])new QFilter[]{orgFilter, acctstatus});
        BigDecimal sumMoney = new BigDecimal(bankAccts.length);
        Label label = (Label)this.getView().getControl("summoney");
        label.setText(this.getNumberFormatAccount(sumMoney));
        HashMap<String, Object> returnData = this.sumAcctsNotMainCurrency(bankAccts, currency);
        BigDecimal sumMoneyMainCurrency = (BigDecimal)returnData.get("MainCurrency");
        Object sumMoneyNotMainCurrency = returnData.get("maxTotal");
        Object CurrencyId = returnData.get("maxCurrencyId");
        this.drawPiechart(currency, sumMoneyMainCurrency, CurrencyId, (BigDecimal)sumMoneyNotMainCurrency, sumMoney, "account", this.cardName);
        HashMap<String, BigDecimal> returnMap = this.sumCashPoolAccts(bankAccts, orgList);
        BigDecimal sumCashPool = returnMap.get("sumPoolAcct");
        BigDecimal bigDecimal = returnMap.get("balanceZeroAcct");
        Label ticketnameLabel = (Label)this.getView().getControl("ticketname");
        Label ticketcountLabel = (Label)this.getView().getControl("ticketcount");
        Label ticketmoneyLabel = (Label)this.getView().getControl("ticketmoney");
        Label countLabel = (Label)this.getView().getControl("count");
        if (BigDecimal.ZERO.compareTo(sumCashPool) == 0) {
            if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                ticketnameLabel.setText(null);
                ticketcountLabel.setText(null);
                ticketmoneyLabel.setText(null);
                countLabel.setText(null);
            } else {
                ticketnameLabel.setText(ResManager.loadKDString((String)"\u4f59\u989d\u4e3a\u96f6\u7684\u975e\u8d44\u91d1\u6c60\u8d26\u6237\u6570", (String)"AccountInformationPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                ticketmoneyLabel.setText(this.getNumberFormatAccount(bigDecimal));
                ticketcountLabel.setText(null);
                countLabel.setText(null);
            }
        } else {
            ticketnameLabel.setText(ResManager.loadKDString((String)"\u8d44\u91d1\u6c60\u8d26\u6237\u6570", (String)"AccountInformationPlugin_3", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            ticketmoneyLabel.setText(this.getNumberFormatAccount(sumCashPool));
            if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                ticketcountLabel.setText(null);
                countLabel.setText(null);
            } else {
                ticketcountLabel.setText(ResManager.loadKDString((String)"\u4f59\u989d\u4e3a\u96f6\u7684\u975e\u8d44\u91d1\u6c60\u8d26\u6237\u6570", (String)"AccountInformationPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                countLabel.setText(this.getNumberFormatAccount(bigDecimal));
            }
        }
    }

    private HashMap<String, BigDecimal> sumCashPoolAccts(DynamicObject[] bankAccts, List<Long> orgList) {
        QFilter idsFilter = new QFilter("company", "in", (Object)orgList.toArray());
        DynamicObject[] acctgroups = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id,accountbank,currency,entrys,entrys.bankacct", (QFilter[])new QFilter[]{idsFilter});
        HashSet<Object> acctSet = new HashSet<Object>(acctgroups.length);
        for (DynamicObject acctgroup : acctgroups) {
            if (acctgroup.getDynamicObject("accountbank") == null) continue;
            Long accountbank = (Long)acctgroup.getDynamicObject("accountbank").getPkValue();
            DynamicObjectCollection entrys = acctgroup.getDynamicObjectCollection("entrys");
            acctSet.add(accountbank);
            for (Object entry : entrys) {
                DynamicObject dynamicObject = entry.getDynamicObject("bankacct");
                if (dynamicObject == null) continue;
                DynamicObject[] bankacctId = (DynamicObject[])dynamicObject.getPkValue();
                acctSet.add(bankacctId);
            }
        }
        BigDecimal sumAccts = new BigDecimal(acctSet.size());
        ArrayList<Long> outPoolids = new ArrayList<Long>(10);
        for (DynamicObject bankAcct : bankAccts) {
            Long accountbank = (Long)bankAcct.getPkValue();
            if (acctSet.contains(accountbank)) continue;
            outPoolids.add(accountbank);
        }
        QFilter bankaccountQf = new QFilter("bankaccount", "in", (Object)outPoolids.toArray());
        DynamicObject[] accountbalanceAll = BusinessDataServiceHelper.load((String)"cas_accountbalance", (String)"id,bankaccount,currency,amount,bookdate", (QFilter[])new QFilter[]{bankaccountQf});
        DynamicObject[] accountbalances = this.getDynamicRecentData(accountbalanceAll);
        HashSet<Long> hasMoneyacct = new HashSet<Long>();
        HashSet<Long> notMoneyacct = new HashSet<Long>();
        for (Long l : outPoolids) {
            for (DynamicObject accountbalance : accountbalances) {
                Long bankaccountId = (Long)accountbalance.getDynamicObject("bankaccount").getPkValue();
                if (!String.valueOf(l).equals(String.valueOf(bankaccountId))) continue;
                BigDecimal amount = accountbalance.getBigDecimal("amount");
                if (amount != null && amount.compareTo(BigDecimal.ZERO) == 0) {
                    notMoneyacct.add(bankaccountId);
                    continue;
                }
                hasMoneyacct.add(bankaccountId);
            }
        }
        BigDecimal totalAccthasMeny = BigDecimal.ZERO;
        for (Long aLong : notMoneyacct) {
            if (hasMoneyacct.contains(aLong)) continue;
            totalAccthasMeny = totalAccthasMeny.add(BigDecimal.ONE);
        }
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(2);
        hashMap.put("sumPoolAcct", sumAccts);
        hashMap.put("balanceZeroAcct", totalAccthasMeny);
        return hashMap;
    }

    private HashMap<String, Object> sumAcctsNotMainCurrency(DynamicObject[] bankAccts, Long currency) {
        Long maxCurrencyId = null;
        BigDecimal maxTotal = BigDecimal.ZERO;
        BigDecimal bankSumMoney = BigDecimal.ZERO;
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        if (bankAccts != null && bankAccts.length > 0) {
            HashMap dataMap = new HashMap();
            for (DynamicObject bankAcct : bankAccts) {
                DynamicObject defaultCurrency = bankAcct.getDynamicObject("defaultcurrency");
                if (defaultCurrency == null || EmptyUtil.isEmpty((Object)defaultCurrency.getPkValue())) continue;
                Long currencuId = (Long)defaultCurrency.getPkValue();
                if (!String.valueOf(currency).equals(String.valueOf(currencuId))) {
                    ArrayList<DynamicObject> acctList = (ArrayList<DynamicObject>)dataMap.get(currencuId);
                    if (acctList == null || acctList.size() < 1) {
                        acctList = new ArrayList<DynamicObject>();
                        acctList.add(bankAcct);
                        dataMap.put(currencuId, acctList);
                        continue;
                    }
                    acctList.add(bankAcct);
                    dataMap.put(currencuId, acctList);
                    continue;
                }
                bankSumMoney = bankSumMoney.add(BigDecimal.ONE);
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                List acctList = (List)entry.getValue();
                if (maxTotal == null) {
                    maxTotal = new BigDecimal(acctList.size());
                    maxCurrencyId = (Long)entry.getKey();
                }
                maxTotal = maxTotal.compareTo(new BigDecimal(acctList.size())) > 0 ? maxTotal : new BigDecimal(acctList.size());
                maxCurrencyId = maxTotal.compareTo(new BigDecimal(acctList.size())) > 0 ? maxCurrencyId : (Long)entry.getKey();
            }
        }
        returnData.put("maxTotal", maxTotal);
        returnData.put("maxCurrencyId", maxCurrencyId);
        returnData.put("MainCurrency", bankSumMoney);
        return returnData;
    }

    private void showFormCapitalSumRpt() {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("am_acctsummaryrpt");
        HashMap params = new HashMap();
        showParameter.setCustomParams(params);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("filter_queryway", (Object)"org");
        filter.addFilterItem("filter_company_id", super.getOrgList());
        filter.addFilterItem("filter_status", (Object)"normal,closing");
        filter.addFilterItem("filter_isincludefinorg", (Object)Boolean.TRUE);
        queryParam.setFilter(filter);
        showParameter.setQueryParam(queryParam);
        showParameter.setLinkQuery(true);
        showParameter.setPageId(this.getView().getPageId() + "fromacct");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("summoney".equals(key)) {
            this.showFormCapitalSumRpt();
        }
    }
}

