/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.formplugin.index;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.helper.BaseDataHelper;

public class CommonMethodsPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(CommonMethodsPlugin.class);
    private static String[] colors = new String[]{"#098bff", "#00cccc", "#87db3b", "#ffd72b"};
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final BigDecimal TEN_THOUSAND = new BigDecimal(10000);

    public List<Long> getOrgList() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"mon_transactionplan", (String)this.getPermissionItem());
        if (orgList == null || orgList.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u672a\u62e5\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7", (String)"CommonMethodsPlugin_0", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            return null;
        }
        return orgList;
    }

    public String getCurrencyName(Object currency, String ... type) {
        if (currency == null) {
            return null;
        }
        String name = null;
        if (currency == null || "0".equals(String.valueOf(currency))) {
            return "";
        }
        DynamicObject currency1 = BusinessDataServiceHelper.loadSingle((Object)currency, (String)"bd_currency");
        if (currency1 != null) {
            name = currency1.getString("name");
            if (type != null && type.length > 0) {
                name = "sign".equals(type[0]) ? currency1.getString("sign") : name;
            }
        }
        return name;
    }

    public DynamicObject[] getDynamicRecentData(DynamicObject[] accountbalances) {
        HashMap<String, DynamicObject> acctRecentData = new HashMap<String, DynamicObject>(10);
        for (DynamicObject accountbalance : accountbalances) {
            Date recentDatabookdate;
            Long bankaccountId = (Long)accountbalance.getDynamicObject("bankaccount").getPkValue();
            DynamicObject currency = accountbalance.getDynamicObject("currency");
            if (currency == null) continue;
            Long pkValue = (Long)currency.getPkValue();
            String key = String.valueOf(bankaccountId) + pkValue;
            DynamicObject recentData = (DynamicObject)acctRecentData.get(key);
            if (recentData == null) {
                acctRecentData.put(key, accountbalance);
                continue;
            }
            Date bookdate = accountbalance.getDate("bookdate");
            recentData = bookdate.compareTo(recentDatabookdate = recentData.getDate("bookdate")) > 0 ? accountbalance : recentData;
            acctRecentData.put(key, recentData);
        }
        HashSet<DynamicObject> accountbalancesList = new HashSet<DynamicObject>(10);
        for (Map.Entry entry : acctRecentData.entrySet()) {
            DynamicObject data = (DynamicObject)entry.getValue();
            accountbalancesList.add(data);
        }
        return accountbalancesList.toArray(new DynamicObject[accountbalancesList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> diffCurrencySumMoney(DynamicObject[] accountbalances, Long aimCurrency, Boolean flag, String cardName) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        Long currentOrgId = TmcOrgDataHelper.getCurrentOrgId();
        BigDecimal sumTotalMoney = BigDecimal.ZERO;
        if (accountbalances != null && accountbalances.length > 0) {
            HashMap<Long, BigDecimal> currencyMoneyMap = new HashMap<Long, BigDecimal>();
            for (DynamicObject dynamicObject : accountbalances) {
                DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("currency");
                if (dynamicObject2 == null) continue;
                Long l = (Long)dynamicObject2.getPkValue();
                BigDecimal bigDecimal = (BigDecimal)currencyMoneyMap.get(l);
                if (bigDecimal == null) {
                    currencyMoneyMap.put(l, dynamicObject.getBigDecimal("amount"));
                    continue;
                }
                currencyMoneyMap.put(l, bigDecimal.add(dynamicObject.getBigDecimal("amount")));
            }
            HashMap<Long, BigDecimal> difCurSumMoney = new HashMap<Long, BigDecimal>();
            ArrayList longRates = new ArrayList();
            for (Map.Entry entry : currencyMoneyMap.entrySet()) {
                longRates.add(entry.getKey());
            }
            boolean flagExist = BaseDataHelper.verifyExchangeRateCard(longRates, (Long)aimCurrency, (Long)currentOrgId, (Date)new Date(), (String)cardName, (AbstractFormPlugin)this);
            if (!flagExist) {
                return null;
            }
            for (Map.Entry entry : currencyMoneyMap.entrySet()) {
                Long l = (Long)entry.getKey();
                BigDecimal bigDecimal = BaseDataHelper.getExchangeRate((Long)l, (Long)aimCurrency, (Long)currentOrgId, (Date)new Date());
                if (null == bigDecimal) continue;
                BigDecimal totalMoney = (BigDecimal)currencyMoneyMap.get(l);
                totalMoney = totalMoney.multiply(bigDecimal);
                difCurSumMoney.put(l, totalMoney);
            }
            if (flag.booleanValue()) {
                void var13_30;
                void var12_20;
                Object var12_19 = null;
                for (Map.Entry entry : difCurSumMoney.entrySet()) {
                    void var12_22;
                    Long l = (Long)entry.getKey();
                    BigDecimal bigDecimal = (BigDecimal)difCurSumMoney.get(l);
                    if (String.valueOf(l).equals(String.valueOf(aimCurrency))) continue;
                    if (var12_20 == null) {
                        BigDecimal bigDecimal2 = bigDecimal;
                    }
                    BigDecimal bigDecimal3 = var12_22.compareTo(bigDecimal) >= 0 ? var12_22 : bigDecimal;
                }
                Object var13_29 = null;
                for (Map.Entry entry : difCurSumMoney.entrySet()) {
                    Long curId = (Long)entry.getKey();
                    if (var12_20 == null || var12_20.compareTo((BigDecimal)entry.getValue()) != 0) continue;
                    Long l = curId;
                }
                BigDecimal bigDecimal = (BigDecimal)currencyMoneyMap.get(var13_30);
                returnData.put("currency", var13_30);
                returnData.put("sumMoney", bigDecimal);
            } else {
                for (Map.Entry entry : difCurSumMoney.entrySet()) {
                    BigDecimal bigDecimal = (BigDecimal)entry.getValue();
                    sumTotalMoney = sumTotalMoney.add(bigDecimal);
                }
                returnData.put("sumMoney", sumTotalMoney);
            }
        } else {
            returnData.put("sumMoney", BigDecimal.ZERO);
        }
        return returnData;
    }

    public BigDecimal diffCurrencyToMainCurrency(HashMap<Long, BigDecimal> currencyMoneyMap, Long targetCurId, String cardName) {
        Long orgId = TmcOrgDataHelper.getCurrentOrgId();
        Set<Long> diffCurIds = currencyMoneyMap.keySet();
        boolean exist = BaseDataHelper.verifyExchangeRateCard(new ArrayList<Long>(diffCurIds), (Long)targetCurId, (Long)orgId, (Date)new Date(), (String)cardName, (AbstractFormPlugin)this);
        if (!exist) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (Map.Entry<Long, BigDecimal> entry : currencyMoneyMap.entrySet()) {
            Long diffCurId = entry.getKey();
            BigDecimal exRate = BaseDataHelper.getExchangeRate((Long)diffCurId, (Long)targetCurId, (Long)orgId, (Date)new Date());
            if (null == exRate) continue;
            BigDecimal diffMoeny = entry.getValue();
            BigDecimal exMoney = diffMoeny.multiply(exRate);
            total = total.add(exMoney);
        }
        return total;
    }

    public void drawPiechart(Object mainCurId, BigDecimal mainCurMoney, Object noMainCurId, BigDecimal notMainCurMoney, BigDecimal totalMoney, String type, String cardName) {
        logger.info("--->>> drawPiechart():mainCurId={},mainCurMoney={},noMainCurId={},notMainCurMoney={},totalMoney={},type={},cardName={}", new Object[]{mainCurId, mainCurMoney, noMainCurId, notMainCurMoney, totalMoney, type, cardName});
        boolean isAcctCard = type.equals("account");
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(true);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        ArrayList<ItemValue> itemList = new ArrayList<ItemValue>(10);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap113", "flexpanelap112", "flexpanelap11"});
        if (mainCurMoney == null) {
            mainCurMoney = BigDecimal.ZERO;
        }
        String valueName = isAcctCard ? String.format(ResManager.loadKDString((String)"%s", (String)"CommonMethodsPlugin_5", (String)"tmc-mon-formplugin", (Object[])new Object[0]), this.getCurrencyName(mainCurId, new String[0])) : ResManager.loadKDString((String)this.getCurrencyName(mainCurId, new String[0]), (String)"CommonMethodsPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]);
        ItemValue mainItem = isAcctCard ? new ItemValue(valueName, (Number)mainCurMoney, colors[0]) : new ItemValue(valueName, (Number)mainCurMoney.divide(TEN_THOUSAND, 2, 4), colors[0]);
        itemList.add(mainItem);
        Label mainRateLab = (Label)this.getView().getControl("mainrate");
        String mainRateValue = EmptyUtil.isEmpty((BigDecimal)totalMoney) ? "0.00%" : mainCurMoney.multiply(HUNDRED).divide(totalMoney, 2, 4) + "%";
        mainRateLab.setText(mainRateValue);
        Label mainMoneyLab = (Label)this.getView().getControl("maincurrcymoney1");
        String mainMoneyValue = isAcctCard ? this.getNumberFormatAccount(mainCurMoney) : this.getCurrencyName(mainCurId, "sign") + this.getNumberFormat(mainCurMoney.divide(TEN_THOUSAND, 2, 4));
        mainMoneyLab.setText(mainMoneyValue);
        logger.info("drawPiechart() : mainCurMoney={},mainRateValue={},mainMoneyValue={}", new Object[]{mainCurMoney, mainRateValue, mainMoneyValue});
        Label noMainRateLab = (Label)this.getView().getControl("notmainrate");
        Label noMainMoneyLab = (Label)this.getView().getControl("nobussnessmoney");
        Label otherRateLab = (Label)this.getView().getControl("otherrate");
        Label otherMoneyLab = (Label)this.getView().getControl("other");
        BigDecimal diffCur2MainMoney = BigDecimal.ZERO;
        if (noMainCurId != null && BigDecimal.ZERO.compareTo(notMainCurMoney) != 0) {
            BigDecimal otherMoeny;
            HashMap<Long, BigDecimal> diffCurMoenyMap = new HashMap<Long, BigDecimal>();
            diffCurMoenyMap.put((Long)noMainCurId, notMainCurMoney);
            if (!isAcctCard) {
                diffCur2MainMoney = this.diffCurrencyToMainCurrency(diffCurMoenyMap, (Long)mainCurId, cardName);
            }
            if (diffCur2MainMoney == null) {
                return;
            }
            String diffCurName = this.getCurrencyName(noMainCurId, new String[0]);
            ItemValue diffItem = isAcctCard ? new ItemValue(diffCurName, (Number)notMainCurMoney, colors[1]) : new ItemValue(diffCurName, (Number)diffCur2MainMoney.divide(TEN_THOUSAND, 2, 4), colors[1]);
            itemList.add(diffItem);
            String noMainRateValue = EmptyUtil.isEmpty((BigDecimal)totalMoney) ? "0.00%" : (isAcctCard ? notMainCurMoney.multiply(HUNDRED).divide(totalMoney, 2, 4) + "%" : diffCur2MainMoney.multiply(HUNDRED).divide(totalMoney, 2, 4) + "%");
            noMainRateLab.setText(noMainRateValue);
            String noMainMoneyValue = isAcctCard ? this.getNumberFormatAccount(notMainCurMoney) : this.getCurrencyName(noMainCurId, "sign") + this.getNumberFormat(notMainCurMoney.divide(TEN_THOUSAND, 2, 4));
            noMainMoneyLab.setText(noMainMoneyValue);
            logger.info("drawPiechart() : diffCur2MainMoney={},noMainRateValue={},noMainMoneyValue={}", new Object[]{diffCur2MainMoney, noMainRateValue, noMainMoneyValue});
            BigDecimal bigDecimal = otherMoeny = isAcctCard ? totalMoney.subtract(mainCurMoney).subtract(notMainCurMoney) : totalMoney.subtract(mainCurMoney).subtract(diffCur2MainMoney);
            if (BigDecimal.ZERO.compareTo(otherMoeny) != 0) {
                ItemValue otheritem = isAcctCard ? new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"CommonMethodsPlugin_4", (String)"tmc-mon-formplugin", (Object[])new Object[0]), (Number)otherMoeny, colors[2]) : new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6(\u6298\u7b97)", (String)"CommonMethodsPlugin_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]), (Number)otherMoeny.divide(TEN_THOUSAND, 2, 4), colors[2]);
                itemList.add(otheritem);
                String otherRateValue = EmptyUtil.isEmpty((BigDecimal)totalMoney) ? "0.00%" : otherMoeny.multiply(HUNDRED).divide(totalMoney, 2, 4) + "%";
                otherRateLab.setText(otherRateValue);
                String otherMoneyValue = isAcctCard ? this.getNumberFormatAccount(otherMoeny) : this.getCurrencyName(mainCurId, "sign") + this.getNumberFormat(otherMoeny.divide(TEN_THOUSAND, 2, 4));
                otherMoneyLab.setText(otherMoneyValue);
                logger.info("drawPiechart(),otherMoeny={},otherRateValue={},otherMoneyValue={}", new Object[]{otherMoeny, otherRateValue, otherMoneyValue});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap113"});
            }
        } else {
            BigDecimal otherMoeny;
            BigDecimal bigDecimal = otherMoeny = isAcctCard ? totalMoney.subtract(mainCurMoney).subtract(notMainCurMoney) : totalMoney.subtract(mainCurMoney).subtract(diffCur2MainMoney);
            if (BigDecimal.ZERO.compareTo(otherMoeny) != 0) {
                ItemValue otherItem = isAcctCard ? new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"CommonMethodsPlugin_4", (String)"tmc-mon-formplugin", (Object[])new Object[0]), (Number)otherMoeny, colors[1]) : new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6(\u6298\u7b97)", (String)"CommonMethodsPlugin_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]), (Number)otherMoeny.divide(TEN_THOUSAND, 2, 4), colors[1]);
                itemList.add(otherItem);
                String otherRateValue = EmptyUtil.isEmpty((BigDecimal)totalMoney) ? "0.00%" : otherMoeny.multiply(HUNDRED).divide(totalMoney, 2, 4) + "%";
                noMainRateLab.setText(otherRateValue);
                String otherMoneyValue = isAcctCard ? this.getNumberFormat(otherMoeny) : this.getCurrencyName(mainCurId, "sign") + this.getNumberFormat(otherMoeny.divide(TEN_THOUSAND, 2, 4));
                noMainMoneyLab.setText(otherMoneyValue);
                logger.info("drawPiechart(),otherMoeny={},otherRateValue={},otherMoneyValue={}", new Object[]{otherMoeny, otherRateValue, otherMoneyValue});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap113"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap113", "flexpanelap112"});
            }
        }
        PieSeries series = pieChart.createPieSeries("piechartap");
        series.setPropValue("label", (Object)new Object[]{Boolean.FALSE, "center"});
        ItemValue[] items = new ItemValue[itemList.size()];
        itemList.toArray(items);
        series.setRadius("45%", "60%");
        series.setCenter("25%", "38%");
        series.setData(items);
        this.getView().setVisible(Boolean.TRUE, new String[]{"piechartap"});
        if (isAcctCard) {
            pieChart.addTooltip("formatter", (Object)new StringBuilder("{b0}: ").append("{c0}(").append(ResManager.loadKDString((String)"\u4e2a", (String)"CommonMethodsPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0])).append(")<br/>{d0}%"));
        } else {
            pieChart.addTooltip("formatter", (Object)new StringBuilder("{b0}: ").append("{c0}(").append(ResManager.loadKDString((String)"\u4e07\u5143", (String)"CommonMethodsPlugin_3", (String)"tmc-mon-formplugin", (Object[])new Object[0])).append(")<br/>{d0}%"));
        }
        pieChart.setLegendPropValue("top", (Object)"20");
        pieChart.setLegendPropValue("orient", (Object)"vertical");
        pieChart.setLegendPropValue("left", (Object)160);
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.setLegendPropValue("itemGap", (Object)30);
        pieChart.addTooltip("position", (Object)new String[]{"15%", "50%"});
        pieChart.refresh();
    }

    protected String getPermissionItem() {
        return "47156aff000000ac";
    }

    protected String getNumberFormat(BigDecimal number) {
        DecimalFormat df = new DecimalFormat("###,###,###,##0.00");
        String format = df.format(number);
        return format;
    }

    protected String getNumberFormatAccount(BigDecimal number) {
        DecimalFormat df = new DecimalFormat("###,###,###,##0");
        String format = df.format(number);
        return format;
    }
}

