/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.calbalance;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.tmc.mon.business.calbalance.AbstractCalBalance;
import kd.tmc.mon.business.mode.AccountBalanceMode;
import kd.tmc.mon.common.enums.CalculationsEnum;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.MonDateUtils;

public class ManulaCalBalance
extends AbstractCalBalance {
    public ManulaCalBalance() {
        super(null);
    }

    public ManulaCalBalance(List<AccountBalanceMode> accountLst) {
        super(accountLst);
    }

    public ManulaCalBalance(LinkedHashMap<String, AccountBalanceMode> accountMap, List<AccountBalanceMode> account) {
        super(accountMap, account);
    }

    @Override
    public void updataAccountMap(List<AccountBalanceMode> accountLst, CalculationsEnum calEnum) {
        if (MonHelper.isEmpty((Object)this.accountMap)) {
            this.accountMap = this.accountMapAll();
        }
        for (AccountBalanceMode balcance : accountLst) {
            String key = this.getKey(balcance);
            AccountBalanceMode oldBalance = (AccountBalanceMode)this.accountMap.get(key);
            BigDecimal diffCreditAmount = BigDecimal.ZERO;
            BigDecimal diffDebitAmount = BigDecimal.ZERO;
            if (CalculationsEnum.Sub == calEnum) {
                if (MonHelper.isEmpty((Object)oldBalance)) continue;
                diffDebitAmount = oldBalance.getDebitAmount().subtract(balcance.getDebitAmount());
                oldBalance.setDebitAmount(diffDebitAmount);
                diffCreditAmount = oldBalance.getCreditAmount().subtract(balcance.getCreditAmount());
                oldBalance.setCreditAmount(diffCreditAmount);
                oldBalance.setAmount(oldBalance.getCalAmount());
            } else if (MonHelper.isEmpty((Object)oldBalance)) {
                oldBalance = balcance;
                oldBalance.setDayBalance(this.getPreDayAmount(oldBalance));
                oldBalance.setAmount(oldBalance.getCalAmount());
                this.accountMap.put(key, oldBalance);
            } else if (CalculationsEnum.Add == calEnum) {
                diffDebitAmount = oldBalance.getDebitAmount().add(balcance.getDebitAmount());
                oldBalance.setDebitAmount(diffDebitAmount);
                diffCreditAmount = oldBalance.getCreditAmount().add(balcance.getCreditAmount());
                oldBalance.setCreditAmount(diffCreditAmount);
                oldBalance.setAmount(oldBalance.getCalAmount());
            }
            long abankaccount = balcance.getBankAccount();
            long acurrency = balcance.getCurrency();
            Date abookdate = MonDateUtils.getCSTToDate((Date)balcance.getBookDate());
            for (Map.Entry entry : this.accountMap.entrySet()) {
                AccountBalanceMode mode = (AccountBalanceMode)entry.getValue();
                Long mbankaccount = mode.getBankAccount();
                Long mcurrency = mode.getCurrency();
                Date mbookdate = MonDateUtils.getCSTToDate((Date)mode.getBookDate());
                if (!mbankaccount.equals(abankaccount) || !mcurrency.equals(acurrency) || mbookdate.compareTo(abookdate) <= 0) continue;
                if (CalculationsEnum.Sub == calEnum) {
                    if (diffCreditAmount.compareTo(BigDecimal.ZERO) > 0) {
                        mode.setDayBalance(mode.getDayBalance().subtract(balcance.getCreditAmount()));
                    } else {
                        mode.setDayBalance(mode.getDayBalance().subtract(balcance.getDebitAmount()));
                    }
                } else if (CalculationsEnum.Add == calEnum) {
                    if (diffCreditAmount.compareTo(BigDecimal.ZERO) > 0) {
                        mode.setDayBalance(mode.getDayBalance().add(balcance.getCreditAmount()));
                    } else {
                        mode.setDayBalance(mode.getDayBalance().add(balcance.getDebitAmount()));
                    }
                }
                mode.setAmount(mode.getCalAmount());
            }
        }
    }
}

