/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.calbalance;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.tmc.mon.business.calbalance.InitCalBalance;
import kd.tmc.mon.business.mode.AccountBalanceMode;
import kd.tmc.mon.common.enums.CalculationsEnum;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.MonDateUtils;

public class SynCalBalance
extends InitCalBalance {
    public SynCalBalance() {
    }

    public SynCalBalance(List<AccountBalanceMode> accountLst) {
        super(accountLst);
    }

    public SynCalBalance(LinkedHashMap<String, AccountBalanceMode> accountMap, List<AccountBalanceMode> accountLst) {
        super(accountMap, accountLst);
    }

    @Override
    public synchronized void updataAccountMap(List<AccountBalanceMode> accountLst, CalculationsEnum calEnum) {
        if (MonHelper.isEmpty((Object)this.accountMap)) {
            this.accountMap = this.accountMapAll();
        }
        for (AccountBalanceMode account : accountLst) {
            Date date = (Date)this.beginDateMap.get(account.getOrgId());
            if (account.getBookDate().before(date)) continue;
            String key = this.getKey(account);
            BigDecimal bdebitamount = account.getDebitAmount();
            BigDecimal bcreditamount = account.getCreditAmount();
            AccountBalanceMode mode = null;
            if (MonHelper.isNotEmpty(this.accountMap.get(key))) {
                mode = (AccountBalanceMode)this.accountMap.get(key);
                BigDecimal debitamount = mode.getDebitAmount();
                BigDecimal creditamount = mode.getCreditAmount();
                mode.setCreditAmount(creditamount.add(bcreditamount));
                mode.setDebitAmount(debitamount.add(bdebitamount));
                mode.setDayTradeNum(mode.getDayTradeNum() + 1);
                mode.setAmount(mode.getCalAmount());
                this.updateLastAmount(this.accountMap, account, CalculationsEnum.None);
                continue;
            }
            mode = new AccountBalanceMode();
            mode.setOrgId(account.getOrgId());
            mode.setBookDate(account.getBookDate());
            mode.setBankAccount(account.getBankAccount());
            mode.setCurrency(account.getCurrency());
            mode.setCreditAmount(bcreditamount);
            mode.setDebitAmount(bdebitamount);
            BigDecimal daybalance = this.getPreDayAmount(mode);
            mode.setDayBalance(daybalance);
            mode.setAmount(mode.getCalAmount());
            this.updateLastAmount(this.accountMap, account, CalculationsEnum.None);
            this.accountMap.put(key, mode);
        }
    }

    private void updateLastAmount(Map<String, AccountBalanceMode> accountMap, AccountBalanceMode account, CalculationsEnum calEnum) {
        long abankaccount = account.getBankAccount();
        long acurrency = account.getCurrency();
        Date abookdate = MonDateUtils.getCSTToDate((Date)account.getBookDate());
        for (Map.Entry<String, AccountBalanceMode> entry : accountMap.entrySet()) {
            AccountBalanceMode mode = entry.getValue();
            Long mbankaccount = mode.getBankAccount();
            Long mcurrency = mode.getCurrency();
            Date mbookdate = MonDateUtils.getCSTToDate((Date)mode.getBookDate());
            if (!mbankaccount.equals(abankaccount) || !mcurrency.equals(acurrency) || mbookdate.compareTo(abookdate) <= 0) continue;
            mode.setDayBalance(mode.getCalDayBalance(account));
            mode.setAmount(mode.getCalAmount());
        }
    }
}

