/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.query;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PoolMoneyService {
    private static Log logger = LogFactory.getLog(PoolMoneyService.class);
    private static final String[] FIELDS = new String[]{"currency", "org", "acctid", "bank", "acctnumber", "amount", "sort", "color", "bookdate", "cur", "groupacctamount", "subacctamoutsum", "acctgroup"};
    private static final DataType[] DATA_TYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType};
    private static final String BANK_JOURNAL_SELECT_FIELDS = "currency.name as currency,org.name as org,bankaccount.id as acctid,bankaccount.bank.bank_cate.name as bank,bankaccount.bankaccountnumber as acctnumber,amount,'1' sort,'0' color,bookdate,currency.id as cur,0.0 AS groupacctamount,0.0 AS subacctamoutsum,'' acctgroup";
    private static final String BANK_BALANCE_SELECT_FIELDS = "currency.name as currency,company.name as org,accountbank.id as acctid,accountbank.bank.bank_cate.name as bank,accountbank.bankaccountnumber as acctnumber,amount,'1' sort,'0' color,bizdate as bookdate,currency.id as cur,0.0 AS groupacctamount,0.0 AS subacctamoutsum,'' acctgroup";

    public static DataSet queryBalanceDataSet(String datasource, Date balanceDate, DynamicObjectCollection balanceCurrency, DynamicObjectCollection bankFi, List<Long> orgIds, List<Long> acctIds) {
        DataSet dataSet = null;
        if (EmptyUtil.isEmpty(acctIds)) {
            return dataSet;
        }
        switch (datasource) {
            case "bankjournal": {
                QFilter[] jQFilters = PoolMoneyService.getQFilters(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
                dataSet = PoolMoneyService.queryFromBankJournal(BANK_JOURNAL_SELECT_FIELDS, jQFilters);
                break;
            }
            case "bankbalance": {
                QFilter[] bQFilters = PoolMoneyService.getQFilters(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
                dataSet = PoolMoneyService.queryFromBankBalance(BANK_BALANCE_SELECT_FIELDS, bQFilters);
                break;
            }
            case "directconnacct": {
                DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds)});
                logger.info("PoolMoneyService.queryBalanceDataSet(),datasource=directconnacct,query accts.size={}", (Object)accts.size());
                ArrayList<Long> directIds = new ArrayList<Long>();
                ArrayList<Long> noDirectIds = new ArrayList<Long>();
                for (DynamicObject acct : accts) {
                    Long id = acct.getLong("id");
                    String finorgtype = acct.getString("finorgtype");
                    boolean issetbankinterface = acct.getBoolean("issetbankinterface");
                    if ("1".equals(finorgtype) || "3".equals(finorgtype) || issetbankinterface) {
                        directIds.add(id);
                        continue;
                    }
                    noDirectIds.add(id);
                }
                DataSet journal = null;
                if (EmptyUtil.isNoEmpty(noDirectIds)) {
                    QFilter[] journalFilter = PoolMoneyService.getQFilters("bankjournal", balanceDate, balanceCurrency, orgIds, noDirectIds);
                    journal = PoolMoneyService.queryFromBankJournal(BANK_JOURNAL_SELECT_FIELDS, journalFilter);
                }
                DataSet balance = null;
                if (EmptyUtil.isNoEmpty(directIds)) {
                    QFilter[] balanceFilter = PoolMoneyService.getQFilters("bankbalance", balanceDate, balanceCurrency, orgIds, directIds);
                    balance = PoolMoneyService.queryFromBankBalance(BANK_BALANCE_SELECT_FIELDS, balanceFilter);
                }
                dataSet = null != journal && null != balance ? journal.union(balance) : (null != journal ? journal : balance);
            }
        }
        return dataSet;
    }

    public static DataSet queryCurrencyDataSet(String datasource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        DataSet result = null;
        switch (datasource) {
            case "bankjournal": {
                QFilter[] jFilters = PoolMoneyService.getQFilters(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
                result = PoolMoneyService.queryFromBankJournal("currency", jFilters);
                break;
            }
            case "bankbalance": {
                QFilter[] bFilters = PoolMoneyService.getQFilters(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
                result = PoolMoneyService.queryFromBankBalance("currency", bFilters);
                break;
            }
            case "directconnacct": {
                DynamicObjectCollection acctList = QueryServiceHelper.query((String)"am_accountbank", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds)});
                logger.info("PoolMoneyService.queryCurrencyDataSet(),datasource=directconnacct,query acctList.size={}", (Object)acctList.size());
                ArrayList<Long> directIds = new ArrayList<Long>();
                ArrayList<Long> noDirectIds = new ArrayList<Long>();
                for (DynamicObject acct : acctList) {
                    Long id = acct.getLong("id");
                    String finorgtype = acct.getString("finorgtype");
                    boolean issetbankinterface = acct.getBoolean("issetbankinterface");
                    if ("1".equals(finorgtype) || "3".equals(finorgtype) || issetbankinterface) {
                        directIds.add(id);
                        continue;
                    }
                    noDirectIds.add(id);
                }
                DataSet journal = null;
                if (EmptyUtil.isNoEmpty(noDirectIds)) {
                    QFilter[] journalFilter = PoolMoneyService.getQFilters("bankjournal", balanceDate, balanceCurrency, orgIds, noDirectIds);
                    journal = PoolMoneyService.queryFromBankJournal("currency", journalFilter);
                }
                DataSet balance = null;
                if (EmptyUtil.isNoEmpty(directIds)) {
                    QFilter[] balanceFilter = PoolMoneyService.getQFilters("bankbalance", balanceDate, balanceCurrency, orgIds, directIds);
                    balance = PoolMoneyService.queryFromBankBalance("currency", balanceFilter);
                }
                result = null != journal && null != balance ? journal.union(balance) : (null != journal ? journal : balance);
            }
        }
        return result;
    }

    public static DataSet getDetailDataSet(DataSet dataSet, Set<Long> acctIds) {
        if (null == dataSet || EmptyUtil.isEmpty(acctIds)) {
            return PoolMoneyService.createEmptyDataSet();
        }
        DataSet maxGroupData = dataSet.copy().groupBy(new String[]{"acctid", "cur"}).max("bookdate").finish();
        HashSet<String> maxKeySet = new HashSet<String>();
        for (Row row : maxGroupData) {
            String maxRowKey = String.valueOf(row.getLong("acctid")) + String.valueOf(row.getLong("cur")) + String.valueOf(row.getDate("bookdate").getTime());
            maxKeySet.add(maxRowKey);
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        Iterator iterator = dataSet.iterator();
        ArrayList<Object[]> detailLsit = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            String rowKey;
            Row row = (Row)iterator.next();
            Long rowAcctId = row.getLong("acctid");
            Long rowCurId = row.getLong("cur");
            Date rowBookDate = row.getDate("bookdate");
            if (null == rowAcctId || null == rowCurId || null == rowBookDate || !maxKeySet.contains(rowKey = String.valueOf(rowAcctId) + String.valueOf(rowCurId) + String.valueOf(rowBookDate.getTime()))) continue;
            Object[] arr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                arr[i] = row.get(name);
            }
            detailLsit.add(arr);
        }
        return Algo.create((String)"PoolMoneyService").createDataSet(detailLsit, rowMeta);
    }

    public static DataSet[] getDetailDataSet(DataSet dataSet, Set<Long> acctIds, Map<Long, Set<Long>> poolMap) {
        if (null == dataSet || EmptyUtil.isEmpty(acctIds)) {
            return new DataSet[]{PoolMoneyService.createEmptyDataSet(), PoolMoneyService.createEmptyDataSet()};
        }
        DataSet maxGroupData = dataSet.copy().groupBy(new String[]{"acctid", "cur"}).max("bookdate").finish();
        HashSet<String> maxKeySet = new HashSet<String>();
        for (Row row : maxGroupData) {
            String maxRowKey = String.valueOf(row.getLong("acctid")) + String.valueOf(row.getLong("cur")) + String.valueOf(row.getDate("bookdate").getTime());
            maxKeySet.add(maxRowKey);
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        Iterator iterator = dataSet.iterator();
        ArrayList<Object[]> poolDetailList = new ArrayList<Object[]>();
        ArrayList<Object[]> outPoolDetailList = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            String rowKey;
            Row row = (Row)iterator.next();
            Long rowAcctId = row.getLong("acctid");
            Long rowCurId = row.getLong("cur");
            Date rowBookDate = row.getDate("bookdate");
            if (null == rowAcctId || null == rowCurId || null == rowBookDate || !maxKeySet.contains(rowKey = String.valueOf(rowAcctId) + String.valueOf(rowCurId) + String.valueOf(rowBookDate.getTime()))) continue;
            Object[] arr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                arr[i] = row.get(name);
            }
            if (poolMap.containsKey(rowAcctId) && EmptyUtil.isNoEmpty(poolMap.get(rowAcctId)) && poolMap.get(rowAcctId).contains(rowCurId)) {
                poolDetailList.add(arr);
                continue;
            }
            outPoolDetailList.add(arr);
        }
        DataSet poolDetail = Algo.create((String)"PoolMoneyService").createDataSet(poolDetailList, rowMeta);
        DataSet outPoolDetail = Algo.create((String)"PoolMoneyService").createDataSet(outPoolDetailList, rowMeta);
        return new DataSet[]{poolDetail, outPoolDetail};
    }

    public static QFilter[] getQFilters(String datasource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)balanceCurrency)) {
            Long[] curIds = (Long[])balanceCurrency.stream().map(e -> e.getLong("id")).toArray(Long[]::new);
            qFilters.add(new QFilter("currency", "in", (Object)curIds));
        }
        if ("bankbalance".equals(datasource)) {
            qFilters.add(new QFilter("bizdate", "<=", (Object)balanceDate));
            qFilters.add(new QFilter("accountbank", "in", acctIds));
            qFilters.add(new QFilter("company", "in", orgIds));
        } else {
            qFilters.add(new QFilter("bookdate", "<=", (Object)balanceDate));
            qFilters.add(new QFilter("bankaccount", "in", acctIds));
            qFilters.add(new QFilter("org", "in", orgIds));
        }
        return qFilters.toArray(new QFilter[0]);
    }

    public static DataSet queryFromBankJournal(String fileds, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)"PoolMoneyService", (String)"cas_accountbalance", (String)fileds, (QFilter[])filters, null);
    }

    public static DataSet queryFromBankBalance(String fileds, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)"PoolMoneyService", (String)"bei_bankbalance", (String)fileds, (QFilter[])filters, null);
    }

    public static Set<Long> queryAcctIds(DynamicObjectCollection balanceCurrency, DynamicObjectCollection bankFi, List<Long> orgFiList, boolean statsInnerAcct) {
        ArrayList<QFilter> acctFilters = new ArrayList<QFilter>();
        QFilter orgFilter = !EmptyUtil.isEmpty(orgFiList) ? BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", orgFiList, (boolean)true) : new QFilter("ctrlstrategy", "=", (Object)"5").and("status", "=", (Object)"C").or("id", "in", orgFiList);
        acctFilters.add(orgFilter);
        acctFilters.add(new QFilter("acctstatus", "!=", (Object)"closed"));
        acctFilters.add(new QFilter("isvirtual", "=", (Object)"0"));
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)balanceCurrency)) {
            Long[] curIds = (Long[])balanceCurrency.stream().map(c -> c.getLong("id")).toArray(Long[]::new);
            acctFilters.add(new QFilter("currency.fbasedataid", "in", (Object)curIds));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankFi)) {
            Long[] bankIds = (Long[])bankFi.stream().map(b -> b.getLong("id")).toArray(Long[]::new);
            acctFilters.add(new QFilter("bank.bank_cate", "in", (Object)bankIds));
        }
        if (!statsInnerAcct) {
            acctFilters.add(new QFilter("inneracct", "=", (Object)0L));
        }
        DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])acctFilters.toArray(new QFilter[0]));
        return accts.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
    }

    public static Map<DynamicObject, Set<Long>> queryAcctGroups(DynamicObjectCollection balanceCurrency, DynamicObjectCollection bankFi, List<Long> orgFiList, boolean statsInnerAcct) {
        HashMap<DynamicObject, Set<Long>> map = new HashMap<DynamicObject, Set<Long>>();
        Set<Long> acctIds = PoolMoneyService.queryAcctIds(balanceCurrency, bankFi, orgFiList, statsInnerAcct);
        if (EmptyUtil.isNoEmpty(acctIds)) {
            DynamicObject[] acctGroups;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("accountbank", "in", acctIds));
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)balanceCurrency)) {
                Long[] curIds = (Long[])balanceCurrency.stream().map(c -> c.getLong("id")).toArray(Long[]::new);
                qFilters.add(new QFilter("currency", "in", (Object)curIds));
            }
            for (DynamicObject acctGroup : acctGroups = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id,currency,company,accountbank,name,entrys,entrys.bankacct,entrys.bankacct.id,entrys.bankacct.inneracct.id", (QFilter[])qFilters.toArray(new QFilter[0]))) {
                DynamicObjectCollection entry = acctGroup.getDynamicObjectCollection("entrys");
                HashSet<Long> subAcctIds = new HashSet<Long>();
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entry)) {
                    for (DynamicObject eBankAcct : entry) {
                        Long eBankAcctId = eBankAcct.getLong("bankacct.id");
                        Long eInnerAcctId = eBankAcct.getLong("bankacct.inneracct.id");
                        if (!statsInnerAcct && eInnerAcctId != 0L) continue;
                        subAcctIds.add(eBankAcctId);
                    }
                }
                map.put(acctGroup, subAcctIds);
            }
        }
        return map;
    }

    public static DataSet getAcctGroupDataSet(boolean sonacctispool, Map<DynamicObject, Set<Long>> acctGroupMap, DataSet groupDetail, DataSet subDetail) {
        int size = acctGroupMap.size();
        Set<DynamicObject> acctGroups = acctGroupMap.keySet();
        HashMap<Long, String> groupAcctCurMap = new HashMap<Long, String>(size);
        HashMap<Long, BigDecimal> subAcctAmtMap = new HashMap<Long, BigDecimal>(size);
        HashMap<Long, BigDecimal> groupAcctAmtMap = new HashMap<Long, BigDecimal>(size);
        HashSet<DynamicObject[]> gAcctIds = new HashSet<DynamicObject[]>(size);
        for (DynamicObject acctGroup : acctGroups) {
            Long gId = acctGroup.getLong("id");
            DynamicObject[] gAcctId = Long.valueOf(acctGroup.getDynamicObject("accountbank").getLong("id"));
            Long gCurId = acctGroup.getDynamicObject("currency").getLong("id");
            groupAcctCurMap.put(gId, String.valueOf(gAcctId) + "_" + String.valueOf(gCurId));
            gAcctIds.add(gAcctId);
            subAcctAmtMap.put(gId, BigDecimal.ZERO);
            groupAcctAmtMap.put(gId, BigDecimal.ZERO);
        }
        HashMap<Long, String> openOrgMap = new HashMap<Long, String>(gAcctIds.size());
        HashMap<Long, String> bankCateMap = new HashMap<Long, String>(gAcctIds.size());
        if (EmptyUtil.isNoEmpty(gAcctIds)) {
            DynamicObject[] accts;
            for (DynamicObject acct : accts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,openorg.name,bank.bank_cate.name", (QFilter[])new QFilter[]{new QFilter("id", "in", gAcctIds)})) {
                long acctId = acct.getLong("id");
                openOrgMap.put(acctId, acct.getString("openorg.name"));
                bankCateMap.put(acctId, acct.getString("bank.bank_cate.name"));
            }
        }
        for (Row row : subDetail) {
            Long rowCurId = row.getLong("cur");
            Long rowAcctId = row.getLong("acctid");
            Long groupId = PoolMoneyService.getGroupIdBySubAcctId(acctGroupMap, rowAcctId, rowCurId);
            if (!EmptyUtil.isNoEmpty((Long)groupId)) continue;
            BigDecimal subSumAmt = (BigDecimal)subAcctAmtMap.get(groupId);
            subSumAmt = subSumAmt.add(row.getBigDecimal("amount"));
            subAcctAmtMap.put(groupId, subSumAmt);
        }
        RowMeta rowMeta = groupDetail.getRowMeta();
        Field[] fields = rowMeta.getFields();
        for (Row row : groupDetail) {
            Long rowCurId = row.getLong("cur");
            Long rowAcctId = row.getLong("acctid");
            String mapKey = String.valueOf(rowAcctId) + "_" + String.valueOf(rowCurId);
            Long groupId = null;
            for (Map.Entry entry : groupAcctCurMap.entrySet()) {
                if (!Objects.equals(mapKey, entry.getValue())) continue;
                groupId = (Long)entry.getKey();
            }
            if (!EmptyUtil.isNoEmpty(groupId)) continue;
            BigDecimal gAcctAmt = (BigDecimal)groupAcctAmtMap.get(groupId);
            gAcctAmt = gAcctAmt.add(row.getBigDecimal("amount"));
            groupAcctAmtMap.put(groupId, gAcctAmt);
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(size);
        for (DynamicObject acctGroup : acctGroups) {
            Object[] rowArr = PoolMoneyService.genDataRowArr(fields, acctGroup, openOrgMap, bankCateMap, groupAcctAmtMap, subAcctAmtMap, sonacctispool);
            dataList.add(rowArr);
        }
        return Algo.create((String)"PoolMoneyService").createDataSet(dataList, rowMeta);
    }

    public static Long getGroupIdBySubAcctId(Map<DynamicObject, Set<Long>> acctGroupMap, Long subAcctId, Long rowCurId) {
        for (Map.Entry<DynamicObject, Set<Long>> entry : acctGroupMap.entrySet()) {
            DynamicObject acctGroup = entry.getKey();
            Long gCurId = acctGroup.getDynamicObject("currency").getLong("id");
            Set<Long> subAcctIds = entry.getValue();
            if (!subAcctIds.contains(subAcctId) || !Objects.equals(gCurId, rowCurId)) continue;
            return acctGroup.getLong("id");
        }
        return null;
    }

    public static Object[] genDataRowArr(Field[] fields, DynamicObject acctGroup, Map<Long, String> openOrgMap, Map<Long, String> bankCateMap, Map<Long, BigDecimal> groupAmtMap, Map<Long, BigDecimal> subSumAmtMap, boolean sonacctispool) {
        String groupAcctNumber = acctGroup.getDynamicObject("accountbank").getString("bankaccountnumber");
        Long groupAcctId = acctGroup.getDynamicObject("accountbank").getLong("id");
        Long groupId = acctGroup.getLong("id");
        String curName = acctGroup.getDynamicObject("currency").getString("name");
        BigDecimal groupAmt = groupAmtMap.containsKey(groupId) ? groupAmtMap.get(groupId) : BigDecimal.ZERO;
        BigDecimal subSumAmt = subSumAmtMap.containsKey(groupId) ? subSumAmtMap.get(groupId) : BigDecimal.ZERO;
        Object[] arr = new Object[fields.length];
        block26: for (int i = 0; i < fields.length; ++i) {
            String name;
            switch (name = fields[i].getName()) {
                case "currency": {
                    arr[i] = curName;
                    continue block26;
                }
                case "org": {
                    arr[i] = openOrgMap.get(groupAcctId);
                    continue block26;
                }
                case "bank": {
                    arr[i] = bankCateMap.get(groupAcctId);
                    continue block26;
                }
                case "acctnumber": {
                    arr[i] = groupAcctNumber;
                    continue block26;
                }
                case "amount": {
                    arr[i] = sonacctispool ? groupAmt.add(subSumAmt) : groupAmt;
                    continue block26;
                }
                case "sort": {
                    arr[i] = "1";
                    continue block26;
                }
                case "color": {
                    arr[i] = "0";
                    continue block26;
                }
                case "cur": {
                    arr[i] = acctGroup.getDynamicObject("currency").getLong("id");
                    continue block26;
                }
                case "groupacctamount": {
                    arr[i] = groupAmt;
                    continue block26;
                }
                case "subacctamoutsum": {
                    arr[i] = subSumAmt;
                    continue block26;
                }
                case "acctgroup": {
                    arr[i] = acctGroup.getString("name");
                }
            }
        }
        return arr;
    }

    public static DataSet queryByCurrency(DynamicObject rptCurrency, Date balanceDate, long orgId, DataSet dataSet, String[] sortFields, long exchangeRateTableId, String currencyUnit) {
        ArrayList<Object[]> curList = new ArrayList<Object[]>();
        DataSet copy = dataSet.copy();
        DataSet curGroup = copy.groupBy(new String[]{"cur", "currency"}).sum("amount").sum("groupacctamount").sum("subacctamoutsum").finish();
        Iterator curIiter = curGroup.iterator();
        Long rptCurId = rptCurrency.getLong("id");
        Field[] fields = dataSet.getRowMeta().getFields();
        BigDecimal amtTotal = BigDecimal.ZERO;
        BigDecimal groupAmtTotal = BigDecimal.ZERO;
        BigDecimal subSumAmtTotal = BigDecimal.ZERO;
        while (curIiter.hasNext()) {
            Row row = (Row)curIiter.next();
            Long rowCurId = row.getLong("cur");
            BigDecimal rowAmt = row.getBigDecimal("amount");
            BigDecimal rowGroupAmt = row.getBigDecimal("groupacctamount");
            BigDecimal rowSubSumAmt = row.getBigDecimal("subacctamoutsum");
            Object[] curArr = new Object[fields.length];
            block37: for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "currency": {
                        curArr[i] = row.getString("currency") + " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
                        continue block37;
                    }
                    case "amount": {
                        curArr[i] = rowAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                        continue block37;
                    }
                    case "sort": {
                        curArr[i] = "1";
                        continue block37;
                    }
                    case "color": {
                        curArr[i] = "1";
                        continue block37;
                    }
                    case "cur": {
                        curArr[i] = rowCurId;
                        continue block37;
                    }
                    case "groupacctamount": {
                        curArr[i] = rowGroupAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                        continue block37;
                    }
                    case "subacctamoutsum": {
                        curArr[i] = rowSubSumAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                    }
                }
            }
            curList.add(curArr);
            BigDecimal exRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)row.getLong("cur"), (Long)rptCurId, (Date)balanceDate);
            if (exRate == null) {
                exRate = BigDecimal.ONE;
            }
            amtTotal = amtTotal.add(rowAmt.multiply(exRate));
            groupAmtTotal = groupAmtTotal.add(rowGroupAmt.multiply(exRate));
            subSumAmtTotal = subSumAmtTotal.add(rowSubSumAmt.multiply(exRate));
        }
        Object[] rptArr = new Object[fields.length];
        block38: for (int i = 0; i < fields.length; ++i) {
            String name;
            switch (name = fields[i].getName()) {
                case "currency": {
                    rptArr[i] = ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd", (String)"AccountMoneySumListDataPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]) + " " + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccountMoneySumListDataPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]);
                    continue block38;
                }
                case "amount": {
                    rptArr[i] = amtTotal.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                    continue block38;
                }
                case "sort": {
                    rptArr[i] = "2";
                    continue block38;
                }
                case "color": {
                    rptArr[i] = "3";
                    continue block38;
                }
                case "cur": {
                    rptArr[i] = rptCurId;
                    continue block38;
                }
                case "groupacctamount": {
                    rptArr[i] = groupAmtTotal.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                    continue block38;
                }
                case "subacctamoutsum": {
                    rptArr[i] = subSumAmtTotal.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                }
            }
        }
        curList.add(rptArr);
        DataSet totalDataSet = Algo.create((String)"PoolMoneyService").createDataSet(curList, dataSet.getRowMeta());
        dataSet = dataSet.updateFields(new String[]{"amount", "groupacctamount", "subacctamoutsum"}, new String[]{"amount/" + currencyUnit, "groupacctamount/" + currencyUnit, "subacctamoutsum/" + currencyUnit});
        DataSet allData = dataSet.union(totalDataSet);
        return allData.orderBy(new String[]{"sort", "currency", sortFields[0], sortFields[1], sortFields[2]});
    }

    public static DataSet queryByOthers(String calcStyle, DynamicObject reportCurrency, Date balanceDate, String[] sortFields, long orgId, DataSet dataSet, long exchangeRateTableId, String currencyUnit) {
        Long rptCurId = reportCurrency.getLong("id");
        DataSet copy2 = dataSet.copy();
        DataSet calcGroup = copy2.groupBy(new String[]{"cur", "currency", calcStyle}).sum("amount").sum("groupacctamount").sum("subacctamoutsum").finish();
        Iterator calcIter = calcGroup.iterator();
        Field[] fields = dataSet.getRowMeta().getFields();
        HashMap<String, BigDecimal[]> calcAmtMap = new HashMap<String, BigDecimal[]>();
        ArrayList<Object[]> calcTotalList = new ArrayList<Object[]>(10);
        while (calcIter.hasNext()) {
            Row row = (Row)calcIter.next();
            String rowStyle = row.getString(calcStyle);
            Long rowCurId = row.getLong("cur");
            BigDecimal rowAmt = row.getBigDecimal("amount");
            BigDecimal rowGroupAmt = row.getBigDecimal("groupacctamount");
            BigDecimal rowSubSumAmt = row.getBigDecimal("subacctamoutsum");
            Object[] calcTotalArr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "currency": {
                        calcTotalArr[i] = row.getString("currency") + " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
                        break;
                    }
                    case "amount": {
                        calcTotalArr[i] = rowAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                        break;
                    }
                    case "sort": {
                        calcTotalArr[i] = "1";
                        break;
                    }
                    case "color": {
                        calcTotalArr[i] = "1";
                        break;
                    }
                    case "cur": {
                        calcTotalArr[i] = rowCurId;
                        break;
                    }
                    case "groupacctamount": {
                        calcTotalArr[i] = rowGroupAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                        break;
                    }
                    case "subacctamoutsum": {
                        calcTotalArr[i] = rowSubSumAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                    }
                }
                if (!calcStyle.equals(name)) continue;
                calcTotalArr[i] = rowStyle;
            }
            calcTotalList.add(calcTotalArr);
            BigDecimal exRate = BigDecimal.ZERO;
            if (rowCurId.equals(rptCurId)) {
                exRate = BigDecimal.ONE;
            } else {
                exRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)rowCurId, (Long)rptCurId, (Date)balanceDate);
                if (exRate == null) {
                    exRate = BigDecimal.ONE;
                }
            }
            BigDecimal[] calcAmts = new BigDecimal[3];
            if (calcAmtMap.containsKey(rowStyle)) {
                calcAmts = (BigDecimal[])calcAmtMap.get(rowStyle);
                calcAmts[0] = calcAmts[0].add(rowAmt.multiply(exRate));
                calcAmts[1] = calcAmts[1].add(rowGroupAmt.multiply(exRate));
                calcAmts[2] = calcAmts[2].add(rowSubSumAmt.multiply(exRate));
            } else {
                calcAmts[0] = rowAmt.multiply(exRate);
                calcAmts[1] = rowGroupAmt.multiply(exRate);
                calcAmts[2] = rowSubSumAmt.multiply(exRate);
            }
            calcAmtMap.put(rowStyle, calcAmts);
        }
        BigDecimal amtTotal = BigDecimal.ZERO;
        BigDecimal groupAmtTotal = BigDecimal.ZERO;
        BigDecimal subSumAmtTotal = BigDecimal.ZERO;
        for (Map.Entry calcAmt : calcAmtMap.entrySet()) {
            String calcKey = (String)calcAmt.getKey();
            BigDecimal[] amtArr = (BigDecimal[])calcAmtMap.get(calcKey);
            BigDecimal styleAmt = amtArr[0];
            BigDecimal groupAmt = amtArr[1];
            BigDecimal subStmAmt = amtArr[2];
            amtTotal = amtTotal.add(styleAmt);
            groupAmtTotal = groupAmtTotal.add(groupAmt);
            subSumAmtTotal = subSumAmtTotal.add(subStmAmt);
            Object[] styleArr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "amount": {
                        styleArr[i] = styleAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                        break;
                    }
                    case "sort": {
                        styleArr[i] = "1";
                        break;
                    }
                    case "color": {
                        styleArr[i] = "2";
                        break;
                    }
                    case "cur": {
                        styleArr[i] = rptCurId;
                        break;
                    }
                    case "groupacctamount": {
                        styleArr[i] = groupAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                        break;
                    }
                    case "subacctamoutsum": {
                        styleArr[i] = subStmAmt.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                    }
                }
                if (!calcStyle.equals(name)) continue;
                styleArr[i] = calcKey == null ? " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]) : calcKey + " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            calcTotalList.add(styleArr);
        }
        Object[] reportArr = new Object[fields.length];
        block56: for (int i = 0; i < fields.length; ++i) {
            String name;
            switch (name = fields[i].getName()) {
                case "currency": {
                    reportArr[i] = ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd", (String)"AccountMoneySumListDataPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]) + " " + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccountMoneySumListDataPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]);
                    continue block56;
                }
                case "amount": {
                    reportArr[i] = amtTotal.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                    continue block56;
                }
                case "sort": {
                    reportArr[i] = "2";
                    continue block56;
                }
                case "color": {
                    reportArr[i] = "3";
                    continue block56;
                }
                case "cur": {
                    reportArr[i] = rptCurId;
                    continue block56;
                }
                case "groupacctamount": {
                    reportArr[i] = groupAmtTotal.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                    continue block56;
                }
                case "subacctamoutsum": {
                    reportArr[i] = subSumAmtTotal.divide(new BigDecimal(currencyUnit), RoundingMode.HALF_UP);
                }
            }
        }
        calcTotalList.add(reportArr);
        DataSet totalDataSet = Algo.create((String)"PoolMoneyService").createDataSet(calcTotalList, dataSet.getRowMeta());
        dataSet = dataSet.updateFields(new String[]{"amount", "groupacctamount", "subacctamoutsum"}, new String[]{"amount/" + currencyUnit, "groupacctamount/" + currencyUnit, "subacctamoutsum/" + currencyUnit});
        DataSet union = dataSet.union(totalDataSet);
        union = union.orderBy(new String[]{"sort", calcStyle, "currency", sortFields[1], sortFields[2]});
        return union;
    }

    public static DataSet createEmptyDataSet() {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATA_TYPES);
        return Algo.create((String)"PoolMoneyService.createEmptyDataSet").createDataSet(new ArrayList(), rowMeta);
    }
}

