/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tmc.mon.business.calbalance.AbstractCalBalance;
import kd.tmc.mon.business.mode.AccountBalanceMode;
import kd.tmc.mon.business.task.BankJournalHelper;
import kd.tmc.mon.common.enums.CalculationsEnum;

public class BatchUpdateBankJournal {
    private static final Log logger = LogFactory.getLog(BatchUpdateBankJournal.class);
    private static final ThreadPool threadPoolJournal = ThreadPools.newFixedThreadPool((String)"BatchUpdateBankJournal", (int)5);

    public static void batchUpdate(AbstractCalBalance calBalance, List<Long> ids, CalculationsEnum calEnum) {
        int pageSize = 100;
        int totalSize = ids.size();
        int totalPage = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        ArrayList<Future> lst = new ArrayList<Future>(totalPage);
        int beginIndex = 0;
        CopyOnWriteArrayList monJournalAll = new CopyOnWriteArrayList();
        for (int i = 0; i < totalPage; ++i) {
            int endIndex;
            int n = endIndex = i < totalPage - 1 ? beginIndex + pageSize : totalSize;
            if (totalSize < pageSize) {
                endIndex = totalSize;
            }
            List<Long> rangeIds = ids.subList(beginIndex, endIndex);
            QFilter casfilter = new QFilter("id", "in", rangeIds);
            QFilter monfilter = new QFilter("bankjournalid", "in", rangeIds);
            Future future = threadPoolJournal.submit(() -> {
                List<DynamicObject> fetchAll = null;
                List<AccountBalanceMode> accountLst = null;
                if (CalculationsEnum.Sub == calEnum) {
                    fetchAll = BankJournalHelper.monFetch(monfilter);
                } else {
                    fetchAll = BankJournalHelper.casFetch(casfilter);
                    Map<Long, DynamicObject> monJournals = BankJournalHelper.convertor(fetchAll);
                    DynamicObject[] journals = monJournals.values().toArray(new DynamicObject[0]);
                    SaveServiceHelper.save((DynamicObject[])journals);
                    monJournalAll.addAll(monJournals.values());
                    BankJournalHelper.updateBillValue(monJournals, monJournalAll);
                }
                accountLst = BankJournalHelper.journalToAccounts(fetchAll);
                calBalance.updataAccountMap(accountLst, calEnum);
                return Boolean.TRUE;
            });
            beginIndex = endIndex;
            lst.add(future);
        }
        for (Future future : lst) {
            try {
                future.get();
            }
            catch (Exception e) {
                logger.info("\u65e5\u8bb0\u8d26\u4f59\u989d\u66f4\u65b0\u9519\u8bef");
            }
        }
    }

    public static void batchAdd(AbstractCalBalance calBalance, List<DynamicObject> journalLst, CalculationsEnum calEnum) {
        int pageSize = 100;
        int totalSize = journalLst.size();
        int totalPage = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        ArrayList<Future> lst = new ArrayList<Future>(totalPage);
        int beginIndex = 0;
        List<DynamicObject> monJournalAll = BankJournalHelper.monFetchAll();
        for (int i = 0; i < totalPage; ++i) {
            int endIndex;
            int n = endIndex = i < totalPage - 1 ? beginIndex + pageSize : totalSize;
            if (totalSize < pageSize) {
                endIndex = totalSize;
            }
            List<DynamicObject> casJournal = journalLst.subList(beginIndex, endIndex);
            Future future = threadPoolJournal.submit(() -> {
                Map<Long, DynamicObject> monJournals = BankJournalHelper.convertor(casJournal);
                DynamicObject[] journals = monJournals.values().toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])journals);
                monJournalAll.addAll(monJournals.values());
                BankJournalHelper.updateBillValue(monJournals, monJournalAll);
                List<AccountBalanceMode> accountLst = BankJournalHelper.journalToAccounts(casJournal);
                calBalance.updataAccountMap(accountLst, calEnum);
                return Boolean.TRUE;
            });
            beginIndex = endIndex;
            lst.add(future);
        }
        for (Future future : lst) {
            try {
                future.get();
            }
            catch (Exception e) {
                logger.info("\u65e5\u8bb0\u8d26\u4f59\u989d\u66f4\u65b0\u9519\u8bef");
            }
        }
    }
}

