/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.mon.business.calbalance.AbstractCalBalance;
import kd.tmc.mon.business.calbalance.DiffCalBalance;
import kd.tmc.mon.business.calbalance.InitCalBalance;
import kd.tmc.mon.business.calbalance.ManulaCalBalance;
import kd.tmc.mon.business.calbalance.SynCalBalance;
import kd.tmc.mon.business.task.BankJournalHelper;
import kd.tmc.mon.business.task.BatchUpdateBankJournal;
import kd.tmc.mon.common.enums.CalculationsEnum;

public class SynDataFacade {
    private static Log logger = LogFactory.getLog(SynDataFacade.class);
    private static AbstractCalBalance cal;

    private SynDataFacade() {
        throw new IllegalStateException("Utility class");
    }

    public static void allSynBanJournalData() {
        SynCalBalance cal = new SynCalBalance();
        try (TXHandle t1 = TX.requiresNew();){
            cal.clearAccountBalance();
            BankJournalHelper.clearBankJournal();
        }
        QFilter filter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
        cal.getCasInitAccount(filter);
        List<Long> ids = BankJournalHelper.casFetch("id", new QFilter[0]);
        SynDataFacade.updateHandle(cal, ids, CalculationsEnum.None);
    }

    public static void synBanJournalData(Long[] orgIds, Long[] accountIds, Date beginDate) {
        if (orgIds == null && accountIds == null && beginDate == null) {
            SynDataFacade.allSynBanJournalData();
            return;
        }
        SynCalBalance cal = new SynCalBalance();
        ArrayList<Long> ids = new ArrayList<Long>();
        try (TXHandle t1 = TX.requiresNew();){
            QFilter fOrgIds = new QFilter("org", "in", (Object)orgIds);
            QFilter fBankAccount = new QFilter("bankaccount", "in", (Object)accountIds);
            QFilter fBeginDate = new QFilter("beginDate", ">=", (Object)beginDate);
            cal.deleteAccountBalance(fOrgIds, fBankAccount, fBeginDate);
            QFilter fAccountbank = new QFilter("accountbank", "in", (Object)accountIds);
            BankJournalHelper.deleteBankJournal(fOrgIds, fAccountbank, fBeginDate);
        }
        SynDataFacade.updateHandle(cal, ids, CalculationsEnum.None);
    }

    public static void addBankJournal(List<DynamicObject> journalLst) {
        cal = new DiffCalBalance();
        BatchUpdateBankJournal.batchAdd(cal, journalLst, CalculationsEnum.Add);
        cal.saveAccounts();
        cal.close();
    }

    public static void deleteBankJournal(List<DynamicObject> journalLst) {
        cal = new DiffCalBalance();
        List<Long> ids = journalLst.stream().map(value -> value.getLong("id")).collect(Collectors.toList());
        SynDataFacade.updateHandle(cal, ids, CalculationsEnum.Sub);
        QFilter[] filters = new QFilter[]{new QFilter("bankjournalid", "in", ids)};
        DeleteServiceHelper.delete((String)"mon_bankjournal", (QFilter[])filters);
    }

    public static void addMonulaBankJournal(List<Long> ids) {
        cal = new ManulaCalBalance();
        QFilter filter = new QFilter("id", "in", ids);
        try (TXHandle tx = TX.requiresNew();){
            SynDataFacade.deleteMonulaBankJournal(ids);
        }
        tx = TX.requiresNew();
        var3_3 = null;
        try {
            List<DynamicObject> casJournaLst = BankJournalHelper.casFetch(filter);
            BatchUpdateBankJournal.batchAdd(cal, casJournaLst, CalculationsEnum.Add);
            cal.saveAccounts();
            cal.close();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public static void deleteMonulaBankJournal(List<Long> ids) {
        cal = new ManulaCalBalance();
        SynDataFacade.updateHandle(cal, ids, CalculationsEnum.Sub);
        QFilter[] filters = new QFilter[]{new QFilter("bankjournalid", "in", ids)};
        DeleteServiceHelper.delete((String)"mon_bankjournal", (QFilter[])filters);
    }

    public static void initAccountBalance(List<Long> ids) {
        InitCalBalance initCal = new InitCalBalance();
        QFilter filter = new QFilter("id", "in", ids).and(new QFilter("isfinishinit", "=", (Object)Boolean.TRUE));
        initCal.getCasInitAccount(filter);
        initCal.saveAccounts();
        initCal.close();
    }

    public static void deinitAccountBalance(List<Long> ids) {
        InitCalBalance initCal = new InitCalBalance();
        QFilter filter = new QFilter("id", "in", ids);
        initCal.getCasDeInitAccount(filter);
        initCal.saveAccounts();
        initCal.close();
    }

    private static void updateHandle(AbstractCalBalance cal, List<Long> ids, CalculationsEnum calEnum) {
        BatchUpdateBankJournal.batchUpdate(cal, ids, calEnum);
        cal.saveAccounts();
        cal.close();
        logger.info("SynDataFacade-updateHandle");
    }
}

