/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.QueryTypeEnum;
import kd.tmc.mon.report.helper.FinReportHelper;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CreditStructureDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String CREDITLIMIT_SEL = "id,org,bank,currency,totalamt,avaramt";
    private static final String ORGNAME = "orgname";
    private static final String TOTALAMT = "totalamt";
    private static final String AVARAMT = "avaramt";
    private static final String ROWID = "rowid";
    private static final String BANK = "bank";
    private static final String ORGIDS = "orgids";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam queryParam) {
        DataSet bizDs;
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.putAll(queryParam.getCustomParam());
        paramMap.put(ORGIDS, this.getQueryOrgIds(queryParam));
        Long statCurrency = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        String statDim = (String)paramMap.get("filter_statdim");
        if ("org".equals(statDim)) {
            bizDs = this.getCreditOrgDs(paramMap);
            if (bizDs.isEmpty()) {
                return MonReportHelper.createEmptyDs();
            }
            String showType = (String)paramMap.get("filter_showttype");
            bizDs = "step".equals(showType) ? this.addOrgViewTree(bizDs, paramMap, queryParam) : bizDs.addFields(new String[]{"sumlevel + '_' + org", "'0'", "1", "'0'"}, new String[]{ROWID, "pid", "level", "isgroupnode"});
        } else if (BANK.equals(statDim)) {
            bizDs = this.getCreditBankDs(paramMap);
            if (bizDs.isEmpty()) {
                return MonReportHelper.createEmptyDs();
            }
            bizDs = bizDs.updateFields(new String[]{ROWID, "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        } else {
            bizDs = this.getCreditCurrencyDs(paramMap);
            if (bizDs.isEmpty()) {
                return MonReportHelper.createEmptyDs();
            }
            bizDs = bizDs.updateFields(new String[]{ROWID, "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        }
        bizDs = this.addSubRowDataSet(bizDs, paramMap);
        bizDs = this.addSumRowDataSet(bizDs, paramMap);
        bizDs = bizDs.updateField("statcurrency", String.valueOf(statCurrency));
        return this.reDealResultDataSet(bizDs, queryParam);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        return this.getCreditBillRate(dataSet);
    }

    private DataSet getCreditCurrencyDs(Map<String, Object> queryMap) {
        DataSet endCreditBillDs;
        DataSet startCreditBillDs = this.getCreditBillDs(queryMap, true);
        if (this.isEmpty(startCreditBillDs, endCreditBillDs = this.getCreditBillDs(queryMap, false))) {
            return MonReportHelper.createEmptyDs();
        }
        DataSet creditBillDs = endCreditBillDs.groupBy(new String[]{"currency"}).sum(TOTALAMT).sum(AVARAMT).finish().select(new String[]{"currency", "totalamt creditendamt", "avaramt surplusendamt"});
        if (startCreditBillDs != null) {
            startCreditBillDs = startCreditBillDs.groupBy(new String[]{"currency"}).sum(TOTALAMT).sum(AVARAMT).finish().select(new String[]{"currency currency1", "totalamt creditstartamt", "avaramt surplusstartamt"});
            creditBillDs = creditBillDs.fullJoin(startCreditBillDs).on("currency", "currency1").select(new String[]{"case when currency=null then currency1 else currency end currency", "creditendamt", "surplusendamt", "creditstartamt-surplusstartamt usestartamt", "creditstartamt", "creditendamt-surplusendamt useendamt", "surplusstartamt"}).finish();
        } else {
            creditBillDs = creditBillDs.addField("0", "creditstartamt").addField("0", "surplusstartamt").addField("0", "usestartamt").addField("0", "useendamt");
        }
        DataSet result = creditBillDs.groupBy(new String[]{"currency"}).sum("creditendamt").sum("surplusendamt").sum("creditstartamt").sum("surplusstartamt").sum("useendamt").sum("usestartamt").finish().addField("currency", ROWID).addField("0", "pid").addField("'0'", "isgroupnode").addField("1", "level").addField("creditendamt-creditstartamt", "creditchangeamt").addField("surplusendamt-surplusstartamt", "surpluschangeamt").addField("useendamt-usestartamt", "usechangeamt");
        Set<Long> currencyIds = CreditStructureDataListPlugin.getFieldVals(result, "currency");
        if (currencyIds.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        DataSet currencyDs = QueryServiceHelper.queryDataSet((String)"curreny", (String)"bd_currency", null, (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)}, null);
        Long statCurrency = (Long)((DynamicObject)queryMap.get("filter_statcurrency")).getPkValue();
        result = currencyDs.leftJoin(result).on("id", ROWID).select(new String[]{"name orgname"}, result.getRowMeta().getFieldNames()).finish().addField(String.valueOf(statCurrency), "statcurrency").addField("0", this.sumField);
        return result;
    }

    private DataSet getCreditBankDs(Map<String, Object> queryMap) {
        DataSet endCreditBillDs;
        DataSet startCreditBillDs = this.getCreditBillDs(queryMap, true);
        if (this.isEmpty(startCreditBillDs, endCreditBillDs = this.getCreditBillDs(queryMap, false))) {
            return MonReportHelper.createEmptyDs();
        }
        DataSet endCreditBankDs = endCreditBillDs.groupBy(new String[]{BANK}).sum(TOTALAMT).sum(AVARAMT).finish();
        DataSet bankTree = this.createBankTree(endCreditBankDs, startCreditBillDs);
        if (startCreditBillDs != null) {
            DataSet startCreditBankDs = startCreditBillDs.groupBy(new String[]{BANK}).sum(TOTALAMT).sum(AVARAMT).finish();
            bankTree = bankTree.leftJoin(startCreditBankDs).on(ROWID, BANK).select(new String[]{ROWID, "name orgname", "pid", "isgroupnode", "level", "totalamt creditstartamt", "avaramt surplusstartamt"}).finish();
        } else {
            bankTree = bankTree.addField("0", "creditstartamt").addField("0", "surplusstartamt").addField("name", ORGNAME);
        }
        bankTree = bankTree.leftJoin(endCreditBankDs).on(ROWID, BANK).select(new String[]{ROWID, ORGNAME, "pid", "isgroupnode", "level", "creditstartamt", "surplusstartamt", "totalamt creditendamt", "avaramt surplusendamt", "0 currency"}).finish();
        return this.updateBankFields(queryMap, bankTree);
    }

    private DataSet getCreditOrgDs(Map<String, Object> queryMap) {
        DataSet endCreditBillDs;
        DataSet startCreditBillDs = this.getCreditBillDs(queryMap, true);
        if (this.isEmpty(startCreditBillDs, endCreditBillDs = this.getCreditBillDs(queryMap, false))) {
            return MonReportHelper.createEmptyDs();
        }
        DataSet endCreditOrgDs = endCreditBillDs.groupBy(new String[]{"org", ORGNAME}).sum(TOTALAMT, "creditendamt").sum(AVARAMT, "surplusendamt").finish();
        if (startCreditBillDs != null) {
            DataSet startCreditOrgDs = startCreditBillDs.groupBy(new String[]{"org"}).sum(TOTALAMT).sum(AVARAMT).finish();
            endCreditOrgDs = endCreditOrgDs.leftJoin(startCreditOrgDs).on("org", "org").select(new String[]{"org", ORGNAME, "totalamt creditstartamt", "avaramt surplusstartamt", "creditendamt", "surplusendamt", "0 currency"}).finish();
        } else {
            endCreditOrgDs = endCreditOrgDs.addField("0", "creditstartamt").addField("0", "surplusstartamt");
        }
        return this.updateAmtFields(queryMap, endCreditOrgDs);
    }

    private DataSet getCreditBillRate(DataSet billDataTreeDs) {
        DataSet[] dataSets = billDataTreeDs.splitByFilter(new String[]{"sumlevel = 2"}, true);
        DataSet totalAmtds = dataSets[0];
        if (totalAmtds.isEmpty()) {
            return dataSets[1];
        }
        Row row = totalAmtds.copy().next();
        billDataTreeDs = dataSets[1].union(totalAmtds).select(new String[]{ROWID, "pid", "isgroupnode", "level", ORGNAME, "creditstartamt", this.converfield("creditstartamt", "creditstartrate", row.getBigDecimal("creditstartamt")), "surplusstartamt", this.converfield("surplusstartamt", "surplusstartrate", row.getBigDecimal("surplusstartamt")), "usestartamt", this.converfield("usestartamt", "usestartrate", row.getBigDecimal("usestartamt")), "creditendamt", this.converfield("creditendamt", "creditendrate", row.getBigDecimal("creditendamt")), "surplusendamt", this.converfield("surplusendamt", "surplusendrate", row.getBigDecimal("surplusendamt")), "useendamt", this.converfield("useendamt", "useendrate", row.getBigDecimal("useendamt")), "creditchangeamt", "surpluschangeamt", "usechangeamt", "case when creditstartamt=0 then 0.00 else creditchangeamt*100/creditstartamt end creditchangerate", "case when surplusstartamt=0 then 0.00 else surpluschangeamt*100/surplusstartamt end surpluschangerate", "case when usestartamt=0 then 0.00 else usechangeamt*100/usestartamt end usechangerate", "statcurrency", "sumlevel", "1 subsort"});
        return this.upateRateFormat(billDataTreeDs);
    }

    private String converfield(String field, String fieldRate, BigDecimal total) {
        if (total == null || "0".equals(total.toPlainString().split("\\.")[0])) {
            return "0.0 " + fieldRate;
        }
        return field + "*100/" + total.toPlainString() + " " + fieldRate;
    }

    private DataSet upateRateFormat(DataSet result) {
        return result.updateField("creditstartrate", "case when creditstartrate=0 then 0.00 else creditstartrate end").updateField("surplusstartrate", "case when creditstartrate=0 then 0.00 else creditstartrate end").updateField("creditendrate", "case when creditendrate=0 then 0.00 else creditendrate end").updateField("surplusendrate", "case when surplusendrate=0 then 0.00 else surplusendrate end").updateField("creditchangerate", "case when creditchangerate=0 then 0.00 else creditchangerate end").updateField("surpluschangerate", "case when surpluschangerate=0 then 0.00 else surpluschangerate end").updateField("usestartrate", "case when usestartrate=0 then 0.00 else usestartrate end").updateField("useendrate", "case when useendrate=0 then 0.00 else useendrate end").updateField("usechangerate", "case when usechangerate=0 then 0.00 else usechangerate end");
    }

    private DataSet updateAmtFields(Map<String, Object> queryMap, DataSet billDataTreeDs) {
        Long statCurrency = (Long)((DynamicObject)queryMap.get("filter_statcurrency")).getPkValue();
        DataSet billDataTreeTotalDs = billDataTreeDs.updateField("creditstartamt", "case when creditstartamt=null then 0 else creditstartamt end").updateField("surplusstartamt", "case when surplusstartamt=null then 0 else surplusstartamt end").updateField("creditendamt", "case when creditendamt=null then 0 else creditendamt end").updateField("surplusendamt", "case when surplusendamt=null then 0 else surplusendamt end").select(new String[]{"org", ORGNAME, "creditstartamt", "surplusstartamt", "creditendamt", "surplusendamt", "creditstartamt-surplusstartamt usestartamt", "creditendamt-surplusendamt useendamt", "0 usechangeamt", statCurrency + "L statcurrency", "0 sumlevel", "creditendamt-creditstartamt creditchangeamt", "surplusendamt-surplusstartamt surpluschangeamt"});
        billDataTreeTotalDs = billDataTreeTotalDs.updateField("usechangeamt", "useendamt-usestartamt");
        return billDataTreeTotalDs;
    }

    private DataSet updateBankFields(Map<String, Object> queryMap, DataSet billDataTreeDs) {
        Long statCurrency = (Long)((DynamicObject)queryMap.get("filter_statcurrency")).getPkValue();
        DataSet billDataTreeTotalDs = billDataTreeDs.updateField("creditstartamt", "case when creditstartamt=null then 0 else creditstartamt end").updateField("surplusstartamt", "case when surplusstartamt=null then 0 else surplusstartamt end").updateField("creditendamt", "case when creditendamt=null then 0 else creditendamt end").updateField("surplusendamt", "case when surplusendamt=null then 0 else surplusendamt end").select(new String[]{ROWID, "pid", "isgroupnode", "level", ORGNAME, "creditstartamt", "surplusstartamt", "creditendamt", "surplusendamt", "creditstartamt-surplusstartamt usestartamt", "creditendamt-surplusendamt useendamt", "0 usechangeamt", statCurrency + "L statcurrency", "0 sumlevel", "creditendamt-creditstartamt creditchangeamt", "surplusendamt-surplusstartamt surpluschangeamt"});
        billDataTreeTotalDs = billDataTreeTotalDs.updateField("usechangeamt", "useendamt-usestartamt");
        billDataTreeTotalDs = this.getSumDataSetByLevel(billDataTreeTotalDs, this.getSumFields(), "orgname,statcurrency");
        return billDataTreeTotalDs;
    }

    private DataSet createBankTree(DataSet startCreditBillDs, DataSet endCreditBillDs) {
        HashSet<Long> bankIds = new HashSet<Long>();
        bankIds.addAll(CreditStructureDataListPlugin.getFieldVals(startCreditBillDs, BANK));
        bankIds.addAll(CreditStructureDataListPlugin.getFieldVals(endCreditBillDs, BANK));
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)"getBdFinorgInfo", (String)"bd_finorginfo", (String)"id, name,case when finorgtype.type='0' then bank_cate else finorgtype end pid, case when finorgtype.type='0' then '2' else '1' end type, '0' isgroupnode, 2 level", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)}, null).addField("id", ROWID);
        HashSet<Long> bankTypes = new HashSet<Long>();
        HashSet<Long> notBankTypes = new HashSet<Long>();
        finOrgDs.copy().forEach(o -> {
            String type = o.getString("type");
            if ("2".equals(type)) {
                bankTypes.add(o.getLong("pid"));
            } else {
                notBankTypes.add(o.getLong("pid"));
            }
        });
        finOrgDs = finOrgDs.select(new String[]{"id", "name", "pid", ROWID, "isgroupnode", "level"});
        DataSet finorgTypeDs = FinReportHelper.getBaseDataDs(notBankTypes, "bd_finorgtype");
        DataSet bankTypeDs = FinReportHelper.getBaseDataDs(bankTypes, "bd_bankcgsetting");
        return finOrgDs.union(finorgTypeDs).union(bankTypeDs);
    }

    private DataSet getCreditBillDs(Map<String, Object> queryMap, boolean isStart) {
        QFilter qfilter = this.getQfilter(queryMap);
        Date startDate = (Date)queryMap.get("filter_startdate");
        if (isStart && EmptyUtil.isEmpty((Object)startDate)) {
            return null;
        }
        Date endDate = (Date)queryMap.get("filter_enddate");
        qfilter.and("startdate", "<=", (Object)(isStart ? startDate : endDate));
        String selFields = this.getSelFields(queryMap);
        DataSet creditOrgDs = QueryServiceHelper.queryDataSet((String)"getCreditOrgDs", (String)"cfm_creditlimit", (String)(selFields + ", org.name orgname"), (QFilter[])new QFilter[]{qfilter}, null);
        DataSet creditReturnDs = this.getCreditReturnDs(creditOrgDs.copy(), isStart ? startDate : endDate);
        selFields = selFields + ",orgname";
        creditOrgDs = creditOrgDs.leftJoin(creditReturnDs).on("id", "creditlimit").select(selFields.split(","), new String[]{"creditlimit", "returnamt"}).finish().updateField(AVARAMT, "case when creditlimit!=null then avaramt+returnamt else avaramt end");
        return this.convertRateUnit(creditOrgDs, queryMap, isStart);
    }

    private DataSet getCreditReturnDs(DataSet creditOrgDs, Date date) {
        Set<Long> creditLimitIds = CreditStructureDataListPlugin.getFieldVals(creditOrgDs, "id");
        Date endDate = DateUtils.getDataFormat((Date)date, (boolean)false);
        DataSet creditReturnDs = QueryServiceHelper.queryDataSet((String)"getCreditReturnDs", (String)"cfm_credituse", (String)"creditlimit,returnentry.e_amount amount", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("creditlimit", "in", creditLimitIds), new QFilter("returnamt", ">", (Object)0), new QFilter("createtime", "<=", (Object)endDate), new QFilter("returnentry.e_returntime", ">", (Object)endDate)}, null).updateField("amount", "-amount");
        DataSet creditUseDs = QueryServiceHelper.queryDataSet((String)"getCreditReturnDs_creditUseDs", (String)"cfm_credituse", (String)"creditlimit,realamt amount", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("creditlimit", "in", creditLimitIds), new QFilter("amount", ">", (Object)0), new QFilter("createtime", ">", (Object)endDate)}, null);
        creditReturnDs = creditReturnDs.union(creditUseDs);
        return creditReturnDs.groupBy(new String[]{"creditlimit"}).sum("amount", "returnamt").finish();
    }

    private String getSelFields(Map<String, Object> queryMap) {
        String selectFields = CREDITLIMIT_SEL;
        String statDim = (String)queryMap.get("filter_statdim");
        if (!selectFields.contains(statDim)) {
            selectFields = selectFields + "," + statDim;
        }
        return selectFields;
    }

    private QFilter getQfilter(Map<String, Object> queryMap) {
        List orgIds = (List)queryMap.get(ORGIDS);
        String bankType = (String)queryMap.get("filter_banktype");
        String bankProp = BANK.equals(bankType) ? "filter_bank" : "filter_bankorg";
        String type = BANK.equals(bankType) ? CreditFinTypeEnum.FINORG.getValue() : CreditFinTypeEnum.ORG.getValue();
        DynamicObjectCollection banks = (DynamicObjectCollection)queryMap.get(bankProp);
        DynamicObjectCollection currencys = (DynamicObjectCollection)queryMap.get("filter_currency");
        boolean isClose = (Boolean)queryMap.get("filter_close");
        QFilter filter = new QFilter("org", "in", (Object)orgIds).and("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("banktype", "=", (Object)type);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)banks)) {
            Set bankId = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            filter.and(BANK, "in", bankId);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys)) {
            Set currencyIds = currencys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            filter.and("currency", "in", currencyIds);
        }
        if (!isClose) {
            filter.and("isclose", "=", (Object)"0");
        }
        return filter;
    }

    private DataSet convertRateUnit(DataSet ds, Map<String, Object> queryMap, boolean isStart) {
        String unit = MonReportHelper.getUnit((String)queryMap.get("filter_currencyunit"));
        Date startDate = (Date)queryMap.get("filter_startdate");
        Date endDate = (Date)queryMap.get("filter_enddate");
        String org = (String)queryMap.get("org");
        Long statCurrency = (Long)((DynamicObject)queryMap.get("filter_statcurrency")).getPkValue();
        ArrayList currencyIdList = new ArrayList(10);
        ds.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
        String queryWay = (String)queryMap.get("filter_queryway");
        DataSet rateDs = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)statCurrency, (long)Long.parseLong(org), (Date)(isStart ? startDate : endDate), (!QueryTypeEnum.isOrgview((String)queryWay) ? 1 : 0) != 0);
        return ds.leftJoin(rateDs).on("currency", "tarcurrency").select(ds.getRowMeta().getFieldNames(), new String[]{"rate"}).finish().updateField(TOTALAMT, String.format("totalamt*rate/%s", unit)).updateField(AVARAMT, String.format("avaramt*rate/%s", unit));
    }

    private List<String> getSumFields() {
        ArrayList<String> sumFields = new ArrayList<String>();
        sumFields.add("creditstartamt");
        sumFields.add("creditendamt");
        sumFields.add("surplusstartamt");
        sumFields.add("surplusendamt");
        sumFields.add("creditchangeamt");
        sumFields.add("surpluschangeamt");
        sumFields.add("usestartamt");
        sumFields.add("useendamt");
        sumFields.add("usechangeamt");
        return sumFields;
    }

    public static Set<Long> getFieldVals(DataSet ds, String field) {
        HashSet<Long> fieldVal = new HashSet<Long>();
        if (ds == null || ds.isEmpty()) {
            return fieldVal;
        }
        ds.copy().forEach(o -> fieldVal.add(o.getLong(field)));
        return fieldVal;
    }

    private boolean isEmpty(DataSet startCreditBillDs, DataSet endCreditBillDs) {
        return !(startCreditBillDs != null && !startCreditBillDs.isEmpty() || endCreditBillDs != null && !endCreditBillDs.isEmpty());
    }

    protected boolean isNeedOrgTree() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        return "org".equals(statdim);
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    protected List<String> orinalAmountField() {
        return Collections.emptyList();
    }

    public List<String> sumAmountFields() {
        return this.getSumFields();
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)ORGNAME);
    }
}

