/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.DebtsBizTypeEnum;
import kd.tmc.mon.report.data.DebtsdueDataBuilder;
import kd.tmc.mon.report.helper.DebtsReportHelper;

public class DebtsdueSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private List<String> dynamicColList = new ArrayList<String>(10);
    private Map<String, String> billtypeNameToKeyMap = new HashMap<String, String>(10);
    private Map<String, String> billtypeKeyToNameMap = new HashMap<String, String>(10);
    private List<String> cdmDynCols = new ArrayList<String>(10);
    private List<String> lcDynCols = new ArrayList<String>(10);
    private List<String> cfmRepayDynCols = new ArrayList<String>(10);
    private List<String> bondRepayDynCols = new ArrayList<String>(10);
    private List<String> cfmInstDynCols = new ArrayList<String>(10);
    private List<String> bondInstDynCols = new ArrayList<String>(10);
    private Boolean isCdmMerge = Boolean.FALSE;
    private Boolean isLcMerge = Boolean.FALSE;
    private Boolean isCfmRepayMerge = Boolean.FALSE;
    private Boolean isCfmInstMerge = Boolean.FALSE;
    private Boolean isBondRepayMerge = Boolean.FALSE;
    private Boolean isBondInstMerge = Boolean.FALSE;
    private boolean isListCal = false;
    private List<String> extendCols = new ArrayList<String>(10);
    private List<String> dynRow2ColGroupFileds = Arrays.asList("duedate", "bank", "org", "currency");
    private static List<String> sumAmtFields;
    private static List<String> initTotalFields;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.addExtendedColumnKeys(queryParam);
        DataSet data = this.getDataSet(paramMap);
        if (null == data || EmptyUtil.isEmpty((Object)data)) {
            RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"duedate").createDataSetBuilder(rowMeta).build();
        }
        this.isListCal = true;
        ArrayList<String> sumGroupCols = new ArrayList<String>(this.dynRow2ColGroupFileds);
        sumGroupCols.add("countbilltype");
        DataSet resultDataSet = data.groupBy(sumGroupCols.toArray(new String[0])).sum("count").finish();
        resultDataSet = this.dealRow2Col(resultDataSet);
        resultDataSet = this.dealExchgRateDataSet(resultDataSet, paramMap);
        resultDataSet = this.dealIsMergeData(resultDataSet, paramMap);
        return this.dealSubTotalAndTotal(resultDataSet);
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        bizDs = bizDs.updateField("pid", "cast(pid as String)");
        DataSet initTotalSet = this.addAllTotalDataSet(bizDs.copy().filter("sumlevel = 0"), initTotalFields, Collections.singletonList("currency"), "tol_duedate");
        initTotalSet = initTotalSet.updateFields(new String[]{"rowid", "pid", "sumlevel"}, new String[]{"cast(rowid as String)", "cast(pid as String)", "1"});
        DataSet totalDateSet = this.addAllTotalDataSet(bizDs.copy().filter("sumlevel = 0"), sumAmtFields, Collections.singletonList("statcurrency"), "tol_duedate");
        totalDateSet = totalDateSet.updateFields(new String[]{"rowid", "pid", "sumlevel"}, new String[]{"cast(rowid as String)", "cast(pid as String)", "1"});
        return bizDs.union(initTotalSet).union(totalDateSet);
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    public List<String> subAmountFields() {
        return sumAmtFields;
    }

    public String subNameField() {
        return "tol_duedate";
    }

    public List<String> groupFields() {
        return Collections.singletonList("duedate");
    }

    public List<String> orderByFields() {
        return Collections.singletonList("duedate");
    }

    private DataSet dealRow2Col(DataSet resultDataSet) {
        DataSet groupNameDs = resultDataSet.copy().groupBy(new String[]{"countbilltype"}).finish().select("countbilltype");
        ArrayList<String> dynColList = new ArrayList<String>(100);
        for (Row groupNameD : groupNameDs) {
            dynColList.add(groupNameD.getString("countbilltype"));
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select ").append(String.join((CharSequence)",", this.dynRow2ColGroupFileds)).append(" , ").append(this.buildSqlStr(dynColList, "countbilltype", "count")).append(" group by ").append(String.join((CharSequence)",", this.dynRow2ColGroupFileds)).append(" order by duedate");
        return resultDataSet.executeSql(sqlSb.toString());
    }

    private String buildSqlStr(List<String> dynColList, String baseStr, String amtStr) {
        StringBuilder sb = new StringBuilder();
        for (String dynCol : dynColList) {
            sb.append("sum(case when ").append(baseStr).append("='").append(dynCol).append("' then ").append(amtStr).append(" else 0 end) as ").append(dynCol).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        if (!this.isListCal) {
            return columns;
        }
        this.putColAndName2Cache();
        for (AbstractReportColumn column : columns) {
            this.setColIsHide((ReportColumn)column);
        }
        for (String colStr : this.dynamicColList) {
            ReportColumn cols = new ReportColumn();
            cols.setFieldKey(colStr);
            cols.setFieldType("amount");
            cols.setZeroShow(false);
            this.setCurreny(cols, colStr);
            this.setHyperLink(cols, colStr);
            this.setCaption(cols, colStr);
            columns.add((AbstractReportColumn)cols);
        }
        return columns;
    }

    private DataSet getDataSet(Map<String, Object> paramMap) {
        DebtsdueDataBuilder debtsInstBean;
        DataSet repayDataSet;
        DataSet dataSet;
        DebtsdueDataBuilder debtsBean;
        String bizType = (String)paramMap.get("filter_biztype");
        ArrayList<DataSet> needUnionDataSets = new ArrayList<DataSet>();
        if (bizType.contains(DebtsBizTypeEnum.CDM.getCode())) {
            debtsBean = DebtsdueDataBuilder.getObjByDebtsType(DebtsBizTypeEnum.CDM.getCode());
            QFilter cdmFilter = this.getParmComonFilter(paramMap, debtsBean);
            String cdmFields = "TO_CHAR(draftbillexpiredate,'yyyy-MM-dd') as duedate,draweraccount.bank as bank,company as org,currency as currency,draftbilltype.name as countbilltype,amount as count";
            DataSet cdmSrcDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)(cdmFields = this.addNewExtField2Select(cdmFields, debtsBean)), (QFilter[])cdmFilter.toArray(), null);
            if (!cdmSrcDataSet.isEmpty()) {
                dataSet = this.nameTransSeri(cdmSrcDataSet, DebtsBizTypeEnum.CDM.getCode());
                needUnionDataSets.add(dataSet);
            }
        }
        if (bizType.contains(DebtsBizTypeEnum.LC.getCode())) {
            debtsBean = DebtsdueDataBuilder.getObjByDebtsType(DebtsBizTypeEnum.LC.getCode());
            QFilter lcFilter = this.getParmComonFilter(paramMap, debtsBean);
            String lcFields = "TO_CHAR(endpaydate,'yyyy-MM-dd') as duedate,lettercredit.bank as bank,org,arrivalcurrency as currency,credittype.name as countbilltype,todoamount as count";
            DataSet lcSrcDataSet = QueryServiceHelper.queryDataSet((String)"lc_arrival", (String)"lc_arrival", (String)(lcFields = this.addNewExtField2Select(lcFields, debtsBean)), (QFilter[])lcFilter.toArray(), null);
            if (!lcSrcDataSet.isEmpty()) {
                dataSet = this.nameTransSeri(lcSrcDataSet, DebtsBizTypeEnum.LC.getCode());
                ORM.create().toPlainDynamicObjectCollection(dataSet.copy());
                needUnionDataSets.add(dataSet);
            }
        }
        if (bizType.contains(DebtsBizTypeEnum.CFM.getCode())) {
            debtsBean = DebtsdueDataBuilder.getObjByDebtsType(DebtsBizTypeEnum.CFMREPAY.getCode());
            QFilter cfmRepayFilter = this.getParmComonFilter(paramMap, debtsBean);
            String cfmRepayFileds = "TO_CHAR(repayplan_entry.exrepaymentdate,'yyyy-MM-dd') as duedate,creditor as bank,org,currency,finproduct.name as countbilltype,repayplan_entry.enotrepayamount as count";
            DataSet cfmRepayScrDataSet = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_repay", (String)"cfm_loanbill", (String)(cfmRepayFileds = this.addNewExtField2Select(cfmRepayFileds, debtsBean)), (QFilter[])cfmRepayFilter.toArray(), null);
            if (!cfmRepayScrDataSet.isEmpty()) {
                repayDataSet = this.nameTransSeri(cfmRepayScrDataSet, DebtsBizTypeEnum.CFMREPAY.getCode());
                ORM.create().toPlainDynamicObjectCollection(repayDataSet.copy());
                needUnionDataSets.add(repayDataSet);
            }
            debtsInstBean = DebtsdueDataBuilder.getObjByDebtsType(DebtsBizTypeEnum.CFMINST.getCode());
            QFilter cfmInstFilter = this.getParmComonFilter(paramMap, debtsInstBean);
            String cfmInstFileds = "TO_CHAR(interest_entry.interesdate,'yyyy-MM-dd') as duedate,creditor as bank,org,currency,finproduct.name as countbilltype,interest_entry.interestcalamount as count";
            DataSet cfmInstScrDataSet = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_inst", (String)"cfm_loanbill", (String)(cfmInstFileds = this.addNewExtField2Select(cfmInstFileds, debtsBean)), (QFilter[])cfmInstFilter.toArray(), null);
            if (!cfmInstScrDataSet.isEmpty()) {
                DataSet instDataSet = this.nameTransSeri(cfmInstScrDataSet, DebtsBizTypeEnum.CFMINST.getCode());
                ORM.create().toPlainDynamicObjectCollection(instDataSet.copy());
                needUnionDataSets.add(instDataSet);
            }
        }
        if (bizType.contains(DebtsBizTypeEnum.BOND.getCode())) {
            debtsBean = DebtsdueDataBuilder.getObjByDebtsType(DebtsBizTypeEnum.BONDREPAY.getCode());
            QFilter bondRepayFilter = this.getParmComonFilter(paramMap, debtsBean);
            String bondRepayFileds = "TO_CHAR(repayplan_entry.exrepaymentdate,'yyyy-MM-dd') as duedate,accountbank.bank as bank,org,currency,finproduct.name as countbilltype,repayplan_entry.enotrepayamount as count";
            DataSet bondRepayScrDataSet = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_bond_repay", (String)"cfm_loanbill_bond", (String)(bondRepayFileds = this.addNewExtField2Select(bondRepayFileds, debtsBean)), (QFilter[])bondRepayFilter.toArray(), null);
            if (!bondRepayScrDataSet.isEmpty()) {
                repayDataSet = this.nameTransSeri(bondRepayScrDataSet, DebtsBizTypeEnum.BONDREPAY.getCode());
                ORM.create().toPlainDynamicObjectCollection(repayDataSet.copy());
                needUnionDataSets.add(repayDataSet);
            }
            debtsInstBean = DebtsdueDataBuilder.getObjByDebtsType(DebtsBizTypeEnum.BONDINST.getCode());
            QFilter bondInstFilter = this.getParmComonFilter(paramMap, debtsInstBean);
            String bondInstFileds = "TO_CHAR(interest_entry.interesdate,'yyyy-MM-dd') as duedate,accountbank.bank as bank,org,currency,finproduct.name as countbilltype,interest_entry.interestcalamount as count";
            DataSet bondInstScrDataSet = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_bond_inst", (String)"cfm_loanbill_bond", (String)(bondInstFileds = this.addNewExtField2Select(bondInstFileds, debtsBean)), (QFilter[])bondInstFilter.toArray(), null);
            if (!bondInstScrDataSet.isEmpty()) {
                DataSet dataSet2 = this.nameTransSeri(bondInstScrDataSet, DebtsBizTypeEnum.BONDINST.getCode());
                ORM.create().toPlainDynamicObjectCollection(dataSet2.copy());
                needUnionDataSets.add(dataSet2);
            }
        }
        DataSet unionDataSet = null;
        if (!needUnionDataSets.isEmpty()) {
            unionDataSet = (DataSet)needUnionDataSets.get(0);
            for (int i = 1; i < needUnionDataSets.size(); ++i) {
                unionDataSet = unionDataSet.union((DataSet)needUnionDataSets.get(i));
            }
        }
        return unionDataSet;
    }

    private QFilter getParmComonFilter(Map<String, Object> paramMap, DebtsdueDataBuilder debtsObj) {
        QFilter comFilter = new QFilter("billstatus", "=", (Object)"C");
        comFilter.and(this.transDateFilter(paramMap, debtsObj.getDuedate()));
        DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get("filter_bank");
        if (banks != null && banks.size() > 0) {
            List creditorNames = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            comFilter.and(debtsObj.getBank(), "in", creditorNames);
        } else {
            comFilter.and(debtsObj.getBank(), ">", (Object)0);
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)paramMap.get("filter_org");
        if (orgs != null && orgs.size() > 0) {
            List orgIds = orgs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            comFilter.and(debtsObj.getOrg(), "in", orgIds);
        } else {
            List authorizedBankOrgIds = (List)paramMap.get("AuthorizedBankOrg");
            comFilter.and(debtsObj.getOrg(), "in", (Object)authorizedBankOrgIds);
        }
        comFilter.and(debtsObj.getCurrency(), ">", (Object)0);
        DebtsReportHelper.setBizBillFilter(comFilter, debtsObj, DebtsdueSumDataListPlugin.getBillGroupTypes(paramMap), false);
        return comFilter;
    }

    private static Map<String, DynamicObjectCollection> getBillGroupTypes(Map<String, Object> paramMap) {
        HashMap<String, DynamicObjectCollection> typedatas = new HashMap<String, DynamicObjectCollection>();
        typedatas.put("cdm", (DynamicObjectCollection)paramMap.get("filter_cdmbilltype"));
        typedatas.put("lc", (DynamicObjectCollection)paramMap.get("filter_lcbilltype"));
        typedatas.put("cfm", (DynamicObjectCollection)paramMap.get("filter_financingvarieties"));
        typedatas.put("bond", (DynamicObjectCollection)paramMap.get("filter_bondvarieties"));
        return typedatas;
    }

    private QFilter transDateFilter(Map<String, Object> paramMap, String dateField) {
        QFilter dateFilter;
        String bizDateRanges = (String)paramMap.get("filter_bizdateranges");
        if ("thisday".equals(bizDateRanges)) {
            dateFilter = new QFilter(dateField, ">=", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)true)).and(dateField, "<=", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)false));
        } else {
            Date bizDateStartDate = (Date)paramMap.get("bizdateranges_startdate");
            dateFilter = new QFilter(dateField, ">=", (Object)bizDateStartDate);
            Date bizDateEndDate = (Date)paramMap.get("bizdateranges_enddate");
            if (EmptyUtil.isNoEmpty((Object)bizDateEndDate)) {
                dateFilter.and(new QFilter(dateField, "<=", (Object)DateUtils.getDataFormat((Date)bizDateEndDate, (boolean)false)));
            }
        }
        return dateFilter;
    }

    private DataSet dealExchgRateDataSet(DataSet sourceDataSet, Map<String, Object> paramMap) {
        DynamicObject transCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        Date startDate = (Date)paramMap.get("bizdateranges_startdate");
        long loginOrgId = (Long)paramMap.get("filter_loginorg");
        String[] fieldNames = sourceDataSet.copy().getRowMeta().getFieldNames();
        ArrayList currencyIdList = new ArrayList(10);
        sourceDataSet.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
        DataSet exchRateDS = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)transCurrency.getLong("id"), (long)loginOrgId, (Date)startDate, (boolean)true);
        return sourceDataSet.join(exchRateDS).on("currency", "tarcurrency").select(fieldNames, new String[]{"rate"}).finish();
    }

    private DataSet dealSubTotalAndTotal(DataSet afterMergeData) {
        sumAmtFields = new ArrayList<String>(10);
        this.addSubTotalCal(sumAmtFields, this.cdmDynCols, this.isCdmMerge, "transcdmamt");
        this.addSubTotalCal(sumAmtFields, this.lcDynCols, this.isLcMerge, "translcamt");
        this.addSubTotalCal(sumAmtFields, this.cfmRepayDynCols, this.isCfmRepayMerge, "transcfmrepayamt");
        this.addSubTotalCal(sumAmtFields, this.bondRepayDynCols, this.isBondRepayMerge, "transbondrepayamt");
        this.addSubTotalCal(sumAmtFields, this.cfmInstDynCols, this.isCfmInstMerge, "transcfminstamt");
        this.addSubTotalCal(sumAmtFields, this.bondInstDynCols, this.isBondInstMerge, "transbondinstamt");
        initTotalFields = new ArrayList<String>(sumAmtFields.size());
        for (String sumAmtField : sumAmtFields) {
            if (sumAmtField.endsWith("_trans")) {
                initTotalFields.add(sumAmtField.replace("_trans", ""));
                continue;
            }
            if (sumAmtField.startsWith("trans")) {
                initTotalFields.add(sumAmtField.replace("trans", ""));
                continue;
            }
            initTotalFields.add(sumAmtField);
        }
        DataSet totalDataSet = afterMergeData.addField(String.join((CharSequence)"+", sumAmtFields), "transtotalamt").addField(String.join((CharSequence)"+", initTotalFields), "inittotalamt");
        sumAmtFields.add("transtotalamt");
        initTotalFields.add("inittotalamt");
        return totalDataSet;
    }

    private void addSubTotalCal(List<String> sumAmtFields, List<String> dynCols, boolean isMerge, String subTolFiled) {
        if (EmptyUtil.isNoEmpty(dynCols)) {
            if (isMerge) {
                sumAmtFields.add(subTolFiled);
            } else {
                sumAmtFields.addAll(dynCols.stream().map(o -> o + "_trans").collect(Collectors.toList()));
            }
        }
    }

    private DataSet dealIsMergeData(DataSet transDataSet, Map<String, Object> paramMap) {
        String[] fieldNames;
        this.isCdmMerge = (Boolean)paramMap.get("filter_iscdmmerge");
        this.isLcMerge = (Boolean)paramMap.get("filter_islcmerge");
        this.isCfmRepayMerge = (Boolean)paramMap.get("filter_iscfmrepaymerge");
        this.isCfmInstMerge = (Boolean)paramMap.get("filter_iscfminstmerge");
        this.isBondRepayMerge = (Boolean)paramMap.get("filter_isbondrepaymerge");
        this.isBondInstMerge = (Boolean)paramMap.get("filter_isbondinstmerge");
        RowMeta rowMetas = transDataSet.copy().getRowMeta();
        for (String colName : fieldNames = rowMetas.getFieldNames()) {
            if (colName.endsWith("_cdm")) {
                this.cdmDynCols.add(colName);
                continue;
            }
            if (colName.endsWith("_lc")) {
                this.lcDynCols.add(colName);
                continue;
            }
            if (colName.endsWith("_cfmrepay")) {
                this.cfmRepayDynCols.add(colName);
                continue;
            }
            if (colName.endsWith("_cfminst")) {
                this.cfmInstDynCols.add(colName);
                continue;
            }
            if (colName.endsWith("_bondrepay")) {
                this.bondRepayDynCols.add(colName);
                continue;
            }
            if (!colName.endsWith("_bondinst")) continue;
            this.bondInstDynCols.add(colName);
        }
        String unit = DebtsReportHelper.getUnit((String)paramMap.get("filter_currencyunit"));
        DataSet cdmDataSet = this.addDynCal2Play(transDataSet, this.isCdmMerge, this.cdmDynCols, "cdmamt", unit);
        DataSet lcDataSet = this.addDynCal2Play(cdmDataSet, this.isLcMerge, this.lcDynCols, "lcamt", unit);
        DataSet cfmrepayDataSet = this.addDynCal2Play(lcDataSet, this.isCfmRepayMerge, this.cfmRepayDynCols, "cfmrepayamt", unit);
        DataSet bondRepayDataSet = this.addDynCal2Play(cfmrepayDataSet, this.isBondRepayMerge, this.bondRepayDynCols, "bondrepayamt", unit);
        DataSet cfmInstDataSet = this.addDynCal2Play(bondRepayDataSet, this.isCfmInstMerge, this.cfmInstDynCols, "cfminstamt", unit);
        DataSet bondinstDataSet = this.addDynCal2Play(cfmInstDataSet, this.isBondInstMerge, this.bondInstDynCols, "bondinstamt", unit);
        return bondinstDataSet.addField("duedate", "tol_duedate");
    }

    private DataSet addDynCal2Play(DataSet transDataSet, boolean isNeedMerge, List<String> dynCols, String showField, String unit) {
        if (EmptyUtil.isNoEmpty(dynCols)) {
            if (isNeedMerge) {
                String colExpr = this.genDynSumSqlAndUnit(dynCols, unit);
                return transDataSet.addField(colExpr, showField).addField(String.format("(%s)*rate", colExpr), "trans" + showField);
            }
            for (String dynCol : dynCols) {
                this.dynamicColList.add(dynCol);
                this.dynamicColList.add(dynCol + "_trans");
                transDataSet = transDataSet.updateField(dynCol, String.format("%s/%s", dynCol, unit));
                transDataSet = transDataSet.addField(String.format("%s*rate", dynCol), dynCol + "_trans");
            }
        }
        return transDataSet;
    }

    private String genDynSumSqlAndUnit(List<String> dynCols, String unit) {
        StringBuilder sumb = new StringBuilder();
        for (String dynCol : dynCols) {
            sumb.append(dynCol).append(String.format("/%s", unit)).append('+');
        }
        return sumb.substring(0, sumb.length() - 1);
    }

    private DataSet nameTransSeri(DataSet union, String subfix) {
        if (union.isEmpty()) {
            return union;
        }
        for (Row row : union.copy()) {
            String billtype = "p_" + row.getString("countbilltype");
            String billtypeHash = DebtsdueSumDataListPlugin.getMd5(billtype) + "_" + subfix;
            this.billtypeNameToKeyMap.put(billtype, billtypeHash);
            this.billtypeKeyToNameMap.put(billtypeHash, billtype);
        }
        final RowMeta rowMetas = union.getRowMeta();
        union = union.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("countbilltype".equals(fieldName)) {
                        rowInfo.add(DebtsdueSumDataListPlugin.this.billtypeNameToKeyMap.get("p_" + row.get("countbilltype")));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
        return union;
    }

    private static String getMd5(String value) {
        try {
            byte[] valueBytes = value == null ? new byte[]{} : value.getBytes(StandardCharsets.UTF_8);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(valueBytes);
            byte[] s = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : s) {
                sb.append(String.format("%02X", b));
            }
            return sb.toString();
        }
        catch (Exception var3) {
            return "";
        }
    }

    private void putColAndName2Cache() {
        if (EmptyUtil.isNoEmpty(this.dynamicColList) && EmptyUtil.isNoEmpty(this.billtypeKeyToNameMap)) {
            IAppCache iAppCache = TmcAppCache.get((String)"mon", (String)"mon_debtsdue", (String)"countbilltype");
            iAppCache.put("mon_debtsdue_countbilltype", this.billtypeKeyToNameMap);
        }
    }

    private void setColIsHide(ReportColumn column) {
        String fieldKey;
        switch (fieldKey = column.getFieldKey()) {
            case "cdmamt": 
            case "transcdmamt": {
                if (this.isCdmMerge.booleanValue() && !EmptyUtil.isEmpty(this.cdmDynCols)) break;
                column.setHide(true);
                break;
            }
            case "lcamt": 
            case "translcamt": {
                if (this.isLcMerge.booleanValue() && !EmptyUtil.isEmpty(this.lcDynCols)) break;
                column.setHide(true);
                break;
            }
            case "cfmrepayamt": 
            case "transcfmrepayamt": {
                if (this.isCfmRepayMerge.booleanValue() && !EmptyUtil.isEmpty(this.cfmRepayDynCols)) break;
                column.setHide(true);
                break;
            }
            case "bondrepayamt": 
            case "transbondrepayamt": {
                if (this.isBondRepayMerge.booleanValue() && !EmptyUtil.isEmpty(this.bondRepayDynCols)) break;
                column.setHide(true);
                break;
            }
            case "cfminstamt": 
            case "transcfminstamt": {
                if (this.isCfmInstMerge.booleanValue() && !EmptyUtil.isEmpty(this.cfmInstDynCols)) break;
                column.setHide(true);
                break;
            }
            case "bondinstamt": 
            case "transbondinstamt": {
                if (this.isBondInstMerge.booleanValue() && !EmptyUtil.isEmpty(this.bondInstDynCols)) break;
                column.setHide(true);
            }
        }
    }

    private void setCurreny(ReportColumn cols, String col) {
        if (col.endsWith("_trans")) {
            cols.setCurrencyField("statcurrency");
        } else {
            cols.setCurrencyField("currency");
        }
    }

    private void setHyperLink(ReportColumn cols, String col) {
        if (!col.endsWith("_trans")) {
            cols.setHyperlink(true);
        }
    }

    private void setCaption(ReportColumn cols, String col) {
        if (col.endsWith("_trans")) {
            String resStr = col.substring(0, col.length() - 6);
            String colName = this.billtypeKeyToNameMap.get(resStr);
            if (col.endsWith("inst_trans")) {
                cols.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s(\u6298\u7b97\u5e01)", (String)"DebtsdueSumDataListPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), new LocaleString(colName.substring(2)))));
            } else {
                cols.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s(\u6298\u7b97\u5e01)", (String)"DebtsdueSumDataListPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), new LocaleString(colName.substring(2)))));
            }
        } else {
            String colName = this.billtypeKeyToNameMap.get(col);
            if (col.endsWith("inst")) {
                cols.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s(\u5229\u606f\u539f\u5e01)", (String)"DebtsdueSumDataListPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]), new LocaleString(colName.substring(2)))));
            } else {
                cols.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s(\u539f\u5e01)", (String)"DebtsdueSumDataListPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]), new LocaleString(colName.substring(2)))));
            }
        }
    }

    private void addExtendedColumnKeys(ReportQueryParam param) {
        String newGroupCols = (String)param.getCustomParam().get("newgroup_columnkeys");
        String oldFiledStrs = String.join((CharSequence)",", this.dynRow2ColGroupFileds);
        if (EmptyUtil.isNoEmpty((String)newGroupCols) && !newGroupCols.equals(oldFiledStrs)) {
            for (String newFiled : newGroupCols.split(",")) {
                if (this.dynRow2ColGroupFileds.contains(newFiled)) continue;
                this.extendCols.add(newFiled);
            }
            this.dynRow2ColGroupFileds = Arrays.stream(newGroupCols.split(",")).collect(Collectors.toList());
        }
    }

    private String addNewExtField2Select(String selectFileds, DebtsdueDataBuilder debtsBean) {
        if (EmptyUtil.isNoEmpty(this.extendCols)) {
            StringBuilder sb = new StringBuilder(selectFileds);
            for (String extendCol : this.extendCols) {
                String subExtendCol = extendCol.substring(0, extendCol.length() - 3);
                if (!this.validColIsExist(subExtendCol, debtsBean)) continue;
                sb.append(',').append(subExtendCol).append(" as ").append(extendCol);
            }
            return sb.toString();
        }
        return selectFileds;
    }

    private boolean validColIsExist(String subExtendCol, DebtsdueDataBuilder debtsBean) {
        DynamicObject bizBill = TmcDataServiceHelper.newDynamicObject((String)debtsBean.getEntiy());
        boolean isExist = bizBill.getDynamicObjectType().getProperties().containsKey((Object)subExtendCol);
        if (!isExist) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u88ab\u7ec8\u6b62,\u5b9e\u4f53[%1$s]\u4e0d\u5b58\u5728%2$s\u6807\u8bc6", (String)"DebtsdueDataBuilder_04", (String)"tmc-lc-report", (Object[])new Object[0]), debtsBean.getEntiyName(), subExtendCol + "_ek"));
        }
        return isExist;
    }
}

