/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.report.helper.MonReportHelper;
import kd.tmc.mon.report.helper.costcalbean.LoanCalResult;
import kd.tmc.mon.report.helper.costcalbean.LoanInfo;
import kd.tmc.mon.report.helper.costcalbean.RepayInfo;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FinCostCalDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(FinCostCalDataListPlugin.class);
    private static final String LOANTYPE_CFM = "cfm";
    private static final String LOANTYPE_SL = "sl";
    private static final String LOANTYPE_BOND = "bond";
    private static final String LOANTYPE_BDIM = "bdim";
    private static final String LOANTYPE_FL = "fl";
    private String statdim;
    private static final String LONA_FIELDS = "id,org,org.name orgname,currency,currency.name currencyname,startloanrate as loanrate,bizdate,loantype,creditortype,id entryid,case when creditor >0  then creditor else id end as creditor,textcreditor,drawamount, 1 radio,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate,cleardate";
    private static final String SL_FIELDS = "id,org,org.name orgname,currency,currency.name currencyname,startloanrate as loanrate,bizdate,loantype,creditortype,banksyndicate_entry.id entryid,case when banksyndicate_entry.e_bank >0  then banksyndicate_entry.e_bank else banksyndicate_entry.id end as creditor,banksyndicate_entry.e_bank.name textcreditor,banksyndicate_entry.e_shareamount drawamount,banksyndicate_entry.e_shareamount/drawamount radio,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate,cleardate";
    private static final String BOND_FIELDS = "id,org,org.name orgname,currency,currency.name currencyname,startloanrate as loanrate,bizdate,loantype,investor_entry.e_investortype as creditortype,investor_entry.id entryid,case when investor_entry.e_investorid >0 then investor_entry.e_investorid else investor_entry.id end as creditor,investor_entry.e_investorname textcreditor,investor_entry.e_investamount drawamount,investor_entry.e_investamount/drawamount radio,case when renewalexpiredate is null then expiredate else renewalexpiredate end expiredate,cleardate";
    private String[] groupFields;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.statdim = (String)paramMap.get("filter_statdim");
        DataSet dataSet = this.getBillDataSet(paramMap);
        if (null == dataSet || dataSet.isEmpty()) {
            RowMeta rowMeta = new RowMeta(new String[]{"orgname"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"cfm_loanbill_repay_cal").createDataSetBuilder(rowMeta).build();
        }
        return this.groupByStatdimAndCalSum(dataSet);
    }

    protected DataSet addExchangeRateAndCurrencyUnit(DataSet bizDataSet, Map<String, Object> paramMap) {
        DataSet dataSet = super.addExchangeRateAndCurrencyUnit(bizDataSet, paramMap);
        String showType = (String)paramMap.get("filter_showttype");
        if ("tile".equals(showType)) {
            String[] groupFields = this.groupFields;
            if (!"currency".equals(this.statdim)) {
                groupFields = (String[])Arrays.stream(this.groupFields).filter(e -> !"currency".equals(e)).toArray(String[]::new);
            }
            dataSet = dataSet.groupBy(groupFields).sum("daybalance_report").sum("totalinstamt_report").sum("feeamt_report").sum("compamt_report").finish();
        }
        return dataSet;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        String statdim = (String)paramMap.get("filter_statdim");
        if ("textcreditor".equals(statdim)) {
            return bizDs;
        }
        return super.addSumRowDataSet(bizDs, paramMap);
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        String statdim = (String)paramMap.get("filter_statdim");
        if ("textcreditor".equals(statdim)) {
            return bizDs;
        }
        return super.addSubRowDataSet(bizDs, paramMap);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (EmptyUtil.isEmpty((Object)dataSet) || dataSet.isEmpty()) {
            return dataSet;
        }
        Map paramMap = this.transQueryParam(queryParam);
        if ("textcreditor".equals(this.statdim)) {
            dataSet = this.dealCreditDataSet(dataSet.removeFields(new String[]{"sumlevel", "statcurrency", "rowid", "pid", "level"}), paramMap);
        }
        dataSet = this.calOtherAveInfo(dataSet, paramMap);
        List<String> excludeProps = Arrays.asList("daybalance_report", "totalinstamt_report", "statcurrency", "feeamt_report", "compamt_report");
        List<String> fieldList = Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(e -> !excludeProps.contains(e)).collect(Collectors.toList());
        fieldList.add("daybalance_report as daybalance");
        fieldList.add("totalinstamt_report as totalinstamt");
        fieldList.add("feeamt_report as feeamt");
        fieldList.add("compamt_report as compamt");
        fieldList.add("statcurrency as tarcurrency");
        dataSet = dataSet.select(fieldList.toArray(new String[0])).addField("case when daybalance is null or daybalance=0 then 0 else compamt*100*360/(days*daybalance) end", "comprate");
        return dataSet;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("daybalance", "totalinstamt", "feeamt", "compamt");
    }

    protected boolean isNeedOrgTree() {
        return "orgname".equals(this.statdim);
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("daybalance_report", "totalinstamt_report", "feeamt_report", "compamt_report");
    }

    public String sumNameField() {
        String sumNameField = "";
        switch (this.statdim) {
            case "orgname": {
                sumNameField = "orgname";
                break;
            }
            case "currency": {
                sumNameField = "currencyname";
                break;
            }
            case "creditororg": {
                sumNameField = "textcreditor";
                break;
            }
        }
        return sumNameField;
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"orgname");
    }

    public List<String> groupFields() {
        List<String> groupFields = Arrays.stream(this.groupFields).collect(Collectors.toList());
        if (!"currency".equals(this.statdim)) {
            groupFields.remove("currency");
        }
        return groupFields;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        for (AbstractReportColumn column : columns) {
            String fieldKey;
            ReportColumn rColumn = (ReportColumn)column;
            switch (fieldKey = rColumn.getFieldKey()) {
                case "orgname": 
                case "textcreditor": {
                    if ("creditororg".equals(this.statdim) || fieldKey.equals(this.statdim)) break;
                    rColumn.setHide(true);
                    break;
                }
                case "currencyname": {
                    if ("currency".equals(this.statdim)) break;
                    rColumn.setHide(true);
                    break;
                }
                case "currency": {
                    if (!"creditororg".equals(this.statdim) && fieldKey.equals(this.statdim)) break;
                    rColumn.setHide(true);
                }
            }
        }
        return columns;
    }

    private DataSet getBillDataSet(Map<String, Object> paramMap) {
        String filterData;
        Date startDate = (Date)paramMap.get("filter_startdate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        QFilter loanFilter = this.getLoanBillFilter(paramMap);
        DataSet loanBillDs = this.getLoandBillDs(loanFilter, filterData = (String)paramMap.get("filter_data"), paramMap);
        if (loanBillDs == null || loanBillDs.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        loanBillDs = loanBillDs.copy().addField("drawamount", "notrepayamount");
        DataSet repaymentDs = this.getRepaymentDs(loanBillDs);
        loanBillDs = this.getloanBillBalanceDs(loanBillDs, repaymentDs, endDate);
        repaymentDs = repaymentDs != null ? repaymentDs.filter("to_char(repaydate, 'yyyyMMdd')>=" + DateUtils.formatString((Date)startDate, (String)"yyyyMMdd")) : repaymentDs;
        List<LoanInfo> loanInfos = this.getLoanInfos(loanBillDs, startDate, endDate);
        List<RepayInfo> repayInfos = this.getRepayInfos(repaymentDs);
        ArrayList<LoanCalResult> loanCalResults = new ArrayList<LoanCalResult>();
        this.calDayBalanceAmt(loanInfos, repayInfos);
        this.calInstTotalAmt(startDate, endDate, loanCalResults, loanInfos);
        DataSet newLoanbillDs = this.resultReCombine2DateSet(loanBillDs, loanCalResults);
        newLoanbillDs = newLoanbillDs.filter("daybalance>0");
        newLoanbillDs = this.addFeeAmtCompAmt(newLoanbillDs, paramMap);
        return newLoanbillDs;
    }

    private DataSet getloanBillBalanceDs(DataSet loanBillDs, DataSet repaymentDs, Date endDate) {
        DataSet repayamtGroupDs;
        if (repaymentDs == null) {
            return loanBillDs;
        }
        DataSet beforeEndRepayDs = repaymentDs.copy().filter("to_char(repaydate, 'yyyyMMdd')<=" + DateUtils.formatString((Date)endDate, (String)"yyyyMMdd"));
        if (beforeEndRepayDs.isEmpty()) {
            return loanBillDs;
        }
        DataSet repayGroupDs = beforeEndRepayDs.copy().filter("loantype='sl' or isbuyback").groupBy(new String[]{"loanid", "creditorid"}).sum("repayamt").finish();
        if (!repayGroupDs.isEmpty()) {
            loanBillDs = loanBillDs.leftJoin(repayGroupDs).on("id", "loanid").on("creditor", "creditorid").select(loanBillDs.getRowMeta().getFieldNames(), new String[]{"repayamt"}).finish().updateField("notrepayamount", "case when repayamt!=null then notrepayamount-repayamt else notrepayamount end").removeFields(new String[]{"repayamt"});
        }
        if (!(repayamtGroupDs = beforeEndRepayDs.filter("loantype!='sl' and !isbuyback").groupBy(new String[]{"loanid"}).sum("repayamt").finish()).isEmpty()) {
            DataSet notrepayAmountDs = loanBillDs.groupBy(new String[]{"id"}).sum("notrepayamount").finish();
            loanBillDs = loanBillDs.leftJoin(notrepayAmountDs).on("id", "id").select(loanBillDs.getRowMeta().getFieldNames(), new String[]{"notrepayamount sumamount"}).finish();
            loanBillDs = loanBillDs.leftJoin(repayamtGroupDs).on("id", "loanid").select(loanBillDs.getRowMeta().getFieldNames(), new String[]{"repayamt"}).finish().updateField("radio", "case when sumamount>0 then notrepayamount/sumamount else 0 end").updateField("notrepayamount", "case when repayamt!=null then notrepayamount-repayamt*radio else notrepayamount end").removeFields(new String[]{"repayamt", "sumamount"});
        }
        return loanBillDs.updateField("notrepayamount", "case when notrepayamount>0 then notrepayamount else 0 end");
    }

    private DataSet getLoandBillDs(QFilter baseFilter, String filterData, Map<String, Object> paramMap) {
        String creditorTypes = (String)paramMap.get("filter_creditortype");
        Set datas = Arrays.stream(filterData.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        DataSet loanBillAllDs = null;
        if (datas.contains(LOANTYPE_CFM)) {
            QFilter loan_filter = MonReportHelper.getCreditortypeFilter(baseFilter.copy(), creditorTypes, "");
            QFilter creditorFilter = MonReportHelper.getCreditorFilter(paramMap, "");
            DataSet loanBillDs = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_costcal_loan", (String)"cfm_loanbill", (String)LONA_FIELDS, (QFilter[])new QFilter[]{loan_filter, creditorFilter}, null);
            QFilter sl_Filter = MonReportHelper.getCreditortypeFilter(baseFilter.copy(), creditorTypes, LOANTYPE_SL);
            QFilter slCreditorFilter = MonReportHelper.getCreditorFilter(paramMap, LOANTYPE_SL);
            DataSet slLoanBillDs = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_costcal_sl", (String)"cfm_loanbill", (String)SL_FIELDS, (QFilter[])new QFilter[]{sl_Filter, slCreditorFilter}, null);
            loanBillAllDs = loanBillDs.union(slLoanBillDs);
        }
        if (datas.contains(LOANTYPE_BDIM)) {
            QFilter bondFilter = MonReportHelper.getCreditortypeFilter(baseFilter.copy(), creditorTypes, LOANTYPE_BOND);
            QFilter bondCreditorFilter = MonReportHelper.getCreditorFilter(paramMap, LOANTYPE_BOND);
            DataSet bondLoanBillDs = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_costcal_bond", (String)"cfm_loanbill_bond", (String)BOND_FIELDS, (QFilter[])new QFilter[]{bondFilter, bondCreditorFilter}, null);
            DataSet dataSet = loanBillAllDs = loanBillAllDs != null ? loanBillAllDs.union(bondLoanBillDs) : bondLoanBillDs;
        }
        if (datas.contains(LOANTYPE_FL)) {
            QFilter fl_filter = MonReportHelper.getCreditortypeFilter(baseFilter.copy(), creditorTypes, "finlease");
            QFilter finleaseCreditorFilter = MonReportHelper.getCreditorFilter(paramMap, "finlease");
            DataSet flBillDs = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_costcal_fl", (String)"cfm_loanbill", (String)LONA_FIELDS, (QFilter[])new QFilter[]{fl_filter, finleaseCreditorFilter}, null);
            loanBillAllDs = loanBillAllDs != null ? loanBillAllDs.union(flBillDs) : flBillDs;
        }
        return loanBillAllDs != null ? loanBillAllDs.filter("drawamount>0") : loanBillAllDs;
    }

    private DataSet groupByStatdimAndCalSum(DataSet dataSet) {
        this.groupFields = new String[]{"org", "orgname", "currency"};
        if ("textcreditor".equals(this.statdim)) {
            this.groupFields = new String[]{"creditortype", "creditor", "textcreditor", "currency"};
        } else if ("currency".equals(this.statdim)) {
            this.groupFields = new String[]{"currency", "currencyname"};
        } else if ("creditororg".equals(this.statdim)) {
            this.groupFields = new String[]{"creditortype", "textcreditor", "creditor", "org", "orgname", "currency"};
        }
        return dataSet.groupBy(this.groupFields).sum("daybalance").sum("totalinstamt").sum("feeamt").sum("compamt").finish().orderBy(this.groupFields);
    }

    private String getTarCurrencyId(Map<String, Object> paramMap) {
        return String.valueOf(((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id"));
    }

    private DataSet dealCreditDataSet(DataSet oriDataSet, Map<String, Object> paramMap) {
        oriDataSet = oriDataSet.addFields(new String[]{"0", "creditor", "0"}, new String[]{"isgroupnode", "rowid", "pid"});
        DataSet bankDs = oriDataSet.filter("creditortype='bank'");
        DataSet finorgDs = oriDataSet.filter("creditortype='finorg'");
        DataSet settleCenterDs = oriDataSet.filter("creditortype='settlecenter'");
        DataSet otherDs = oriDataSet.filter("creditortype !='bank' and creditortype !='finorg' and creditortype !='settlecenter' ");
        HashSet<Object> banks = new HashSet<Object>(16);
        HashSet<Object> settlecenters = new HashSet<Object>(16);
        HashSet<Object> finorgs = new HashSet<Object>(16);
        for (Row row : oriDataSet.copy()) {
            Long creditor = row.getLong("creditor");
            if (!EmptyUtil.isNoEmpty((Long)creditor)) continue;
            if (CreditorTypeEnum.BANK.getValue().equals(row.get("creditortype"))) {
                banks.add(creditor);
                continue;
            }
            if (CreditorTypeEnum.FINORG.getValue().equals(row.get("creditortype"))) {
                finorgs.add(creditor);
                continue;
            }
            if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(row.get("creditortype"))) continue;
            settlecenters.add(creditor);
        }
        HashSet<Object> bankTypes = new HashSet<Object>(16);
        bankTypes.addAll(banks);
        bankTypes.addAll(settlecenters);
        bankTypes.addAll(finorgs);
        if (EmptyUtil.isNoEmpty(bankTypes)) {
            String[] finFileds = new String[]{"creditortype", "creditor", "textcreditor", "daybalance_report", "totalinstamt_report", "feeamt_report", "compamt_report", "isgroupnode", "rowid"};
            DataSet allFinDataSets = QueryServiceHelper.queryDataSet((String)"bd_finorginfo_tree", (String)"bd_finorginfo", (String)"id,name textcreditor,bank_cate,bank_cate.name pcatename ,finorgtype,finorgtype.name ptypename", (QFilter[])new QFilter("id", "in", bankTypes).toArray(), (String)"createtime");
            if (EmptyUtil.isNoEmpty(banks)) {
                DataSet bankFinDataSet = allFinDataSets.copy().filter(String.format("id in (%s)", this.getInSqlStr(banks)));
                bankDs = bankDs.join(bankFinDataSet.copy(), JoinType.LEFT).on("creditor", "id").select(finFileds, new String[]{"bank_cate as pid", "pcatename pname"}).finish();
                bankDs = this.updateRowId(bankDs);
                bankDs = bankDs.removeFields(new String[]{"pname"}).union(this.getParentSumDs(bankDs));
            }
            if (EmptyUtil.isNoEmpty(finorgs)) {
                DataSet noBankFinDataSet = allFinDataSets.copy().filter(String.format("id in (%s)", this.getInSqlStr(finorgs)));
                finorgDs = finorgDs.join(noBankFinDataSet.copy(), JoinType.LEFT).on("creditor", "id").select(finFileds, new String[]{"finorgtype as pid", "ptypename as pname"}).finish();
                finorgDs = this.updateRowId(finorgDs);
                finorgDs = finorgDs.removeFields(new String[]{"pname"}).union(this.getParentSumDs(finorgDs));
            }
            if (EmptyUtil.isNoEmpty(settlecenters)) {
                DataSet centerFinDataSet = allFinDataSets.copy().filter(String.format("id in (%s)", this.getInSqlStr(settlecenters)));
                settleCenterDs = settleCenterDs.join(centerFinDataSet.copy(), JoinType.LEFT).on("creditor", "id").select(finFileds, new String[]{"finorgtype as pid", "ptypename as pname"}).finish();
                settleCenterDs = this.updateRowId(settleCenterDs);
                settleCenterDs = settleCenterDs.removeFields(new String[]{"pname"}).union(this.getParentSumDs(settleCenterDs));
            }
        }
        otherDs = this.updateRowId(otherDs);
        DataSet resultDateSet = bankDs.union(finorgDs).union(settleCenterDs).union(otherDs);
        resultDateSet = resultDateSet.addFields(new String[]{"0", this.getOrderFieldSql(), this.getTarCurrencyId(paramMap)}, new String[]{"sumlevel", "orderfield", "statcurrency"});
        DataSet subTotalDs = this.addSubTotalDataSet(resultDateSet.copy().filter("pid=0"), Arrays.asList("creditortype", "orderfield", "statcurrency"), this.getSumFields(), "textcreditor").select(new String[]{"creditortype", "orderfield creditor", this.getCaseSql(), "daybalance_report", "totalinstamt_report", "feeamt_report", "compamt_report", "0 isgroupnode", "orderfield  rowid", "0 pid", "sumlevel", "orderfield", "statcurrency"});
        DataSet temSubTotalDs = subTotalDs.copy().filter(this.sumField + " = 1").updateField(this.sumField, "0").addField("1", "groupFields");
        DataSet allTotalDs = this.addAllTotalDataSet(temSubTotalDs, this.getSumFields(), Arrays.asList("groupFields", "statcurrency"), "textcreditor").removeFields(new String[]{"groupFields"}).updateFields(new String[]{"isgroupnode", "rowid", "pid"}, new String[]{"0", String.valueOf(DBServiceHelper.genGlobalLongId()), "0"});
        return resultDateSet.union(subTotalDs).orderBy(new String[]{"orderfield asc", "sumlevel"}).union(allTotalDs);
    }

    private DataSet getParentSumDs(DataSet bankDs) {
        DataSet pidGroupDataSet = bankDs.copy().filter("pid > 0").groupBy(new String[]{"pid", "pname", "creditortype"}).sum("daybalance_report").sum("totalinstamt_report").sum("feeamt_report").sum("compamt_report").finish();
        return pidGroupDataSet.select("creditortype,pid as creditor,pname textcreditor,daybalance_report,totalinstamt_report,feeamt_report,compamt_report,1 as isgroupnode,pid rowid,0 pid");
    }

    private DataSet calOtherAveInfo(DataSet dataSet, Map<String, Object> paramMap) {
        Date startDate = (Date)paramMap.get("filter_startdate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1;
        String[] fieldNames = dataSet.copy().getRowMeta().getFieldNames();
        List<String> selectFileds = Arrays.stream(fieldNames).collect(Collectors.toList());
        selectFileds.add(String.format("totalinstamt_report/%s as  avedayinst", diffDays));
        selectFileds.add(String.format("case when daybalance_report=0 then 0 else totalinstamt_report*1000/(daybalance_report*(%s)) end as averate", diffDays));
        selectFileds.add(String.format("case when daybalance_report=0 then 0 else totalinstamt_report*1000/(daybalance_report*(%s))/10*360 end as aveyaerrate", diffDays));
        return dataSet.select(selectFileds.toArray(new String[0])).addField(diffDays + "", "days");
    }

    private void calInstTotalAmt(Date startDate, Date endDate, List<LoanCalResult> loanCalResults, List<LoanInfo> loanInfoList) {
        BigDecimal diffDays = new BigDecimal(DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1);
        List<LoanCalResult> calResults = this.batchCalcLoanBillInt(startDate, endDate, diffDays, loanInfoList);
        loanCalResults.addAll(calResults);
    }

    private List<LoanCalResult> batchCalcLoanBillInt(Date startDate, Date endDate, BigDecimal diffDays, List<LoanInfo> loanInfos) {
        ArrayList<LoanCalResult> results = new ArrayList<LoanCalResult>(16);
        List<Long> loanBillIds = loanInfos.stream().map(LoanInfo::getId).collect(Collectors.toList());
        Map<Long, IntBillInfo> intBillInfoMap = FinCostCalDataListPlugin.batchCallInt(loanBillIds, startDate, endDate);
        for (LoanInfo loanInfo : loanInfos) {
            IntBillInfo billInfo = intBillInfoMap.get(loanInfo.getId());
            IntBillInfo intBillInfo = billInfo == null || billInfo instanceof IntBillInfo ? billInfo : (IntBillInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)billInfo), IntBillInfo.class);
            results.add(this.getLoanCalResult(loanInfo, intBillInfo, diffDays));
        }
        return results;
    }

    private LoanCalResult getLoanCalResult(LoanInfo loanInfo, IntBillInfo intBillInfo, BigDecimal diffDays) {
        if (intBillInfo != null) {
            loanInfo.setTotalInstAmt(intBillInfo.getAmount());
        } else {
            loanInfo.setTotalInstAmt(BigDecimal.ZERO);
        }
        return new LoanCalResult(loanInfo.getId(), loanInfo.getEntryId(), diffDays, loanInfo.getDayBalance(), loanInfo.getTotalInstAmt());
    }

    private DataSet resultReCombine2DateSet(DataSet loanBillDs, List<LoanCalResult> loanCalResults) {
        final Map<Long, LoanCalResult> idLoanCalResultMap = loanCalResults.stream().collect(Collectors.toMap(LoanCalResult::getEntryId, o -> o));
        loanBillDs = loanBillDs.addField(String.valueOf(0.0), "daybalance").addField(String.valueOf(0.0), "totalinstamt");
        final RowMeta newRowMetas = loanBillDs.copy().getRowMeta();
        loanBillDs = loanBillDs.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                for (String fieldName : newRowMetas.getFieldNames()) {
                    Long id = row.getLong("entryid");
                    LoanCalResult loanCalResult = (LoanCalResult)idLoanCalResultMap.get(id);
                    if ("daybalance".equals(fieldName)) {
                        rowInfo.add(loanCalResult.getDayBalance());
                        continue;
                    }
                    if ("totalinstamt".equals(fieldName)) {
                        rowInfo.add(loanCalResult.getTotalInstAmt());
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return newRowMetas;
            }
        });
        ORM.create().toPlainDynamicObjectCollection(loanBillDs.copy());
        DataSet billGroupAmountDs = loanBillDs.copy().groupBy(new String[]{"id"}).sum("drawamount").finish();
        loanBillDs = loanBillDs.leftJoin(billGroupAmountDs).on("id", "id").select(loanBillDs.getRowMeta().getFieldNames(), new String[]{"drawamount sumamount"}).finish().updateField("totalinstamt", "case when sumamount>0 then totalinstamt*drawamount/sumamount else drawamount end").removeFields(new String[]{"sumamount"});
        return loanBillDs;
    }

    private void calDayBalanceAmt(List<LoanInfo> loanInfos, List<RepayInfo> repayInfos) {
        Map<Long, List<RepayInfo>> loanIdRepayMap = repayInfos.stream().collect(Collectors.groupingBy(RepayInfo::getLoanId));
        for (LoanInfo loanInfo : loanInfos) {
            BigDecimal radio;
            Long loanId = loanInfo.getId();
            if (EmptyUtil.isEmpty((Object)loanInfo.getRadio()) || EmptyUtil.isEmpty((BigDecimal)(radio = new BigDecimal(loanInfo.getRadio())))) continue;
            BigDecimal noRepayAmt = loanInfo.getNoRepayAmt();
            Date searchStartDate = loanInfo.getSearchStartDate();
            Date searchEndDate = loanInfo.getSearchEndDate();
            Date effectLoanDate = loanInfo.getLoanDate();
            ArrayList<RepayInfo> repayInfoList = loanIdRepayMap.get(loanId) == null ? new ArrayList(10) : loanIdRepayMap.get(loanId);
            BigDecimal totalDays = new BigDecimal(DateUtils.getDiffDays((Date)searchStartDate, (Date)searchEndDate) - 1);
            if (searchStartDate.compareTo(effectLoanDate) >= 0) {
                effectLoanDate = searchStartDate;
            }
            BigDecimal effectDays = new BigDecimal(DateUtils.getDiffDays((Date)effectLoanDate, (Date)searchEndDate) - 1);
            BigDecimal aAmt = noRepayAmt.multiply(effectDays);
            BigDecimal bAmt = this.getbAmt(repayInfoList, loanInfo, radio);
            BigDecimal balanceAmt = aAmt.add(bAmt).divide(totalDays, 10, 4);
            loanInfo.setDayBalance(balanceAmt);
        }
    }

    private BigDecimal getbAmt(List<RepayInfo> repayInfoList, LoanInfo loanInfo, BigDecimal radio) {
        Date searchStartDate = loanInfo.getSearchStartDate();
        Date searchEndDate = loanInfo.getSearchEndDate();
        BigDecimal bAmt = BigDecimal.ZERO;
        for (RepayInfo repayInfo : repayInfoList) {
            Date repayDate = repayInfo.getRepayDate();
            if (repayDate.compareTo(searchEndDate) > 0) continue;
            Date loanDate = loanInfo.getLoanDate();
            BigDecimal repayAmt = this.repayAmout(repayInfo, loanInfo, radio);
            Date calStartDate = loanDate.compareTo(searchStartDate) >= 0 ? loanDate : searchStartDate;
            BigDecimal sDays = new BigDecimal(DateUtils.getDiffDays((Date)calStartDate, (Date)repayDate) - 1);
            bAmt = bAmt.add(repayAmt.multiply(sDays));
        }
        return bAmt;
    }

    private BigDecimal repayAmout(RepayInfo repayInfo, LoanInfo loanInfo, BigDecimal radio) {
        String loanType = loanInfo.getLoanType();
        if (LOANTYPE_SL.equals(loanType)) {
            if (EmptyUtil.isNoEmpty((Long)repayInfo.getCreditorId()) && repayInfo.getCreditorId().equals(loanInfo.getCreditorId())) {
                return repayInfo.getRepayAmt();
            }
            return BigDecimal.ZERO;
        }
        if (LOANTYPE_BOND.equals(loanType)) {
            if (EmptyUtil.isNoEmpty((Long)repayInfo.getCreditorId())) {
                return repayInfo.getCreditorId().equals(loanInfo.getCreditorId()) ? repayInfo.getRepayAmt() : BigDecimal.ZERO;
            }
            return repayInfo.getRepayAmt().multiply(radio);
        }
        return repayInfo.getRepayAmt().multiply(radio);
    }

    private DataSet getRepaymentDs(DataSet loanBillDs) {
        Set<Long> slloanBillIds = this.getDataSetFieldIds(loanBillDs.copy().filter("loantype='sl'"), "id");
        Set<Long> notSlLoanBillIds = this.getDataSetFieldIds(loanBillDs.filter("loantype!='sl'"), "id");
        QFilter filter = this.getBaseFilter();
        DataSet repaymentDs = null;
        if (EmptyUtil.isNoEmpty(notSlLoanBillIds)) {
            QFilter notSlFilter = filter.copy().and("loans.e_loanbill", "in", notSlLoanBillIds);
            repaymentDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_notsl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,loans.e_loanbill loanid,loans.e_repayamount repayamt,case when loans.buyback_entry.e_investorid>0 then loans.buyback_entry.e_investorid else loans.buyback_entry.e_investentryid end creditorid,loans.buyback_entry.e_buybackamt buybackamt", (QFilter[])new QFilter[]{notSlFilter}, null).updateField("repayamt", "case when creditorid>0 then buybackamt else repayamt end").select("id,repaydate,loantype,isbuyback,loanid,repayamt,creditorid");
        }
        if (EmptyUtil.isNoEmpty(slloanBillIds)) {
            QFilter slFilter = filter.and("loans.e_loanbill", "in", slloanBillIds);
            DataSet slLoandDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_sl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,slentryentity.s_loanbillno loanid,slentryentity.s_repayamount repayamt,slentryentity.s_bank creditorid", (QFilter[])new QFilter[]{slFilter}, null);
            repaymentDs = repaymentDs != null ? repaymentDs.union(slLoandDs) : slLoandDs;
        }
        return repaymentDs;
    }

    private QFilter getLoanBillFilter(Map<String, Object> paramMap) {
        DynamicObjectCollection finProducts;
        QFilter loanFilter = this.getBaseFilter();
        loanFilter.and(new QFilter("bizdate", "<=", paramMap.get("filter_cutoffdate")));
        List orgIds = this.getQueryOrgIds(this.getQueryParam());
        logger.info("\u6709\u6743\u9650\u7684\u7ec4\u7ec7id\uff1a" + orgIds);
        loanFilter.and(new QFilter("org", "in", (Object)orgIds));
        DynamicObjectCollection currencys = (DynamicObjectCollection)paramMap.get("filter_currency");
        if (currencys != null && currencys.size() > 0) {
            List currencyIds = currencys.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            loanFilter.and("currency", "in", currencyIds);
        }
        if ((finProducts = (DynamicObjectCollection)paramMap.get("filter_finproduct")) != null && finProducts.size() > 0) {
            List finProductIds = finProducts.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            loanFilter.and("finproduct", "in", finProductIds);
        }
        String regionsStr = (String)paramMap.get("filter_region");
        Set regions = Arrays.stream(regionsStr.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty((String)regionsStr) && regions.size() != 3) {
            loanFilter.and(new QFilter("region", "in", regions));
        }
        loanFilter.and(new QFilter("drawamount", ">", (Object)BigDecimal.ZERO)).and(new QFilter("startloanrate", ">", (Object)BigDecimal.ZERO)).and(new QFilter("currency", ">", (Object)BigDecimal.ZERO));
        QFilter excluLoanFilter = loanFilter.copy();
        Date startDate = (Date)paramMap.get("filter_startdate");
        excluLoanFilter.and(new QFilter("notrepayamount", "=", (Object)BigDecimal.ZERO)).and(new QFilter("lastrepaydate", "<=", (Object)startDate));
        List excludeLoanIds = QueryServiceHelper.queryPrimaryKeys((String)"cfm_loanbill", (QFilter[])new QFilter[]{loanFilter}, (String)"billno", (int)0);
        if (EmptyUtil.isNoEmpty((Object)excludeLoanIds)) {
            loanFilter.and(new QFilter("id", "not in", (Object)excludeLoanIds));
        }
        loanFilter = this.initLenderNatureFilter(paramMap, loanFilter);
        return loanFilter;
    }

    private QFilter getBaseFilter() {
        return new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("confirmstatus", "=", (Object)"yetconfirm")).and(new QFilter("org", ">", (Object)0));
    }

    private static Map<Long, IntBillInfo> batchCallInt(List<Long> loanBillids, Date beginDate, Date endDate) {
        return (Map)DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)TmcAppEnum.CFM.getValue(), (String)"intCalcService", (String)"batchCallLoanInt", (Object[])new Object[]{loanBillids, beginDate, endDate, true});
    }

    private Set<Long> getDataSetFieldIds(DataSet billDataSet, String field) {
        HashSet<Long> billIds = new HashSet<Long>();
        billDataSet.copy().forEach(o -> billIds.add(o.getLong(field)));
        return billIds;
    }

    private String getInSqlStr(Set<Object> banks) {
        StringJoiner stringJoiner = new StringJoiner(",");
        banks.stream().map(o -> String.valueOf(o)).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    private String getCaseSql() {
        return String.format("case when creditortype ='bank' then '%1$s'  when creditortype ='finorg' then  '%2$s' when creditortype ='settlecenter' then '%3$s'  when creditortype ='innerunit' then '%4$s' when creditortype ='custom' then '%5$s' else '%6$s'end as textcreditor", ResManager.loadKDString((String)"\u94f6\u884c\u5c0f\u8ba1", (String)"FinCostCalDataListPlugin_02", (String)"tmc-mon-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u94f6\u884c\u5c0f\u8ba1", (String)"FinCostCalDataListPlugin_04", (String)"tmc-mon-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u5c0f\u8ba1", (String)"FinCostCalDataListPlugin_03", (String)"tmc-mon-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5185\u90e8\u5355\u4f4d\u5c0f\u8ba1", (String)"FinCostCalDataListPlugin_05", (String)"tmc-mon-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba2\u5546\u5c0f\u8ba1", (String)"FinCostCalDataListPlugin_06", (String)"tmc-mon-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6\u5c0f\u8ba1", (String)"FinCostCalDataListPlugin_07", (String)"tmc-mon-report", (Object[])new Object[0]));
    }

    private String getOrderFieldSql() {
        int i = RandomUtils.nextInt();
        return String.format("case when creditortype ='bank' then %1$s  when creditortype ='finorg' then  %2$s when creditortype ='settlecenter' then %3$s  when creditortype ='innerunit' then %4$s when creditortype ='custom' then %5$s else %6$s end", i + 101, i + 102, i + 103, i + 104, i + 105, i + 106);
    }

    private List<String> getSumFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("daybalance_report");
        fields.add("totalinstamt_report");
        fields.add("feeamt_report");
        fields.add("compamt_report");
        return fields;
    }

    private QFilter initLenderNatureFilter(Map<String, Object> paramMap, QFilter filter) {
        String lendernature = (String)paramMap.get("filter_lendernature");
        if (!EmptyUtil.isEmpty((String)lendernature)) {
            filter.and(new QFilter("lendernature", "in", (Object)lendernature.split(",")));
        }
        return filter;
    }

    private List<RepayInfo> getRepayInfos(DataSet repaymentDs) {
        ArrayList<RepayInfo> repayInfos = new ArrayList<RepayInfo>(16);
        if (repaymentDs == null) {
            return repayInfos;
        }
        for (Row repayBill : repaymentDs.copy()) {
            repayInfos.add(new RepayInfo(repayBill.getLong("loanid"), repayBill.getBigDecimal("repayamt"), repayBill.getDate("repaydate"), repayBill.getLong("creditorid")));
        }
        return repayInfos;
    }

    private List<LoanInfo> getLoanInfos(DataSet loanBillDs, Date startDate, Date endDate) {
        ArrayList<LoanInfo> loanInfos = new ArrayList<LoanInfo>(16);
        for (Row loanBill : loanBillDs.copy()) {
            loanInfos.add(new LoanInfo(loanBill.getLong("id"), loanBill.getLong("entryid"), loanBill.getBigDecimal("notrepayamount"), loanBill.getBigDecimal("drawamount"), loanBill.getDouble("radio"), loanBill.getBigDecimal("loanrate"), loanBill.getDate("bizdate"), startDate, endDate, loanBill.getString("loantype"), loanBill.getLong("creditor")));
        }
        return loanInfos;
    }

    private DataSet updateRowId(DataSet oriDataSet) {
        RowMeta rowMeta = oriDataSet.getRowMeta();
        List<String> rowFieldList = Arrays.stream(rowMeta.getFields()).map(Field::getName).collect(Collectors.toList());
        DataSetBuilder bizDsBuilder = Algo.create((String)FinCostCalDataListPlugin.class.getSimpleName()).createDataSetBuilder(oriDataSet.getRowMeta());
        for (Row row : oriDataSet) {
            ArrayList updateRow = new ArrayList(rowFieldList.size());
            rowFieldList.forEach(rowField -> {
                if (rowField.equals("rowid")) {
                    updateRow.add(String.valueOf(DBServiceHelper.genGlobalLongId()));
                } else {
                    updateRow.add(row.get(rowField));
                }
            });
            bizDsBuilder.append(updateRow.toArray());
        }
        return bizDsBuilder.build();
    }

    private DataSet buildCompCalcDs(DataSet dataSet, Map<String, Object> paramMap) {
        ArrayList<Field> field = new ArrayList<Field>(8);
        field.add(new Field("compid", (DataType)DataType.LongType));
        field.add(new Field("compfeeamt", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        DataSetBuilder builder = Algo.create((String)"Build_Comprate_Calc_Ds").createDataSetBuilder(rowMeta);
        Date startDate = (Date)paramMap.get("filter_startdate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        for (Row row : dataSet.copy()) {
            int difDays;
            Date drawDate = row.getDate("bizdate");
            if (EmptyUtil.isEmpty((Object)drawDate)) continue;
            Date maxDate = drawDate.compareTo(startDate) >= 0 ? drawDate : startDate;
            int weightDays = DateUtils.getDiffDays((Date)maxDate, (Date)endDate);
            BigDecimal notRepayAmount = row.getBigDecimal("notrepayamount");
            Date expireDate = EmptyUtil.isEmpty((BigDecimal)notRepayAmount) && EmptyUtil.isNoEmpty((Object)row.getDate("cleardate")) ? row.getDate("cleardate") : row.getDate("expiredate");
            if (EmptyUtil.isEmpty((Object)expireDate) || (difDays = DateUtils.getDiffDays((Date)drawDate, (Date)expireDate)) == 0) continue;
            BigDecimal feeamt = row.getBigDecimal("feeamt").multiply(new BigDecimal(weightDays)).divide(new BigDecimal(difDays), 10, 4);
            Object[] rowArr = new Object[]{row.getLong("id"), feeamt};
            builder.append(rowArr);
        }
        return builder.build().groupBy(new String[]{"compid"}).max("compfeeamt").finish();
    }

    private DataSet buildFeeAmtDs(DataSet loanBillDS) {
        ArrayList<Long> loanBillIds = new ArrayList<Long>(loanBillDS.copy().count("id", false));
        for (Row row : loanBillDS.copy()) {
            loanBillIds.add(row.getLong("id"));
        }
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "in", loanBillIds);
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("feesource", "in", Arrays.asList(FeeSourceEnum.HAND.getValue(), FeeSourceEnum.BIZPATCH.getValue(), FeeSourceEnum.BATCHINPUT.getValue()))));
        DataSet feeDs = QueryServiceHelper.queryDataSet((String)"TradeFinanceDataListPlugin_Fee", (String)"cfm_feebill", (String)"entry.srcbillid as srcbillid,entry.feedetailamt as feedetailamt,entry.excrate as excrate", (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter}, (String)"");
        if (feeDs.isEmpty()) {
            return feeDs;
        }
        return feeDs.groupBy(new String[]{"srcbillid"}).sum("feedetailamt*excrate", "feeamt").finish().select("srcbillid,feeamt");
    }

    private DataSet addFeeAmtCompAmt(DataSet newLoanbillDs, Map<String, Object> paramMap) {
        if (null == newLoanbillDs || newLoanbillDs.isEmpty()) {
            return newLoanbillDs;
        }
        DataSet feeAmtDs = this.buildFeeAmtDs(newLoanbillDs);
        newLoanbillDs = null != feeAmtDs && !feeAmtDs.isEmpty() ? newLoanbillDs.leftJoin(feeAmtDs).on("id", "srcbillid").select(newLoanbillDs.getRowMeta().getFieldNames(), new String[]{"feeamt"}).finish().updateField("feeamt", "case when feeamt is null then 0 else feeamt end") : newLoanbillDs.addField("0", "feeamt");
        DataSet compCalcDs = this.buildCompCalcDs(newLoanbillDs, paramMap);
        newLoanbillDs = newLoanbillDs.leftJoin(compCalcDs).on("id", "compid").select(newLoanbillDs.getRowMeta().getFieldNames(), new String[]{"compfeeamt"}).finish().updateField("feeamt", "compfeeamt").addField("totalinstamt + feeamt", "compamt");
        return newLoanbillDs;
    }
}

