/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.ReportShowTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.QueryTypeEnum;
import kd.tmc.mon.report.helper.FinReportHelper;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FinStructureDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String LOAN_FIELDS = "id,org,loantype,drawamount amount,region,creditortype,creditor,textcreditor,currency, 1 rate";
    private static final String SLLOAN_FIELDS = "id,org,loantype,banksyndicate_entry.e_shareamount amount,region, 'bank' creditortype,banksyndicate_entry.e_bank creditor,banksyndicate_entry.e_bank.name textcreditor,currency,banksyndicate_entry.e_shareamount/drawamount rate";
    private static final String BOND_FIELDS = "id,org,loantype,investor_entry.e_investamount amount,region,investor_entry.e_investortype creditortype,investor_entry.e_investorid creditor,investor_entry.e_investorname textcreditor,currency,investor_entry.e_investamount/drawamount rate";
    private static final String TOTAL_FIELDS = "currency,basechinamt tbasechinamt, basegatamt tbasegatamt, baseabroadamt tbaseabroadamt,baseamt tbaseamt,endchinamt tendchinamt, endgatamt tendgatamt, endabroadamt tendabroadamt, endamt tendamt";
    private static final String REGION = "region";
    private static final String FINORGTYPE = "finorgtype";
    private static final String ROWID = "rowid";
    private static final String ORGIDS = "orgids";
    private static final String ORGNAME = "orgname";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.putAll(queryParam.getCustomParam());
        paramMap.put(ORGIDS, this.getQueryOrgIds(queryParam));
        Long tarCurrencyId = (Long)paramMap.get("filter_statcurrency");
        DataSet billDataSet = this.getBillDataSet(paramMap);
        if (billDataSet == null || billDataSet.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        String statDim = (String)queryParam.getCustomParam().get("filter_statdim");
        DataSet resultDs = "org".equals(statDim) ? this.dealBillDataSetByOrg(billDataSet, paramMap, tarCurrencyId, queryParam) : ("creditor".equals(statDim) ? this.dealBillDataSetByCreditor(billDataSet, tarCurrencyId) : this.dealBillDataSetByCurrency(billDataSet, tarCurrencyId));
        resultDs = resultDs.addField(String.valueOf(tarCurrencyId), "tarcurrency");
        return this.convertTotalRate(resultDs);
    }

    private DataSet getLoandBillDs(Map<String, Object> paramMap, boolean isBase) {
        QFilter baseFilter = this.getFilter(paramMap, isBase);
        QFilter filter = this.getCreditortypeFilter(baseFilter.copy(), paramMap, "");
        DataSet loanBillDs = QueryServiceHelper.queryDataSet((String)"FinStructureDataListPlugin-getBillDataSet", (String)"cfm_loanbill", (String)LOAN_FIELDS, (QFilter[])new QFilter[]{filter}, null);
        QFilter slFilter = this.getCreditortypeFilter(baseFilter.copy(), paramMap, "sl");
        DataSet slLoanBillDs = null;
        if (slFilter != null) {
            slLoanBillDs = QueryServiceHelper.queryDataSet((String)"FinStructureDataListPlugin-getBillDataSet", (String)"cfm_loanbill", (String)SLLOAN_FIELDS, (QFilter[])new QFilter[]{slFilter}, null);
        }
        QFilter bondFilter = this.getCreditortypeFilter(baseFilter.copy(), paramMap, "bond");
        DataSet bondLoanBillDs = QueryServiceHelper.queryDataSet((String)"FinStructureDataListPlugin-getBillDataSet", (String)"cfm_loanbill_bond", (String)BOND_FIELDS, (QFilter[])new QFilter[]{bondFilter}, null);
        if (slLoanBillDs == null) {
            return loanBillDs.union(bondLoanBillDs);
        }
        return loanBillDs.union(slLoanBillDs).union(bondLoanBillDs);
    }

    private String getExp(String field) {
        return "case when " + field + "=0 then '' else cast(round(" + field + ", 2) as String) end";
    }

    private DataSet dealBillDataSetByCurrency(DataSet billDataSet, Long tarCurrencyId) {
        Set<Long> currencyIds = this.getDataSetFieldIds(billDataSet, "currency");
        DataSet currencyDs = FinReportHelper.getBaseDataDs(currencyIds, "bd_currency");
        DataSet billDataDs = billDataSet.leftJoin(currencyDs).on("currency", "id").select(new String[]{"name orgname", "basechinamt", "basegatamt", "baseabroadamt", "baseamt", "endchinamt", "endgatamt", "endabroadamt", "endamt", "endamt-baseamt as changeamount", ROWID, "pid", "isgroupnode", "level", "0 sumlevel", "'" + tarCurrencyId + "'currency"}).finish();
        DataSet totalDs = this.addAllTotalDataSet(billDataDs, this.sumFields(), Collections.singletonList("currency"), ORGNAME).select(new String[]{ORGNAME, "basechinamt", "basegatamt", "baseabroadamt", "baseamt", "endchinamt", "endgatamt", "endabroadamt", "endamt", " 0.00 as basechinrate", " 0.00 as basegatrate", " 0.00 as baseabroadrate", " 0.00 as baserate", " 0.00 as endchinrate", " 0.00 as endgatrate", " 0.00 as endabroadrate", " 0.00 as endrate", "changeamount", " (case when baseamt=0 then 0.00 else changeamount*100/baseamt end) changerate", "" + DBServiceHelper.genGlobalLongId() + " rowid", "0 pid", "isgroupnode", "level", "sumlevel", "currency"});
        DataSet totalAmtds = totalDs.select(TOTAL_FIELDS.split(",")).addField("0", "pid");
        DataSet sumRateDs = billDataDs.leftJoin(totalAmtds).on("pid", "pid").select(new String[]{ORGNAME, "basechinamt", "basegatamt", "baseabroadamt", "baseamt", "endchinamt", "endgatamt", "endabroadamt", "endamt", this.converfield("basechinamt", "basechinrate"), this.converfield("basegatamt", "basegatrate"), this.converfield("baseabroadamt", "baseabroadrate"), this.converfield("baseamt", "baserate"), this.converfield("endchinamt", "endchinrate"), this.converfield("endgatamt", "endgatrate"), this.converfield("endabroadamt", "endabroadrate"), this.converfield("endamt", "endrate"), "changeamount", " ( case when baseamt=0 then 0 else (endamt-baseamt)*100/baseamt end ) as changerate", ROWID, "pid", "0 isgroupnode", "level", "sumlevel", "currency"}).finish();
        sumRateDs = sumRateDs.union(totalDs);
        return this.formatDsRate(sumRateDs);
    }

    private DataSet dealBillDataSetByOrg(DataSet billDataSet, Map<String, Object> paramMap, Long tarCurrencyId, ReportQueryParam queryParam) {
        billDataSet = billDataSet.addFields(new String[]{tarCurrencyId + "L", "0", "endamt-baseamt"}, new String[]{"statcurrency", "sumlevel", "changeamount"});
        boolean showStep = ReportShowTypeEnum.STEP.getValue().equals(paramMap.get("filter_showttype"));
        if (showStep) {
            billDataSet = this.addOrgViewTree(billDataSet, paramMap, queryParam);
        } else {
            DataSet orgDataSet;
            String queryWay = (String)paramMap.get("filter_queryway");
            List orgIds = (List)paramMap.get(ORGIDS);
            if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
                orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)8L).filter("orgid in (" + StringUtils.join((Collection)orgIds, (String)",") + ")");
            } else {
                DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
                orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgView.getLong("id")).filter("orgid in (" + StringUtils.join((Collection)orgIds, (String)",") + ")");
            }
            billDataSet = billDataSet.leftJoin(orgDataSet).on("org", ROWID).select(new String[]{ORGNAME, "basechinamt", "basegatamt", "baseabroadamt", "baseamt", "endchinamt", "endgatamt", "endabroadamt", "endamt", "changeamount", ROWID, "'0' pid", "'0' isgroupnode", "1 level", "sumlevel", "statcurrency"}).finish();
            billDataSet = billDataSet.updateFields(new String[]{ROWID, "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        }
        billDataSet = this.addSubRowDataSet(billDataSet, paramMap);
        billDataSet = this.addSumRowDataSet(billDataSet, paramMap);
        billDataSet = billDataSet.updateField("statcurrency", tarCurrencyId + "L");
        billDataSet = billDataSet.addField("case when baseamt=0 then 0.00 else round(changeamount*100/baseamt, 2) end ", "changerate");
        DataSet[] dataSets = billDataSet.splitByFilter(new String[]{"sumlevel = 2", "sumlevel != 2"}, false);
        billDataSet = this.calculationOrgAddRate(dataSets[1], dataSets[0].copy());
        DataSet totalDs = this.addTotalFields(dataSets[0]).select(billDataSet.getRowMeta().getFieldNames());
        return billDataSet.union(totalDs);
    }

    private DataSet dealBillDataSetByCreditor(DataSet billDataSet, Long tarCurrencyId) {
        Object[] fieldNames = billDataSet.getRowMeta().getFieldNames();
        billDataSet = billDataSet.addField(String.valueOf(tarCurrencyId), "currency").select(StringUtils.join((Object[])fieldNames, (String)",") + ",currency");
        DataSet bankDs = billDataSet.filter("creditortype='bank' and creditor!=0");
        DataSet finorgDs = billDataSet.filter("creditortype='finorg'");
        DataSet settleCenterDs = billDataSet.filter("creditortype='settlecenter'");
        DataSet innerUnitDs = billDataSet.filter("creditortype='innerunit'");
        DataSet customDs = billDataSet.filter("creditortype='custom'");
        DataSet otherDs = billDataSet.filter("creditortype='other'");
        DataSet bankTreeDs = this.createBankTree(bankDs, tarCurrencyId);
        DataSet finOrgTreeDs = this.createFinOrgTree(finorgDs, tarCurrencyId);
        settleCenterDs = this.createNotTreeDs(settleCenterDs, true, "settlecenter");
        innerUnitDs = this.createNotTreeDs(innerUnitDs, false, "innerunit");
        customDs = this.getCustomAndOther(customDs, "custom");
        otherDs = this.getCustomAndOther(otherDs, "other");
        DataSet allDataSets = bankTreeDs.select(finOrgTreeDs.getRowMeta().getFieldNames()).union(finOrgTreeDs).union(settleCenterDs).union(innerUnitDs).union(customDs).union(otherDs);
        DataSet subTotalDs = allDataSets.copy().filter(this.sumField + " = 1").updateField(this.sumField, "pid");
        DataSet allTotalDs = this.addAllTotalDataSet(subTotalDs, this.sumFields(), Collections.singletonList("currency"), ORGNAME).updateField("changerate", "case when baseamt=0 then 0.00 else round(changeamount*100/baseamt, 2) end").updateField(ROWID, String.valueOf(DBServiceHelper.genGlobalLongId())).updateField("pid", "0");
        allDataSets = this.calculationAddRate(allDataSets, allTotalDs);
        return allDataSets.union(this.addTotalFields(allTotalDs));
    }

    private DataSet addTotalFields(DataSet allTotalDs) {
        return allTotalDs.addField("0", "basechinrate").addField("0", "basegatrate").addField("0", "baseabroadrate").addField("0", "baserate").addField("0", "endchinrate").addField("0", "endgatrate").addField("0", "endabroadrate").addField("0", "endrate");
    }

    private DataSet getCustomAndOther(DataSet ds, String type) {
        long globaId = DBServiceHelper.genGlobalLongId();
        String totalCaption = FinReportHelper.getTotalCaption(type);
        DataSet newDs = ds.select(new String[]{"" + globaId + " rowid", "0 pid", "'0' isgroupnode", "0 level", "0 sumlevel", "basechinamt", "baseabroadamt", "basegatamt", "baseamt", "endchinamt", "endabroadamt", "endgatamt", "endamt", "endamt-baseamt changeamount", "'" + totalCaption + "' orgname", "currency"}).addField("case when baseamt=0 then 0.00 else round(changeamount*100/baseamt, 2) end", "changerate");
        return newDs.union(this.getNoTreeTotalDs(newDs, totalCaption));
    }

    private DataSet createNotTreeDs(DataSet ds, boolean isSettleCenter, String type) {
        Set<Long> creditorIds = this.getDataSetFieldIds(ds.copy(), "creditor");
        DataSet finorgDs = null;
        finorgDs = isSettleCenter ? FinReportHelper.getBdFinorgInfo(creditorIds, "bank_cate") : FinReportHelper.getBaseDataDs(creditorIds, "bos_org");
        String totalCaption = FinReportHelper.getTotalCaption(type);
        DataSet newDs = ds.leftJoin(finorgDs).on("creditor", "id").select(new String[]{"creditor rowid", "0 pid", "'0' isgroupnode", "0 level", "0 sumlevel", "basechinamt", "baseabroadamt", "basegatamt", "baseamt", "endchinamt", "endabroadamt", "endgatamt", "endamt", "endamt-baseamt changeamount", "name as orgname", "currency"}).finish().addField("case when baseamt=0 then 0.00 else round(changeamount*100/baseamt, 2) end", "changerate");
        DataSet noTreeTotalDs = this.getNoTreeTotalDs(newDs, totalCaption);
        return newDs.union(noTreeTotalDs);
    }

    private DataSet getNoTreeTotalDs(DataSet newDs, String totalCaption) {
        return this.addSubTotalDataSet(newDs, Collections.singletonList("currency"), this.sumFields(), ORGNAME).updateField(ORGNAME, "concat ( '" + totalCaption + "'+ orgname)").updateField("changerate", " case when baseamt=0 then 0.00 else round(changeamount*100/baseamt, 2) end ").updateField(ROWID, String.valueOf(DBServiceHelper.genGlobalLongId())).updateField("pid", "0");
    }

    private DataSet createFinOrgTree(DataSet finorgDs, Long tarCurrencyId) {
        Set<Long> bankIds = this.getDataSetFieldIds(finorgDs, "creditor");
        DataSet bdFinorgInfoDs = FinReportHelper.getBdFinorgInfo(bankIds, FINORGTYPE);
        String[] fieldNames = finorgDs.getRowMeta().getFieldNames();
        Set<Long> finTypeIds = this.getDataSetFieldIds(bdFinorgInfoDs, "pid");
        DataSet finorgTypeds = FinReportHelper.getBaseDataDs(finTypeIds, "bd_finorgtype").addField(String.valueOf(tarCurrencyId), "currency").select("'finorg' as creditortype, 0 creditor,0 basechinamt,0 basegatamt,0 baseabroadamt,0 baseamt,0 endchinamt,0 endgatamt,0 endabroadamt,0 endamt,currency,0 changeamount,id,rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = finorgDs.leftJoin(bdFinorgInfoDs).on("creditor", "id").select(fieldNames, new String[]{"endamt-baseamt as changeamount", "id", ROWID, "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish();
        DataSet finOrgTreeDs = creditorDs.union(finorgTypeds);
        DataSet sumDataSet = this.getSumDataSet(finOrgTreeDs);
        DataSet totalDs = this.getTotalDs(finOrgTreeDs, "finorg").select(sumDataSet.getRowMeta().getFieldNames());
        return sumDataSet.union(totalDs).select(new String[]{ROWID, "pid", "isgroupnode", "level", "sumlevel", "basechinamt", "baseabroadamt", "basegatamt", "baseamt", "endchinamt", "endabroadamt", "endgatamt", "endamt", "changeamount", ORGNAME, "currency", "changerate"});
    }

    private DataSet createBankTree(DataSet bankDs, Long tarCurrencyId) {
        Set<Long> bankIds = this.getDataSetFieldIds(bankDs, "creditor");
        DataSet bdFinorgInfoDs = FinReportHelper.getBdFinorgInfo(bankIds, "bank_cate");
        String[] fieldNames = bankDs.getRowMeta().getFieldNames();
        Set<Long> bankTypeIds = this.getDataSetFieldIds(bdFinorgInfoDs, "pid");
        DataSet bankcgSettingDs = FinReportHelper.getBaseDataDs(bankTypeIds, "bd_bankcgsetting").addField(String.valueOf(tarCurrencyId), "currency").select("'bank' as creditortype, 0 creditor,0 basechinamt,0 basegatamt,0 baseabroadamt,0 baseamt,0 endchinamt,0 endgatamt,0 endabroadamt,0 endamt,currency,0 changeamount,id,rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = bankDs.leftJoin(bdFinorgInfoDs).on("creditor", "id").select(fieldNames, new String[]{"endamt-baseamt as changeamount", "id", ROWID, "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish().filter("pid!=0");
        DataSet bankTreeDs = creditorDs.union(bankcgSettingDs);
        DataSet sumDataSet = this.getSumDataSet(bankTreeDs);
        DataSet totalDs = this.getTotalDs(bankTreeDs, "bank").select(sumDataSet.getRowMeta().getFieldNames());
        return sumDataSet.union(totalDs);
    }

    private DataSet getTotalDs(DataSet ds, String type) {
        String totalCaption = FinReportHelper.getTotalCaption(type);
        String orgName = "concat ( '" + totalCaption + "'+ orgname)";
        if (EmptyUtil.isEmpty((String)type)) {
            orgName = ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"FinStructureDataListPlugin_0", (String)"tmc-fbp-report", (Object[])new Object[0]);
        }
        return this.addSubTotalDataSet(ds.copy(), Collections.singletonList("currency"), this.sumFields(), ORGNAME).removeFields(new String[]{"isgroupnode"}).addNullField("isgroupnode").updateField(ROWID, String.valueOf(DBServiceHelper.genGlobalLongId())).updateField("pid", "0").updateField(ORGNAME, orgName).addField("case when baseamt=0 then 0.00 else round(changeamount*100/baseamt, 2) end", "changerate");
    }

    private DataSet calculationAddRate(DataSet sumDataSet, DataSet totalDs) {
        DataSet totalAmtds = totalDs.select(TOTAL_FIELDS.split(","));
        return sumDataSet.leftJoin(totalAmtds).on("currency", "currency").select(new String[]{ROWID, "pid", "isgroupnode", "level", "sumlevel", "basechinamt", "baseabroadamt", "basegatamt", "baseamt", "endchinamt", "endabroadamt", "endgatamt", "endamt", "changeamount", ORGNAME, "currency", "changerate", this.converfield("basechinamt", "basechinrate"), this.converfield("basegatamt", "basegatrate"), this.converfield("baseabroadamt", "baseabroadrate"), this.converfield("baseamt", "baserate"), this.converfield("endchinamt", "endchinrate"), this.converfield("endgatamt", "endgatrate"), this.converfield("endabroadamt", "endabroadrate"), this.converfield("endamt", "endrate")}).finish();
    }

    private DataSet calculationOrgAddRate(DataSet sumDataSet, DataSet totalDs) {
        List<String> totalFields = Arrays.stream(TOTAL_FIELDS.split(",")).map(f -> "currency".equals(f) ? "stat" + f : f).collect(Collectors.toList());
        DataSet totalAmtds = totalDs.select(totalFields.toArray(new String[0]));
        return sumDataSet.leftJoin(totalAmtds).on("statcurrency", "statcurrency").select(new String[]{ROWID, "pid", "isgroupnode", "level", "sumlevel", "basechinamt", "baseabroadamt", "basegatamt", "baseamt", "endchinamt", "endabroadamt", "endgatamt", "endamt", "changeamount", ORGNAME, "statcurrency", "changerate", this.converfield("basechinamt", "basechinrate"), this.converfield("basegatamt", "basegatrate"), this.converfield("baseabroadamt", "baseabroadrate"), this.converfield("baseamt", "baserate"), this.converfield("endchinamt", "endchinrate"), this.converfield("endgatamt", "endgatrate"), this.converfield("endabroadamt", "endabroadrate"), this.converfield("endamt", "endrate")}).finish();
    }

    private DataSet getRepaymentDs(DataSet loanBillDs, Map<String, Object> paramMap, boolean isBase) {
        Set<Long> loanBillIds = this.getDataSetFieldIds(loanBillDs.copy(), "id");
        QFilter filter = this.getBaseFilter().and(new QFilter("loans.e_loanbill", "in", loanBillIds));
        Date baseDate = (Date)paramMap.get("filter_basedate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        if (isBase) {
            filter.and(new QFilter("bizdate", "<=", (Object)baseDate));
        } else {
            filter.and(new QFilter("bizdate", ">", (Object)baseDate)).and(new QFilter("bizdate", "<=", (Object)endDate));
        }
        DataSet repaymentDs = this.getRepaymentDs(loanBillDs, filter);
        return repaymentDs;
    }

    private DataSet getRepaymentDs(DataSet loanBillDs, QFilter filter) {
        Set<Long> slloanBillIds = this.getDataSetFieldIds(loanBillDs.copy().filter("loantype='sl'"), "id");
        Set<Long> notSlLoanBillIds = this.getDataSetFieldIds(loanBillDs.filter("loantype!='sl'"), "id");
        DataSet repaymentDs = null;
        if (EmptyUtil.isNoEmpty(notSlLoanBillIds)) {
            QFilter notSlFilter = filter.copy().and("loans.e_loanbill", "in", notSlLoanBillIds);
            repaymentDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_notsl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,loans.e_loanbill loanid,loans.e_repayamount repayamt,case when loans.buyback_entry.e_investorid>0 then loans.buyback_entry.e_investorid else loans.buyback_entry.e_investentryid end bankid,loans.buyback_entry.e_buybackamt buybackamt", (QFilter[])new QFilter[]{notSlFilter}, null).updateField("repayamt", "case when bankid>0 then buybackamt else repayamt end").select("id,repaydate,loantype,isbuyback,loanid,repayamt,bankid");
        }
        if (EmptyUtil.isNoEmpty(slloanBillIds)) {
            QFilter slFilter = filter.and("loans.e_loanbill", "in", slloanBillIds);
            DataSet slLoandDs = QueryServiceHelper.queryDataSet((String)"getRepaymentDs_sl", (String)"cfm_repaymentbill", (String)"id,bizdate repaydate,loantype,isbuyback,slentryentity.s_loanbillno loanid,slentryentity.s_repayamount repayamt,slentryentity.s_bank bankid", (QFilter[])new QFilter[]{slFilter}, null);
            repaymentDs = repaymentDs != null ? repaymentDs.union(slLoandDs) : slLoandDs;
        }
        return repaymentDs;
    }

    private DataSet getBillDataSet(Map<String, Object> paramMap) {
        DataSet baseLoanBillDs = this.getLoandBillDs(paramMap, true);
        DataSet baseLoandRepayDs = this.getLoanBillWithRepay(baseLoanBillDs, paramMap, true);
        DataSet baseToEndLoanBillDs = this.getLoandBillDs(paramMap, false);
        DataSet endLoanBillDs = baseLoandRepayDs.copy();
        if (!baseToEndLoanBillDs.isEmpty()) {
            endLoanBillDs = endLoanBillDs.union(baseToEndLoanBillDs);
        }
        DataSet endLoandRepayDs = this.getLoanBillWithRepay(endLoanBillDs, paramMap, false);
        String statDim = (String)paramMap.get("filter_statdim");
        DataSet dsFromGroup = null;
        dsFromGroup = "org".equals(statDim) ? this.getDsByStatDimOrg(baseLoandRepayDs, endLoandRepayDs, paramMap) : ("creditor".equals(statDim) ? this.getDsByStatDimCredito(baseLoandRepayDs, endLoandRepayDs, paramMap) : this.getDsByStatDimCurrency(baseLoandRepayDs, endLoandRepayDs, paramMap));
        return dsFromGroup;
    }

    private DataSet getLoanBillWithRepay(DataSet baseLoanBillDs, Map<String, Object> paramMap, boolean isBase) {
        DataSet notSlorbackRepayDs;
        DataSet repaymentDs = this.getRepaymentDs(baseLoanBillDs.copy(), paramMap, isBase);
        if (repaymentDs == null) {
            return baseLoanBillDs;
        }
        DataSet slorbackRepayDs = repaymentDs.copy().filter("loantype='sl' or isbuyback").groupBy(new String[]{"loanid", "bankid"}).sum("repayamt").finish();
        if (!slorbackRepayDs.isEmpty()) {
            baseLoanBillDs = baseLoanBillDs.leftJoin(slorbackRepayDs).on("id", "loanid").on("creditor", "bankid").select(baseLoanBillDs.getRowMeta().getFieldNames(), new String[]{"repayamt"}).finish().updateField("amount", "amount-(case when repayamt!=null then repayamt else 0 end)").removeFields(new String[]{"repayamt"});
        }
        if (!(notSlorbackRepayDs = repaymentDs.copy().filter("loantype!='sl' and !isbuyback").groupBy(new String[]{"loanid"}).sum("repayamt").finish()).isEmpty()) {
            DataSet loanSumDs = baseLoanBillDs.groupBy(new String[]{"id"}).sum("amount").finish();
            baseLoanBillDs = baseLoanBillDs.leftJoin(loanSumDs).on("id", "id").select(baseLoanBillDs.getRowMeta().getFieldNames(), new String[]{"amount sumamount"}).finish();
            baseLoanBillDs = baseLoanBillDs.leftJoin(notSlorbackRepayDs).on("id", "loanid").select(baseLoanBillDs.getRowMeta().getFieldNames(), new String[]{"repayamt"}).finish().updateField("rate", "case when sumamount>0 then amount/sumamount else 0 end").updateField("amount", "amount-(case when repayamt!=null then repayamt*rate else 0 end)").removeFields(new String[]{"repayamt", "sumamount"});
        }
        return baseLoanBillDs.updateField("amount", "case when amount>0 then amount else 0 end");
    }

    private DataSet getDsByStatDimCurrency(DataSet baseLoandRepayDs, DataSet endLoandRepayDs, Map<String, Object> paramMap) {
        DataSet baseLoandRepayGroupDs = baseLoandRepayDs.groupBy(new String[]{"currency", REGION}).sum("amount").finish();
        DataSet baseSumDs = this.getDsConverEx(baseLoandRepayGroupDs, paramMap, true, new String[]{REGION, "currency"});
        DataSet endLoandRepayGroupDs = endLoandRepayDs.groupBy(new String[]{"currency", REGION}).sum("amount").finish();
        DataSet endSumDs = this.getDsConverEx(endLoandRepayGroupDs, paramMap, false, new String[]{REGION, "currency"}).select(new String[]{"currency currency1", "region region1", "amount amount1"});
        DataSet baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("currency", "currency1").on(REGION, "region1").select(new String[]{"( case when currency=null then currency1 else currency end ) currency ", "( case when region=null then region1 else region end ) region", "amount", "amount1"}).finish();
        DataSet dsFromGroupCurrency = this.getDsFromGroupCurrency(baseAndEndDs).select(new String[]{"currency", "basechinamt", "basegatamt", "baseabroadamt", "basechinamt+basegatamt+baseabroadamt baseamt", "endchinamt", "endgatamt", "endabroadamt", "endchinamt+endgatamt+endabroadamt endamt"});
        return dsFromGroupCurrency.filter("baseamt!=0 or endamt!=0");
    }

    private DataSet getDsFromGroupCurrency(DataSet baseAndEndDs) {
        DataSet regionR1Group = baseAndEndDs.filter("region='R1'").select(new String[]{"currency currency1", "amount basechinamt", "amount1 endchinamt"});
        DataSet regionR2Group = baseAndEndDs.filter("region='R2'").select(new String[]{"currency currency2", "amount basegatamt", "amount1 endgatamt"});
        DataSet regionR3Group = baseAndEndDs.filter("region='R3'").select(new String[]{"currency currency3", "amount baseabroadamt", "amount1 endabroadamt"});
        DataSet groupR12Ds = regionR1Group.fullJoin(regionR2Group).on("currency1", "currency2").select(new String[]{"(case when currency1=null then currency2 else currency1 end ) currency12", "basechinamt", "basegatamt", "endchinamt", "endgatamt"}).finish().updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end ").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ");
        return groupR12Ds.fullJoin(regionR3Group).on("currency12", "currency3").select(new String[]{"( case when currency12=null then currency3 else currency12 end ) currency", "basechinamt", "basegatamt", "baseabroadamt", "endchinamt", "endgatamt", "endabroadamt"}).finish().updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end").updateField("baseabroadamt", "case when baseabroadamt=null then 0 else baseabroadamt end").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ").updateField("endabroadamt", "case when endabroadamt=null then 0 else endabroadamt end ");
    }

    private DataSet getDsByStatDimCredito(DataSet baseLoandRepayDs, DataSet endLoandRepayDs, Map<String, Object> paramMap) {
        DataSet baseLoandRepayGroupDs = baseLoandRepayDs.groupBy(new String[]{"creditortype", "creditor", "currency", REGION}).sum("amount").finish();
        DataSet baseSumDs = this.getDsConverEx(baseLoandRepayGroupDs, paramMap, true, new String[]{"creditortype", "creditor", REGION});
        DataSet endLoandRepayGroupDs = endLoandRepayDs.groupBy(new String[]{"creditortype", "creditor", "currency", REGION}).sum("amount").finish();
        DataSet endSumDs = this.getDsConverEx(endLoandRepayGroupDs, paramMap, false, new String[]{"creditortype", "creditor", REGION}).select(new String[]{"creditortype creditortype1", "creditor creditor1", "region region1", "amount amount1"});
        DataSet baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("creditortype", "creditortype1").on("creditor", "creditor1").on(REGION, "region1").select(new String[]{"( case when creditortype=null then creditortype1 else creditortype end ) creditortype ", "( case when creditor=null then creditor1 else creditor end ) creditor ", "( case when region=null then region1 else region end ) region", "amount", "amount1"}).finish();
        DataSet dsFromGroup = this.getDsFromGroupCreditor(baseAndEndDs).select(new String[]{"creditortype", "creditor", "basechinamt", "basegatamt", "baseabroadamt", "basechinamt+basegatamt+baseabroadamt baseamt", "endchinamt", "endgatamt", "endabroadamt", "endchinamt+endgatamt+endabroadamt endamt"});
        return dsFromGroup.filter("baseamt!=0 or endamt!=0");
    }

    private DataSet getDsByStatDimOrg(DataSet baseLoandRepayDs, DataSet endLoandRepayDs, Map<String, Object> paramMap) {
        DataSet baseLoandRepayGroupDs = baseLoandRepayDs.copy().groupBy(new String[]{"org", "currency", REGION}).sum("amount").finish();
        DataSet baseSumDs = this.getDsConverEx(baseLoandRepayGroupDs, paramMap, true, new String[]{"org", REGION});
        DataSet endLoandRepayGroupDs = endLoandRepayDs.copy().groupBy(new String[]{"org", "currency", REGION}).sum("amount").finish();
        DataSet endSumDs = this.getDsConverEx(endLoandRepayGroupDs, paramMap, false, new String[]{"org", REGION}).select(new String[]{"org org1", "region region1", "amount amount1"});
        DataSet baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("org", "org1").on(REGION, "region1").select(new String[]{"( case when org=null then org1 else org end ) org", "( case when region=null then region1 else region end ) region", "amount", "amount1"}).finish();
        return this.getDsFromGroupOrg(baseAndEndDs).select(new String[]{"org", "basechinamt", "basegatamt", "baseabroadamt", "basechinamt+basegatamt+baseabroadamt baseamt", "endchinamt", "endgatamt", "endabroadamt", "endchinamt+endgatamt+endabroadamt endamt"});
    }

    private DataSet getDsConverEx(DataSet loandRepayGroupDs, Map<String, Object> paramMap, boolean isBase, String[] strArr) {
        Long tarCurrencyId = (Long)paramMap.get("filter_statcurrency");
        DataSet currencyDataSet = loandRepayGroupDs.copy().groupBy(new String[]{"currency"}).finish();
        Date baseDate = (Date)paramMap.get("filter_basedate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        Long orgId = Long.parseLong(String.valueOf(paramMap.get("org")));
        ArrayList currencyIdList = new ArrayList(10);
        currencyDataSet.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
        String queryWay = (String)paramMap.get("filter_queryway");
        DataSet exChangeDataSet = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)tarCurrencyId, (long)orgId, (Date)(isBase ? baseDate : endDate), (!QueryTypeEnum.isOrgview((String)queryWay) ? 1 : 0) != 0);
        String unit = String.valueOf(paramMap.get("filter_currencyunit"));
        return loandRepayGroupDs.leftJoin(exChangeDataSet).on("currency", "tarcurrency").select(strArr, new String[]{"tarcurrency", String.format("amount*rate/%s", unit) + " amount"}).finish().groupBy(strArr).sum("amount").finish();
    }

    private DataSet getDsFromGroupCreditor(DataSet loanBillDs) {
        DataSet customAmdOtherDs = loanBillDs.filter("creditortype='custom' or creditortype='other' ").groupBy(new String[]{"creditortype", REGION}).sum("amount").sum("amount1").finish().select(new String[]{"creditortype", "0 creditor", REGION, "amount", "amount1"});
        loanBillDs = loanBillDs.filter("creditortype!='custom' and creditortype!='other' ").union(customAmdOtherDs);
        DataSet regionR1Group = loanBillDs.filter("region='R1'").select(new String[]{"creditortype creditortype1", "creditor creditor1", "amount basechinamt", "amount1 endchinamt"});
        DataSet regionR2Group = loanBillDs.filter("region='R2'").select(new String[]{"creditortype creditortype2", "creditor creditor2", "amount basegatamt", "amount1 endgatamt"});
        DataSet regionR3Group = loanBillDs.filter("region='R3'").select(new String[]{"creditortype creditortype3", "creditor creditor3", "amount baseabroadamt", "amount1 endabroadamt"});
        DataSet groupR12Ds = regionR1Group.fullJoin(regionR2Group).on("creditortype1", "creditortype2").on("creditor1", "creditor2").select(new String[]{"(case when creditortype1=null then creditortype2 else creditortype1 end ) creditortype12", "(case when creditor1=null then creditor2 else creditor1 end ) creditor12", "basechinamt", "basegatamt", "endchinamt", "endgatamt"}).finish();
        groupR12Ds = this.updateFieldDs(groupR12Ds);
        DataSet ds = groupR12Ds.fullJoin(regionR3Group).on("creditortype12", "creditortype3").on("creditor12", "creditor3").select(new String[]{"( case when creditortype12=null then creditortype3 else creditortype12 end ) creditortype", "( case when creditor12=null then creditor3 else creditor12 end ) creditor", "basechinamt", "basegatamt", "baseabroadamt", "endchinamt", "endgatamt", "endabroadamt"}).finish();
        return this.updateRegionField(ds);
    }

    private DataSet updateFieldDs(DataSet groupR12Ds) {
        return groupR12Ds.updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end ").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ");
    }

    private DataSet updateRegionField(DataSet ds) {
        return ds.updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end").updateField("baseabroadamt", "case when baseabroadamt=null then 0 else baseabroadamt end").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ").updateField("endabroadamt", "case when endabroadamt=null then 0 else endabroadamt end ");
    }

    private DataSet getDsFromGroupOrg(DataSet loanBillDs) {
        DataSet regionR1Group = loanBillDs.filter("region='R1'").select(new String[]{"org org1", "amount basechinamt", "amount1 endchinamt"});
        DataSet regionR2Group = loanBillDs.filter("region='R2'").select(new String[]{"org org2", "amount basegatamt", "amount1 endgatamt"});
        DataSet regionR3Group = loanBillDs.filter("region='R3'").select(new String[]{"org org3", "amount baseabroadamt", "amount1 endabroadamt"});
        DataSet groupR12Ds = regionR1Group.fullJoin(regionR2Group).on("org1", "org2").select(new String[]{"(case when org1=null then org2 else org1 end ) org12", "basechinamt", "basegatamt", "endchinamt", "endgatamt"}).finish();
        groupR12Ds = this.updateFieldDs(groupR12Ds);
        DataSet ds = groupR12Ds.fullJoin(regionR3Group).on("org12", "org3").select(new String[]{"( case when org12=null then org3 else org12 end ) org", "basechinamt", "basegatamt", "baseabroadamt", "endchinamt", "endgatamt", "endabroadamt"}).finish();
        return this.updateRegionField(ds);
    }

    private DataSet formatDsRate(DataSet unionDs) {
        return unionDs.updateField("basechinrate", " case when basechinrate=0 or basechinrate=null then 0.00 else round(basechinrate,2) end ").updateField("basegatrate", " case when basegatrate=0 or basegatrate=null then 0.00 else round(basegatrate,2) end ").updateField("baseabroadrate", " case when baseabroadrate=0 or baseabroadrate=null then 0.00 else round(baseabroadrate,2) end ").updateField("baserate", " case when baserate=0 or baserate=null then 0.00 else round(baserate,2) end ").updateField("endchinrate", " case when endchinrate=0 or endchinrate=null then 0.00 else round(endchinrate,2) end ").updateField("endgatrate", " case when endgatrate=0 or endgatrate=null then 0.00 else round(endgatrate,2) end ").updateField("endabroadrate", " case when endabroadrate=0 or endabroadrate=null then 0.00 else round(endabroadrate,2) end").updateField("endrate", " case when endrate=0 or endrate=null then 0.00 else round(endrate,2) end").updateField("changerate", " case when changerate=0 or changerate=null then 0.00 else round(changerate,2) end ");
    }

    private QFilter getFilter(Map<String, Object> paramMap, boolean isBase) {
        QFilter filter = this.getBaseFilter();
        Date baseDate = (Date)paramMap.get("filter_basedate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        if (isBase) {
            filter.and(new QFilter("bizdate", "<=", (Object)baseDate));
        } else {
            filter.and(new QFilter("bizdate", ">", (Object)baseDate)).and(new QFilter("bizdate", "<=", (Object)endDate));
        }
        DynamicObjectCollection finpoducts = (DynamicObjectCollection)paramMap.get("filter_finproduct");
        if (finpoducts != null && !finpoducts.isEmpty()) {
            Set productIds = finpoducts.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            filter.and(new QFilter("finproduct", "in", productIds));
        }
        List orgIds = (List)paramMap.get(ORGIDS);
        filter.and(new QFilter("org", "in", (Object)orgIds));
        String regionsStr = (String)paramMap.get("filter_region");
        if (EmptyUtil.isNoEmpty((String)regionsStr)) {
            Set regions = Arrays.stream(regionsStr.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            filter.and(new QFilter(REGION, "in", regions));
        }
        return filter;
    }

    private QFilter getCreditortypeFilter(QFilter filter, Map<String, Object> paramMap, String loantype) {
        String creditType = (String)paramMap.get("filter_creditortype");
        filter.and(FinReportHelper.getLoandTypeFilter(loantype));
        if (EmptyUtil.isNoEmpty((String)creditType)) {
            Set types = Arrays.stream(creditType.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            if ("sl".equals(loantype)) {
                if (!types.isEmpty() && !types.contains("bank")) {
                    return null;
                }
                return filter;
            }
            if ("bond".equals(loantype)) {
                filter.and(new QFilter("investor_entry.e_investortype", "in", types));
            } else {
                filter.and(new QFilter("creditortype", "in", types));
            }
        }
        return filter;
    }

    private String converfield(String field, String fieldRate) {
        return "case when t" + field + "=0 then 0.00 else " + field + "*100/t" + field + " end " + fieldRate + "";
    }

    private Set<Long> getDataSetFieldIds(DataSet billDataSet, String field) {
        HashSet<Long> billIds = new HashSet<Long>();
        billDataSet.copy().forEach(o -> billIds.add(o.getLong(field)));
        return billIds;
    }

    private QFilter getBaseFilter() {
        return new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("confirmstatus", "=", (Object)"yetconfirm"));
    }

    private DataSet getSumDataSet(DataSet treeData) {
        treeData = this.getSumDataSetByLevel(treeData.copy(), this.sumFields(), "orgname,currency");
        return treeData.addField("case when baseamt=0 then 0.00 else round(changeamount*100/baseamt, 2) end ", "changerate");
    }

    private List<String> sumFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("basechinamt");
        fields.add("baseabroadamt");
        fields.add("basegatamt");
        fields.add("baseamt");
        fields.add("endchinamt");
        fields.add("endabroadamt");
        fields.add("endgatamt");
        fields.add("endamt");
        fields.add("changeamount");
        return fields;
    }

    private DataSet convertTotalRate(DataSet rowDs) {
        if (rowDs == null || rowDs.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        return rowDs.updateField("basechinrate", this.getExp("basechinrate")).updateField("basegatrate", this.getExp("basegatrate")).updateField("baseabroadrate", this.getExp("baseabroadrate")).updateField("baserate", this.getExp("baserate")).updateField("endchinrate", this.getExp("endchinrate")).updateField("endgatrate", this.getExp("endgatrate")).updateField("endabroadrate", this.getExp("endabroadrate")).updateField("endrate", this.getExp("endrate"));
    }

    protected boolean isNeedOrgTree() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        return "org".equals(statdim);
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    protected List<String> orinalAmountField() {
        return Collections.emptyList();
    }

    public List<String> sumAmountFields() {
        return this.sumFields();
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)ORGNAME);
    }
}

