/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class HugeFundFlowSumDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String TRANSDETAIL_SELECT = "company as org,company.name as orgname,bank,bank.name as bankname,currency,currency.name as currencyname,creditamount as flowinamount,debitamount as flowoutamount";
    private static final String BANKJOURNAL_SELECT = "org,org.name as orgname,accountbank.bank as bank,accountbank.bank.name as bankname,currency,currency.name as currencyname,debitamount as flowinamount,creditamount as flowoutamount";
    private static final Long DEFAULTORGVIEWID = 8L;
    private String statDim;
    private String showStep;
    private String bankLevel;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paraMap = this.transQueryParam(queryParam);
        this.initParams(paraMap);
        List orgIds = this.getQueryOrgIds(queryParam);
        List<QFilter> qFilters = this.buildQueryFilters(paraMap, orgIds);
        DataSet dataSet = this.queryPrimaryData(qFilters, paraMap);
        return this.getDsConverEx(dataSet, paraMap);
    }

    private void initParams(Map<String, Object> paraMap) {
        this.statDim = (String)paraMap.get("filter_statdim");
        this.showStep = (String)paraMap.get("filter_showttype");
        this.bankLevel = (String)paraMap.get("filter_banklevel");
    }

    protected boolean isNeedOrgTree() {
        return this.isTreeDataSet();
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"dyncolid", (Object)"dyncol");
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        return bizDs;
    }

    public String sumNameField() {
        return "dyncol";
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("flowinamount", "flowoutamount", "pureamount");
    }

    private List<QFilter> buildQueryFilters(Map<String, Object> paraMap, List<Long> orgIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Date startDate = (Date)paraMap.get("filter_startdate");
        Date endDate = (Date)paraMap.get("filter_enddate");
        String dataSource = (String)paraMap.get("filter_datasource");
        if ("A".equals(dataSource)) {
            List bankIds = (List)paraMap.get("filter_openbank");
            if (EmptyUtil.isNoEmpty((Object)bankIds)) {
                qFilters.add(new QFilter("bank", "in", (Object)bankIds));
            }
            qFilters.add(new QFilter("company", "in", orgIds));
            qFilters.add(new QFilter("biztime", ">=", (Object)startDate));
            qFilters.add(new QFilter("biztime", "<", (Object)endDate));
        } else {
            List bankAcctIds = (List)paraMap.get("filter_bankacct");
            if (EmptyUtil.isNoEmpty((Object)bankAcctIds)) {
                qFilters.add(new QFilter("accountbank", "in", (Object)bankAcctIds));
            }
            qFilters.add(new QFilter("org", "in", orgIds));
            qFilters.add(new QFilter("bookdate", ">=", (Object)startDate));
            qFilters.add(new QFilter("bookdate", "<", (Object)endDate));
        }
        return qFilters;
    }

    private DataSet queryPrimaryData(List<QFilter> qFilters, Map<String, Object> paraMap) {
        DataSet dataSet = "A".equals(paraMap.get("filter_datasource")) ? QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bei_transdetail", (String)TRANSDETAIL_SELECT, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"") : QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_bankjournal", (String)BANKJOURNAL_SELECT, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
        return dataSet;
    }

    private DataSet getDsConverEx(DataSet dataSet, Map<String, Object> paraMap) {
        DataSet resDs;
        DataSet exChangeDataSet = this.getExChangeRateDs(dataSet, paraMap);
        exChangeDataSet = exChangeDataSet.select("rate as exchrate, tarcurrency");
        String unit = (String)paraMap.get("filter_currencyunit");
        DataSet exchangedDs = dataSet.leftJoin(exChangeDataSet).on("currency", "tarcurrency").select(new String[]{"org", "orgname", "bank", "bankname", "currency", "currencyname"}, new String[]{String.format("flowinamount*exchrate/%s", unit) + " flowinamount", String.format("flowoutamount*exchrate/%s", unit) + " flowoutamount"}).finish();
        if (StringUtils.equals((CharSequence)"b", (CharSequence)this.statDim) && StringUtils.equals((CharSequence)"1", (CharSequence)this.bankLevel)) {
            DataSet tmpDs = this.dealDataSetByBankLevel(exchangedDs);
            resDs = tmpDs.select("bankcgname as dyncol,bankcgid as dyncolid,org,flowinamount,flowoutamount");
        } else {
            resDs = exchangedDs.select(this.getDynColumn(this.statDim) + ",org,flowinamount,flowoutamount");
        }
        DataSet afterGroupDs = resDs.groupBy(new String[]{"dyncol", "dyncolid"}).sum("flowinamount").sum("flowoutamount").sum("flowinamount-flowoutamount", "pureamount").finish();
        return afterGroupDs;
    }

    private String getDynColumn(String statDim) {
        String dynCol = "";
        if (StringUtils.equals((CharSequence)"o", (CharSequence)statDim)) {
            dynCol = "orgname as dyncol,org as dyncolid";
        } else if (StringUtils.equals((CharSequence)"b", (CharSequence)statDim)) {
            dynCol = "bankname as dyncol,bank as dyncolid";
        } else if (StringUtils.equals((CharSequence)"c", (CharSequence)statDim)) {
            dynCol = "currencyname as dyncol,currency as dyncolid";
        }
        return dynCol;
    }

    private DataSet dealDataSetByBankLevel(DataSet dataSet) {
        DataSet bankDs = dataSet.copy().select("bank").distinct();
        HashSet bankSet = new HashSet();
        bankDs.forEach(r -> bankSet.add(r.getLong("bank")));
        QFilter bankQF = new QFilter("id", "in", bankSet);
        DataSet bdBankDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_bank"), (String)CreditorTypeEnum.BANK.getFormId(), (String)"id bankid, bank_cate.name bankcgname,bank_cate.id bankcgid", (QFilter[])bankQF.toArray(), null);
        return dataSet.join(bdBankDs).on("bank", "bankid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"bankcgname", "bankcgid"}).finish();
    }

    private boolean isTreeDataSet() {
        return StringUtils.equals((CharSequence)"o", (CharSequence)this.statDim) && StringUtils.equals((CharSequence)"step", (CharSequence)this.showStep);
    }
}

