/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.DebtsBizTypeEnum;
import kd.tmc.mon.report.data.InDebtsAnalysisDataBuider;

public class InDebtsAnalysisDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(InDebtsAnalysisDataListPlugin.class);
    private List<String> dynamicColList = new ArrayList<String>(10);
    private List<String> bizAmtColList = new ArrayList<String>(10);
    private Map<String, String> billtypeNameToKeyMap = new HashMap<String, String>(16);
    private Map<String, String> billtypeKeyToNameMap = new HashMap<String, String>(16);
    private List<String> cdmDynCols = new ArrayList<String>(10);
    private List<String> lcDynCols = new ArrayList<String>(10);
    private List<String> cfmRepayDynCols = new ArrayList<String>(10);
    private List<String> bondRepayDynCols = new ArrayList<String>(10);
    private Boolean isCdmMerge = Boolean.FALSE;
    private Boolean isLcMerge = Boolean.FALSE;
    private Boolean isCfmRepayMerge = Boolean.FALSE;
    private Boolean isBondRepayMerge = Boolean.FALSE;
    private final List<String> dynRow2ColGroupFields = Arrays.asList("creditor", "creditortext");
    private static final String SELECT_FIELDS = "creditor,creditortext,countbilltype,currency,amount";
    private static final String LONA_FIELDS = "id, creditor, textcreditor as creditortext, finproduct.name as countbilltype,currency,drawamount amount,1 radio";
    private static final String SL_FIELDS = "id,case when banksyndicate_entry.e_bank >0  then banksyndicate_entry.e_bank else banksyndicate_entry.id end as creditor,banksyndicate_entry.e_bank.name creditortext, finproduct.name as countbilltype, currency,banksyndicate_entry.e_shareamount amount, banksyndicate_entry.e_shareamount/drawamount radio";
    private static final String BOND_FIELDS = "id, investor_entry.e_investorid as creditor,investor_entry.e_investorname as creditortext, finproduct.name as countbilltype,currency, investor_entry.e_investamount amount, investor_entry.e_investamount/drawamount  radio";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        DataSet data = this.getDataSet(queryParam, paramMap);
        if (null == data || data.isEmpty()) {
            RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"creditor").createDataSetBuilder(rowMeta).build();
        }
        DataSet resultDataSet = this.addExchangeRateAndCurrencyUnit(data, paramMap);
        ArrayList<String> groupFileds = new ArrayList<String>(this.dynRow2ColGroupFields);
        groupFileds.add("countbilltype");
        resultDataSet = resultDataSet.groupBy(groupFileds.toArray(new String[0])).sum("amount_report", "amount").finish();
        resultDataSet = this.dealRow2Col(resultDataSet);
        resultDataSet = this.dealIsMergeData(resultDataSet, paramMap);
        resultDataSet = this.unionCreditmLimitDaSet(resultDataSet, paramMap);
        Long tarCurrencyId = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        String totalJoinExp = String.join((CharSequence)"+", this.bizAmtColList);
        resultDataSet = resultDataSet.addField(tarCurrencyId.toString(), "tarcurrency").addField(totalJoinExp, "total").addField("0", this.sumField);
        ArrayList<String> sumAmtFields = new ArrayList<String>(this.bizAmtColList);
        sumAmtFields.add("total");
        sumAmtFields.add("limitamt");
        DataSet totalDateSet = this.addAllTotalDataSet(resultDataSet, sumAmtFields, Collections.singletonList("tarcurrency"), "creditortext");
        Row row = (Row)totalDateSet.copy().iterator().next();
        BigDecimal total = row.getBigDecimal("total");
        BigDecimal limitTotalAmt = row.getBigDecimal("limitamt");
        resultDataSet = resultDataSet.addField(String.format("total*100/%s", total), "debtspercent").addField(String.format("case when %s =0 then 0 else  limitamt*100/%s end", limitTotalAmt, limitTotalAmt), "limitpercent");
        totalDateSet = totalDateSet.addField("0", "debtspercent").addField("0", "limitpercent");
        resultDataSet = this.addFinTreeStructure(resultDataSet).orderBy(new String[]{"sumlevel desc"});
        List<String> totalColList = this.getResultColList(String.format("'%s' as rowid", DB.genGlobalLongId()), "'0' as pid", "'0' isgroupnode", "creditortext", "''  as pname", "2  sumlevel");
        resultDataSet = resultDataSet.union(totalDateSet.select(totalColList.toArray(new String[0]))).addField(tarCurrencyId.toString(), "tarcurrency");
        return resultDataSet.removeFields(new String[]{"pname"});
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        for (AbstractReportColumn column : columns) {
            this.setColIsHide((ReportColumn)column);
        }
        for (String colStr : this.dynamicColList) {
            ReportColumn cols = new ReportColumn();
            cols.setFieldKey(colStr);
            cols.setFieldType("amount");
            cols.setZeroShow(false);
            cols.setCurrencyField("tarcurrency");
            cols.setHyperlink(false);
            cols.setCaption(new LocaleString(this.billtypeKeyToNameMap.get(colStr).substring(2)));
            columns.add(1, (AbstractReportColumn)cols);
        }
        return columns;
    }

    private DataSet addFinTreeStructure(DataSet dataSet) {
        HashSet<Object> finOrgIds = new HashSet<Object>();
        for (Row row : dataSet.copy()) {
            finOrgIds.add(row.get("creditor"));
        }
        QFilter bankFilter = new QFilter("id", "in", finOrgIds).and("finorgtype.type", "=", (Object)"0");
        DataSet bankDataSets = QueryServiceHelper.queryDataSet((String)"bd_finorginfo_tree", (String)"bd_finorginfo", (String)"id,name,bank_cate,bank_cate.name pcatename,3 as sumlevel", (QFilter[])bankFilter.toArray(), (String)"bank_cate");
        if (!bankDataSets.isEmpty()) {
            List<String> resultColList = this.getResultColList("concat(creditor,'_', creditortext, '_', sumlevel) as rowid", "concat(bank_cate,'') as pid", "'0' as isgroupnode", "creditortext", "pcatename  as pname", "sumlevel");
            DataSet parentSumDs = this.getParentSumDs(dataSet = dataSet.leftJoin(bankDataSets).on("creditor", "id").select(resultColList.toArray(new String[0])).finish());
            if (EmptyUtil.isNoEmpty((Object)parentSumDs)) {
                dataSet = dataSet.union(parentSumDs);
            }
        } else {
            List<String> resultColList = this.getResultColList(String.format("'%s' as rowid", DB.genGlobalLongId()), "'0' as pid", "'0' isgroupnode", "creditortext", "''  as pname", "0 sumlevel");
            dataSet = dataSet.select(resultColList.toArray(new String[0]));
        }
        return dataSet.updateFields(new String[]{"isgroupnode", "pid"}, new String[]{"case when isgroupnode = null then '0' else isgroupnode end as isgroupnode", "case when pname is null then '0' else pid end as pid"});
    }

    private DataSet getParentSumDs(DataSet bankDs) {
        GroupbyDataSet groupbyDataSet = bankDs.copy().filter("pid > 0").groupBy(new String[]{"pid", "pname"});
        for (String sumField : this.bizAmtColList) {
            groupbyDataSet.sum(sumField);
        }
        DataSet pidGroupDataSet = groupbyDataSet.sum("total").sum("debtspercent").sum("limitamt").sum("limitpercent").finish();
        List<String> selectFields = this.getResultColList("concat(pid,'') as rowid", "'0' as pid", "'1' as isgroupnode", "pname as creditortext", "'' pname", "3 as sumlevel");
        return pidGroupDataSet.select(selectFields.toArray(new String[0]));
    }

    private List<String> getResultColList(String rowid, String pid, String isgroupnode, String creditortext, String pname, String sumField) {
        ArrayList<String> selectFields = new ArrayList<String>(12);
        selectFields.add(creditortext);
        selectFields.add(rowid);
        selectFields.add(pid);
        selectFields.add(isgroupnode);
        selectFields.add(pname);
        selectFields.add(sumField);
        selectFields.addAll(this.bizAmtColList);
        selectFields.add("total");
        selectFields.add("debtspercent");
        selectFields.add("limitamt");
        selectFields.add("limitpercent");
        return selectFields;
    }

    private DataSet unionCreditmLimitDaSet(DataSet resultDataSet, Map<String, Object> paramMap) {
        HashSet<Object> creditorIds = new HashSet<Object>();
        DataSet dataSet = resultDataSet.copy();
        for (Row row : dataSet) {
            creditorIds.add(row.get("creditor"));
        }
        Date selectDate = (Date)paramMap.get("filter_selectdate");
        QFilter limitFilter = new QFilter("bank", "in", creditorIds).and("bank", ">", (Object)0).and("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("startdate", "<=", (Object)selectDate);
        DataSet limitDS = QueryServiceHelper.queryDataSet((String)"creditlimit", (String)"cfm_creditlimit", (String)"id,bank,currency,totalamt as amount", (QFilter[])limitFilter.toArray(), null);
        if (EmptyUtil.isNoEmpty((Object)limitDS) && !limitDS.isEmpty()) {
            DataSet limitDataSet = this.addExchangeRateAndCurrencyUnit(limitDS, paramMap);
            limitDataSet = limitDataSet.groupBy(new String[]{"bank"}).sum("amount_report", "limitamt").finish();
            String[] resultFields = resultDataSet.getRowMeta().getFieldNames();
            return resultDataSet.leftJoin(limitDataSet).on("creditor", "bank").select(resultFields, new String[]{"limitamt"}).finish();
        }
        return resultDataSet.addField("0", "limitamt");
    }

    private QFilter getParmComonFilter(ReportQueryParam param, InDebtsAnalysisDataBuider debtsBean) {
        QFilter commFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        List applyOrg = this.getQueryOrgIds(param, "filter_org", "filter_orgview");
        commFilter.and(debtsBean.getOrg(), "in", (Object)applyOrg);
        commFilter.and(debtsBean.getCurrency(), ">", (Object)0);
        commFilter.and(debtsBean.getCount(), ">", (Object)0);
        return commFilter;
    }

    private DataSet queryCDMDataSet(ReportQueryParam param, Map<String, Object> paramMap) {
        InDebtsAnalysisDataBuider debtsBean = InDebtsAnalysisDataBuider.getObjByDebtsType(DebtsBizTypeEnum.CDM.getCode());
        QFilter cdmFilter = this.getParmComonFilter(param, debtsBean);
        DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get("filter_bank");
        if (banks != null && !banks.isEmpty()) {
            List creditorNames = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            cdmFilter.and(debtsBean.getBank(), "in", creditorNames);
        } else {
            cdmFilter.and(debtsBean.getBank(), ">", (Object)0);
        }
        cdmFilter.and(new QFilter("draftbillstatus", "!=", (Object)"splited"));
        cdmFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
        Date queryDate = (Date)paramMap.get("filter_selectdate");
        cdmFilter.and(new QFilter("issuedate", "<=", (Object)queryDate));
        this.getDueDateRange(cdmFilter, "draftbillexpiredate", paramMap);
        logger.info(String.format("draftBalance query param:%s", cdmFilter));
        return QueryServiceHelper.queryDataSet((String)"queryDraftBalance", (String)"cdm_payablebill", (String)"draweraccount.bank as creditor ,draweraccount.bank.name as creditortext, draftbilltype.name as countbilltype,currency,amount", (QFilter[])cdmFilter.toArray(), null);
    }

    private DataSet queryLCDataSet(ReportQueryParam param, Map<String, Object> paramMap) {
        InDebtsAnalysisDataBuider debtsBean = InDebtsAnalysisDataBuider.getObjByDebtsType(DebtsBizTypeEnum.LC.getCode());
        QFilter lcFilter = this.getParmComonFilter(param, debtsBean);
        DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get("filter_bank");
        if (banks != null && !banks.isEmpty()) {
            List creditorNames = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            lcFilter.and(debtsBean.getBank(), "in", creditorNames);
        } else {
            lcFilter.and(debtsBean.getBank(), ">", (Object)0);
        }
        Date queryDate = (Date)paramMap.get("filter_selectdate");
        lcFilter.and(new QFilter("arrivaldate", "<=", (Object)queryDate));
        this.getDueDateRange(lcFilter, "endpaydate", paramMap);
        logger.info(String.format("creditBalance query param:%s", lcFilter.toString()));
        DataSet dataResult = QueryServiceHelper.queryDataSet((String)"queryCreditBalance", (String)"lc_arrival", (String)"id,lettercredit.bank as creditor,lettercredit.bank.name as creditortext,credittype.name as countbilltype,arrivalcurrency as currency,arrivalamount as amount", (QFilter[])lcFilter.toArray(), null);
        if (EmptyUtil.isEmpty((Object)dataResult)) {
            return dataResult;
        }
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (Row row : dataResult.copy()) {
            ids.add(row.get("id"));
        }
        QFilter payFilter = new QFilter("entrys.realpaydate", "<=", (Object)queryDate);
        payFilter.and("id", "in", ids);
        DataSet payInfo = QueryServiceHelper.queryDataSet((String)"queryCreditPayBalance", (String)"lc_arrival", (String)"id,entrys.arrpayamount as arrpayamount", (QFilter[])payFilter.toArray(), null);
        if (!payInfo.isEmpty()) {
            String[] fieldNames = dataResult.getRowMeta().getFieldNames();
            payInfo = payInfo.groupBy(new String[]{"id"}).sum("arrpayamount").finish();
            dataResult = dataResult.leftJoin(payInfo).on("id", "id").select(fieldNames, new String[]{"arrpayamount"}).finish();
            dataResult = dataResult.updateField("arrpayamount", "case when arrpayamount is null then 0 else arrpayamount end");
            dataResult = dataResult.updateField("amount", "amount - arrpayamount");
        }
        return dataResult.select(new String[]{"creditor", "creditortext", "countbilltype", "currency", "amount"}).filter("amount != 0");
    }

    private static DataSet unionDataSet(DataSet left, DataSet right) {
        if (right.isEmpty()) {
            return left;
        }
        return left.isEmpty() ? right : left.union(right);
    }

    private DataSet queryCFMDataSet(ReportQueryParam param, Map<String, Object> paramMap) {
        DataSet slRepayScrDataSet;
        DataSet loanScrDataSet;
        InDebtsAnalysisDataBuider debtsBean = InDebtsAnalysisDataBuider.getObjByDebtsType(DebtsBizTypeEnum.CFMREPAY.getCode());
        QFilter cfmRepayFilter = this.getParmComonFilter(param, debtsBean);
        Date queryDate = (Date)paramMap.get("filter_selectdate");
        this.getDueDateRange(cfmRepayFilter, "expiredate", paramMap);
        cfmRepayFilter.and(new QFilter("bizdate", "<=", (Object)queryDate)).and("confirmstatus", "=", (Object)"yetconfirm").and(QFilter.of((String)"cleardate is null", (Object[])new Object[0]).or(QFilter.of((String)"cleardate is not null", (Object[])new Object[0]).and("cleardate", ">", (Object)queryDate)));
        QFilter loanTypeFilter = new QFilter("loantype", "in", (Object)new String[]{"loan", "entrust", "ec"}).and(new QFilter("textcreditor", "!=", (Object)" ").or(new QFilter("textcreditor", "!=", (Object)"")));
        DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get("filter_bank");
        if (banks != null && !banks.isEmpty()) {
            List bankIds = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            loanTypeFilter.and(debtsBean.getBank(), "in", bankIds);
        }
        DataSet loanRepayScrDataSet = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_repay_loan", (String)"cfm_loanbill", (String)LONA_FIELDS, (QFilter[])new QFilter[]{cfmRepayFilter, loanTypeFilter}, null);
        String otherName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InDebtsAnalysisDataListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
        loanRepayScrDataSet = loanRepayScrDataSet.select(new String[]{"id", "case when creditor >0 then creditor else 999 end as creditor", "case when creditor >0 then creditortext else '" + otherName + "' end  as creditortext", "countbilltype", "currency", "amount", "radio"});
        QFilter slTypeFilter = new QFilter("loantype", "=", (Object)"sl").and("banksyndicate_entry.id", ">", (Object)0).and(new QFilter("banksyndicate_entry.e_bank.name", "!=", (Object)" ").or(new QFilter("banksyndicate_entry.e_bank.name", "!=", (Object)"")));
        if (banks != null && !banks.isEmpty()) {
            List bankIds = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            slTypeFilter.and("banksyndicate_entry.e_bank", "in", bankIds);
        }
        if ((loanScrDataSet = InDebtsAnalysisDataListPlugin.unionDataSet(loanRepayScrDataSet, slRepayScrDataSet = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_repay_ls", (String)"cfm_loanbill", (String)SL_FIELDS, (QFilter[])new QFilter[]{cfmRepayFilter, slTypeFilter}, null).filter("creditor > 0"))).isEmpty()) {
            return loanScrDataSet;
        }
        HashSet<Object> loanBillIds = new HashSet<Object>();
        for (Row row : loanScrDataSet.copy()) {
            loanBillIds.add(row.get("id"));
        }
        DataSet payDataSet = this.queryPayInfo(paramMap, loanBillIds);
        if (payDataSet.isEmpty()) {
            return loanScrDataSet;
        }
        String[] fieldNames = loanScrDataSet.getRowMeta().getFieldNames();
        payDataSet = payDataSet.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        loanScrDataSet = loanScrDataSet.leftJoin(payDataSet).on("id", "loanbillid").select(fieldNames, new String[]{"repayamount"}).finish();
        loanScrDataSet = loanScrDataSet.updateField("repayamount", "case when repayamount is null then 0 else repayamount end");
        return loanScrDataSet.updateField("amount", "amount-(repayamount*radio)");
    }

    private DataSet queryPayInfo(Map<String, Object> customParam, Set<Object> loanBillIds) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Date queryDate = (Date)customParam.get("filter_selectdate");
        filter.and(new QFilter("bizdate", "<=", (Object)queryDate));
        filter.and(new QFilter("loans.e_loanbill", "in", loanBillIds));
        logger.info(String.format("payInfo query param:%s", filter));
        return QueryServiceHelper.queryDataSet((String)"querysPayBalance", (String)"cfm_repaymentbill", (String)"loans.e_loanbill as loanbillid,case when loans.e_repayamount is null then 0 else loans.e_repayamount end as repayamount", (QFilter[])filter.toArray(), null);
    }

    private DataSet queryBONDDataSet(ReportQueryParam param, Map<String, Object> paramMap) {
        InDebtsAnalysisDataBuider debtsBean = InDebtsAnalysisDataBuider.getObjByDebtsType(DebtsBizTypeEnum.CFMREPAY.getCode());
        QFilter cfmRepayFilter = this.getParmComonFilter(param, debtsBean);
        Date queryDate = (Date)paramMap.get("filter_selectdate");
        cfmRepayFilter.and(new QFilter("bizdate", "<=", (Object)queryDate));
        this.getDueDateRange(cfmRepayFilter, "expiredate", paramMap);
        QFilter bondTypeFilter = new QFilter("loantype", "=", (Object)"bond").and("investor_entry.id", ">", (Object)0).and(QFilter.of((String)"cleardate is null", (Object[])new Object[0]).or(QFilter.of((String)"cleardate is not null", (Object[])new Object[0]).and("cleardate", ">", (Object)queryDate))).and(new QFilter("investor_entry.e_investorname", "!=", (Object)" ").or(new QFilter("investor_entry.e_investorname", "!=", (Object)"")));
        DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get("filter_bank");
        if (banks != null && !banks.isEmpty()) {
            List bankIds = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            bondTypeFilter.and("investor_entry.e_investorid", "in", bankIds);
        }
        DataSet slRepayScrDataSet = QueryServiceHelper.queryDataSet((String)"cfm_loanbill_repay_bond", (String)"cfm_loanbill_bond", (String)BOND_FIELDS, (QFilter[])new QFilter[]{cfmRepayFilter, bondTypeFilter}, null);
        String otherName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InDebtsAnalysisDataListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
        slRepayScrDataSet = slRepayScrDataSet.select(new String[]{"id", "case when creditor >0 then creditor else 999 end as creditor", "case when creditor >0 then creditortext else '" + otherName + "' end  as creditortext", "countbilltype", "currency", "amount", "radio"});
        HashSet<Object> loanBillIds = new HashSet<Object>();
        for (Row row : slRepayScrDataSet.copy()) {
            loanBillIds.add(row.get("id"));
        }
        DataSet payDataSet = this.queryPayInfo(paramMap, loanBillIds);
        if (payDataSet.isEmpty()) {
            return slRepayScrDataSet;
        }
        String[] fieldNames = slRepayScrDataSet.getRowMeta().getFieldNames();
        payDataSet = payDataSet.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        slRepayScrDataSet = slRepayScrDataSet.leftJoin(payDataSet).on("id", "loanbillid").select(fieldNames, new String[]{"repayamount"}).finish().updateField("repayamount", "case when repayamount is null then 0 else repayamount end");
        return slRepayScrDataSet.updateField("amount", "amount-(repayamount*radio)");
    }

    private DataSet getDataSet(ReportQueryParam param, Map<String, Object> paramMap) {
        DataSet bondRepayScrDataSet;
        DataSet repayDataSet;
        DataSet cfmRepayScrDataSet;
        DataSet lcSrcDataSet;
        DataSet dataSet;
        DataSet cdmSrcDataSet;
        String bizType = (String)paramMap.get("filter_biztype");
        ArrayList<DataSet> needUnionDataSets = new ArrayList<DataSet>();
        if (bizType.contains(DebtsBizTypeEnum.CDM.getCode()) && !(cdmSrcDataSet = this.queryCDMDataSet(param, paramMap)).isEmpty()) {
            dataSet = this.nameTransSeri(cdmSrcDataSet, DebtsBizTypeEnum.CDM.getCode());
            needUnionDataSets.add(dataSet);
        }
        if (bizType.contains(DebtsBizTypeEnum.LC.getCode()) && !(lcSrcDataSet = this.queryLCDataSet(param, paramMap)).isEmpty()) {
            dataSet = this.nameTransSeri(lcSrcDataSet, DebtsBizTypeEnum.LC.getCode());
            ORM.create().toPlainDynamicObjectCollection(dataSet.copy());
            needUnionDataSets.add(dataSet);
        }
        if (bizType.contains(DebtsBizTypeEnum.CFM.getCode()) && (cfmRepayScrDataSet = this.queryCFMDataSet(param, paramMap)) != null && !cfmRepayScrDataSet.isEmpty()) {
            cfmRepayScrDataSet = cfmRepayScrDataSet.select(SELECT_FIELDS);
            repayDataSet = this.nameTransSeri(cfmRepayScrDataSet, DebtsBizTypeEnum.CFMREPAY.getCode());
            ORM.create().toPlainDynamicObjectCollection(repayDataSet.copy());
            needUnionDataSets.add(repayDataSet);
        }
        if (bizType.contains(DebtsBizTypeEnum.BOND.getCode()) && !(bondRepayScrDataSet = this.queryBONDDataSet(param, paramMap).select(SELECT_FIELDS)).isEmpty()) {
            repayDataSet = this.nameTransSeri(bondRepayScrDataSet, DebtsBizTypeEnum.BONDREPAY.getCode());
            ORM.create().toPlainDynamicObjectCollection(repayDataSet.copy());
            needUnionDataSets.add(repayDataSet);
        }
        DataSet unionDataSet = null;
        if (!needUnionDataSets.isEmpty()) {
            unionDataSet = (DataSet)needUnionDataSets.get(0);
            for (int i = 1; i < needUnionDataSets.size(); ++i) {
                unionDataSet = unionDataSet.union((DataSet)needUnionDataSets.get(i));
            }
        }
        return unionDataSet;
    }

    private DataSet dealRow2Col(DataSet resultDataSet) {
        DataSet groupNameDs = resultDataSet.copy().groupBy(new String[]{"countbilltype"}).finish().select("countbilltype");
        ArrayList<String> dynColList = new ArrayList<String>(100);
        for (Row groupNameD : groupNameDs) {
            dynColList.add(groupNameD.getString("countbilltype"));
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select ").append(String.join((CharSequence)",", this.dynRow2ColGroupFields)).append(" , ").append(this.buildSqlStr(dynColList)).append(" group by ").append(String.join((CharSequence)",", this.dynRow2ColGroupFields));
        return resultDataSet.executeSql(sqlSb.toString());
    }

    private String buildSqlStr(List<String> dynColList) {
        StringBuilder sb = new StringBuilder();
        for (String dynCol : dynColList) {
            sb.append("sum(case when ").append("countbilltype").append("='").append(dynCol).append("' then ").append("amount").append(" else 0 end) as ").append(dynCol).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    private DataSet dealIsMergeData(DataSet transDataSet, Map<String, Object> paramMap) {
        String[] fieldNames;
        this.isCdmMerge = (Boolean)paramMap.get("filter_iscdmmerge");
        this.isLcMerge = (Boolean)paramMap.get("filter_islcmerge");
        this.isCfmRepayMerge = (Boolean)paramMap.get("filter_iscfmrepaymerge");
        this.isBondRepayMerge = (Boolean)paramMap.get("filter_isbondrepaymerge");
        RowMeta rowMetas = transDataSet.getRowMeta();
        for (String colName : fieldNames = rowMetas.getFieldNames()) {
            if (colName.endsWith("_cdm")) {
                this.cdmDynCols.add(colName);
                continue;
            }
            if (colName.endsWith("_lc")) {
                this.lcDynCols.add(colName);
                continue;
            }
            if (colName.endsWith("_cfmrepay")) {
                this.cfmRepayDynCols.add(colName);
                continue;
            }
            if (!colName.endsWith("_bondrepay")) continue;
            this.bondRepayDynCols.add(colName);
        }
        DataSet cdmDataSet = this.addDynCal2Play(transDataSet, this.isCdmMerge, this.cdmDynCols, "cdmamt");
        DataSet lcDataSet = this.addDynCal2Play(cdmDataSet, this.isLcMerge, this.lcDynCols, "lcamt");
        DataSet cfmrepayDataSet = this.addDynCal2Play(lcDataSet, this.isCfmRepayMerge, this.cfmRepayDynCols, "cfmrepayamt");
        return this.addDynCal2Play(cfmrepayDataSet, this.isBondRepayMerge, this.bondRepayDynCols, "bondrepayamt");
    }

    private DataSet addDynCal2Play(DataSet transDataSet, boolean isNeedMerge, List<String> dynCols, String showField) {
        if (EmptyUtil.isNoEmpty(dynCols)) {
            if (isNeedMerge) {
                this.bizAmtColList.add(showField);
                return transDataSet.addField(String.join((CharSequence)"+", dynCols), showField);
            }
            this.bizAmtColList.addAll(dynCols);
            this.dynamicColList.addAll(dynCols);
        }
        return transDataSet;
    }

    private DataSet nameTransSeri(DataSet union, String subfix) {
        if (union.isEmpty()) {
            return union;
        }
        for (Row row : union.copy()) {
            String billtype = "p_" + row.getString("countbilltype");
            String billtypeHash = InDebtsAnalysisDataListPlugin.getMd5(billtype).substring(0, 16) + "_" + subfix;
            this.billtypeNameToKeyMap.put(billtype, billtypeHash);
            this.billtypeKeyToNameMap.put(billtypeHash, billtype);
        }
        final RowMeta rowMetas = union.getRowMeta();
        union = union.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("countbilltype".equals(fieldName)) {
                        rowInfo.add(InDebtsAnalysisDataListPlugin.this.billtypeNameToKeyMap.get("p_" + row.get("countbilltype")));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
        return union;
    }

    private static String getMd5(String value) {
        try {
            byte[] valueBytes = value == null ? new byte[]{} : value.getBytes(StandardCharsets.UTF_8);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(valueBytes);
            byte[] s = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : s) {
                sb.append(String.format("%02X", b));
            }
            return sb.toString();
        }
        catch (Exception var3) {
            return "";
        }
    }

    private void setColIsHide(ReportColumn column) {
        String fieldKey;
        switch (fieldKey = column.getFieldKey()) {
            case "cdmamt": {
                if (!Boolean.TRUE.equals(this.isCdmMerge == false) && !EmptyUtil.isEmpty(this.cdmDynCols)) break;
                column.setHide(true);
                break;
            }
            case "lcamt": {
                if (!Boolean.TRUE.equals(this.isLcMerge == false) && !EmptyUtil.isEmpty(this.lcDynCols)) break;
                column.setHide(true);
                break;
            }
            case "cfmrepayamt": {
                if (!Boolean.TRUE.equals(this.isCfmRepayMerge == false) && !EmptyUtil.isEmpty(this.cfmRepayDynCols)) break;
                column.setHide(true);
                break;
            }
            case "bondrepayamt": {
                if (!Boolean.TRUE.equals(this.isBondRepayMerge == false) && !EmptyUtil.isEmpty(this.bondRepayDynCols)) break;
                column.setHide(true);
                break;
            }
        }
    }

    private void getDueDateRange(QFilter baseFilter, String field, Map<String, Object> paramMap) {
        Date startDueDate = (Date)paramMap.get("filter_startduedate");
        Date endDueDate = (Date)paramMap.get("filter_endduedate");
        if (EmptyUtil.isNoEmpty((Object)startDueDate)) {
            baseFilter.and(new QFilter(field, ">=", (Object)startDueDate));
        }
        if (EmptyUtil.isNoEmpty((Object)endDueDate)) {
            baseFilter.and(new QFilter(field, "<=", (Object)endDueDate));
        }
    }

    protected boolean isNeedOrgTree() {
        return false;
    }

    protected boolean isOrgNeedAddRootNode() {
        return false;
    }
}

