/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.report.helper.FinReportHelper;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LetterCreditDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String ARRIVAL_FIELDS = "id, org, org.name orgname, currency, arrivalamount, arrivalcurrency, lettercredit.bank bank,  entrys.arrpayamount arrpayamount, entrys.operatetype operatetype";
    private static final String GROUPBY_FIELDS = "id, org, orgname, currency, arrivalamount, arrivalcurrency, bank";
    private static final String TOTAL_FIELDS = "currency, basearrivalamt tbasearrivalamt, endarrivalamt tendarrivalamt,basearrpayamt tbasearrpayamt, endarrpayamt tendarrpayamt";
    private static final String ROWID = "rowid";
    private static final String ORGIDS = "ORGIDS";
    private static final String ORGNAME = "orgname";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        this.getQueryParam().getCustomParam().put("filter_showttype", paramMap.get("filter_showttype"));
        paramMap.putAll(queryParam.getCustomParam());
        paramMap.put(ORGIDS, this.getQueryOrgIds(queryParam));
        DataSet dataSet = this.queryLetterDataSet(paramMap);
        if (dataSet == null || dataSet.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        return this.reDealResultDataSet(dataSet, queryParam);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        DataSet resultSet = this.convertTotalRate(dataSet);
        Map paramMap = this.transQueryParam(queryParam);
        Boolean isShowTotal = (Boolean)paramMap.get("filter_isshowtotal");
        String statDim = (String)paramMap.get("filter_statdim");
        if (isShowTotal.booleanValue()) {
            return resultSet;
        }
        if ("org".equals(statDim)) {
            return resultSet.filter("sumlevel != 1 and sumlevel != 2");
        }
        return resultSet.filter("sumlevel != 2");
    }

    private DataSet queryLetterDataSet(Map<String, Object> paramMap) {
        DataSet baseArrivalDs = this.getArrivalDs(paramMap, true);
        DataSet endArrivalDs = this.getArrivalDs(paramMap, false);
        Long tarCurrencyId = (Long)paramMap.get("filter_statcurrency");
        String statDim = (String)paramMap.get("filter_statdim");
        DataSet resultDs = null;
        switch (statDim) {
            case "org": {
                DataSet dsFromGroup = this.getDsByStatDimOrg(baseArrivalDs, endArrivalDs, paramMap);
                resultDs = this.dealDataSetByOrg(dsFromGroup, paramMap, tarCurrencyId);
                break;
            }
            case "bank": {
                DataSet dsFromGroup = this.getDsByStatDimBank(baseArrivalDs, endArrivalDs, paramMap);
                resultDs = this.dealDataSetByBank(dsFromGroup, tarCurrencyId);
                break;
            }
            case "currency": {
                DataSet dsFromGroup = this.getDsByStatDimCurrency(baseArrivalDs, endArrivalDs, paramMap);
                resultDs = this.getDataSet(dsFromGroup, tarCurrencyId, "currency", "bd_currency");
                break;
            }
        }
        return resultDs;
    }

    private DataSet dealDataSetByOrg(DataSet dataSet, Map<String, Object> paramMap, long tarCurrencyId) {
        String showType = (String)this.getQueryParam().getCustomParam().get("filter_showttype");
        dataSet = "step".equals(showType) ? this.getDataSetByOrgView(dataSet, paramMap, tarCurrencyId) : this.getDataSet(dataSet, tarCurrencyId, "org", "bos_org");
        return dataSet;
    }

    private DataSet getDataSetByOrgView(DataSet dataSet, Map<String, Object> paramMap, long tarCurrencyId) {
        DataSet orgDataSet;
        String queryWay = (String)paramMap.get("filter_queryway");
        List orgIds = (List)paramMap.get(ORGIDS);
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
            orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)8L).filter("orgid in (" + StringUtils.join((Collection)orgIds, (String)",") + ")");
        } else {
            DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
            orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgView.getLong("id")).filter("orgid in (" + StringUtils.join((Collection)orgIds, (String)",") + ")");
        }
        DataSet tempDs = orgDataSet.copy().leftJoin(orgDataSet.copy().select(new String[]{"pid pidc", "rowid rowidc"})).on("pid", "rowidc").select(new String[]{"pid", "rowidc"}).finish();
        ArrayList pidList = new ArrayList(10);
        tempDs.iterator().forEachRemaining(v -> {
            if (v.getLong("rowidc") == null) {
                pidList.add(v.getLong("pid"));
            }
        });
        String pidStr = "case when pid in (" + StringUtils.join(pidList, (String)",") + ") then 0 else pid end";
        String levelStr = "case when pid in (" + StringUtils.join(pidList, (String)",") + ") then 1 else level end";
        orgDataSet = orgDataSet.updateFields(new String[]{"pid", "level"}, new String[]{pidStr, levelStr});
        DataSet ds = orgDataSet.leftJoin(dataSet).on(ROWID, "org").select(new String[]{ORGNAME, "endarrivalamt", "basearrivalamt", "endarrpayamt", "basearrpayamt", "endarrivalamt-basearrivalamt as arrivalchangeamt", ROWID, "pid", "isgroupnode", "level", "0 sumlevel"}).finish().addField(String.valueOf(tarCurrencyId), "currency");
        DataSet totalDs = this.getTotalDs(ds, "");
        DataSet sumDataSet = this.getSumDataSet(ds);
        sumDataSet = this.removeNoDataTreeDs(sumDataSet);
        if (sumDataSet.isEmpty()) {
            return sumDataSet;
        }
        DataSet sumRateDs = this.calculationAddRate(sumDataSet, totalDs.copy());
        totalDs = this.addTotalFields(totalDs).select(sumRateDs.getRowMeta().getFieldNames());
        return sumRateDs.union(totalDs);
    }

    private DataSet dealDataSetByBank(DataSet dataSet, Long tarCurrencyId) {
        Set<Long> bankIds = this.getDataSetFieldIds(dataSet, "bank");
        Object[] fieldNames = dataSet.getRowMeta().getFieldNames();
        dataSet = dataSet.addField(String.valueOf(tarCurrencyId), "currency").select(StringUtils.join((Object[])fieldNames, (String)",") + ",currency");
        DataSet bankFinorgTypeDs = LetterCreditDataListPlugin.getBankFinorgTypeDs(bankIds);
        dataSet = dataSet.leftJoin(bankFinorgTypeDs).on("bank", "id").select(dataSet.getRowMeta().getFieldNames(), new String[]{"finorgtype"}).finish();
        DataSet bankDs = dataSet.copy().filter("finorgtype='FI-014'");
        DataSet finorgDs = dataSet.copy().filter("finorgtype!='FI-014'");
        DataSet bankTreeDs = this.createBankTree(bankDs.removeFields(new String[]{"finorgtype"}), tarCurrencyId);
        DataSet finOrgTreeDs = this.createFinOrgTree(finorgDs.removeFields(new String[]{"finorgtype"}), tarCurrencyId);
        if (bankTreeDs.isEmpty() && finOrgTreeDs.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        DataSet allDataSets = finOrgTreeDs.isEmpty() ? bankTreeDs : (bankTreeDs.isEmpty() ? finOrgTreeDs : bankTreeDs.union(finOrgTreeDs));
        DataSet subTotalDs = allDataSets.copy().filter(this.sumField + " = 1").updateField(this.sumField, "pid");
        DataSet allTotalDs = this.addAllTotalDataSet(subTotalDs, this.sumFields(), Collections.singletonList("currency"), ORGNAME).updateField("arrivalchangerate", "case when basearrivalamt=0 then 0.00 else round(arrivalchangeamt*100/abs(basearrivalamt), 2) end").updateField(ROWID, String.valueOf(DBServiceHelper.genGlobalLongId())).updateField("pid", "0");
        allDataSets = this.calculationAddRate(allDataSets, allTotalDs);
        return allDataSets.union(this.addTotalFields(allTotalDs));
    }

    private DataSet getDataSet(DataSet dataSet, long tarCurrencyId, String statDim, String entity) {
        Set<Long> ids = this.getDataSetFieldIds(dataSet, statDim);
        DataSet orgDataSet = FinReportHelper.getBaseDataDs(ids, entity);
        DataSet joinDataDs = dataSet.leftJoin(orgDataSet).on(statDim, "id").select(new String[]{"name orgname", "endarrivalamt", "basearrivalamt", "endarrpayamt", "basearrpayamt", "endarrivalamt-basearrivalamt as arrivalchangeamt", ROWID, "pid", "isgroupnode", "level", "0 sumlevel", "'" + tarCurrencyId + "'currency"}).finish();
        DataSet totalDs = this.addAllTotalDataSet(joinDataDs, this.sumFields(), Collections.singletonList("currency"), ORGNAME).select(new String[]{ORGNAME, "endarrivalamt", "basearrivalamt", "endarrpayamt", "basearrpayamt", " case when basearrivalamt=0 then 0.00 else 100.00 end as basearrivalrate", " case when endarrivalamt=0 then 0.00 else 100.00 end as endarrivalrate", " case when basearrpayamt=0 then 0.00 else 100.00 end as basearrpayrate", " case when endarrpayamt=0 then 0.00 else 100.00 end as endarrpayrate", "arrivalchangeamt", " (case when basearrivalamt=0 then 0.00 else arrivalchangeamt*100/abs(basearrivalamt) end) arrivalchangerate", "" + DBServiceHelper.genGlobalLongId() + " rowid", "0 pid", "isgroupnode", "level", "sumlevel", "currency"});
        DataSet totalAmtds = totalDs.select(TOTAL_FIELDS.split(",")).addField("0", "pid");
        DataSet sumRateDs = joinDataDs.leftJoin(totalAmtds).on("pid", "pid").select(new String[]{ORGNAME, "endarrivalamt", "basearrivalamt", "endarrpayamt", "basearrpayamt", this.converfield("basearrivalamt", "basearrivalrate"), this.converfield("endarrivalamt", "endarrivalrate"), this.converfield("basearrpayamt", "basearrpayrate"), this.converfield("endarrpayamt", "endarrpayrate"), "arrivalchangeamt", " ( case when basearrivalamt=0 then 0 else (arrivalchangeamt)*100/abs(basearrivalamt) end ) as arrivalchangerate", ROWID, "pid", "0 isgroupnode", "level", "sumlevel", "currency"}).finish();
        sumRateDs = sumRateDs.union(totalDs);
        return this.formatDsRate(sumRateDs);
    }

    private DataSet getDsByStatDimOrg(DataSet baseArrivalDs, DataSet endArrivalDs, Map<String, Object> paramMap) {
        DataSet endSumDs;
        DataSet endGroupDs = endArrivalDs.copy().groupBy(new String[]{"org", "currency"}).sum("arrivalamount").sum("arrpayamount").finish();
        DataSet baseAndEndDs = endSumDs = this.getDsConverEx(endGroupDs, paramMap, new String[]{"org"});
        if (baseArrivalDs == null || baseArrivalDs.isEmpty()) {
            baseAndEndDs = baseAndEndDs.select(new String[]{"org", "arrivalamount-arrpayamount endarrivalamt", "arrpayamount endarrpayamt"}).addField("0", "basearrivalamt").addField("0", "basearrpayamt");
        } else {
            DataSet baseGroupDs = baseArrivalDs.groupBy(new String[]{"org", "currency"}).sum("arrivalamount").sum("arrpayamount").finish();
            DataSet baseSumDs = this.getDsConverEx(baseGroupDs, paramMap, new String[]{"org"}).select(new String[]{"org org1", "arrivalamount basearrivalamt", "arrpayamount basearrpayamt"});
            baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("org1", "org").select(new String[]{"org", "arrivalamount-arrpayamount endarrivalamt", "basearrivalamt-basearrpayamt basearrivalamt", "arrpayamount endarrpayamt", "basearrpayamt"}).finish();
            baseAndEndDs = baseAndEndDs.select(new String[]{"org", "case when endarrivalamt=null then 0.00 else endarrivalamt end as endarrivalamt", "case when basearrivalamt=null then 0.00 else basearrivalamt end as basearrivalamt", "case when endarrpayamt=null then 0.00 else endarrpayamt end as endarrpayamt", "case when basearrpayamt=null then 0.00 else basearrpayamt end as basearrpayamt"});
        }
        return baseAndEndDs;
    }

    private DataSet getDsByStatDimBank(DataSet baseArrivalDs, DataSet endArrivalDs, Map<String, Object> paramMap) {
        DataSet endSumDs;
        DataSet endGroupDs = endArrivalDs.groupBy(new String[]{"bank", "currency"}).sum("arrivalamount").sum("arrpayamount").finish();
        DataSet baseAndEndDs = endSumDs = this.getDsConverEx(endGroupDs, paramMap, new String[]{"bank"});
        if (baseArrivalDs == null || baseArrivalDs.isEmpty()) {
            baseAndEndDs = baseAndEndDs.select(new String[]{"bank", "arrivalamount-arrpayamount endarrivalamt", "arrpayamount endarrpayamt"}).addField("0", "basearrivalamt").addField("0", "basearrpayamt");
        } else {
            DataSet baseGroupDs = baseArrivalDs.groupBy(new String[]{"bank", "currency"}).sum("arrivalamount").sum("arrpayamount").finish();
            DataSet baseSumDs = this.getDsConverEx(baseGroupDs, paramMap, new String[]{"bank"}).select(new String[]{"bank bank1", "arrivalamount basearrivalamt", "arrpayamount basearrpayamt"});
            baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("bank1", "bank").select(new String[]{"bank", "arrivalamount-arrpayamount endarrivalamt", "basearrivalamt-basearrpayamt basearrivalamt", "arrpayamount endarrpayamt", "basearrpayamt"}).finish();
            baseAndEndDs = baseAndEndDs.select(new String[]{"bank", "case when endarrivalamt=null then 0.00 else endarrivalamt end as endarrivalamt", "case when basearrivalamt=null then 0.00 else basearrivalamt end as basearrivalamt", "case when endarrpayamt=null then 0.00 else endarrpayamt end as endarrpayamt", "case when basearrpayamt=null then 0.00 else basearrpayamt end as basearrpayamt"});
        }
        return baseAndEndDs;
    }

    private DataSet getDsByStatDimCurrency(DataSet baseArrivalDs, DataSet endArrivalDs, Map<String, Object> paramMap) {
        DataSet endSumDs;
        DataSet endGroupDs = endArrivalDs.groupBy(new String[]{"currency"}).sum("arrivalamount").sum("arrpayamount").finish();
        DataSet baseAndEndDs = endSumDs = this.getDsConverEx(endGroupDs, paramMap, new String[]{"currency"});
        if (baseArrivalDs == null || baseArrivalDs.isEmpty()) {
            baseAndEndDs = baseAndEndDs.select(new String[]{"currency", "arrivalamount-arrpayamount endarrivalamt", "arrpayamount endarrpayamt"}).addField("0", "basearrivalamt").addField("0", "basearrpayamt");
        } else {
            DataSet baseGroupDs = baseArrivalDs.groupBy(new String[]{"currency"}).sum("arrivalamount").sum("arrpayamount").finish();
            DataSet baseSumDs = this.getDsConverEx(baseGroupDs, paramMap, new String[]{"currency"}).select(new String[]{"currency currency1", "arrivalamount basearrivalamt", "arrpayamount basearrpayamt"});
            baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("currency1", "currency").select(new String[]{"currency", "arrivalamount-arrpayamount endarrivalamt", "basearrivalamt-basearrpayamt basearrivalamt", "arrpayamount endarrpayamt", "basearrpayamt"}).finish();
            baseAndEndDs = baseAndEndDs.select(new String[]{"currency", "case when endarrivalamt=null then 0.00 else endarrivalamt end as endarrivalamt", "case when basearrivalamt=null then 0.00 else basearrivalamt end as basearrivalamt", "case when endarrpayamt=null then 0.00 else endarrpayamt end as endarrpayamt", "case when basearrpayamt=null then 0.00 else basearrpayamt end as basearrpayamt"});
        }
        return baseAndEndDs;
    }

    private DataSet getDsConverEx(DataSet srcGroupDs, Map<String, Object> paramMap, String[] strArr) {
        Long tarCurrencyId = (Long)paramMap.get("filter_statcurrency");
        DataSet currencyDataSet = srcGroupDs.copy().groupBy(new String[]{"currency"}).finish();
        Long orgId = Long.parseLong(String.valueOf(paramMap.get("org")));
        ArrayList currencyIdList = new ArrayList(10);
        currencyDataSet.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
        String queryWay = (String)paramMap.get("filter_queryway");
        boolean orgQueryWay = "filter_org".equals(queryWay);
        DataSet exChangeDataSet = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)tarCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate(), (boolean)orgQueryWay);
        String unit = (String)paramMap.get("filter_currencyunit");
        return srcGroupDs.leftJoin(exChangeDataSet).on("currency", "tarcurrency").select(strArr, new String[]{"tarcurrency", String.format("arrivalamount*rate/%s", unit) + " arrivalamount", String.format("arrpayamount*rate/%s", unit) + " arrpayamount"}).finish().groupBy(strArr).sum("arrivalamount").sum("arrpayamount").finish();
    }

    private DataSet createBankTree(DataSet bankDs, Long tarCurrencyId) {
        Set<Long> bankIds = this.getDataSetFieldIds(bankDs, "bank");
        DataSet bdFinorgInfoDs = FinReportHelper.getBdFinorgInfo(bankIds, "bank_cate");
        String[] fieldNames = bankDs.getRowMeta().getFieldNames();
        Set<Long> bankTypeIds = this.getDataSetFieldIds(bdFinorgInfoDs, "pid");
        DataSet bankcgSettingDs = FinReportHelper.getBaseDataDs(bankTypeIds, "bd_bankcgsetting").addField(String.valueOf(tarCurrencyId), "currency").select("0 bank,0 basearrivalamt,0 endarrivalamt,0 basearrpayamt,0 endarrpayamt, currency,0 arrivalchangeamt,id,rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = bankDs.leftJoin(bdFinorgInfoDs).on("bank", "id").select(fieldNames, new String[]{"endarrivalamt-basearrivalamt as arrivalchangeamt", "id", ROWID, "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish().filter("pid!=0");
        DataSet bankTreeDs = creditorDs.union(bankcgSettingDs);
        DataSet sumDataSet = this.getSumDataSet(bankTreeDs);
        DataSet totalDs = this.getTotalDs(bankTreeDs, "bank").select(sumDataSet.getRowMeta().getFieldNames());
        return sumDataSet.union(totalDs);
    }

    private DataSet createFinOrgTree(DataSet finorgDs, Long tarCurrencyId) {
        Set<Long> bankIds = this.getDataSetFieldIds(finorgDs, "bank");
        DataSet bdFinorgInfoDs = FinReportHelper.getBdFinorgInfo(bankIds, "finorgtype");
        String[] fieldNames = finorgDs.getRowMeta().getFieldNames();
        Set<Long> finTypeIds = this.getDataSetFieldIds(bdFinorgInfoDs, "pid");
        DataSet finorgTypeds = FinReportHelper.getBaseDataDs(finTypeIds, "bd_finorgtype").addField(String.valueOf(tarCurrencyId), "currency").select("0 bank,0 basearrivalamt,0 endarrivalamt,0 basearrpayamt,0 endarrpayamt, currency,0 arrivalchangeamt,id,rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = finorgDs.leftJoin(bdFinorgInfoDs).on("bank", "id").select(fieldNames, new String[]{"endarrivalamt-basearrivalamt as arrivalchangeamt", "id", ROWID, "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish();
        DataSet finOrgTreeDs = creditorDs.union(finorgTypeds);
        DataSet sumDataSet = this.getSumDataSet(finOrgTreeDs);
        DataSet totalDs = this.getTotalDs(finOrgTreeDs, "finorg").select(sumDataSet.getRowMeta().getFieldNames());
        return sumDataSet.union(totalDs).select(new String[]{ROWID, "pid", "isgroupnode", "level", "sumlevel", "basearrivalamt", "endarrivalamt", "arrivalchangeamt", "basearrpayamt", "endarrpayamt", ORGNAME, "currency", "arrivalchangerate"});
    }

    public static DataSet getBankFinorgTypeDs(Set<Long> bankIds) {
        String acctBankFiled = "id, finorgtype.number finorgtype";
        QFilter qFilter = new QFilter("id", "in", bankIds);
        DataSet finorgTypeDs = QueryServiceHelper.queryDataSet((String)"bd_finorginfo_type", (String)"bd_finorginfo", (String)acctBankFiled, (QFilter[])new QFilter[]{qFilter}, null);
        return finorgTypeDs.groupBy(new String[]{"id", "finorgtype"}).finish();
    }

    private Set<Long> getDataSetFieldIds(DataSet dataSet, String field) {
        HashSet<Long> ids = new HashSet<Long>(16);
        dataSet.copy().forEach(o -> ids.add(o.getLong(field)));
        return ids;
    }

    private DataSet formatDsRate(DataSet unionDs) {
        return unionDs.updateField("basearrivalrate", " case when basearrivalrate=0 or basearrivalrate=null then 0.00 else round(basearrivalrate,2) end ").updateField("endarrivalrate", " case when endarrivalrate=0 or endarrivalrate=null then 0.00 else round(endarrivalrate,2) end ").updateField("basearrpayrate", " case when basearrpayrate=0 or basearrpayrate=null then 0.00 else round(basearrpayrate,2) end ").updateField("endarrpayrate", " case when endarrpayrate=0 or endarrpayrate=null then 0.00 else round(endarrpayrate,2) end ").updateField("arrivalchangerate", " case when arrivalchangerate=0 or arrivalchangerate=null then 0.00 else round(arrivalchangerate,2) end ");
    }

    private DataSet getArrivalDs(Map<String, Object> paramMap, boolean isBase) {
        if (isBase && EmptyUtil.isEmpty((Object)paramMap.get("filter_basedate"))) {
            return MonReportHelper.createEmptyDs();
        }
        QFilter qFilter = this.getQFilter(paramMap, isBase);
        DataSet arrivalDs = QueryServiceHelper.queryDataSet((String)"query_lc_arrival", (String)"lc_arrival", (String)ARRIVAL_FIELDS, (QFilter[])new QFilter[]{qFilter}, null);
        Set<Long> arrivalIds = this.getDataSetFieldIds(arrivalDs, "id");
        QFilter entryQFilter = this.getEntryQFilter(paramMap, isBase, arrivalIds);
        DataSet entryDs = QueryServiceHelper.queryDataSet((String)"query_lc_arrival", (String)"lc_arrival", (String)ARRIVAL_FIELDS, (QFilter[])new QFilter[]{entryQFilter}, null);
        entryDs = entryDs.select(new String[]{"id", "org", ORGNAME, "currency", "arrivalamount", "arrivalcurrency", "bank", "case when arrpayamount=null then 0.00 else arrpayamount end as arrpayamount", "operatetype"});
        entryDs = entryDs.filter("operatetype = 'payment'");
        entryDs = entryDs.groupBy(GROUPBY_FIELDS.split(",")).sum("arrpayamount").finish();
        arrivalDs = arrivalDs.groupBy(GROUPBY_FIELDS.split(",")).finish();
        arrivalDs = arrivalDs.leftJoin(entryDs).on("id", "id").select(GROUPBY_FIELDS.split(","), new String[]{"arrpayamount"}).finish();
        arrivalDs = arrivalDs.select(new String[]{"id", "org", ORGNAME, "currency", "arrivalamount", "arrivalcurrency", "bank", "case when arrpayamount=null then 0.00 else arrpayamount end as arrpayamount"});
        return arrivalDs.filter("bank != 0 and bank != null");
    }

    private QFilter getEntryQFilter(Map<String, Object> paramMap, boolean isBase, Set<Long> arrivalIds) {
        Date baseDate = (Date)paramMap.get("filter_basedate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        QFilter qFilter = new QFilter("id", "in", arrivalIds);
        QFilter dateQFilter = new QFilter("entrys.realpaydate", "<=", (Object)(isBase ? baseDate : endDate)).or(new QFilter("entrys.realpaydate", "=", null));
        return qFilter.and(dateQFilter);
    }

    private QFilter getQFilter(Map<String, Object> paramMap, boolean isBase) {
        DynamicObjectCollection currencyDoc;
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("arrivalstatus", "in", Arrays.asList("arrival_confirm", "arrival_pay")));
        Date baseDate = (Date)paramMap.get("filter_basedate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        List allORGIDS = (List)paramMap.get(ORGIDS);
        qFilter.and(new QFilter("org", "in", (Object)allORGIDS));
        DynamicObjectCollection bankDoc = (DynamicObjectCollection)paramMap.get("filter_bank");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankDoc)) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject bank : bankDoc) {
                ids.add(bank.getLong("id"));
            }
            qFilter.and(new QFilter("lettercredit.bank", "in", ids));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyDoc = (DynamicObjectCollection)paramMap.get("filter_currency")))) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject currency : currencyDoc) {
                ids.add(currency.getLong("id"));
            }
            qFilter.and(new QFilter("currency", "in", ids));
        }
        QFilter arrivalDate = new QFilter("arrivaldate", "<=", (Object)(isBase ? baseDate : endDate));
        return qFilter.and(arrivalDate);
    }

    private DataSet getSumDataSet(DataSet treeData) {
        treeData = this.getSumDataSetByLevel(treeData.copy(), this.sumFields(), "orgname, currency");
        return treeData.addField("case when basearrivalamt=0 then 0.00 else round(arrivalchangeamt*100/abs(basearrivalamt), 2) end ", "arrivalchangerate");
    }

    private DataSet convertTotalRate(DataSet rowDs) {
        if (rowDs == null || rowDs.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        return rowDs.updateField("basearrivalrate", this.getExp("basearrivalrate")).updateField("endarrivalrate", this.getExp("endarrivalrate")).updateField("basearrpayrate", this.getExp("basearrpayrate")).updateField("endarrpayrate", this.getExp("endarrpayrate")).updateField("arrivalchangerate", "case when basearrivalamt=0 then '-' else cast(round(arrivalchangerate, 2) as String) end");
    }

    private String getExp(String field) {
        return "case when " + field + "=0 then '0.00' else cast(round(" + field + ", 2) as String) end";
    }

    private DataSet removeNoDataTreeDs(DataSet treeData) {
        return this.removeNoDataTreeDs(treeData, Arrays.asList("endarrivalamt", "endarrivalamt"));
    }

    private DataSet calculationAddRate(DataSet sumDataSet, DataSet totalDs) {
        DataSet totalAmtds = totalDs.select(TOTAL_FIELDS.split(","));
        return sumDataSet.leftJoin(totalAmtds).on("currency", "currency").select(new String[]{ROWID, "pid", "isgroupnode", "level", "sumlevel", "basearrivalamt", "endarrivalamt", "basearrpayamt", "endarrpayamt", "endarrivalamt-basearrivalamt as arrivalchangeamt", ORGNAME, "currency", "arrivalchangerate", this.converfield("basearrivalamt", "basearrivalrate"), this.converfield("endarrivalamt", "endarrivalrate"), this.converfield("basearrpayamt", "basearrpayrate"), this.converfield("endarrpayamt", "endarrpayrate")}).finish();
    }

    private String converfield(String field, String fieldRate) {
        return "case when t" + field + "=0 then 0.00 else " + field + "*100/t" + field + " end " + fieldRate + "";
    }

    private DataSet addTotalFields(DataSet allTotalDs) {
        return allTotalDs.addField("case when basearrivalamt=0 then 0.00 else 100.00 end", "basearrivalrate").addField("case when endarrivalamt=0 then 0.00 else 100.00 end", "endarrivalrate").addField("case when basearrpayamt=0 then 0.00 else 100.00 end", "basearrpayrate").addField("case when endarrpayamt=0 then 0.00 else 100.00 end", "endarrpayrate");
    }

    private List<String> sumFields() {
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add("basearrivalamt");
        fields.add("endarrivalamt");
        fields.add("basearrpayamt");
        fields.add("endarrpayamt");
        fields.add("arrivalchangeamt");
        return fields;
    }

    private DataSet getTotalDs(DataSet ds, String type) {
        String totalCaption = FinReportHelper.getTotalCaption(type);
        String orgName = "concat ( '" + totalCaption + "'+ orgname)";
        if (EmptyUtil.isEmpty((String)type)) {
            orgName = ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"LetterCreditDataListPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
        }
        return this.addSubTotalDataSet(ds, Collections.singletonList("currency"), this.sumFields(), ORGNAME).removeFields(new String[]{"isgroupnode"}).addNullField("isgroupnode").updateField(ROWID, String.valueOf(DBServiceHelper.genGlobalLongId())).updateField("pid", "0").updateField(ORGNAME, orgName).addField("case when basearrivalamt=0 then 0.00 else round(arrivalchangeamt*100/abs(basearrivalamt), 2) end", "arrivalchangerate");
    }

    protected boolean isNeedOrgTree() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        return "org".equals(statdim);
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    public List<String> sumAmountFields() {
        return this.sumFields();
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)ORGNAME);
    }
}

