/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.NumericType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.report.helper.FinReportHelper;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang3.tuple.Pair;

public class LetterOfGuaStructureDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;
    private String groupString = null;
    private String orderString = null;
    private Long statcurrency = null;
    private final List<QFilter> filterList = new ArrayList<QFilter>(12);
    private static final String LETTER_FIELDS = "id,finorginfo.bank_cate.id bankcateid,finorginfo.finorgtype.number bankcatenumber ,finorginfo.bank_cate.name bankcatename, applyorg,applyorg.name applyorgtext,finorginfo,finorginfo.name finorginfotext,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext, amount,startdate";
    private static final String TOTAL_FIELDS = "applyorg,applyorgtext,finorginfo,bankcatenumber,finorginfotext,guaranteetype,guaranteetypetext,currency,currencytext";

    public DataSet queryDataSet(ReportQueryParam param) {
        this.init(param);
        DataSet baseDataSet = this.queryBillData(true);
        DataSet baseEndDataSet = this.queryBillData(false);
        DataSet dataSet = this.handleListDataSet(baseDataSet, baseEndDataSet);
        return this.modifyField(dataSet);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        String showType = (String)this.paramMap.get("filter_showttype");
        if ("step".equals(showType)) {
            String statdim = (String)this.paramMap.get("filter_statdim");
            if ("applyorg".equals(statdim)) {
                dataSet = this.updateParentOrg(dataSet);
            } else if ("finorginfo".equals(statdim)) {
                dataSet = this.handleTreeDataSet(dataSet);
            }
        }
        return this.castType(dataSet);
    }

    private DataSet updateParentOrg(DataSet dataSet) {
        if (dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.updateField("applyorgtext", "case when applyorgtext is null then orgname else applyorgtext end");
        return dataSet;
    }

    private DataSet castType(DataSet dataSet) {
        return dataSet.updateField("changerate", "case when b_amount = 0 then '-' else cast(round((be_amount - b_amount)*100/b_amount,2) as string) end");
    }

    private DataSet modifyField(DataSet dataSet) {
        return dataSet.removeFields(new String[]{"statcurrency", "pid", "rowid", "sumlevel"});
    }

    private DataSet handleTreeDataSet(DataSet dataSet) {
        if (dataSet.copy().isEmpty()) {
            return dataSet;
        }
        DataSet[] dataSets = dataSet.copy().splitByGroup(new String[]{"sumlevel"});
        dataSet = this.dealBillDataSetBank(dataSets[0]);
        dataSet = dataSet.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        DataSet sum = dataSets[1].addNullField("isgroupnode").addNullField("level").updateField("rowid", String.valueOf(DBServiceHelper.genGlobalLongId())).select(dataSet.getRowMeta().getFieldNames());
        return dataSet.union(sum.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}));
    }

    private DataSet dealBillDataSetBank(DataSet bankDs) {
        if (bankDs.copy().isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        DataSet[] dataSets = bankDs.splitByFilter(new String[]{"bankcatenumber='FI-014'"}, true);
        DataSet bank = dataSets[0];
        Set<Long> bankIds = this.getDataSetFieldIds(bank, "finorginfo");
        DataSet bdFinorgInfoDs = FinReportHelper.getBdFinorgInfo(bankIds, "bank_cate");
        String[] fieldNames = bankDs.getRowMeta().getFieldNames();
        Set<Long> bankTypeIds = this.getDataSetFieldIds(bdFinorgInfoDs, "pid");
        DataSet bankcgSettingDs = FinReportHelper.getBaseDataDs(bankTypeIds, "bd_bankcgsetting").select(this.genRootTypeFileds(bankDs, "finorginfotext") + "rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = bank.leftJoin(bdFinorgInfoDs).on("finorginfo", "id").select((String[])Arrays.stream(fieldNames).filter(e -> !"rowid,pid,isgroupnode,level,sumlevel".contains((CharSequence)e)).toArray(String[]::new), new String[]{"rowid", "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish();
        DataSet bankTreeDs = creditorDs.union(bankcgSettingDs);
        DataSet sumDataSet = this.getSumDataSetByLevel(bankTreeDs, this.sumFields(), this.groupString);
        sumDataSet = sumDataSet.addField(String.valueOf(this.statcurrency), "statcurrency");
        DataSet nobank = dataSets[1];
        if (!nobank.copy().isEmpty()) {
            nobank = nobank.addNullField("isgroupnode").addNullField("level").select(sumDataSet.getRowMeta().getFieldNames());
            nobank = this.setRowId(nobank, sumDataSet.getRowMeta());
            sumDataSet = sumDataSet.union(nobank);
        }
        return sumDataSet;
    }

    public String genRootTypeFileds(DataSet dataSet, String groupString) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        DataType[] dataTypes = dataSet.getRowMeta().getDataTypes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dataTypes.length; ++i) {
            DataType dataType = dataTypes[i];
            String fieldName = fieldNames[i];
            if ("rowid,pid,isgroupnode,level,sumlevel".contains(fieldName)) continue;
            if (dataType instanceof NumericType) {
                sb.append("0 ").append(fieldName);
                if (i == dataTypes.length - 1) continue;
                sb.append(',');
                continue;
            }
            if (!(dataType instanceof StringType)) continue;
            if (groupString.contains(fieldName)) {
                sb.append("name ").append(fieldName);
            } else {
                sb.append("'' ").append(fieldName);
            }
            if (i == dataTypes.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private Set<Long> getDataSetFieldIds(DataSet billDataSet, String field) {
        HashSet<Long> billIds = new HashSet<Long>();
        billDataSet.copy().forEach(o -> billIds.add(o.getLong(field)));
        return billIds;
    }

    private DataSet handleListDataSet(DataSet baseDataSet, DataSet baseEndDataSet) {
        String statDim = (String)this.paramMap.get("filter_statdim");
        DataSet groupBaseDataSet = this.afterGroupAddField(this.groupByStatdim(baseDataSet, true));
        DataSet groupBaseEndDataSet = this.afterGroupAddField(this.groupByStatdim(baseEndDataSet, false));
        CharSequence[] baseFieldNames = groupBaseDataSet.getRowMeta().getFieldNames();
        CharSequence[] baseEndFieldNames = groupBaseEndDataSet.getRowMeta().getFieldNames();
        DataSet totalBaseDataSet = this.addAllTotalDataSet(groupBaseDataSet, Collections.singletonList("b_amount"), statDim + "text");
        DataSet totalBaseEndDataSet = this.addAllTotalDataSet(groupBaseEndDataSet, Collections.singletonList("be_amount"), statDim + "text");
        DataSet newTotalBaseDataSet = totalBaseDataSet.copy().select(String.join((CharSequence)",", totalBaseDataSet.getRowMeta().getFieldNames()).replace("b_amount", "b_amount b_totalamount")).updateField("pid", "0");
        DataSet newTotalBaseEndDataSet = totalBaseEndDataSet.copy().select(String.join((CharSequence)",", totalBaseEndDataSet.getRowMeta().getFieldNames()).replace("be_amount", "be_amount be_totalamount")).updateField("pid", "0");
        groupBaseDataSet = groupBaseDataSet.leftJoin(newTotalBaseDataSet).on("pid", "pid").select((String[])baseFieldNames, new String[]{"b_totalamount"}).finish().select(String.join((CharSequence)",", baseFieldNames) + ",b_amount*100/b_totalamount b_ratio");
        groupBaseEndDataSet = groupBaseEndDataSet.leftJoin(newTotalBaseEndDataSet).on("pid", "pid").select((String[])baseEndFieldNames, new String[]{"be_totalamount"}).finish().select(String.join((CharSequence)",", baseEndFieldNames) + ",be_amount*100/be_totalamount be_ratio");
        String[] newBaseFieldNames = groupBaseDataSet.getRowMeta().getFieldNames();
        String[] newBaseEndFieldNames = groupBaseEndDataSet.getRowMeta().getFieldNames();
        String[] changeBaseEndFieldNames = new String[newBaseEndFieldNames.length];
        StringBuilder field = new StringBuilder();
        for (int i = 0; i < newBaseEndFieldNames.length; ++i) {
            String name = newBaseEndFieldNames[i];
            if ("be_amount,be_ratio".contains(name)) {
                changeBaseEndFieldNames[i] = name;
                continue;
            }
            changeBaseEndFieldNames[i] = name + " " + name + "1";
            field.append("case when ").append(name).append("=null then ").append(name).append("1").append(" else ").append(name).append(" end ").append(name).append(",");
        }
        String b_amount = "(case when b_amount=null then 0 else b_amount end)";
        String be_amount = "(case when be_amount=null then 0 else be_amount end)";
        field.append(b_amount).append(" b_amount,").append(be_amount).append(" be_amount,").append("case when b_ratio=null then 0 else b_ratio end b_ratio,case when be_ratio=null then 0 else be_ratio end be_ratio,").append(be_amount).append("-").append(b_amount).append(" changeamount,");
        field.append("case when b_amount=null or b_amount=0 then 0 else round((").append(be_amount).append("-").append(b_amount).append(")*100/").append("b_amount").append(",2) end changerate");
        DataSet allDateset = groupBaseDataSet.fullJoin(groupBaseEndDataSet).on(statDim, statDim).select(newBaseFieldNames, changeBaseEndFieldNames).finish().select(field.toString());
        return allDateset;
    }

    private DataSet setRowId(DataSet allDateset, final RowMeta newRowMeta) {
        allDateset = allDateset.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                for (String fieldName : newRowMeta.getFieldNames()) {
                    if ("rowid".equals(fieldName)) {
                        rowInfo.add(String.valueOf(DBServiceHelper.genGlobalLongId()));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return newRowMeta;
            }
        });
        return allDateset;
    }

    private List<String> sumFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("b_amount");
        fields.add("be_amount");
        fields.add("changeamount");
        fields.add("changerate");
        fields.add("b_ratio");
        fields.add("be_ratio");
        return fields;
    }

    private DataSet groupByStatdim(DataSet billDataSet, boolean isBase) {
        String sumField = isBase ? "b_amount" : "be_amount";
        DataSet currencyDataSet = this.getExChangeRateDs(billDataSet, this.paramMap);
        String unit = (String)this.paramMap.get("filter_currencyunit");
        DataSet exBillDataSet = billDataSet.leftJoin(currencyDataSet).on("currency", "tarcurrency").select(TOTAL_FIELDS.split(","), new String[]{"tarcurrency", "rate", String.format("amount*rate/%s " + sumField, unit)}).finish();
        return exBillDataSet == null ? MonReportHelper.createEmptyDs() : exBillDataSet.groupBy(this.groupString.split(",")).sum(sumField).finish();
    }

    private DataSet queryBillData(boolean isBase) {
        QFilter qFilter = this.getDateFilter(isBase);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(this.filterList);
        qFilters.add(qFilter);
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_letterofguarantee"), (String)"gm_letterofguarantee", (String)LETTER_FIELDS, (QFilter[])qFilters.toArray(new QFilter[0]), (String)this.orderString);
    }

    private QFilter getDateFilter(boolean isBase) {
        Date baseDate = (Date)this.paramMap.get("filter_basedate");
        Date cutoffDate = (Date)this.paramMap.get("filter_cutoffdate");
        Date date = isBase ? baseDate : cutoffDate;
        String cp = isBase ? ">=" : ">";
        QFilter qFilter = new QFilter("bizstatus", "not in", (Object)new String[]{"cancelled", "claimed"}).or(new QFilter("canceldate", cp, (Object)date).and("bizstatus", "=", (Object)"cancelled")).or(new QFilter("bizstatus", "=", (Object)"claimed").and("claimdate", cp, (Object)date));
        return new QFilter("startdate", "<=", (Object)date).and(qFilter);
    }

    private void init(ReportQueryParam reportQueryParam) {
        String[] dimensions;
        this.paramMap = this.transQueryParam(reportQueryParam);
        this.paramMap.putAll(reportQueryParam.getCustomParam());
        this.statcurrency = (Long)((DynamicObject)this.paramMap.get("filter_statcurrency")).getPkValue();
        String dimension = (String)this.paramMap.get("filter_statdim");
        StringBuilder group = new StringBuilder(dimension.replaceAll("_", ","));
        for (String s : dimensions = dimension.split("_")) {
            group.append(',').append(s).append("text");
        }
        if ("finorginfo".equals(dimension)) {
            group.append(",bankcatenumber");
        }
        this.groupString = group.toString();
        this.orderString = dimension.replaceAll("_", ",");
        this.filterList.add(new QFilter("applyorg.id", "in", (Object)this.getQueryOrgIds(reportQueryParam)));
        String finOrgInfo = (String)this.paramMap.get("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((String)finOrgInfo)) {
            String[] split = finOrgInfo.split(",");
            List ids = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            this.filterList.add(new QFilter("finorginfo", "in", ids));
        }
        this.filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
    }

    protected List<String> orinalAmountField() {
        return Collections.emptyList();
    }

    protected boolean isNeedOrgTree() {
        String dimensions = (String)this.paramMap.get("filter_statdim");
        return dimensions.contains("applyorg");
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    public List<String> groupFields() {
        return Arrays.stream(this.groupString.split(",")).collect(Collectors.toList());
    }

    public List<String> amountFields() {
        return Arrays.asList("b_amount", "be_amount", "changeamount", "be_ratio", "b_ratio");
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("b_amount", "be_amount", "changeamount", "be_ratio", "b_ratio");
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"applyorg", (Object)"applyorgtext");
    }

    public String sumNameField() {
        String columnStr;
        String statdim;
        switch (statdim = (String)this.paramMap.get("filter_statdim")) {
            case "applyorg": {
                columnStr = "applyorgtext";
                break;
            }
            case "finorginfo": {
                columnStr = "finorginfotext";
                break;
            }
            case "currency": {
                columnStr = "currencytext";
                break;
            }
            case "guaranteetype": {
                columnStr = "guaranteetypetext";
                break;
            }
            default: {
                columnStr = "applyorgtext";
            }
        }
        return columnStr;
    }

    private DataSet afterGroupAddField(DataSet sourceDataSet) {
        String[] fieldNames = sourceDataSet.getRowMeta().getFieldNames();
        ArrayList<Field> field = new ArrayList<Field>(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            field.add(new Field(fieldNames[i], sourceDataSet.getRowMeta().getFieldDataType(i)));
        }
        field.add(new Field("statcurrency", (DataType)DataType.LongType));
        field.add(new Field("pid", (DataType)DataType.IntegerType));
        field.add(new Field("rowid", (DataType)DataType.LongType));
        field.add(new Field("sumlevel", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        Iterator it = sourceDataSet.copy().iterator();
        while (it.hasNext()) {
            ArrayList<Object> values = new ArrayList<Object>(field.size());
            Row row = (Row)it.next();
            for (int i = 0; i < fieldNames.length; ++i) {
                values.add(row.get(i));
            }
            values.add(String.valueOf(this.statcurrency));
            values.add("0");
            values.add(String.valueOf(DBServiceHelper.genGlobalLongId()));
            values.add("0");
            dsBuilder.append(values.toArray());
        }
        return dsBuilder.build();
    }
}

